package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.FmsIcStatus;
import gov.va.caret.service.base.FmsIcStatusLocalServiceBaseImpl;

/**
 * The implementation of the fms ic status local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.FmsIcStatusLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.FmsIcStatusLocalServiceBaseImpl
 * @see gov.va.caret.service.FmsIcStatusLocalServiceUtil
 */
public class FmsIcStatusLocalServiceImpl extends FmsIcStatusLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.FmsIcStatusLocalServiceUtil} to access the fms ic status local service.
     */
	public FmsIcStatus getByTransNumber( String fmsOgId ) throws ApplicationWorkFlowException{
		try{
			return fmsIcStatusPersistence.fetchByTransactionNumber( fmsOgId );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<FmsIcStatus> getUnLogged( ) throws ApplicationWorkFlowException {
		try {
			return fmsIcStatusPersistence.findAll();//findByModifiedDate(modifiedDate, classPk, attributes);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
	}
	
	public int countUnLogged( ) throws ApplicationWorkFlowException {
		try {
			return fmsIcStatusPersistence.countByTransactionNumber("");
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
	} 
	
}
