package gov.va.caret.service.impl;

import java.util.Date;
import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchBgAsnException;
import gov.va.caret.NoSuchFmsIcNewException;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.FmsIcNew;
import gov.va.caret.service.base.FmsIcNewLocalServiceBaseImpl;

/**
 * The implementation of the fms ic new local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.FmsIcNewLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.FmsIcNewLocalServiceBaseImpl
 * @see gov.va.caret.service.FmsIcNewLocalServiceUtil
 */
public class FmsIcNewLocalServiceImpl extends FmsIcNewLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.FmsIcNewLocalServiceUtil} to access the fms ic new local service.
     */
	
	public FmsIcNew getByTransNumber( String fmsOgId ) throws ApplicationWorkFlowException{
		try{
			return fmsIcNewPersistence.fetchByTransactionNumber( fmsOgId );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<FmsIcNew> getUnLogged( ) throws ApplicationWorkFlowException {
		try {
			return fmsIcNewPersistence.findAll();//findByModifiedDate(modifiedDate, classPk, attributes);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
	}
	
	public int countUnLogged( ) throws ApplicationWorkFlowException {
		try {
			return fmsIcNewPersistence.countByTransactionNumber("");
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException (e);
		}
	} 
	
}
