package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.service.base.EELgLocalServiceBaseImpl;

/**
 * The implementation of the e e lg local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.EELgLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.EELgLocalServiceBaseImpl
 * @see gov.va.caret.service.EELgLocalServiceUtil
 */
public class EELgLocalServiceImpl extends EELgLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.EELgLocalServiceUtil} to access the e e lg local service.
     */ 
	/**
    * Returns all the e e lgs where ICN = &#63;.
    *
    * @param ICN the i c n
    * @return the matching e e lgs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.EELg> findByIcn(
        java.lang.String ICN)
        throws com.liferay.portal.kernel.exception.SystemException {
        return this.eeLgPersistence.findByIcn(ICN);
    }
}
