/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import java.util.Collections;
import java.util.List;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchBgAsnException;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BgNum;
import gov.va.caret.model.BoxGp;
import gov.va.caret.service.base.BoxGpLocalServiceBaseImpl;

/**
 * The implementation of the box gp local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.BoxGpLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.BoxGpLocalServiceBaseImpl
 * @see gov.va.caret.service.BoxGpLocalServiceUtil
 */
public class BoxGpLocalServiceImpl extends BoxGpLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.BoxGpLocalServiceUtil} to access the box gp local service.
	 */
	
	public List<BoxGp> getBoxGroups ( String name ) throws ApplicationWorkFlowException{
		try {
			return boxGpPersistence.findByBoxGroup( name );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<BoxGp> getBoxGroups ( String boxGroup, String boxSubGroup ) throws ApplicationWorkFlowException{
		try {
			return boxGpPersistence.findByBoxSubGroup(boxGroup, boxSubGroup);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<BgNum> getBoxGroupBgNum ( long ownerId ) throws ApplicationWorkFlowException{
		try {
			return bgNumPersistence.findByBoxGroupNumberAssociations(ownerId);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<BgAsn> getBoxGroupAssociations ( long ownerId ) throws ApplicationWorkFlowException{
		try {
			return bgAsnPersistence.findByBoxGroupAssociations(ownerId);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<BgAsn> getBoxGroupAssociations ( long ownerId, boolean enabled ) throws ApplicationWorkFlowException{
		try {
			return bgAsnPersistence.findBySelectedBoxGroupAssociations(ownerId, enabled);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public BgAsn getBoxGroupAssociation ( long ownerId, long boxGpId ) throws ApplicationWorkFlowException{
		try { int count = bgAsnPersistence.countByBgAsnInst(ownerId, boxGpId);
		if ( count == 1 )
			return bgAsnPersistence.findByBgAsnInst(ownerId, boxGpId);
		} catch (NoSuchBgAsnException e) {
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
}