/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.NoSuchClassNameException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.persistence.ClassNameUtil;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.impl.AudLgImpl;
import gov.va.caret.service.AudLgLocalServiceUtil;
import gov.va.caret.service.base.BlsReLocalServiceBaseImpl;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

/**
 * The implementation of the bls re local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.BlsReLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.BlsReLocalServiceBaseImpl
 * @see gov.va.caret.service.BlsReLocalServiceUtil
 */
public class BlsReLocalServiceImpl extends BlsReLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.BlsReLocalServiceUtil} to access the bls re local service.
	 */
	public List<BlsRe> findBlsByZip( String zip ) throws ApplicationWorkFlowException {
		try {
			if ( Toolbox.isEmpty(zip) ) {
				return Collections.emptyList();
			}
			List<BlsRe> list = blsRePersistence.findByZip(zip);
			if ( list.isEmpty() ) {
				return blsRePersistence.findByZip( String.valueOf(Integer.valueOf(zip)) );
			}
			return list;
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public BlsRe findLatestBlsByZip( String zip ) throws ApplicationWorkFlowException {
		try {
			if ( Toolbox.isEmpty(zip) ) {
				return null;
			}
			BlsRe blsRe = blsRePersistence.fetchByZip_First(zip, null);
			if ( blsRe == null ) {
				return blsRePersistence.fetchByZip_First(String.valueOf(Integer.valueOf(zip)), null);
			}
			return blsRe;
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	 /**
	    * Updates the bls re in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	    *
	    * @param blsRe the bls re
	    * @return the bls re that was updated
	    * @throws SystemException if a system exception occurred
	    */
	    public gov.va.caret.model.BlsRe updateBlsRe(
	        gov.va.caret.model.BlsRe blsRe, Double oldH75)
	        throws com.liferay.portal.kernel.exception.SystemException {
	        super.updateBlsRe(blsRe);
	        ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
			if ( sc == null ){
				sc = new ServiceContext();
			}
			Object userIdObj = sc.getAttribute( CaretStrPool.USER_ID );
			long userId = userIdObj == null? sc.getUserId(): (Long) userIdObj;
			Object coverUserIdObj = sc.getAttribute( CaretStrPool.REAL_USER_ID );
			long coverUserId = coverUserIdObj == null? userId : (Long)coverUserIdObj;
			String roleName = String.valueOf( sc.getAttribute( CaretStrPool.DASHBOARD_ROLE_NAME ) );
			Date modifiedDate = sc.getCreateDate() == null? new Date(): sc.getCreateDate();
		
	        AudLg audit = new AudLgImpl();
			try {
				audit.setClassId( ClassNameUtil.findByValue( BlsRe.class.getName() ).getPrimaryKey() );
			} catch (NoSuchClassNameException e){
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			audit.setClassPk(blsRe.getBlsReId());
			audit.setAttribute("BLS Rate");
			audit.setModifiedById(sc.getUserId());
			audit.setCoverUserId (coverUserId);
			audit.setModifiedDate(modifiedDate);
			audit.setSysDateTime(modifiedDate.getTime());
			audit.setOldValue(oldH75.toString());
			audit.setNewValue(blsRe.getH75().toString());
			audit.setGroupId (0);
			audit.setRoleName (roleName);
			
			audit = AudLgLocalServiceUtil.addAudLg(audit);
			return blsRe;
	    }
	    
	    
	    public BlsRe findByLessYear( String zip, int year ) throws ApplicationWorkFlowException {
			try {
				if ( Toolbox.isEmpty(zip) || year <= 0 ) {
					return null;
				}
				return blsRePersistence.fetchByLessYear_Last(zip, year, null);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
	    
	    public BlsRe findByMoreYear ( String zip, int year ) throws ApplicationWorkFlowException {
			try {
				if ( Toolbox.isEmpty(zip) || year <= 0 ) {
					return null;
				}
				return blsRePersistence.fetchByMoreYear_First(zip, year, null);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
}