/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import java.util.Collections;
import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.service.base.BgLaeLocalServiceBaseImpl;

/**
 * The implementation of the bg lae local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.BgLaeLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.BgLaeLocalServiceBaseImpl
 * @see gov.va.caret.service.BgLaeLocalServiceUtil
 */
public class BgLaeLocalServiceImpl extends BgLaeLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.BgLaeLocalServiceUtil} to access the bg lae local service.
	 */
	public BgLae getBgLaeAssociation ( long ownerId, long boxGpId ) throws ApplicationWorkFlowException{
		try {
			return bgLaePersistence.fetchByBgCharInst(ownerId, boxGpId);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public BgLae getLastBgLae ( long boxGpId ) throws ApplicationWorkFlowException{
		try {
			return bgLaePersistence.fetchByBoxGp_First(boxGpId, null);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<BgLae> getStaged ( long ownerId ) throws ApplicationWorkFlowException{
		try {
			return bgLaePersistence.findByStagedLt( ownerId + 1 );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public int countByBgCharInst ( long ownerId, long boxGpId ){
		try {
			return bgLaePersistence.countByBgCharInst(ownerId, boxGpId);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return 0;
	}
}