/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import java.util.List;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Assmt;
import gov.va.caret.service.base.AssmtLocalServiceBaseImpl;

/**
 * The implementation of the assmt local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.AssmtLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.AssmtLocalServiceBaseImpl
 * @see gov.va.caret.service.AssmtLocalServiceUtil
 */
public class AssmtLocalServiceImpl extends AssmtLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.AssmtLocalServiceUtil} to access the assmt local service.
	 */
	
	public List<Assmt> findByVcgId(long vcgId) throws ApplicationWorkFlowException {
		try{
			return this.assmtPersistence.findByVcgId(vcgId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}

	public List<Assmt> findByYear(long vcgId, String type, long year) throws ApplicationWorkFlowException {
		try{
			return this.assmtPersistence.findByYear(vcgId, type, year);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		} 
	}
	
	public List<Assmt> findByAssmtTypes(long vcgId, String[] types) throws ApplicationWorkFlowException {
		try {
			return this.assmtPersistence.findByAssmtTypes(vcgId, types);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<Assmt> findByCaregiverTypes(long caregiverId, String[] types) throws ApplicationWorkFlowException {
		try {
			return this.assmtPersistence.findByCaregiverTypes(caregiverId, types);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<Assmt> findByVcgTypes(long vcgId, long caregiverId, String[] types) throws ApplicationWorkFlowException {
		try {
			return this.assmtPersistence.findByVcgTypes(vcgId, caregiverId, types);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}

}