package gov.va.caret.service.ctssh.response;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import gov.va.caret.service.ctssh.request.SimpleRequest;
import gov.va.caret.service.ctssh.template.TemplateResponseProperty;
import gov.va.caret.service.ctssh.util.AppHelper;

public class SimpleResponse extends Response {

	
	
	public int HTTP_RESP_CODE = 0;
	public int HTTP_CONTENT_LENGTH = 0;
	public String HTTP_CONTENT_TYPE = "";
	public String HTTP_RESPONSE_MESSAGE = "";
	private String _key;
	private String _raw_response;
	private String _xformed_response;
	private SimpleRequest requestIn;
	private HashMap<String, ResponseProperty> _response_properties;
	private ResponseRecord[] _response_records;
	private String _error_message = "";
	private String _error_code = "";
	private Document _response_doc;
	
	/**
	 * @param key
	 * @throws Exception
	 */
	public SimpleResponse(String key) throws Exception {
		super(key);
		_key = key;
	}

	/**
	 * @param req
	 * @throws Exception
	 */
	public SimpleResponse(SimpleRequest req) throws Exception {
		super(req);
		requestIn = req;
		_key = requestIn.key();
	}


	/*
	 * HashMap<String,String> properties; ResponseRecord[] <- array of result
	 * record objects HashMap<String, Field> _fields; HashMap<String,
	 * FieldGroups> _field_groups; HashMap<String, Field> _fields;
	 * 
	 */

	/**
	 * @param raw_xml
	 * @throws Exception
	 */
	public void processResult(String raw_xml) throws Exception {

		_raw_response = raw_xml;
		
		//System.out.println(_raw_response);
		_response_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(_raw_response)));
		
		_response_doc.getDocumentElement().normalize();

		// check to see if there is transform on this template.
		if (requestIn.template().raw_xform_body() != null && requestIn.template().raw_xform_body().length() > 0) {
		
			Transformer xform = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(requestIn.template().raw_xform_body())));
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);
			xform.transform(new DOMSource(_response_doc), result);
			_xformed_response = writer.toString();
			_response_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(_xformed_response)));
			
			AppHelper.log("\nXFORMED DATA\n-------------------------------\n" + AppHelper.getPrettyPrintXML(_xformed_response) + "\n-------------------------------\n");
			
		}

		
		// loop through return properties
		_response_properties = new HashMap<>();
		for (TemplateResponseProperty trp : requestIn.template().response_properties()) {
			
			try{
				
				ResponseProperty rp = new ResponseProperty(trp, _response_doc);
				_response_properties.put(rp.name(), rp);
				
				
			}catch(Exception e)
			{
				_error_message = e.getMessage();
				throw e;
			}
			
			
			
			
		}

		// now loop through the records
		if(requestIn.template().rec_xpath() != null && requestIn.template().rec_xpath().length() > 0)
		{
			NodeList nlRecords = AppHelper.getNodeList(requestIn.template().rec_xpath(), _response_doc);
		
			if (nlRecords != null && nlRecords.getLength() > 0) {
				_response_records = new ResponseRecord[nlRecords.getLength()];
				for (int ix = 0; ix < nlRecords.getLength(); ix++) {
					_response_records[ix] = new ResponseRecord(nlRecords.item(ix), requestIn.template());
				}
			} else {
				_response_records = new ResponseRecord[0];
			}
		}else
		{
			_response_records = new ResponseRecord[0];
		}
		// done - easy breasy :)
	}

	
	/**
	 * @return
	 */
	public String raw_response()
	{
		return _raw_response;
	}
	
	/**
	 * @return
	 */
	public String xformed_response()
	{
		return _xformed_response;
	}
	
	/**
	 * @return
	 */
	public HashMap<String, ResponseProperty> response_properties()
	{
		return _response_properties;	
	}
	
	/**
	 * @param key
	 * @return
	 */
	public ResponseProperty property(String key)
	{
		return _response_properties.get(key);	
	}	
	
	
	/**
	 * @param key
	 * @return
	 */
	public String propertyValue(String key)
	{
		if(_response_properties.containsKey(key))
			return _response_properties.get(key).value();
		else
			return "PROPERTY \"" + key + "\" NOT FOUND";
	}
	
	
	/**
	 * @return
	 */
	public ResponseRecord[] response_records()
	{
		return _response_records;
	}

	/**
	 * @return
	 */
	public int record_count()
	{
		return _response_records.length;
	}
	

	/* (non-Javadoc)
	 * @see gov.va.caret.service.ctssh.response.Response#report()
	 */
	@Override
	public String report() throws Exception {

	  	StringBuilder sb = new StringBuilder();
	  	sb.append("======================================================================================================\n");
	  	sb.append("RUN : " + requestIn.toString());
	  	sb.append("\n");
	  	sb.append("INTERFACE KEY : " + _key);
	  	sb.append("\n");

	  	
	  	sb.append(requestIn.report());
	  	
	  	sb.append("....................................................................................................\n");
	  	sb.append("HTTP HEADERS\n");
	  	sb.append("----------------------------------------------------------------------------------------------------\n");
	  	sb.append("RESP_CODE : " + HTTP_RESP_CODE);
	  	sb.append("\n");
		sb.append("CONTENT_LENGTH : " + HTTP_CONTENT_LENGTH);
		sb.append("\n");
		sb.append("CONTENT_TYPE : " + HTTP_CONTENT_TYPE);
		sb.append("\n");
		sb.append("RESPONSE_MESSAGE : " + HTTP_RESPONSE_MESSAGE);
		sb.append("\n");
		sb.append("----------------------------------------------------------------------------------------------------\n");
		
		
	  	sb.append("....................................................................................................\n");
	  	sb.append("RETURN PROPERTIES\n");
	  	sb.append("----------------------------------------------------------------------------------------------------\n");

	  	for(ResponseProperty rp: _response_properties.values())
    	{
	  		sb.append(rp.toString());
	  		sb.append("\n");	
    	}
	  	sb.append("----------------------------------------------------------------------------------------------------\n");

	  	sb.append("....................................................................................................\n");
	  	sb.append("RETURN RECORDS (" + _response_records.length + ")\n");
	  	sb.append("----------------------------------------------------------------------------------------------------\n");

		for(ResponseRecord rr: _response_records)
		{
			sb.append(rr.toString());
			sb.append("\n");
		}
	  	
/*
		
	  	sb.append("....................................................................................................\n");
	  	sb.append("RETURN RAW XML\n");
	  	sb.append("----------------------------------------------------------------------------------------------------\n");
	  	sb.append(AppHelper.getPrettyPrintXML(_raw_response));
	  	sb.append("\n");

	  	sb.append("....................................................................................................\n");
	  	sb.append("RETURN XFORMED XML\n");
	  	sb.append("----------------------------------------------------------------------------------------------------\n");
	  	sb.append(AppHelper.getPrettyPrintXML(_xformed_response));
	  	sb.append("\n");
	*/
		
	  	/*
		private SimpleRequest requestIn;
	  	
    	sb.append("RETRIEVED " + _response_records.length + " RECORDS");
    	
    	for(ResponseProperty rp: response.response_properties().values())
    	{
    		AppHelper.log(rp.name() + " : " + rp.value());
    	}
    	
    	*/
    	
    	return sb.toString();
		
	}

	
	/**
	 * @return
	 */
	public String errorMessage()
	{
		return _error_message;
	}
	
	/**
	 * @return
	 */
	public String errorCode()
	{
		return _error_code;
	}

	public Node response_doc() {
		// TODO Auto-generated method stub
		return _response_doc;
	}	
}
