/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.caret.service.ctssh.response;

import java.util.HashMap;

import org.w3c.dom.Node;

import gov.va.caret.service.ctssh.template.SimpleTemplate;
import gov.va.caret.service.ctssh.template.TemplateResponseField;
import gov.va.caret.service.ctssh.template.TemplateResponseFieldGroup;

/**
 *
 * @author ronaday
 */
public class ResponseRecord {
    
    /**
     * 
     */
    private final HashMap<String, ResponseField> _fields = new HashMap<>();
    /**
     * 
     */
    private final HashMap<String, ResponseFieldGroup> _field_groups = new HashMap<>();
    
    
    /**
     * @param field_key
     * @return
     */
    public String get(String field_key)
    {
    	String rval = null;
    	field_key = field_key.toLowerCase();
    	
    	if(_fields.containsKey(field_key))
    		rval = _fields.get(field_key)._value;
    	
    	
    	return rval;
    }

    /**
     * @param group_name
     * @param group_key
     * @param field_key
     * @return
     */
    public String get(String group_name, String group_key, String field_key)
    {
    	group_name = group_name.toLowerCase();
    	group_key = group_key.toLowerCase();
    	field_key = field_key.toLowerCase();
    	
    	String rval = null;
    	
    	if(_field_groups.containsKey(group_name))
    	{
    		if(_field_groups.get(group_name).containsKey(group_key))
    		{
    			if(_field_groups.get(group_name).get(group_key).containsKey(field_key))
    			{
    				rval = _field_groups.get(group_name).get(group_key).get(field_key).value();
    			}
    		}
    		
    	}	
    	
    	return rval;
    	
    }

    /**
     * @param _source_record_node
     * @param _template
     * @throws Exception
     */
    public ResponseRecord(Node _source_record_node, SimpleTemplate _template) throws Exception {
        
        for(TemplateResponseField field: _template.rec_fields())
        {
            _fields.put(field.name().toLowerCase(), new ResponseField(field, _source_record_node));
        }
        
        
        for(TemplateResponseFieldGroup field_group: _template.rec_field_groups())
        {
            ResponseFieldGroup rfg = new ResponseFieldGroup(field_group, _source_record_node);
            _field_groups.put(rfg.name().toLowerCase(),rfg);
            
        }
        
       
        
        
        
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
	public String toString()
    {
    	StringBuilder sb = new StringBuilder();
    	
    	sb.append("\t[FIELDS]\n");
    	sb.append("\t--------\n");
    	sb.append(ResponseField.fieldheader("\t"));
    	sb.append("\n");
    	for(ResponseField field: _fields.values())
    	{
    		sb.append(field.toString("\t"));
    		sb.append("\n");
    	}
    	

    	sb.append("\t[FIELD GROUPS]\n");
    	sb.append("\t--------\n");    	
    	for(ResponseFieldGroup fieldgroup: _field_groups.values())
    	{
    		sb.append(fieldgroup.toString("\t"));
    		sb.append("\n");
    	}
    	
    	
    	return sb.toString();
    }
    
}
