package gov.va.caret.service.ctssh;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;

import gov.va.caret.model.Persn;
import gov.va.caret.service.ctssh.core.Executor;
import gov.va.caret.service.ctssh.request.Request;
import gov.va.caret.service.ctssh.request.RequestFactory;
import gov.va.caret.service.ctssh.response.Response;
import gov.va.caret.service.ctssh.response.ResponseRecord;
import gov.va.caret.service.ctssh.response.SimpleResponse;
import gov.va.caret.service.ctssh.util.AppHelper;
import gov.va.caret.service.ctssh.util.CacheHandler;
import javax.xml.bind.DatatypeConverter;

public class ServiceFacade {

//	//return a bytebuffer that represents the file esigned by the Vet
//	public static ByteBuffer ESigVet(Persn _current_user, String _user_name, String _common_name, String _email_address, ByteBuffer _byte_buff) throws Exception
//	{
//		
//		
//		
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		
//		//what has to happen is the byte buffer needs to be base24 encoded.
//		String encoded_data = DatatypeConverter.printBase64Binary(_byte_buff.array()); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_VET);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//        
//        return  ByteBuffer.wrap(DatatypeConverter.parseBase64Binary(((SimpleResponse)resp)	.property("SIGNED.RESPONSE").value()));        
//
//        
//		
//		
//	}
//
//	//return a file that represents the file esigned by the Vet. 
////return a file that represents the file esigned by the Vet. 
//	public static File ESigVet(Persn _current_user, String _user_name, String _common_name, String _email_address, File _file, String _output_path) throws Exception
//	{
//		
//	 
//        FileInputStream fis = new FileInputStream(_file);
//        byte[] data = new byte[(int)_file.length()];
//        int br = fis.read(data);
//        fis.close();
//        
//        Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//        req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//        req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//        req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//        String encoded_data = DatatypeConverter.printBase64Binary(data); 
//        System.out.println(encoded_data);
//        req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//        req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_VET);
//        Response resp = Executor.newInstance().execute(req);
//        System.out.println(resp.report());
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//    	String signature = ((SimpleResponse)resp).property("SIGNED.RESPONSE").value();
//        //System.out.println("Got the signature : " + signature);
//        
//        File destpdf = new File(_output_path + "/" + System.currentTimeMillis() + "_1010CGVETSIG.pdf");
//        
//        FileOutputStream fos = new FileOutputStream(destpdf);
//        fos.write(DatatypeConverter.parseBase64Binary(signature));
//        fos.close();
//        
//        return  destpdf;        
//		
//		
//		
//	}
//
//
//			
//	//return a byte[] array that represents the file esigned by the Vet. 
//	public static byte[] ESigVet(Persn _current_user, String _user_name, String _common_name, String _email_address,  byte[] byte_buff) throws Exception
//	{
//
//
//        
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		String encoded_data = DatatypeConverter.printBase64Binary(byte_buff); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_VET);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//    	String signature = ((SimpleResponse)resp).property("SIGNED.RESPONSE").value();
//     
//        return DatatypeConverter.parseBase64Binary(signature);
//		
//	}
//
//	
//	public static ByteBuffer ESigPG(Persn _current_user, String _user_name, String _common_name, String _email_address, ByteBuffer _byte_buff) throws Exception
//	{
//		
//		
//		
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		
//		//what has to happen is the byte buffer needs to be base24 encoded.
//		String encoded_data = DatatypeConverter.printBase64Binary(_byte_buff.array()); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_PRIMCG);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//        
//        return  ByteBuffer.wrap(DatatypeConverter.parseBase64Binary(((SimpleResponse)resp)	.property("SIGNED.RESPONSE").value()));        
//
//        
//		
//		
//	}
//
//	//return a file that represents the file esigned by the Vet. 
//	public static File ESigPG(Persn _current_user, String _user_name, String _common_name, String _email_address, File _file, String _output_path) throws Exception
//	{
//		
//	 
//        FileInputStream fis = new FileInputStream(_file);
//        byte[] data = new byte[(int)_file.length()];
//        int br = fis.read(data);
//        fis.close();
//        
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		String encoded_data = DatatypeConverter.printBase64Binary(data); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_PRIMCG);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//    	String signature = ((SimpleResponse)resp).property("SIGNED.RESPONSE").value();
//        File destpdf = new File(_output_path);
//        FileOutputStream fos = new FileOutputStream(destpdf);
//        fos.write(DatatypeConverter.parseBase64Binary(signature));
//        fos.close();
//        
//        return  new File(_output_path);        
//		
//		
//		
//	}
//
//
//			
//	//return a byte[] array that represents the file esigned by the Vet. 
//	public static byte[] ESigPG(Persn _current_user, String _user_name, String _common_name, String _email_address,  byte[] byte_buff) throws Exception
//	{
//
//
//        
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		String encoded_data = DatatypeConverter.printBase64Binary(byte_buff); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_PRIMCG);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//    	String signature = ((SimpleResponse)resp).property("SIGNED.RESPONSE").value();
//     
//        return DatatypeConverter.parseBase64Binary(signature);
//		
//	}
//	
//	
//	
//	public static ByteBuffer ESigSG1(Persn _current_user, String _user_name, String _common_name, String _email_address, ByteBuffer _byte_buff) throws Exception
//	{
//		
//		
//		
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		
//		//what has to happen is the byte buffer needs to be base24 encoded.
//		String encoded_data = DatatypeConverter.printBase64Binary(_byte_buff.array()); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_SECCG1);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//        
//        return  ByteBuffer.wrap(DatatypeConverter.parseBase64Binary(((SimpleResponse)resp)	.property("SIGNED.RESPONSE").value()));        
//
//        
//		
//		
//	}
//
//	//return a file that represents the file esigned by the Vet. 
//	public static File ESigSG1(Persn _current_user, String _user_name, String _common_name, String _email_address, File _file, String _output_path) throws Exception
//	{
//		
//	 
//        FileInputStream fis = new FileInputStream(_file);
//        byte[] data = new byte[(int)_file.length()];
//        int br = fis.read(data);
//        fis.close();
//        
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		String encoded_data = DatatypeConverter.printBase64Binary(data); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_SECCG1);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//    	String signature = ((SimpleResponse)resp).property("SIGNED.RESPONSE").value();
//        File destpdf = new File(_output_path);
//        FileOutputStream fos = new FileOutputStream(destpdf);
//        fos.write(DatatypeConverter.parseBase64Binary(signature));
//        fos.close();
//        
//        return  new File(_output_path);        
//		
//		
//		
//	}
//
//
//			
//	//return a byte[] array that represents the file esigned by the Vet. 
//	public static byte[] ESigSG1(Persn _current_user, String _user_name, String _common_name, String _email_address,  byte[] byte_buff) throws Exception
//	{
//
//
//        
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		String encoded_data = DatatypeConverter.printBase64Binary(byte_buff); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_SECCG1);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//    	String signature = ((SimpleResponse)resp).property("SIGNED.RESPONSE").value();
//     
//        return DatatypeConverter.parseBase64Binary(signature);
//		
//	}
//	
//	
//	
//	public static ByteBuffer ESigSG2(Persn _current_user, String _user_name, String _common_name, String _email_address, ByteBuffer _byte_buff) throws Exception
//	{
//		
//		
//		
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		
//		//what has to happen is the byte buffer needs to be base24 encoded.
//		String encoded_data = DatatypeConverter.printBase64Binary(_byte_buff.array()); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_SECCG2);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//        
//        return  ByteBuffer.wrap(DatatypeConverter.parseBase64Binary(((SimpleResponse)resp)	.property("SIGNED.RESPONSE").value()));        
//
//        
//		
//		
//	}
//
//	//return a file that represents the file esigned by the Vet. 
//	public static File ESigSG2(Persn _current_user, String _user_name, String _common_name, String _email_address, File _file, String _output_path) throws Exception
//	{
//		
//	 
//        FileInputStream fis = new FileInputStream(_file);
//        byte[] data = new byte[(int)_file.length()];
//        int br = fis.read(data);
//        fis.close();
//        
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		String encoded_data = DatatypeConverter.printBase64Binary(data); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_SECCG2);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//    	String signature = ((SimpleResponse)resp).property("SIGNED.RESPONSE").value();
//        File destpdf = new File(_output_path);
//        FileOutputStream fos = new FileOutputStream(destpdf);
//        fos.write(DatatypeConverter.parseBase64Binary(signature));
//        fos.close();
//        
//        return  new File(_output_path);        
//		
//		
//		
//	}
//
//
//			
//	//return a byte[] array that represents the file esigned by the Vet. 
//	public static byte[] ESigSG2(Persn _current_user, String _user_name, String _common_name, String _email_address,  byte[] byte_buff) throws Exception
//	{
//
//
//        
//		Request req = RequestFactory.createRequest(Request.ESIG_1010CG);
//		req.setParameter(Request.ESIG_USER_NAME, _user_name);		
//		req.setParameter(Request.ESIG_COMMON_NAME, _common_name);
//		req.setParameter(Request.ESIG_EMAIL_ADDRESS, _email_address);
//		String encoded_data = DatatypeConverter.printBase64Binary(byte_buff); 
//		req.setParameter(Request.ESIG_FILE_DATA,encoded_data);
//		req.setParameter(Request.ESIG_SIG_FIELD, Request.ESIG_SIG_FIELD_SECCG2);
//        Response resp = Executor.newInstance().execute(req);
//        
//        if(resp.error())
//        	throw new Exception(resp.errormsg());
//
//    	String signature = ((SimpleResponse)resp).property("SIGNED.RESPONSE").value();
//     
//        return DatatypeConverter.parseBase64Binary(signature);
//		
//	}
	
	
	
	//Do an MVI Attended Search
	public static ArrayList MVIAttendedSearch(Persn _current_user, String _dob, String _ssn, String _gender, String _vet_fname, String _vet_lname,  String _vet_mname,  String _vet_prx,  String _vet_sfx,  String _vet_phone,  String _vet_street1, String _vet_street2,  String _vet_street3,  String _vet_street4,  String _vet_city,  String _vet_state,  String _vet_postal,  String _vet_country) throws Exception
	{

		
		User liferay_user = null;;
		if(_current_user != null)
			liferay_user = UserLocalServiceUtil.getUser(_current_user.getUserId());
		
		Request req = null;
        req = RequestFactory.createRequest(Request.MVI_1305_ATTENDED_SEARCH);
        
        req.setParameter(Request.MVI_SENDER_OID, "2.16.840.1.113883.4.349");
        if(liferay_user != null)
        	req.setParameter(Request.MVI_SENDER_ID, liferay_user.getScreenName());
        else
        	req.setParameter(Request.MVI_SENDER_ID, "bfuser008");
        
        SetParameter(req, Request.MVI_VET_DOB,_dob);
        SetParameter(req, Request.MVI_VET_SSN,_ssn);
   		SetParameter(req, Request.MVI_VET_GENDER ,_gender); 
   		SetParameter(req, Request.MVI_VET_NAME_FIRST,_vet_fname); 
		SetParameter(req, Request.MVI_VET_NAME_LAST,_vet_lname);  
		SetParameter(req, Request.MVI_VET_NAME_MIDDLE,_vet_mname);  
		SetParameter(req, Request.MVI_VET_NAME_PREFIX,_vet_prx);
		SetParameter(req, Request.MVI_VET_NAME_SUFFIX,_vet_sfx);
		SetParameter(req, Request.MVI_VET_PHONE,_vet_phone);  
		SetParameter(req, Request.MVI_VET_ADDRESS_STREET1,_vet_street1);
		SetParameter(req, Request.MVI_VET_ADDRESS_STREET2,_vet_street2);  
		SetParameter(req, Request.MVI_VET_ADDRESS_STREET3,_vet_street3); 
		SetParameter(req, Request.MVI_VET_ADDRESS_STREET4,_vet_street4); 
		SetParameter(req, Request.MVI_VET_ADDRESS_CITY,_vet_city);
		SetParameter(req, Request.MVI_VET_ADDRESS_STATE,_vet_state);  
		SetParameter(req, Request.MVI_VET_ADDRESS_POSTALCD,_vet_postal);  
		SetParameter(req, Request.MVI_VET_ADDRESS_COUNTRY,_vet_country);

	    Response resp = Executor.newInstance().execute(req);
        SimpleResponse response = (SimpleResponse)resp;


        
        //AppHelper.log(response.report());
        
        if(response.error())
        {
        	 AppHelper.log(response.report());
        	throw new Exception( response.errorMessage());
        }
        ArrayList<HashMap<String,Object>> alReturnResults = new ArrayList<>();
        
        if(response.property("RESP.CODE") != null && response.propertyValue("RESP.CODE").intern() == "QE")
        	return alReturnResults;//return empty list if too many results returned
        
        if(response.record_count() == 0)
        	return null;  //return null if nothing was found
        	
   		
        
   		for(ResponseRecord resprec: response.response_records())
   		{
   			HashMap<String,Object> rez = new HashMap<>();
       		rez.put("SSN",  resprec.get("VET.SSN"));
       		rez.put("DOB",  resprec.get("VET.DOB"));
       		rez.put("ICN",  resprec.get("VET.ICN"));
       		rez.put("GENDER", resprec.get("VET.GENDER"));
       		rez.put("FIRST_NAME",  resprec.get("VET.NAMES","L","FIRST"));
       		rez.put("LAST_NAME",  resprec.get("VET.NAMES","L","LAST"));
       		rez.put("MIDDLE_NAME",  resprec.get("VET.NAMES","L","MIDDLE"));
			rez.put("PREFIX",  resprec.get("VET.NAMES","L","PREFIX"));
			rez.put("SUFFIX",  resprec.get("VET.NAMES","L","SUFFIX"));		
       		rez.put("STREET1", resprec.get("VET.ADDRESSES","PHYS","STREET1"));
       		rez.put("STREET2", resprec.get("VET.ADDRESSES","PHYS","STREET1"));
			rez.put("CITY", resprec.get("VET.ADDRESSES","PHYS","CITY"));				
			rez.put("STATE", resprec.get("VET.ADDRESSES","PHYS","STATE"));
			rez.put("POSTALCODE", resprec.get("VET.ADDRESSES","PHYS","POSTALCD"));
			rez.put("COUNTRY", resprec.get("VET.ADDRESSES","PHYS","COUNTRY"));
   		
			alReturnResults.add(rez);
			
   		}
   		
    	return alReturnResults;
		
		
		
	}

	private static void SetParameter(Request req, String FLD, String value) throws Exception {

			if(value != null && req != null)
				req.setParameter(FLD, value);
		
	}

	//Do an MVI Unaattended Search
	public static Map<String, Object> MVIUnattendedSearch(Persn _current_user, String _dob, String _ssn, String _gender, String _vet_fname, String _vet_lname,  String _vet_mname,  String _vet_prx,  String _vet_sfx,  String _vet_phone,  String _vet_street1, String _vet_street2,  String _vet_street3,  String _vet_street4,  String _vet_city,  String _vet_state,  String _vet_postal,  String _vet_country) throws Exception
	{

		
		User liferay_user = null;;
		if(_current_user != null)
			liferay_user = UserLocalServiceUtil.getUser(_current_user.getUserId());
		
		Request req = null;
        req = RequestFactory.createRequest(Request.MVI_1305_UNATTENDED_SEARCH);
        
        req.setParameter(Request.MVI_SENDER_OID, "2.16.840.1.113883.4.349");
        if(liferay_user != null)
        	req.setParameter(Request.MVI_SENDER_ID, liferay_user.getScreenName());
        else
        	req.setParameter(Request.MVI_SENDER_ID, "bfuser008");
        
        SetParameter(req, Request.MVI_VET_DOB,_dob);
        SetParameter(req, Request.MVI_VET_SSN,_ssn);
   		SetParameter(req, Request.MVI_VET_GENDER ,_gender); 
   		SetParameter(req, Request.MVI_VET_NAME_FIRST,_vet_fname); 
		SetParameter(req, Request.MVI_VET_NAME_LAST,_vet_lname);  
		SetParameter(req, Request.MVI_VET_NAME_MIDDLE,_vet_mname);  
		SetParameter(req, Request.MVI_VET_NAME_PREFIX,_vet_prx);
		SetParameter(req, Request.MVI_VET_NAME_SUFFIX,_vet_sfx);
		SetParameter(req, Request.MVI_VET_PHONE,_vet_phone);  
		SetParameter(req, Request.MVI_VET_ADDRESS_STREET1,_vet_street1);
		SetParameter(req, Request.MVI_VET_ADDRESS_STREET2,_vet_street2);  
		SetParameter(req, Request.MVI_VET_ADDRESS_STREET3,_vet_street3); 
		SetParameter(req, Request.MVI_VET_ADDRESS_STREET4,_vet_street4); 
		SetParameter(req, Request.MVI_VET_ADDRESS_CITY,_vet_city);
		SetParameter(req, Request.MVI_VET_ADDRESS_STATE,_vet_state);  
		SetParameter(req, Request.MVI_VET_ADDRESS_POSTALCD,_vet_postal);  
		SetParameter(req, Request.MVI_VET_ADDRESS_COUNTRY,_vet_country);

	    Response resp = Executor.newInstance().execute(req);
        SimpleResponse response = (SimpleResponse)resp;

        if(response.error())
        	throw new Exception(response.errorMessage());
        
        
        HashMap<String,Object> rez = new HashMap<>();
        
        if(response.property("RESP.CODE") != null && response.propertyValue("RESP.CODE").intern() == "QE")
        	return rez;//return empty list if too many results returned
        
        if(response.record_count() == 0)
        	return null;  //return null if nothing was found
        

        
   		//response.response_records()[0].get("ADDR","PHYS","CITY"));
   		rez.put("SSN",  response.response_records()[0].get("VET.SSN"));
   		rez.put("DOB",  response.response_records()[0].get("VET.DOB"));
   		rez.put("ICN",  response.response_records()[0].get("VET.ICN"));
   		rez.put("GENDER", response.response_records()[0].get("VET.GENDER"));
   		rez.put("FIRST_NAME",  response.response_records()[0].get("VET.NAMES","L","FIRST"));
   		rez.put("LAST_NAME",  response.response_records()[0].get("VET.NAMES","L","LAST"));
   		rez.put("MIDDLE_NAME",  response.response_records()[0].get("VET.NAMES","L","MIDDLE"));
		rez.put("PREFIX",  response.response_records()[0].get("VET.NAMES","L","PREFIX"));
		rez.put("SUFFIX",  response.response_records()[0].get("VET.NAMES","L","SUFFIX"));		
   		rez.put("STREET1", response.response_records()[0].get("VET.ADDRESSES","PHYS","STREET1"));
   		rez.put("STREET2", response.response_records()[0].get("VET.ADDRESSES","PHYS","STREET1"));
		rez.put("CITY", response.response_records()[0].get("VET.ADDRESSES","PHYS","CITY"));				
		rez.put("STATE", response.response_records()[0].get("VET.ADDRESSES","PHYS","STATE"));
		rez.put("POSTALCODE", response.response_records()[0].get("VET.ADDRESSES","PHYS","POSTALCD"));
		rez.put("COUNTRY", response.response_records()[0].get("VET.ADDRESSES","PHYS","COUNTRY"));
    
        
		return rez;        	
		
		
		
	}


	//Write a TIU note
	public static Response WriteTIUNote(Persn _current_user, String _note_title, String _note_text, String _vet_dob, String _vet_ssn, String _vet_gender, String _vet_fname, String _vet_lname,  String _vet_mname,  String _vet_prx,  String _vet_sfx,  String _vet_phone,  String _vet_street1, String _vet_street2,  String _vet_street3,  String _vet_street4,  String _vet_city,  String _vet_state,  String _vet_postal,  String _vet_country) throws Exception
	{
		return null;
	}
	
	//if the icn is already in hand, just use it and skip the MVI search  step
	public static void WriteTIUNote(Persn _current_user, String _note_title, String _note_text, String _vet_icn) throws Exception
	{
		//PENDING
	}
	
	public static String EESearchHTML(Persn _current_user, String _vet_icn) throws Exception
	{
	

		Request req = RequestFactory.createRequest("EE.SUMMARY.REPORT");
        req.setParameter(Request.EE_KEY, _vet_icn);
        req.setParameter(Request.EE_KEY_TYPE, "VPID");
        req.setParameter(Request.EE_REQUEST_NAME, "CaregiverData");
        Response resp = Executor.newInstance().execute(req);
        if(resp.error())
        	throw new Exception(resp.errormsg());
        	
        
        SimpleResponse response = (SimpleResponse)resp;
        
        StringWriter writer = new StringWriter();
		StreamResult result = new StreamResult(writer);
		CacheHandler.instance().getTransform("EE.HTML").transform(new DOMSource(response.response_doc()), result);
		String _xformed_response = writer.toString();	
        		
		return _xformed_response;
		
	}
	
	

	public static String EEDodSearch(String _vet_icn)  throws Exception
	{


		Request req = RequestFactory.createRequest("EE.SUMMARY.REPORT");
        req.setParameter(Request.EE_KEY, _vet_icn);
        req.setParameter(Request.EE_KEY_TYPE, "VPID");
        req.setParameter(Request.EE_REQUEST_NAME, "CaregiverData");
        Response resp = Executor.newInstance().execute(req);
        if(resp.error())
        	throw new Exception(resp.errormsg());
        	
        
        SimpleResponse response = (SimpleResponse)resp;
        

        String returnvalue = null;
        if(response.record_count() > 0)
        {
        	if( response.response_records()[0].get("DATE.OF.DEATH") != null)
        	{
        		returnvalue = response.response_records()[0].get("DATE.OF.DEATH");
        		if(returnvalue.length() == 8)
        		{
        		//	2001 0926
        			String year = returnvalue.substring(0, 4);
        			String month = returnvalue.substring(4, 6);
        			String day = returnvalue.substring(6, 8);
        			
        			returnvalue = month + "/" + day + "/" + year;
        		}
        	}
        }
        System.out.println("DOD (" + _vet_icn + "):" + returnvalue);
        return returnvalue;
		
	}
	
	
}
