package gov.va.caret.portlet.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Docum;
import gov.va.caret.model.VcgAn;
import gov.va.caret.pdf.FileType;
import gov.va.caret.security.CAction;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.usps.GetInfoByCityResponseGetInfoByCityResult;
import gov.va.caret.service.usps.USZipLocator;
import gov.va.caret.service.usps.USZipSoap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;

import org.apache.axis.message.MessageElement;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;


public abstract class ResourceCommand {
	
	public static Object handle ( ResourceRequest request, ResourceResponse response, ResourceCommand resourceHandler ){
		String action = ParamUtil.getString( request, CaretStrPool.ACTION, StringPool.BLANK );
		if ( _log.isDebugEnabled() ){
			_log.info("action... " + action );
		}
		if ( !action.isEmpty() ) try {
			Method reflected = resourceHandler.getClass().getDeclaredMethod( action, ResourceRequest.class, ResourceResponse.class );
			//added to improve performance
//			reflected.setAccessible(true);
			return reflected.invoke( resourceHandler, request, response );
		} catch (NoSuchMethodException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (IllegalAccessException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (InvocationTargetException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SecurityException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return StringPool.BLANK;
	}
	
	
	public String getZips ( ResourceRequest request, ResourceResponse response ){
		 _log.info("inside getCities... ");
		 String city = ParamUtil.get(request, "city", StringPool.BLANK);
		 JSONObject zip, json = JSONFactoryUtil.createJSONObject();

		 if ( !city.isEmpty() ){
			 int size = 0;
			JSONArray zips = JSONFactoryUtil.createJSONArray();
			
			List<Map<String, Object>> list = null;
			try {
				list = CaretLocalServiceUtil.getReport( CaretStrPool.ZIP_REPORT, city );
				size = list.size();
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}

			json.put("size", size );
			
			List<String> formatted = new ArrayList<String>();
			for ( Map<String, Object> cont : list ){
				formatted.add( Toolbox.formatZip( cont.get(CaretStrPool.NDX0) ) );
			}
			Collections.sort(formatted);
			
			_log.info("user size vcgs.. " + list.size() );
			for ( String cont : formatted ){
				zip = JSONFactoryUtil.createJSONObject();
				zip.put(CaretStrPool.ZIP, cont );
				zips.put(zip);
			}
			
			json.put("zips", zips);
		 } else {
			 json.put("size", 0 );
		 }
		 return writeJson ( response, json );
	}
	
	@SuppressWarnings("unchecked")
	public void getUSPSZips(ResourceRequest request, ResourceResponse response){				 		 
		String userState = ParamUtil.get(request, "userState", StringPool.BLANK);
		String userCity = ParamUtil.get(request, "userCity", StringPool.BLANK);
		JSONObject oneZip, json = JSONFactoryUtil.createJSONObject();
		JSONArray allZips = JSONFactoryUtil.createJSONArray();
		 
		USZipLocator locator = new USZipLocator();
		String zips = StringPool.BLANK;
		try {	
			USZipSoap soap = locator.getUSZipSoap();
			
			if(soap != null){					
				GetInfoByCityResponseGetInfoByCityResult info = soap.getInfoByCity(userCity);
				
				if(info != null){
					MessageElement [] allZipsbyCity = info.get_any();												
						
					Iterator<MessageElement> zipsByCityIterator = (Iterator<MessageElement>) allZipsbyCity[0].getChildElements();
				    
				    if(allZipsbyCity[0].getChildren().size()>0){
					    while(zipsByCityIterator.hasNext())
					    {
					    	MessageElement oneElement = (MessageElement) zipsByCityIterator.next();
					    	
					        Iterator<MessageElement> oneZipByCityIterator = (Iterator<MessageElement>) oneElement.getChildElements();
						    String currentState = StringPool.BLANK;
					        while(oneZipByCityIterator.hasNext())
						    {
						    	MessageElement oneZipRecord = (MessageElement) oneZipByCityIterator.next();
						
						    	if("STATE".equals(oneZipRecord.getName())){
							    	currentState = oneZipRecord.getValue();
						    	}
						    	if("ZIP".equals(oneZipRecord.getName())){
							    	if(currentState.equals(userState)){
								    	zips = zips.concat(oneZipRecord.getValue() +",");
								    	oneZip = JSONFactoryUtil.createJSONObject();
								    	oneZip.put("oneZip", oneZipRecord.getValue());
										allZips.put(oneZip);
							    	}
						    	}		    	
						    }
					       
					        json.put("size", allZips.length());
					        json.put("allZips", allZips);		
						  }
					}else{
						json.put("size", 0 );
					}
				}else{
					json.put("msg", "Service Unavailable");
				}
			}else{
				json.put("msg", "Service Unavailable");
			}
		}catch (ServiceException e) {
			json.put("msg", "Service Unavailable");
			ApplicationWorkFlowException.handleException(e);
		}catch (RemoteException e) {
			json.put("msg", "Service Unavailable");
			ApplicationWorkFlowException.handleException(e);
		}
				
		writeJson ( response, json);
	}
	
	public String getCities ( ResourceRequest request, ResourceResponse response ){
		 _log.info("inside getCities... ");
		 String state = ParamUtil.get(request, CaretStrPool.STATE, StringPool.BLANK);
		 JSONObject city, json = JSONFactoryUtil.createJSONObject();

		 if ( !state.isEmpty() ){
			 int size = 0; 
			JSONArray cities = JSONFactoryUtil.createJSONArray();
			
			List<Map<String, Object>> list = null;
			try {
//				list = BlsAeLocalServiceUtil.findCities( state );
				list = CaretLocalServiceUtil.getReport( CaretStrPool.CITY_REPORT, state );
				size = list.size();
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}

			json.put("size", size);
			
			_log.info("user size vcgs.. " + list.size() );
			for ( Map<String, Object> cont : list ){
				city = JSONFactoryUtil.createJSONObject();
				city.put(CaretStrPool.CITY, cont.get("ndx0").toString() );
				cities.put(city);
			}
			
			json.put("cities", cities);
		 } else {
			 json.put("size", 0 );
		 }
		 return writeJson ( response, json );
	}
	
	public String getFacils ( ResourceRequest request, ResourceResponse response ){
		_log.info ( "getFacils..." );
		 String zip = ParamUtil.get(request, CaretStrPool.ZIP, StringPool.BLANK);
		 JSONObject facility, json = JSONFactoryUtil.createJSONObject();

		 if ( !zip.isEmpty() ){
			 
			JSONArray facilities = JSONFactoryUtil.createJSONArray();
			int size = 0;
			List<Map<String, Object>> list = null;
			try {
				list = CaretLocalServiceUtil.getReport( CaretStrPool.FACILITY_REPORT, zip );
				size = list.size();
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}

//			Collections.sort(list);
			json.put("size", size );
			
			StringBuilder sb;
			boolean includeNumber = true;
			
			_log.info("user size vcgs.. " + list.size() );
			for ( Map<String, Object> cont : list ){
				facility = JSONFactoryUtil.createJSONObject();
				facility.put("groupId", cont.get(CaretStrPool.NDX0).toString() );
				sb = new StringBuilder( );
				if ( includeNumber ){
					sb.append( cont.get(CaretStrPool.NDX2) ).append(StringPool.COMMA_AND_SPACE);
				}
				sb.append( cont.get(CaretStrPool.NDX1) ).append(StringPool.COMMA_AND_SPACE)
					.append( cont.get(CaretStrPool.NDX3) ).append(StringPool.COMMA_AND_SPACE).append( cont.get(CaretStrPool.NDX4) ).append(" mi");
				facility.put("facility", sb.toString() );
				facilities.put(facility);
			}
			
			json.put("facilities", facilities);
		 } else {
			 json.put("size", 0 );
		 }
		 return writeJson ( response, json );
	}

	public void uploadFile ( ResourceRequest request, ResourceResponse response ) throws FileNotFoundException{
		UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest(request);
		long size = uploadRequest.getSize("file");
		_log.info("size=" + size );
		if ( size == 0 ){
			_log.info("returning since size is 0...");
			return;
		}

		File uploadFile = uploadRequest.getFile("file");
		String name = uploadRequest.getFileName("file");
		
		_log.info("path is ... " + uploadFile.getPath());
		request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_PATH, uploadFile.getPath());
		request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_NAME, name);
	}
	
	public String getDocum(ResourceRequest request, ResourceResponse response) {
		if ( !CAction.canDoCaret( request, CAction.CaretCan.VIEW_VETERANS ) ) {
			_log.warn("permissioning... ");
			return StringPool.BLANK;
		}
		try {
			_log.info("getDocum()");
            long dataId = ParamUtil.getLong(request, "documId", 0);
            if ( dataId == 0 ){
            	long vcgAnId = ParamUtil.getLong(request, "vcgAnId", 0);
            	if ( vcgAnId > 0 ){
            		List<Docum> vcgAnDoc = DocumLocalServiceUtil.getByClass(vcgAnId, PortalUtil.getClassNameId(VcgAn.class), FileType.TEN_TEN_CG.name() );
	            	if ( !vcgAnDoc.isEmpty() ){
	            		dataId = vcgAnDoc.get(0).getDocumId();
	            	}
            	}
            }
            
            if ( dataId == 0 ){
            	long classPk = ParamUtil.getLong(request, "classPk", 0);
            	if ( classPk > 0 ){
            		List<Docum> list = DocumLocalServiceUtil.getByPrimaryKey( classPk );
            		if ( !list.isEmpty() ){
            			Docum docum = list.get(0);
                        if ( docum != null ) {
                            Blob blob = docum.getDocument();
                            byte[] binaryData = blob.getBytes( 1, (int) blob.length() );
                            writeStream( response, binaryData, docum.getName() );
                        }
            		}
            	}
            }
            
            if ( dataId == 0 ){
            	return StringPool.BLANK;
            }
            
            Docum docum = DocumLocalServiceUtil.getDocum(dataId);
            if ( docum != null ) {
                Blob blob = docum.getDocument();
                byte[] binaryData = blob.getBytes( 1, (int) blob.length() );
                writeStream( response, binaryData, docum.getName() );
            }
 
        } catch (Exception e) {
        	ApplicationWorkFlowException.handleException(e);
        }
		return StringPool.BLANK;
	}
	
	protected void writeStream ( ResourceResponse response, byte[] byteArray, String documentName ) throws IOException {
		response.setContentType( MimeTypesUtil.getContentType( documentName ) );
        response.setProperty("Cache-Control", "no-cache");
        response.setProperty("Content-disposition","attachement; filename=" + documentName );
        OutputStream o = response.getPortletOutputStream();
        o.write(byteArray);
        o.flush();
        o.close();
        response.flushBuffer();
	}
	
	protected String writeJson ( ResourceResponse response, JSONObject json ) {
		response.setContentType("text/x-json");
		response.setProperty("Cache-Control", "no-cache");
		try {
			response.getWriter().write( json.toString() );
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return StringPool.BLANK;
	}
	
	protected String getValue ( ResourceRequest request, String parameter ){
		String[] val = request.getParameterMap().get( parameter ); 
		return val==null? null: val[0] ;
	}
	
	protected String removeSpecialChars( String str ) {
		return str == null? null: str.replaceAll("[^a-zA-Z0-9 ]", "");
	}
	
	public void deleteDocum(ResourceRequest request, ResourceResponse response) 
	{
		if ( !CAction.canDoCaret( request, CAction.CaretCan.DELETE_FILE ) ) {
			_log.warn("permissioning... ");
			return;
		}
		//_log.info("delete doc");
        long documId = ParamUtil.getLong(request, "documId", 0);
		String comment = ParamUtil.getString(request, "deleteComment", "");

       // _log.info("document id is : "+documId);
       // _log.info("comment is : "+comment);
        try {
        	Docum document = DocumLocalServiceUtil.getDocum(documId);
        	
        	if(document != null){
        		document.setNote(comment);
        		DocumLocalServiceUtil.deleteDocument(document);      		
        	}

		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}  	
        
		JSONObject json = JSONFactoryUtil.createJSONObject();		
		json.put("documentId", documId);	
		writeJson ( response, json);

	}
	
	

	private static Log _log = LogFactoryUtil.getLog( ResourceCommand.class );

	public void validateUSPSAddress ( ResourceRequest request, ResourceResponse response ){
		validateUSPSAddress(request, response, true);
	}
	
	public void validateUSPSAddress ( ResourceRequest request, ResourceResponse response, boolean useCache ){
	    JSONObject json = JSONFactoryUtil.createJSONObject();
	    String userAddress = ParamUtil.get(request, "userAddress", StringPool.BLANK);
	    String userApt = ParamUtil.get(request, "userAddress2", StringPool.BLANK);
	    String userState = ParamUtil.get(request, "userState", StringPool.BLANK);
	    String userCity = ParamUtil.get(request, "userCity", StringPool.BLANK);
	    String userZip = ParamUtil.get(request, "userZip", StringPool.BLANK);
	    String sb = null;
	    if ( useCache ){
	    	sb = new StringBuilder(userAddress).append(userApt).append(userState).append(userCity).append(userZip).toString();
	    	Object jsonObj = request.getPortletSession().getAttribute( sb.toString() );
	    	if ( jsonObj != null ){
	    		writeJson ( response, (JSONObject) jsonObj );
	    		return;
	    	}
	    }
	    try{
	    	String apt;
	        if ( Toolbox.isEmpty( userApt ) ) {
				apt = "<Address1 />";
			} else {
				apt = "<Address1>" + userApt + "</Address1>";
			}
		    String urlQuery = "API=Verify&XML=<AddressValidateRequest USERID=\"402VA0000550\"><IncludeOptionalElements>true</IncludeOptionalElements><ReturnCarrierRoute>true</ReturnCarrierRoute><Address ID=\"0\"><FirmName />"+ apt +"<Address2>"+userAddress+"</Address2><City>"+userCity+"</City><State>"+userState+"</State><Zip5>"+userZip+"</Zip5><Zip4></Zip4></Address></AddressValidateRequest>";
		    
	        URI uri = new URI(
	                        "http", 
	                        "production.shippingapis.com", 
	                        "/ShippingAPI.dll",
	                        urlQuery,
	                        null);
	        URL url = uri.toURL();
	        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	        DocumentBuilder db = factory.newDocumentBuilder();
	        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
	        Document doc = db.parse(url.openStream());
	        doc.getDocumentElement().normalize();

	        NodeList nodeList = doc.getElementsByTagName("Error");
	        if (nodeList != null && nodeList.getLength() > 0) {
	            json.put("msg", "Invalid Address");
	        }else{	        	
	        	String address2 = doc.getElementsByTagName("Address2").item(0).getTextContent();
	        	String address1 = StringPool.BLANK;
	        	if ( doc.getElementsByTagName("Address1").item(0) != null ) {
	        		address1 = doc.getElementsByTagName("Address1").item(0).getTextContent();
	        	}
	        	String city = doc.getElementsByTagName("City").item(0).getTextContent();
	        	String state = doc.getElementsByTagName("State").item(0).getTextContent();
	        	String zip = doc.getElementsByTagName("Zip5").item(0).getTextContent();
	        	
	        	if(!((userAddress.toUpperCase()).equals(address2))
	        		|| !((userApt.toUpperCase()).equals(address1))
	        		||	!((userCity.toUpperCase()).equals(city))
	        		|| !((userState.toUpperCase()).equals(state))
	        		|| !(userZip.equals(zip)))
	        	{
	        		String correctedAddress = address2 + StringPool.SPACE + address1 + StringPool.COMMA_AND_SPACE +city+ StringPool.COMMA_AND_SPACE +state+ StringPool.COMMA_AND_SPACE +zip;
	        		json.put("msg", "Invalid Address");
	        		json.put("correctedAddress", correctedAddress);
	        	}else{
		            json.put("msg", "Valid Address");
	        	}
	        }
	    } catch (Exception e) {
	        json.put("msg", "Service Unavailable");
	        ApplicationWorkFlowException.handleException(e);
	    }
	    if ( useCache ){
	    	request.getPortletSession().setAttribute( sb.toString(), json );
	    }
	    writeJson ( response, json );
	}

	public abstract String getJspDir() ;
	
	public void getUserList ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException{
		 _log.info("inside getUserList... ");
		 
		if ( !CAction.canDoCaret( request, CAction.CaretCan.GET_USERS ) ) {
			_log.warn("permissioning... ");
			return;
		}
		 
		JSONObject oneUser, json = JSONFactoryUtil.createJSONObject();
		JSONArray allUsers = JSONFactoryUtil.createJSONArray();
	    String referredBy = ParamUtil.get(request, "referredBy", StringPool.BLANK);

	    String roleProp = StringPool.BLANK;
		if(!"".equals(referredBy) && CaretStrPool.CSL.equals(referredBy)){
			roleProp = CaretStrPool.CSL_PROP;
		}else if(!"".equals(referredBy) && CaretStrPool.CSC.equals(referredBy)){
			roleProp = CaretStrPool.CSC_PROP;
		}
		 		 
		_log.info("user-group is : "+PortletProps.get(roleProp));
		Map<String, String> roleGroup = new HashMap<String, String>();
		roleGroup.put("roleGroup", PortletProps.get(roleProp));		
		List<Map<String,Object>> list = CaretLocalServiceUtil.getReport( "cslUserList", roleGroup);
		
		for (Map<String, Object> map : list) {
	        oneUser = JSONFactoryUtil.createJSONObject();
	        String persnId = "";
	        String firstName = "";
	        String lastName = "";
		    for (Map.Entry<String, Object> entry : map.entrySet()) {
		        String key = entry.getKey();
		        String value = entry.getValue().toString();
		        
		        //_log.info("key/value pair is :"+key+"/"+value);
		        //For reference
		        //ndx0 - roleId	//ndx1 - role name	//ndx2 - userId	//ndx3 - persnId	//ndx4 - first name	//ndx5 - last name

		        if(key.equals("ndx3")){
		        	persnId = value;
		        }else if(key.equals("ndx4")){
		        	firstName = value;
		        }else if(key.equals("ndx5")){
		        	lastName = value;
		        }		        
		    }
		    oneUser.put("persnId", persnId);
		    oneUser.put("name", firstName+" "+lastName);
			allUsers.put(oneUser);
		}

		json.put("userList", allUsers);
		json.put("userListSize", allUsers.length());
		
		writeJson ( response, json);		
	}		
	
	public boolean pastMaxTime(ResourceRequest request, ResourceResponse response) {
		return false;
	}
}
