package gov.va.caret.portlet.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ProcessAction;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Dummy;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.OnlineViewController;
import gov.va.caret.controller.dashboard.config.OnlineDashboardConfig;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.VcgUx;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.support.BoxedGroupAssociation;
import gov.va.caret.model.support.Person;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CodifiedRole;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.VcgUxLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.OnlineUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.ResultMap;

public class OnlineActionCommand extends ActionCommand {
	
	@ProcessAction (name="saveUserExpEsig")
	public void saveUserExpEsig( ActionRequest request, ActionResponse actionResponse ) throws ApplicationWorkFlowException, PortalException, SystemException {
		if ( ParamUtil.getLong(request, CaretStrPool.READ_CONFIRMATION ) == PortalUtil.getUserId(request) ){
			if ( "eSig".equals(request.getParameter("eSig") ) ){
				List<BoxGp> urls;
				long lookupId;
				try {
					long vcgAnId = ParamUtil.getLong(request, CaretStrPool.VCGANID );
					if (vcgAnId > 0) {
						lookupId = vcgAnId;
					} else {
						lookupId = PortalUtil.getUserId(request);
					}
					urls = CaretUtil.loadBoxGroup ( "last-attestation-url", "last-attestation-url" );
					BgLae bgLae = BgLaeLocalServiceUtil.getBgLaeAssociation( lookupId, urls.get(0).getBoxGpId() );
					if ( !Toolbox.isEmpty( bgLae.getLargeText() ) ){						
						Map<String,String> map = Toolbox.getUrlQuery( bgLae.getLargeText() );
						OnlineViewController.get().signPdfDocument( request, map );
					}
				} catch (ApplicationWorkFlowException e) {
					e.printStackTrace();
				}  catch (UnsupportedEncodingException e1) {
					e1.printStackTrace();
				}
			}
		}
	}
	
	@ProcessAction (name="saveApplicationVcg")
	public void saveApplicationVcg( ActionRequest request, ActionResponse actionResponse ) throws ApplicationWorkFlowException, PortalException, SystemException {
		if ( ParamUtil.getLong(request, CaretStrPool.READ_CONFIRMATION ) == PortalUtil.getUserId(request) ){
			if ( "eSig".equals(request.getParameter("eSig") ) ){
				List<BoxGp> urls;
				String lastUrl = request.getParameter(CaretStrPool.RESOURCE_HANDLER);
				long lookupId;
				try {
					Map<String,String> map = Toolbox.getUrlQuery( lastUrl );		
					long vcgAnId = Toolbox.getLong("vcgAnId", map); 
					if (vcgAnId > 0) {
						lookupId = vcgAnId;
					} else {
						lookupId = PortalUtil.getUserId(request);
					}
					urls = CaretUtil.loadBoxGroup ( "last-attestation-url", "last-attestation-url" );
					BgLae bgLae = BgLaeLocalServiceUtil.getBgLaeAssociation( PortalUtil.getUserId(request), urls.get(0).getBoxGpId() );
					if ( !Toolbox.isEmpty( bgLae.getLargeText() ) ){
						
						map = Toolbox.getUrlQuery( bgLae.getLargeText() );
						OnlineViewController.get().saveApplicationVcg( request, map, null );
					}
				} catch (ApplicationWorkFlowException e) {
					e.printStackTrace();
				}  catch (UnsupportedEncodingException e1) {
					e1.printStackTrace();
				}
			}
		}
		
//		Person intent = null;
//		long vcgAnId = ParamUtil.getLong(request, "vcgAnId", 0); 
//		long persnId = CaretParam.getPersnId(request);
//		Veteran veteran = null;
//		Primary primary = null;
//		Secondary secondary = null;
//		SecondaryTwo secondaryTwo = null;
//		
//		VcgApplication vcgApplication;
//		StringBuilder message = new StringBuilder();
//		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
//		String signed1010Form = LanguageUtil.get(themeDisplay.getLocale(), "signed-1010cg-form", " signed VA Form 10-10CG" );
//		ServiceContext sc = CaretParam.setOnlineServiceContext(request);
//		Set<Long> userIds = new HashSet<Long>();
//		if ( vcgAnId > 0 ){  //Update to application by caregiver
//			
//			try {
//				vcgApplication = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn(vcgAnId) ); 
//				veteran = new Veteran ( PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
//				userIds.add( veteran.getRootUserId() );
//				if ( vcgApplication.getPrimaryId() > 0 && vcgApplication.getPrimaryId() == persnId ){
//					if ( vcgApplication.getPrimarySignDate() != null ){
//						throw new ApplicationWorkFlowException( "Application was signed in another session." );
//					}
//					boolean mediEnrolled = ParamUtil.getBoolean(request, "vcgAn_mediEnrolled" );
//					vcgApplication.setMediEnrolled(mediEnrolled);
//					vcgApplication.setPrimaryRelationship(ParamUtil.getString(request, "vcgAn_primaryRelationship"));
//					
//					primary = new Primary ( PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) ) );
//					
//					Primary formPrim = (Primary) CaretParam.loadModel(request, new Primary( new PersnImpl() ),
//							Toolbox.getCollection("lastName","firstName","middleName",
//													"birthDate","gender","ssn","email","phone","phone2","email2", "otherHealthInsurance" ), 
//													CaretStrPool.PRIMARY_PERSN  + StringPool.UNDERLINE);
//					formPrim.setMediEnrolled(mediEnrolled);
//					loadAddress( request, formPrim, CaretStrPool.PRIMARY_PERSN );
//					boolean otherHealthInsurance = ParamUtil.getBoolean(request, "otherHealthInsurance", false);
//					if ( !otherHealthInsurance ){
//						formPrim.setOtherHealthInsurance(StringPool.BLANK);
//					} else {
//						formPrim.setOtherInsChecked(otherHealthInsurance);
//					}
//					
//					((Person)formPrim).setFamily( ParamUtil.getBoolean( request, "certifyFamily") ); 
//					((Person)formPrim).setNotFamily( ParamUtil.getBoolean( request, "certifyNotFamily") );
//					
//					if ( OnlineUtil.isRevision(formPrim, primary) ){
//						CaretLocalServiceUtil.save( formPrim );
//						vcgApplication.setPrimaryId( formPrim.getPersnId() );
//						primary = formPrim;
//					} else {
//						CaretLocalServiceUtil.save( primary );
//					}
//					primary.setRelationship( vcgApplication.getPrimaryRelationship() );
//					message.append(primary.getFullName());
//					userIds.add( primary.getRootUserId() );
//					intent = primary;
//		      		_log.info("person is primary, notFamily=" + intent.isNotFamily() + ".. family=" + intent.isFamily()  );
//				}
//				if ( vcgApplication.getSecondaryId() > 0 && vcgApplication.getSecondaryId() == persnId ){
//					if ( vcgApplication.getSecondarySignDate() != null ){
//						throw new ApplicationWorkFlowException( "Application was signed in another session." );
//					}
//					vcgApplication.setSecondaryRelationship( request.getParameter("vcgAn_secondaryRelationship") );
//					
//					secondary = new Secondary ( PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) ) );
//					
//					Secondary formSec = (Secondary) CaretParam.loadModel(request, new Secondary( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
//							"birthDate","gender","ssn","phone","phone2","email","email2"), CaretStrPool.SECONDARY_PERSN  + StringPool.UNDERLINE);
//					loadAddress( request, formSec, CaretStrPool.SECONDARY_PERSN );
//					((Person)formSec).setFamily( ParamUtil.getBoolean( request, "certifyFamily") ); 
//					((Person)formSec).setNotFamily( ParamUtil.getBoolean( request, "certifyNotFamily") ); 
//					
//					if ( OnlineUtil.isRevision(formSec, secondary) ){
//						CaretLocalServiceUtil.save( formSec );
//						vcgApplication.setSecondaryId( formSec.getPersnId() );
//						secondary = formSec;
//					} else {
//						CaretLocalServiceUtil.save( secondary );
//					}
//					secondary.setRelationship( vcgApplication.getSecondaryRelationship() );
//					message.append(secondary.getFullName());
//					userIds.add( secondary.getRootUserId() );
//					intent = secondary;
//		      		_log.info("person is secondary");
//				}
//				if ( vcgApplication.getSecondaryTwoId() > 0 && vcgApplication.getSecondaryTwoId() == persnId ){
//					if ( vcgApplication.getSecondaryTwoSignDate() != null ){
//						throw new ApplicationWorkFlowException( "Application was signed in another session." );
//					}
//					vcgApplication.setSecondaryTwoRelationship( request.getParameter("vcgAn_secondaryTwoRelationship") );
//					
//					secondaryTwo = new SecondaryTwo ( PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) ) );
//					
//					SecondaryTwo formSec2 = (SecondaryTwo) CaretParam.loadModel(request, new SecondaryTwo( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
//							"birthDate","gender","ssn","phone","phone2","email","email2"), CaretStrPool.SECONDARY_TWO_PERSN  + StringPool.UNDERLINE);
//					loadAddress( request, formSec2, CaretStrPool.SECONDARY_TWO_PERSN );
//					((Person)formSec2).setFamily( ParamUtil.getBoolean( request, "certifyFamily") ); 
//					((Person)formSec2).setNotFamily( ParamUtil.getBoolean( request, "certifyNotFamily") ); 
//					if ( OnlineUtil.isRevision(formSec2, secondaryTwo) ){
//						CaretLocalServiceUtil.save( formSec2 );
//						vcgApplication.setSecondaryTwoId( formSec2.getPersnId() );
//						secondaryTwo = formSec2;
//					} else {
//						CaretLocalServiceUtil.save( secondaryTwo );
//					}
//					secondaryTwo.setRelationship( vcgApplication.getSecondaryTwoRelationship() );
//					message.append(secondaryTwo.getFullName());
//					userIds.add( secondaryTwo.getRootUserId() );
//					intent = secondaryTwo;
//		      		_log.info("person is secondarytwo");
//				}
//				
//				VaForm1010cgSection vaForm1010cg = new VaForm1010cgSection( intent, vcgApplication, null );
//				try {
//					if ( !new PdfHandler().signUpdateDocum(vaForm1010cg) ){
//						_log.error("Could not save document, it was locked by another user");
//					} else {
//						message.append( signed1010Form );
//						if ( intent.getRole() == Person.Role.PRIMARY ){
//							vcgApplication.setPrimarySignDate( sc.getCreateDate() );
//						} else if ( intent.getRole() == Person.Role.SECONDARY ){
//							vcgApplication.setSecondarySignDate( sc.getCreateDate() );
//						} else if ( intent.getRole() == Person.Role.SECONDARYTWO ){
//							vcgApplication.setSecondaryTwoSignDate( sc.getCreateDate() );
//						}
//					}
//				} catch (COSVisitorException | IOException e2) {
//					e2.printStackTrace();
//				}
//				
//			} catch (PortalException e) {
//				throw new ApplicationWorkFlowException(e);
//			} catch (SystemException e) {
//				throw new ApplicationWorkFlowException(e);
//			}
//		} else {  // new Application submitted by Veteran....
//			veteran = new Veteran(PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) ));
//			vcgApplication = (VcgApplication) 
//					CaretParam.loadModel(request, 
//					new VcgApplication( new VcgAnImpl() ), 
//					Toolbox.getCollection("lastTreatmentPlace","hospital","clinic","vaHealthEnrolled","primaryId","secondaryId","secondaryTwoId"), 
//					CaretStrPool.VCGAN_UNDERLINE);
//			
//			if ( ( vcgApplication.getPrimaryId() > 0 && !veteran.isPrimaryAvailable() )
//			  || ( vcgApplication.getSecondaryId() > 0 && !veteran.isSecondaryAvailable() )
//			  || ( vcgApplication.getSecondaryTwoId() > 0 && !veteran.isSecondaryTwoAvailable() )){
//				throw new ApplicationWorkFlowException( "Application was signed in another session...." );
//			}
//			
//			Veteran formPerson = (Veteran) CaretParam.loadModel(request, new Veteran( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
//					"birthDate","gender","ssn","phone","phone2","email","groupId"), CaretStrPool.VETERAN_PERSN_UNDERLINE);
//			loadAddress( request, formPerson, CaretStrPool.VETERAN_PERSN );
//			formPerson.setVaHealthEnrolled( vcgApplication.getVaHealthEnrolled() );
//
//			saveOnlineAnswers(request);
//			
//			if ( OnlineUtil.isRevision(formPerson, veteran) ){
//				CaretLocalServiceUtil.save( formPerson );
//				veteran = formPerson;
//			} else {
//				CaretLocalServiceUtil.save( veteran );
//			}
//			userIds.add( veteran.getRootUserId() );//[22601]
//			
//			if ( vcgApplication.getPrimaryId() > 0 ){
//				primary = new Primary( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) ); 
//				userIds.add( primary.getRootUserId() );
//				String secondEmail = request.getParameter("primaryPersn_email2");
//				if ( !Toolbox.isEmpty(  secondEmail ) && !Person.EMAIL_FORMAT.equals(secondEmail) ){
//					primary.setEmail2( secondEmail );
//					CaretLocalServiceUtil.save(primary);
//				}
//			}
//			
//			if ( vcgApplication.getSecondaryId() > 0 ){
//				secondary = new Secondary( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) ); 
//				userIds.add( secondary.getRootUserId() );//[22737]=rootUI // secondaryId=423811
//				String secondEmail = request.getParameter("secondaryPersn_email2");
//				if ( !Toolbox.isEmpty(  secondEmail ) && !Person.EMAIL_FORMAT.equals(secondEmail) ){
//					secondary.setEmail2( secondEmail );
//					CaretLocalServiceUtil.save(secondary);
//				}
//			}
//			
//			if ( vcgApplication.getSecondaryTwoId() > 0 ){
//				secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) ); 
//				userIds.add( secondaryTwo.getRootUserId() );
//				String secondEmail = request.getParameter("secondaryTwoPersn_email2");
//				if ( !Toolbox.isEmpty(  secondEmail ) && !Person.EMAIL_FORMAT.equals(secondEmail) ){
//					secondaryTwo.setEmail2( secondEmail );
//					CaretLocalServiceUtil.save(secondaryTwo);
//				}
//			}
//			
//			vcgApplication.setVeteranId( veteran.getPersnId() );
//			vcgApplication.setGroupId( veteran.getGroupId() );
//			vcgApplication.setStatus( ApplicationStatus.NEED_SIGNATURE.name() );
//
//			message.append(formPerson.getFullName()).append(signed1010Form);
//			
//			CaretLocalServiceUtil.save( vcgApplication );
//			VaForm1010cgSection vaForm1010cg = new VaForm1010cgSection( veteran, vcgApplication, null );
//			try {
//				if ( !new PdfHandler().signUpdateDocum(vaForm1010cg) ){
//					_log.error("Could not save document, it was locked by another user");
//				}
//			} catch (COSVisitorException | IOException e2) {
//				e2.printStackTrace();
//			}
//			
//		}
//		
//		WorIm workItem = null;
//		if ( vcgAnId > 0 ){
//			int signCount = 0;
//			if ( vcgApplication.getSecondaryTwoSignDate() != null ) signCount++;
//			if ( vcgApplication.getPrimarySignDate() != null ) signCount++;
//			if ( vcgApplication.getSecondarySignDate() != null ) signCount++;
//			
//			int idCount = 0;
//			if ( vcgApplication.getPrimaryId() > 0 ) idCount++;
//			if ( vcgApplication.getSecondaryId() > 0 ) idCount++;
//			if ( vcgApplication.getSecondaryTwoId() > 0 ) idCount++;
//			
//			if ( signCount > 0 && signCount == idCount ){
//				vcgApplication.setSubmitDate( sc.getCreateDate() );
//				vcgApplication.setReceivedDate( sc.getCreateDate() );
//				vcgApplication.setStatus( ApplicationStatus.SUBMITTED.name() );
//				long caregiverId = 0;
//				if ( vcgApplication.getPrimaryId() > 0 ){
//					caregiverId = vcgApplication.getPrimaryId(); 
//					if ( primary == null ){
//						primary = new Primary( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) );
//					}
//					userIds.add( primary.getRootUserId() );
//				} else if ( vcgApplication.getSecondaryId() > 0 ){
//					caregiverId = vcgApplication.getSecondaryId();
//					if ( secondary == null ){
//						secondary = new Secondary( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) );
//					}
//					userIds.add( secondary.getRootUserId() );
//				} else {
//					caregiverId = vcgApplication.getSecondaryTwoId();
//					userIds.add(caregiverId);
//					if ( secondaryTwo == null ){
//						secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) );
//					}
//					userIds.add( secondaryTwo.getRootUserId() );
//				}
//				userIds.add( veteran.getRootUserId() );
//				
//				workItem = CaretUtil.createWorkItem( sc, vcgApplication.getGroupId(), vcgApplication, WorkType.ONLINE_APP, veteran.getPersnId(), caregiverId );
//			
//			}
//		}
//		CaretLocalServiceUtil.save( vcgApplication );
//		
//		
//		
//		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
//		List<Docum> documents = DocumLocalServiceUtil.getByTrackerNote( tracker );
//		for ( Docum docum : documents ){
//			if ( docum.getClassPk() == 0 ){
//				docum.setClassPk(vcgApplication.getVcgAnId());
//				docum.setClassId(PortalUtil.getClassNameId(VcgAn.class));
//				docum.setNote(StringPool.BLANK);
//				DocumLocalServiceUtil.updateDocum(docum);
//			}
//		}
//		
//		for ( long userId : userIds ){
//			CaretLocalServiceUtil.addNote( CaretUtil.createNote(
//					sc.getCreateDate(), vcgApplication.getVcgAnId(), 0, userId, message.toString() ) );
//		}
//		if ( workItem != null ){
//			String workAddedToQue = LanguageUtil.get(themeDisplay.getLocale(), "online-1010-work-added-to-q", "10-10CG was submitted to VA for Review." );
//			CaretLocalServiceUtil.save( workItem );
//			userIds = new HashSet<Long>();
//			userIds.add(veteran.getRootUserId());
//			if ( vcgApplication.getPrimaryId() > 0 ){
//				userIds.add(new Person(PersnLocalServiceUtil.getPersn(vcgApplication.getPrimaryId())).getRootUserId());
//			}
//			if ( vcgApplication.getSecondaryId() > 0 ){
//				userIds.add(new Person(PersnLocalServiceUtil.getPersn(vcgApplication.getSecondaryId())).getRootUserId());
//			}
//			if ( vcgApplication.getSecondaryTwoId() > 0 ){
//				userIds.add(new Person(PersnLocalServiceUtil.getPersn(vcgApplication.getSecondaryTwoId())).getRootUserId());
//			}
//			for ( long userId : userIds ){
//				CaretLocalServiceUtil.addNote( CaretUtil.createNote(
//						sc.getCreateDate(), vcgApplication.getVcgAnId(), 0, userId, workAddedToQue ) );
//			}
//		}
//		_log.info( "finished Application creation...");
	}


	@ProcessAction (name="uploadTempFile")
	public void uploadTempFile ( ActionRequest request, ActionResponse actionResponse ) throws FileNotFoundException{
		
		UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest(request);
		String type = ParamUtil.get(request, CaretStrPool.TYPE, StringPool.BLANK);
		String name = uploadRequest.getFileName(CaretStrPool.FILE);
		File uploadFile = uploadRequest.getFile(CaretStrPool.FILE);
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		
		if ( ParamUtil.getBoolean(request, CaretStrPool.REPLACE ) ){
			removeFile( request, actionResponse );
		}
		
		long documId = 0;
		try {
			documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
		} catch (SystemException e1) {
			e1.printStackTrace();
		}
		Docum document = DocumLocalServiceUtil.createDocum(documId);

		InputStream inputStream = new FileInputStream( uploadFile );
		OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
		
		document.setDocument(outputBlob);
		document.setNote( tracker );
		document.setType( type );
		document.setName( name );
 		document.setClassId( ClassNameLocalServiceUtil.getClassNameId( Dummy.class) );
		
		try {
			DocumLocalServiceUtil.addDocum( document );
			FileUtil.delete(uploadFile);
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		} finally {
			if (inputStream != null) {
				try {
					inputStream.close();
				} catch (IOException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
	}
	
	@ProcessAction (name="removeFile")
	public void removeFile ( ActionRequest request, ActionResponse actionResponse ) throws FileNotFoundException{
		
		String trackerNote = request.getParameter(CaretStrPool.TRACKER);
		String type = request.getParameter( CaretStrPool.TYPE );
		try {
			for ( Docum toDelete : DocumLocalServiceUtil.getByTrackerNote( trackerNote, type ) ){
				if ( toDelete.getClassPk() == 0 ){
					DocumLocalServiceUtil.deleteDocum(toDelete);
				}
			}
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
	}
	
	@ProcessAction (name="loadEntry")
	public void loadEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		OnlineDashboardConfig dashboard = CAction.loadOnlineRoleId( actionRequest );
		OnlineUtil.setAutoCompFacilMap();
		
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);
		//boolean isVet = entry.startsWith("VET");
		//actionRequest.setAttribute("isVet", entry.startsWith("VET"));
		//
		if (dashboard.isVeteran()) {
		    if ("VET_WELCOME_INTRO".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetWelcomeIntro.jsp");
		    	return;
		    }
		    else if ("VET_GENERAL_INFO".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetGeneralInfo.jsp");
		    	return;
		    }
		    else if ("VET_REVIEW_CRITERIA".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetReviewCriteria.jsp");
		    	return;
		    }
		    else if ("VET_APPLY_NOW".equals(entry)) {
		    	loadApplication(actionRequest, actionResponse);
		    	return;
		    }
		    else if ("VET_MY_APPLICATIONS".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetMyApplications.jsp");
		    	try {
					OnlineViewController.get().loadRoleView( (PortletRequest)actionRequest, null );
				} catch (PortalException | SystemException e) {
					e.printStackTrace();
				}
		    	return;
		    }
		    else if ("VET_DESIGNATED_CAREGIVERS".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetDesignatedCaregivers.jsp");
		    	try {
					OnlineViewController.get().loadRoleView( (PortletRequest)actionRequest, null );
				} catch (PortalException | SystemException e) {
					e.printStackTrace();
				}
		    	return;
		    }	
		    else if ("VET_MESSAGES".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetMessages.jsp");
		    	try {
					OnlineViewController.get().loadRoleView( (PortletRequest)actionRequest, null );
				} catch (PortalException | SystemException e) {
					e.printStackTrace();
				}
		    	return;
		    }
		    else if ("VET_ONLINE_CHAT".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetOnlineChat.jsp");
		    	try {
					OnlineViewController.get().loadRoleView( (PortletRequest)actionRequest, null );
				} catch (PortalException | SystemException e) {
					e.printStackTrace();
				}		    	
		    	return;
		    }
		    else if ("VET_DASHBOARD".equals(entry)) {
		    	Map<String,Object> form = ResultMap.getForm (actionRequest);
		    	List<VcgUx> applicationUserExperienceList;
				try {
					applicationUserExperienceList = VcgUxLocalServiceUtil.findByTentenRole( PortalUtil.getUserId(actionRequest), new long[] {1l}, false);
					if ( applicationUserExperienceList == null || applicationUserExperienceList.isEmpty() ) {
						form.put("appInProgress", false );
					} else {
						form.put("appInProgress", true );
					}
				} catch (ApplicationWorkFlowException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
			
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetDashboard.jsp");
		    	return;
		    }
		}
		else {
		    if ("CGV_WELCOME_INTRO".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetWelcomeIntro.jsp");
		    	return;
		    }
		    else if ("CGV_GENERAL_INFO".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetGeneralInfo.jsp");
		    	return;
		    }	
		    else if ("CGV_REVIEW_CRITERIA".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/vetReviewCriteria.jsp");
		    	return;
		    }
		    else if ("CGV_APPLY_NOW".equals(entry)) {
		    	//loadApplication(actionRequest, actionResponse);
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/cgvMyApplications.jsp");
		    	try {
					OnlineViewController.get().loadRoleView( (PortletRequest)actionRequest, null );
				} catch (PortalException | SystemException e) {
					e.printStackTrace();
				}
		    	return;
		    }
		    else if ("CGV_VETERAN_APPLICANTS".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/cgvVeteranApplicants.jsp");
		    	try {
					OnlineViewController.get().loadRoleView( (PortletRequest)actionRequest, null );
				} catch (PortalException | SystemException e) {
					e.printStackTrace();
				}return;
		    }
		    else if ("CGV_MESSAGES".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/cgvMessages.jsp");
		    	try {
					OnlineViewController.get().loadRoleView( (PortletRequest)actionRequest, null );
				} catch (PortalException | SystemException e) {
					e.printStackTrace();
				}return;
		    }		    
		    else if ("CGV_DASHBOARD".equals(entry)) {
		    	Map<String,Object> form = ResultMap.getForm (actionRequest);
			    List<VcgUx> applicationUserExperienceList;
				try {
					applicationUserExperienceList = VcgUxLocalServiceUtil.findByTentenRole( PortalUtil.getUserId(actionRequest), new long[] {1l}, false);
					if ( applicationUserExperienceList == null || applicationUserExperienceList.isEmpty() ) {
						form.put("appInProgress", false );
					} else {
						form.put("appInProgress", true );
					}
				} catch (ApplicationWorkFlowException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/cgvDashboard.jsp");
				return;
		    }
		    else if ("CGV_ONLINE_CHAT".equals(entry)) {
		    	actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/online/cgvOnlineChat.jsp");
		    	try {
					OnlineViewController.get().loadRoleView( (PortletRequest)actionRequest, null );
				} catch (PortalException | SystemException e) {
					e.printStackTrace();
				}		    	
		    	return;
		    }
		}
	}	
	
	public void loadApplication( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String context = ParamUtil.getString( actionRequest, "context", StringPool.BLANK );
		OnlineDashboardConfig dashboard = CAction.loadOnlineRoleId( actionRequest );
		if ( "onlineQuestionaire".equals(context) ) {
			saveOnlineQuestions(actionRequest, actionResponse);
		}
		if ( CAction.loadOnlineRoleId( actionRequest ) != null ) {
			OnlineViewController.get().loadApplication(actionRequest); 
		}
	}
	
	public void cancelApplication( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String context = ParamUtil.getString( actionRequest, "context", StringPool.BLANK );
		if ( "onlineQuestionaire".equals(context) ){
			saveOnlineQuestions(actionRequest, actionResponse);
		}
		
		try {
			OnlineViewController.get().cancelApplication(actionRequest);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}
	
	public void saveOnlineQuestions( ActionRequest actionRequest, ActionResponse actionResponse ){
		try {
			_log.info("reached saveOnlineQuestions...");
			
			boolean enrolled = ParamUtil.getBoolean(actionRequest, "enrolled-in-va-health" );
			actionRequest.setAttribute(CaretStrPool.VETERAN_VA_HEALTH_ENROLLED, enrolled );
			
			boolean dateDischarged = ParamUtil.getBoolean(actionRequest, "military-discharged-date" );
			boolean activeDuty = ParamUtil.getBoolean(actionRequest, "is-veteran-in-military" );
			boolean needCare = ParamUtil.getBoolean(actionRequest, "needs-assistance-basic-functions" );
			
//			long persnId = CaretParam.getPersnId(actionRequest);

			Set<Long> boxGroups = new HashSet<Long>();
			actionRequest.getPortletSession().setAttribute(CaretStrPool.ONLINE_QUESTIONAIRE_YN, boxGroups);

			
			List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.ONLINE_QUESTIONAIRE_YN, CaretStrPool.ONLINE_QUESTIONAIRE_YN);
			for ( BoxGp boxGp: groups ){
				if ( boxGp.getLabel().equals( "enrolled-in-va-health" ) ){
					if ( enrolled ){
						boxGroups.add( boxGp.getBoxGpId() );
					}
					continue;
				}
				if ( boxGp.getLabel().equals( "military-discharged-date" ) ){
					if ( dateDischarged ){
						boxGp.getBoxGpId();
					}
					continue;
				}
				if ( boxGp.getLabel().equals( "is-veteran-in-military" ) ){
					if ( activeDuty ){
						boxGp.getBoxGpId();
					}
					continue;
				}
				if ( boxGp.getLabel().equals( "needs-assistance-basic-functions" ) ){
					if ( needCare ){
						boxGp.getBoxGpId();
					}
					continue;
				}
			}				
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	public void saveOnlineAnswers ( ActionRequest actionRequest ) throws ApplicationWorkFlowException {
		_log.info("reached saveOnlineAnswers...");
		@SuppressWarnings("unchecked")
		Set<Long> boxGroups = (Set<Long>) actionRequest.getPortletSession().getAttribute(CaretStrPool.ONLINE_QUESTIONAIRE_YN);
		if ( boxGroups == null ){
			return;
		}
		long persnId = CaretParam.getPersnId( actionRequest );
		for ( Long boxGpId : boxGroups ){
			BgAsn bgAsn = new BgAsnImpl();
			bgAsn.setBoxGpId( boxGpId );
			bgAsn.setOwnerId( persnId );
			bgAsn.setSelected( true );
			CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
		}
	}
	
	public void loadAddress(ActionRequest request, Person persn, String prefix) throws ApplicationWorkFlowException {
		persn.setCountry( ParamUtil.get(request, prefix+"_country" , StringPool.BLANK) );
		OnlineViewController.get().loadPersnAddress( request, persn, prefix );
		
		if ( PortletProps.get("required."+ persn.getRole().getLabel() + ".input").contains("uspsValidation") &&
				!persn.isForeigner() ){
			persn.setValidAddress(true);
		}
	}

	@ProcessAction (name="selectRole")
	public void selectRole( ActionRequest request, ActionResponse actionResponse ) throws ApplicationWorkFlowException, PortalException, SystemException {
		
		_log.info("reached selectRole.....");
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		if ( CaretUtil.isTrackerEnabled() ){
			if ( ! CaretParam.isTracked( request, tracker, true ) ){
				_log.warn("TRACKER BLOCKING action... ");
				request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
				return;
			}
		}
		String roleCode = ParamUtil.getString(request, "role", StringPool.BLANK );
		_log.info("selectRole....." + roleCode);
		
		if ( "VETERAN".equals(roleCode) || "CG_ROLE".equals(roleCode) ){
			String roleName = CodifiedRole.getRoleName(roleCode);
			long companyId = CompanyThreadLocal.getCompanyId();
			long groupId = GroupLocalServiceUtil.getGroup( companyId, CaretUtil.getOnlineSite() ).getGroupId();
			long userId = PortalUtil.getUserId(request);
			if ( !UserGroupRoleLocalServiceUtil.hasUserGroupRole( userId, groupId, roleName) ){
				UserGroupRoleLocalServiceUtil.addUserGroupRoles( new long[]{ userId }, 
					groupId, RoleLocalServiceUtil.fetchRole( companyId, roleName  ).getRoleId() );
			}
		}
	}
	
	
    public void undoSelectRole( ActionRequest request, ActionResponse actionResponse ) throws ApplicationWorkFlowException, PortalException, SystemException {
		
		_log.info("reached undoSelectRole.....");
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		if ( CaretUtil.isTrackerEnabled() ){
			if ( ! CaretParam.isTracked( request, tracker, true ) ){
				_log.warn("TRACKER BLOCKING action... ");
				request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
				return;
			}
		}
		_log.info("undoSelectRoles....." );
		
		
		long companyId = CompanyThreadLocal.getCompanyId();
		long groupId = GroupLocalServiceUtil.getGroup( companyId, CaretUtil.getOnlineSite() ).getGroupId();
		long userId = PortalUtil.getUserId(request);
		if ( UserGroupRoleLocalServiceUtil.hasUserGroupRole( userId, groupId, CodifiedRole.getRoleName("VETERAN") ) ){
			UserGroupRoleLocalServiceUtil.deleteUserGroupRoles( new long[]{ userId }, 
				groupId, RoleLocalServiceUtil.fetchRole( companyId, CodifiedRole.getRoleName("VETERAN")  ).getRoleId() );
		}
		if ( UserGroupRoleLocalServiceUtil.hasUserGroupRole( userId, groupId, CodifiedRole.getRoleName("CG_ROLE") ) ){
			UserGroupRoleLocalServiceUtil.deleteUserGroupRoles( new long[]{ userId }, 
				groupId, RoleLocalServiceUtil.fetchRole( companyId, CodifiedRole.getRoleName("CG_ROLE")  ).getRoleId() );
		}
		request.getPortletSession().removeAttribute( CaretStrPool.ONLINE_DASHBOARD_CONFIG );
		_log.info("reset completed");
	}
	
	
	
	private static Log _log = LogFactoryUtil.getLog( OnlineActionCommand.class );



	
	
}
