package gov.va.caret.portlet;


import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.CaretViewController;
import gov.va.caret.portlet.action.CaretActionCommand;
import gov.va.caret.portlet.resource.CaretResourceCommand;
import gov.va.caret.security.CAction;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.ZipFyLocalServiceUtil;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.TemplateHandler;
import gov.va.caret.view.BootStrapUtil;

import java.io.File;
import java.io.IOException;
import java.util.Collections;

import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;


public class CaretPortlet extends CaretBasePortlet {
	
	public void init() throws PortletException {
		
		super.init();
		
		this.actionCommand = new CaretActionCommand();
		this.resourceCommand = new CaretResourceCommand();
		this.viewController = CaretViewController.getViewController();

		_log.info( "Initializing " + viewController.getVersion() );
		_log.info( "on " + ReleaseInfo.getReleaseInfo() );
			
		try{
			boolean isMviEnabled = CaretUtil.isMviEnabled();
			_log.warn("portlet-ext.properties... search.mvi.attended.enabled=" + isMviEnabled);

			if ( isMviEnabled ){
				try {
					String mviWsdl = new TemplateHandler().loadTemplate( Collections.singletonMap("wsdlLocation", (Object) PropsUtil.get("IdMWebService.wsdl.ftl.location") ), "/gov/va/oit/oed/vaww/templates", "IdMWebService.ftl" );
					File toSet = new File( CaretUtil.getWsdlDirectory() + "/IdMWebService.wsdl");
					FileUtil.write(toSet, mviWsdl);
					_log.debug("WSDL:" + mviWsdl);
				} catch ( Exception e ){
					e.printStackTrace();
				}
			}
			
			
			String[] realPath = new String[]{PropsUtil.get("spreadsheet.location")};
				_log.warn("portlet-ext.properties... spreadsheet.location=" + realPath[0]);
				_log.warn("portlet-ext.properties... init.bootstrap.enabled=" + PropsUtil.get("init.bootstrap.enabled") );
				if ( StringPool.TRUE.equals(PropsUtil.get("init.bootstrap.enabled") ) ){
					try {
						if ( OrganizationLocalServiceUtil.getOrganizationsCount() < 20 ){
							_log.info("begin bootstrap orgs...");
							BootStrapUtil.bootstrapOrgs( getPortletContext(), realPath );
						}
						
						if ( ZipFyLocalServiceUtil.getZipFiesCount() < 5 ){
							_log.info("begin bootstrap facility zip...");
							BootStrapUtil.bootstrapFacZip( getPortletContext(), realPath );
						}
						
						int	count = BlsReLocalServiceUtil.getBlsResCount();
						_log.info("bls zip count=" + count );
						if ( count < 50 ){
							_log.info("begin bootstrap bls Rates...");
							BootStrapUtil.loadBlsRate( getPortletContext(), realPath );
						}
						
					} catch (ApplicationWorkFlowException e1) {
						ApplicationWorkFlowException.handleException(e1);
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					} catch (PortalException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
				
				
				try {
					ServiceContext sc = new ServiceContext();
					sc.setUserId( UserLocalServiceUtil.getDefaultUserId( PortalUtil.getDefaultCompanyId() ) );
					sc.setCompanyId( PortalUtil.getDefaultCompanyId() );
					sc.setAddGuestPermissions(false);
					
					if ( OrganizationLocalServiceUtil.getOrganizationsCount() > 20 ){
						_log.info("attempt site, role, and page setups...");
						BootStrapUtil.setup(sc);
						
						long siteId = GroupLocalServiceUtil.getGroup( PortalUtil.getDefaultCompanyId(), CaretUtil.getClinicSite() ).getGroupId();
						PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup(LayoutLocalServiceUtil.getLayouts(siteId, true).get(0), CAction.CARET_PORTLET);
						portletSetup.setValue("portletSetupShowBorders", String.valueOf(Boolean.FALSE));
						portletSetup.store();
						
						
						_log.info("begin bootstrap persn...");
						BootStrapUtil.bootstrapPersonTable();
						
						if ( "true".equals( PropsUtil.get( "load.caret.sqa.users" ) ) ){
							BootStrapUtil.addUsers ( sc );
						} else {
							_log.info("load.caret.sqa.users=" + PropsUtil.get( "load.caret.sqa.users" ) );
						}
					}

				}
				catch (Exception e) {
					throw new ActionException(e);
				}
				
				String esig = new TemplateHandler().loadTemplate( Collections.singletonMap("wsdlLocation", (Object) PropsUtil.get("ESigDSS.wsdl.ftl.location") ), "/gov/va/oit/oed/vaww/templates", "ESigDSS.ftl" );
				File toSet = new File( CaretUtil.getWsdlDirectory() + "/ESigDSS.wsdl");
				FileUtil.getFile().write(toSet, esig);
				if ( _log.isDebugEnabled() ) {
					_log.debug("ESigDSS:" + esig);
				}
				_log.info("init completed...");
				
		} catch ( Exception e ){
			_log.error( "INIT BOOTSTRAP FAILED..." );
			e.printStackTrace();
		}
		
		
	}
	
	protected void include( String path, RenderRequest renderRequest, RenderResponse renderResponse)
			throws IOException, PortletException {
		if ( CAction.canDoCaret( renderRequest, CAction.VIEW ) ){
			super.include(path,renderRequest, renderResponse);
		}else {
			_log.info("VIEW needed");
		}
	}
	
	private static Log _log = LogFactoryUtil.getLog(CaretPortlet.class);

}