package gov.va.caret.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.CaretBaseViewController;
import gov.va.caret.hook.LogoutPage;
import gov.va.caret.portlet.action.ActionCommand;
import gov.va.caret.portlet.resource.ResourceCommand;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.view.CaretParam;

import java.io.IOException;
import java.util.Calendar;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.ProcessAction;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;


public class CaretBasePortlet extends MVCPortlet implements PortletCommander {
	

	protected void include( String path, RenderRequest renderRequest, RenderResponse renderResponse)
		throws IOException, PortletException {

		PortletRequestDispatcher portletRequestDispatcher = getPortletContext().getRequestDispatcher(path);

		if (portletRequestDispatcher == null) {
			_log.error(path + " is not a valid include");
		}
		else {
			renderRequest.setAttribute( CaretStrPool.BUILDVERSION, getViewController().getVersion() );
			portletRequestDispatcher.include(renderRequest, renderResponse);
		}
	}
	
	public void doView(RenderRequest renderRequest, RenderResponse renderResponse)
			throws IOException, PortletException {  
		//RENDER_PHASE
		if ( _log.isDebugEnabled() ) {
			_log.debug(startDoView);
		}
		if ( this.getClass() == CaretPortlet.class ) {
			
			try {
				String maxSessionTime = CaretUtil.getExpandoValue(PortalUtil.getUser(renderRequest).getExpandoBridge(), CaretStrPool.MAX_SESSION_TIME);
				if ( Validator.isNumber(maxSessionTime) ) {
					Calendar max = Calendar.getInstance();
					max.setTimeInMillis(Long.valueOf(maxSessionTime));
					
					if ( Calendar.getInstance().after( max ) ) {
						_log.error("User has bypassed the maximum allowed time per session... user will need to sign-in once more" );
						CaretUtil.setExpandoValue( PortalUtil.getUser(renderRequest), CaretStrPool.MAX_SESSION_TIME, "" );
						renderRequest.setAttribute("LOGOUT", PropsUtil.get( LogoutPage.LOG_OUT_URL_CLINIC  ) );
						includeVersion(renderRequest, renderResponse);
						return;
					}
				}
			} catch (PortalException | SystemException e) {
				e.printStackTrace();
			}
			
		}
		String mvcPath = ParamUtil.getString( renderRequest, CaretStrPool.MVC_PATH, StringPool.BLANK );
		
		if ( mvcPath.isEmpty() ){
			Object path = renderRequest.getAttribute(CaretStrPool.MVC_PATH);
			if ( path != null ){
				mvcPath = path.toString();
			}
		}
		if ( CaretStrPool.METADATA.equals(mvcPath) ){
			return;
		}
		
		if ( mvcPath.isEmpty() ){
			mvcPath = getViewController().loadDefaultView(renderRequest, renderResponse);
		}
		
		Object tracker = CaretParam.trackNdx( renderRequest );
		renderRequest.setAttribute( CaretStrPool.GENERIC_URL, renderResponse.createRenderURL() );
		renderRequest.setAttribute( CaretStrPool.TRACKER, tracker );
		_log.debug("tracker set..." + tracker);
		includePrint(renderRequest, renderResponse);
		if ( mvcPath != null && !mvcPath.isEmpty() ){
			include(mvcPath, renderRequest, renderResponse);
		} else {
			include(viewJSP, renderRequest, renderResponse);
		}
		includeVersion(renderRequest, renderResponse);
		if ( _log.isDebugEnabled() ) {
			_log.debug(endDoView);
		}
	}
	

	private void includeVersion(RenderRequest renderRequest,
			RenderResponse renderResponse) {
		try {
			include(CaretBaseViewController.VERSION_VIEW, renderRequest, renderResponse);
		} catch (Exception e1) {
			_log.error("Could not load version...");
			ApplicationWorkFlowException.handleException(e1);
		}
	}
	
	private void includePrint(RenderRequest renderRequest,
			RenderResponse renderResponse) {
		try {
			include(CaretBaseViewController.PRINT_VIEW, renderRequest, renderResponse);
		} catch (Exception e1) {
			_log.error("Could not load print...");
			ApplicationWorkFlowException.handleException(e1);
		}
	}

	@Override
	public void serveResource ( ResourceRequest request, ResourceResponse response ) throws PortletException, IOException {
		if ( _log.isDebugEnabled() ) {
			_log.debug(startServeResource);
		}
		if ( resourceCommand.pastMaxTime( request, response ) ) {
			PortalUtil.getHttpServletRequest(request).getSession().invalidate();
			return;
		}
		Object resourceObj = ResourceCommand.handle( request, response, resourceCommand );
		if ( resourceObj != null && !StringPool.BLANK.equals( resourceObj ) ){
			String resourceName = resourceCommand.getJspDir() + resourceObj + CaretBaseViewController.JSP_EXT;
			if ( _log.isDebugEnabled() ){
				_log.debug( "path is " + resourceName );
			}
			try{
				request.getPortletSession().getPortletContext().getRequestDispatcher(resourceName).include(request, response);
			} catch ( javax.portlet.PortletException e ){
				ApplicationWorkFlowException.handleException(e);
				request.getPortletSession().getPortletContext().getRequestDispatcher(CaretStrPool.PAGE_NOT_FOUND).include(request, response);
			}
		}
		if ( _log.isDebugEnabled() ) {
			_log.debug(endServeResource);
		}
	}
	
	public void init() throws PortletException {
		viewJSP = getInitParameter("view-jsp");
		gov.va.caret.service.thread.NonClusteredMonitor.clear ();
	}

	@Override
	public ResourceCommand getResourceCommand() {
		return resourceCommand;
	}

	@Override
	public CaretBaseViewController getViewController() {
		return viewController;
	}
	
	@Override
	public ActionCommand getActionCommand() {
		return actionCommand;
	}
	
	@ProcessAction (name="doAction")
	public void doAction( ActionRequest request, ActionResponse response ) {
		if ( _log.isDebugEnabled() ) {
			_log.debug(startDoAction);
		}
		if ( actionCommand.pastMaxTime( request ) ) {
			try {
				response.sendRedirect("/c/portal/logout");
				return;
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		ActionCommand.handle( request, response, actionCommand );
		if ( _log.isDebugEnabled() ) {
			_log.debug(endDoAction);
		}
	}
	
	protected ResourceCommand resourceCommand;
	protected ActionCommand actionCommand;
	protected CaretBaseViewController viewController;
	protected String viewJSP;
	
	private static Log _log = LogFactoryUtil.getLog(CaretBasePortlet.class);
	

	private static final String startDoView = "Start do View...";
	private static final String endDoView = "End do View...";
	private static final String startDoAction = "Start do Action...";
	private static final String endDoAction = "End do Action...";
	private static final String startServeResource = "Start serve Resource...";
	private static final String endServeResource = "End serve Resource...";
}
