package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.util.Toolbox;


public class TierChange extends MultiFacetedConfig implements CalculationChange, BackPay, Recoupment, ComplexChange {
	
	private BigDecimal totalStipend;  				//[Monthly Amount] + [Prorated Amount] + [Back Pay] OCC Super must review if > 35k
	
	public TierChange(WorIm workItem, StiPt config, StiPt lastRecurring, Calendar paymentMonthDate ) throws ApplicationWorkFlowException {
		super(workItem, config, paymentMonthDate);
		lastRecurringConfigs = Collections.singletonList( new StipendConfig( lastRecurring ) );
		if ( Toolbox.isEmpty( config.getPayment() ) ) {
			config.setPayment( getMonthlyRate().toPlainString() );
		}
		setUp( config.getStipendStartDate() );
	}
	
	public TierChange(WorIm workItem, StiPt config, List<StipendConfig> lastRecurringConfigs, Calendar paymentMonthDate ) throws ApplicationWorkFlowException {
		super(workItem, config, paymentMonthDate);
		this.lastRecurringConfigs = lastRecurringConfigs;
		
		if ( Toolbox.isEmpty( config.getPayment() ) ) {
			config.setPayment( getMonthlyRate().toPlainString() );
		}
		setUp( config.getStipendStartDate() );
	}
	
	public TierChange(WorIm workItem, StiPt config, Calendar paymentMonthDate ) throws ApplicationWorkFlowException {
		super(workItem, config, paymentMonthDate);
		this.lastRecurringConfigs = new ArrayList<StipendConfig>();
		try {
			this.config.resolveFinanceStaged(false, lastRecurringConfigs);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		if ( Toolbox.isEmpty( config.getPayment() ) ) {
			config.setPayment( getMonthlyRate().toPlainString() );
		}
	}
	
	public BigDecimal getMonthlyBackPayAmount( int ndx ){
		if ( lastRecurringConfigs.get(ndx).getMonthlyBackPayAmount() == null ) {
			int retroactiveMonths = getRetroactiveMonths( ndx );
			BigDecimal monthlyBackPayAmount = getMonthlyRateDiff( ndx ).multiply( new BigDecimal ( retroactiveMonths ) ).setScale( 2, RoundingMode.HALF_UP );
			lastRecurringConfigs.get(ndx).setMonthlyBackPayAmount( monthlyBackPayAmount );
			lastRecurringConfigs.get(ndx).setRetroactiveMonths(retroactiveMonths);
			lastRecurringConfigs.get(ndx).setMonthlyRateDiff( getMonthlyRateDiff(ndx) );
			return monthlyBackPayAmount;
		}
		return lastRecurringConfigs.get(ndx).getMonthlyBackPayAmount();
	}
	
	@Override
	public BigDecimal getFinalAmount() {
		return getBackPayAmount(); //getMonthlyRate ( ).add( getBackPayAmount() );
	}
	
	//[New Monthly Amount] + [Prorated Amount] + [Back Pay] + [Recoupment Amount]
	public BigDecimal getTotalStipend(){
		if ( totalStipend == null ){
			//(Tier Change Effective Date prior to current Payment Month)
			if ( lastRecurringConfigs.size() > 1 ) {
				totalStipend = new BigDecimal(0);
				for ( int i = 0; i< lastRecurringConfigs.size() ; i++ ) {
					totalStipend = totalStipend.add( getMonthlyRateDiff(i).multiply( new BigDecimal ( getRetroactiveMonths(i) ) ).add( ( getProratedAmount(i) ) ) );
				}
			} else {
				totalStipend =  (getMonthlyRate().subtract( getMonthlyRateDiff( lastRecurringConfigs.size() -1 ) )).multiply( new BigDecimal ( getRetroactiveMonths() ) ).add( getProratedAmount() ).add(  getMonthlyRate() );
			}
		}
		return totalStipend;
	}

	public StipendConfig getAdjustedConfig ( int index ) {
		StipendConfig adjustedConfig = new StipendConfig ( lastRecurringConfigs.get(index).getWrappedModel() );
		adjustedConfig.setTier( config.getTier() );
		adjustedConfig.setStipendEndDate( lastRecurringConfigs.get(index).getStipendEndDate() );
		return adjustedConfig;
	}
	
	public BigDecimal getAdjustedNewMonthlyRate ( int ndx ) {
		StipendConfig pc = lastRecurringConfigs.get( ndx );
		BigDecimal monthlyRate = StipendConfig.getMonthlyRate( Double.valueOf( pc.getBlsRateHourly() ), Integer.valueOf( config.getTier() ) );
		monthlyRate.setScale( 2, RoundingMode.HALF_UP );
		return monthlyRate;
	}
	
	public BigDecimal getAdjustedNewDailyRate ( int ndx ) {
		StipendConfig pc = lastRecurringConfigs.get( ndx );
		if ( dailyRate == null ){
			dailyRate = new BigDecimal ( config.getTierHours() ).multiply( new BigDecimal( pc.getBlsRateHourly() ) ).multiply( StipendConfig.TWELVE ).divide(StipendConfig.THREESIXTYFIVE, 2, RoundingMode.HALF_UP );
		}
		return dailyRate;
	}
	
	public BigDecimal getDailyRateDiff(){
		return getDailyRateDiff(lastRecurringConfigs.size()-1);
	}
	
	public BigDecimal getBackPayAmount(){
		if ( isBackPayDetected() ) {
			return getProratedAmount().add( getMonthlyBackPayAmount() );
		}
		return defaultValue;
	}
	
	public int getRetroactiveMonths( int ndx ){
		if ( lastRecurringConfigs.get(ndx).getRetroactiveMonths() == 0 ) {
			int totalMonths = -1;//to account for full month and partial month.
			Calendar rollingFirstDay = Calendar.getInstance();
			rollingFirstDay.setTime( lastRecurringConfigs.get(ndx).getStipendStartDate() );
			int i = 0;
			if ( ndx > 0 ) {
				lastRecurringConfigs.get(ndx).setStipendEndDate( lastRecurringConfigs.get(ndx-1).getStipendStartDate() );// possible problem area
			}
			for (  ; rollingFirstDay.getTime().before( lastRecurringConfigs.get(ndx).getStipendEndDate() ); totalMonths++ ) {
				if ( i > 120 ) {
					_log.error("Invalid Stipend-Start-Date..");
					break;
				}
				if ( rollingFirstDay.get(Calendar.MONTH ) == Calendar.DECEMBER ){
					rollingFirstDay.roll( Calendar.YEAR, true );
					rollingFirstDay.roll( Calendar.MONTH, true );
				} else {
					rollingFirstDay.roll( Calendar.MONTH, true );
				}
				i++;
			}
			lastRecurringConfigs.get(ndx).setRetroactiveMonths( Math.max( totalMonths > 120? 0: totalMonths, 0 ) );
			
		}
//		_log.info("Retro Months: " + lastRecurringConfigs.get(ndx).getRetroactiveMonths() );
		return lastRecurringConfigs.get(ndx).getRetroactiveMonths();
	}
	
	public BigDecimal getMonthlyBackPayAmount(){
		if ( lastRecurringConfigs != null && !lastRecurringConfigs.isEmpty() ) {
			if ( lastRecurringConfigs.size() > 1 ) {
				BigDecimal monthlyBackPayAmount = BigDecimal.ZERO;
				for ( int ndx = 0; ndx < lastRecurringConfigs.size(); ndx++ ) {
					BigDecimal monthlyRateDiff = getMonthlyRateDiff(ndx);
					int retroactiveMonths = getRetroactiveMonths( ndx );
					monthlyBackPayAmount = monthlyBackPayAmount.add( new BigDecimal( retroactiveMonths )
							.multiply( monthlyRateDiff ).setScale( 2, RoundingMode.HALF_UP ) );
					lastRecurringConfigs.get(ndx).setMonthlyRateDiff(monthlyRateDiff);
					lastRecurringConfigs.get(ndx).setRetroactiveMonths(retroactiveMonths);
				}
				return monthlyBackPayAmount;
			} else {
				if ( lastRecurringConfigs.get(0).getMonthlyBackPayAmount() == null ) {
					lastRecurringConfigs.get(0).setMonthlyBackPayAmount( new BigDecimal( getRetroactiveMonths( 0 ) ).multiply( getLastRecurringMonthlyRate( 0 ) ).setScale( 2, RoundingMode.HALF_UP ) );
				}
				return lastRecurringConfigs.get(0).getMonthlyBackPayAmount(); 
			}
		}
		return new BigDecimal( getRetroactiveMonths() ).multiply( getMonthlyRate() ).setScale( 2, RoundingMode.HALF_UP );
	}
	
	public int getTotalDays(  ) {
		if ( getPaymentDate().before( config.getStipendStartDate() ) ) {
			return 0;
		}

		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		if ( getPaymentDate().compareTo( StipendConfig.getPayday( calendar ).getTime() ) < 0 ) {
			return 0;
		}
		int applicationDay = calendar.get( Calendar.DAY_OF_MONTH );
		if ( applicationDay == 1 ) {
			return 0;				//full month will be accounted
		}
		calendar.set( Calendar.DAY_OF_MONTH, 1 );
		calendar.roll(Calendar.DAY_OF_MONTH, false );
		int endDateCurrentPaymentMonth = calendar.get( Calendar.DAY_OF_MONTH );
		return endDateCurrentPaymentMonth - applicationDay + 1;//to make the approval date inclusive
	}
	
	public int getTotalDays( int ndx ) {
		if ( lastRecurringConfigs.get(ndx).getStipendEndDate().before( config.getStipendStartDate() ) ) {
			return 0;
		}

		Calendar calendar = Calendar.getInstance();
		calendar.setTime( lastRecurringConfigs.get(ndx).getStipendStartDate() );

		int applicationDay = calendar.get( Calendar.DAY_OF_MONTH );
		if ( applicationDay == 1 ) {
			return 0;				//full month will be accounted
		}
		calendar.set( Calendar.DAY_OF_MONTH, 1 );
		calendar.roll(Calendar.DAY_OF_MONTH, false );
		int endDateCurrentPaymentMonth = calendar.get( Calendar.DAY_OF_MONTH );
		return endDateCurrentPaymentMonth - applicationDay + 1;//to make the approval date inclusive
	}

	public BigDecimal getProratedAmount(){
		BigDecimal proratedAmount = BigDecimal.ZERO;
		
		for ( int ndx = 0; ndx < lastRecurringConfigs.size(); ndx++ ) {
			proratedAmount = proratedAmount.add( getProratedAmount( ndx ) );
		}
		proratedAmount.setScale( 2, RoundingMode.HALF_UP );
		
		return proratedAmount;
	}
	

	public BigDecimal getProratedAmount(int i) {
		BigDecimal proratedAmount = new BigDecimal( getTotalDays( i ) ).multiply( getDailyRateDiff( i ) );
		proratedAmount.setScale( 2, RoundingMode.HALF_UP );
		return proratedAmount;
	}
	

	
	public BigDecimal getMonthlyRateDiff(){
		return getMonthlyRateDiff(0);
	}
	
	//( [Total Days] * ([Old Daily Rate]  [New Daily Rate]) ) + ([Number of Retro Months * ([Old Monthly Amount]  [New Monthly Amount]))
	public BigDecimal getRecoupmentAmount(){
		if ( isRecoupmentDetected() ) {
			return getProratedAmount().add( getMonthlyBackPayAmount() );
		}
		return defaultValue;
	}
	
	public int getRetroactiveMonths( ){
		int count = 0;
		for ( int ndx = 0; ndx < lastRecurringConfigs.size(); ndx++ ) {
			count = count + getRetroactiveMonths( ndx );
			_log.info("RetroactiveMonths:" + count );
		}
		return count;
	}
	
	public boolean isCalculationChange(){
		return true;
	}
	
	public boolean isBackPayDetected() {
		return getLastRecurringMonthlyRate(0).compareTo( getMonthlyRate() ) < 0; 
	}
	public boolean isRecoupmentDetected() {
		if ( getLastRecurringMonthlyRate(lastRecurringConfigs.size()-1).compareTo( getMonthlyRate() ) > 0 ) {
			return getProratedAmount().add( getMonthlyBackPayAmount() ).compareTo(BigDecimal.ZERO) > 0 ;
		}
		return false; 
	}
	public String getBackPayView() {
		return "BackPayView not ready";
	}
	public String getRecoupmentView() {
		return "RecoupmentView not ready";
	}
	

//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig oldConfig = new StipendConfig( 2, 18.11, format.parse("10/05/2016") );
//		StipendConfig config = new StipendConfig( 3, 18.11, format.parse("11/16/2016") );
//		_log.info( new TierChange( config, oldConfig, Calendar.FEBRUARY, 2017 ) );
//	}

	public String toString () {
		return  "Stipend Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n         Effective Date: " + formatDate( config.getStipendStartDate() ) +
//				"\n Current Monthly Amount: " + getOldMonthlyRate() +
				"\n     New Monthly Amount: " + getMonthlyRate(  ) +
				 
				"\n     Prorated Amount of: " + getProratedAmount() +  
				"\n        Retro Months of: " + getRetroactiveMonths() +
//				"\n  Current Daily Rate of: " + getOldDailyRate() +
				"\n      New Daily Rate of: " + getDailyRate() +
				"\n          Pay Change of: " + getDailyRateDiff() + 
				"\n      Recoupment Amount: " + getRecoupmentAmount() +
				"\n      Total Payment Due: " + getTotalStipend(  )  +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
//				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}

	@Override
	public boolean isMonthlyDiff() {
		return true;
	}
	
	private static Log _log = LogFactoryUtil.getLog( TierChange.class );

	@Override
	public List<StipendConfig> getLastRecurringConfigs() {
		return lastRecurringConfigs;
	}

	public void setUp( Date effectiveDate ) {
		
		if ( lastRecurringConfigs != null && !lastRecurringConfigs.isEmpty() && lastRecurringConfigs.size() > 1 ) {
			//sort from most current to least current effective date
			Collections.sort( lastRecurringConfigs, new Comparator<StipendConfig>() {
				@Override
				public int compare(StipendConfig last, StipendConfig first) { 
					return first.getEffectiveDate().compareTo(last.getEffectiveDate());
				}
			});
		}

		List<StipendConfig> inclusive = new ArrayList<StipendConfig>(); 
		StipendConfig lastStipendConfig = null;
		for ( StipendConfig stipendConfig: lastRecurringConfigs ) {
			if ( lastStipendConfig != null ) {
				stipendConfig.setStipendEndDate( lastStipendConfig.getEffectiveDate() );
			} else {
				stipendConfig.setStipendEndDate( this.getPaymentDate() );
			}
			if ( config.getStipendStartDate().after( stipendConfig.getStipendStartDate() ) ) {
				stipendConfig.setTempStipendStartDate( config.getStipendStartDate() );//TODO: Problem area...
			}
			lastStipendConfig = stipendConfig;
			inclusive.add( lastStipendConfig );
//			_log.info( lastStipendConfig.getStipendStartDateStr() + "-" + lastStipendConfig.getStipendEndDateStr() );
		}
		lastRecurringConfigs = inclusive;
	}

	@Override
	public BigDecimal getOneTimePayment(int ndx) {
		return new BigDecimal ( config.getOneTimePayment() ).setScale( 2, RoundingMode.HALF_UP );
	}
	
}

