package gov.va.caret.model.support.occ;


import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;



import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.Persn;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.StiPtWrapper;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.WorSe;
import gov.va.caret.model.impl.StiPtImpl;
import gov.va.caret.model.impl.WorSeImpl;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.service.WorSeLocalServiceUtil;
import gov.va.caret.util.Toolbox;

public class StipendConfig extends StiPtWrapper {

	public static final BigDecimal TWELVE = new BigDecimal(12);
	public static final BigDecimal THREESIXTYFIVE = new BigDecimal(365);
	
	private static final long serialVersionUID = 1L;
	WorSe workItemStep = null;
	
	BigDecimal dailyRate = null;
	
	/*
	a.	Monthly recurring amount 
	b.	Back pay amount
	c.	Final payment amount 
	d.	Recoupment amount
	e.	Monthly rate
	g.	Daily rate
	h.	Prorated amount and dates
	i.	Number of retroactive months
	
	f.	Hourly rate
	j.	Veterans zip code
	k.	Transaction date (application approval date)
	l.	Tier level
	 */
	public static final StipendConfig NULLCONFIG = new StipendConfig(null) {
//		public long getStiPtId() {return 0l;}
		public String getTier() { return "0"; }
		public String getTierHours() { return "0"; }
		public String getBlsRateHourly() { return "0.0";}
		public String getPayment() { return "0.0";}
	};
	
	public static final String OBSOLETE_PAYMENT = "PAYMENT_OBSOLETE";
	public static final String ON_HOLD = "PAYMENT_HOLD";
	public static final String PAYMENT_REJECTED = "PAYMENT_REJECTED";
	public static final String PAYMENT_FINANCE = "PAYMENT_FINANCE";
	public static final String STAGED_PAYMENT = "STAGED_PAYMENT";
	public static final String FINANCE_STAGED = "FINANCE_STAGED";
	public static final String ONE_TIME = "one-time";
	public static final String RECURRING = "recurring";
	
	public static final String[] OCC_PAYMENT_STATUSES = new String[] { PAYMENT_FINANCE, OBSOLETE_PAYMENT, ON_HOLD };
	
	public static final BigDecimal MONTH_MULTIPLIER = new BigDecimal( 4.35 ); //PortletProps.get("bls.payment.weeks") );
	public static final BigDecimal TIER_3_MONTH_HOURS = StipendConfig.MONTH_MULTIPLIER.multiply( new BigDecimal(40) ).setScale( 2, RoundingMode.HALF_UP );//new BigDecimal( Integer.getInteger( PortletProps.get( "tier3.hours"), 40 ) ) );
	public static final BigDecimal TIER_2_MONTH_HOURS = StipendConfig.MONTH_MULTIPLIER.multiply( new BigDecimal( 25 ) ).setScale( 2, RoundingMode.HALF_UP ); //new BigDecimal( Integer.getInteger( PortletProps.get( "tier2.hours"), 25 ) ) );
	public static final BigDecimal TIER_1_MONTH_HOURS = StipendConfig.MONTH_MULTIPLIER.multiply( new BigDecimal( 10 ) ).setScale( 2, RoundingMode.HALF_UP ); //new BigDecimal( Integer.getInteger( PortletProps.get( "tier1.hours"), 10 ) ) );

	public static final int WEEK_YEAR_0 = 2018 * 52;
	public static final int MONTH_YEAR_0 = 2018 * 12;
	public static final String STAGED = "STAGED-";
	public static final String PENDING = "PENDING-";
	public static final String SUBMITTED = "SUBMITTED-";
	public static final String COMPLETED = "COMPLETED-";
	public static final String ADDRESS_CHANGE_OVERWRITE = "ADDRESS_CHANGE_OVERWRITE";
	
	private static Log _log;
	
	static{
		try {
			_log = LogFactoryUtil.getLog( StipendConfig.class );
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private WorIm workItem = null;
	private Vendr vendor = null;
	private String veteranName = null;
	Date lastAppliedDate = null;
	Date stipendEndDate = null;
	private BigDecimal monthlyBackPayAmount = null;
	private BigDecimal monthlyRateDiff = null;
	private BigDecimal dailyRateDiff = null;
	private int retroactiveMonths = 0;
	private Date tempStipendStartDate;
	
	public StipendConfig(StiPt stiPt) {
		super(stiPt);
		if ( stiPt instanceof StipendConfig) {
			_log.warn("Contructing with StipendConfig");
		}
	}

	public static StiPt getStipendConfig( Date stipendStartDate, String payment, String tierHours, String blsRateHourly ) {
		StiPt stiPt = new StiPtImpl();
		stiPt.setStipendStartDate(stipendStartDate);
		stiPt.setPayment(payment);
		stiPt.setTierHours(tierHours);
		stiPt.setBlsRateHourly(blsRateHourly);
		return stiPt;
	}

	//Caregivers Effective Date is always the Application Received Date
	//The date the Application was received
	//AKA Effective Date.  Approval Date must be after applicationReceivedDate
	public Date getEffectiveDate() {
		return super.getStipendStartDate();
	}

	public Date getStipendStartDate() {
		return tempStipendStartDate == null ? super.getStipendStartDate(): tempStipendStartDate;
	}
	
	public static void resolveAllFinanceStaged (  ) throws ApplicationWorkFlowException {
		for ( StiPt stiPt: StiPtLocalServiceUtil.findAllByRecurringBefore( new String[]{FINANCE_STAGED}, new Date()) ) {
			StipendConfig stipendConfig = new StipendConfig(stiPt);
			stipendConfig.resolveFinanceStaged(true);
		}
	}
	
	public StiPt resolveFinanceStaged (boolean save) throws ApplicationWorkFlowException {
		try {
			return resolveFinanceStaged( save, new ArrayList<StipendConfig>() );
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public StiPt resolveFinanceStaged (boolean save, List<StipendConfig> lastRecurring) throws ApplicationWorkFlowException, SystemException {
		StiPt target = null;
		List<StiPt> actives = StiPtLocalServiceUtil.findByVcgRecurringStatus(getVcgId(), new String[]{PAYMENT_FINANCE, ON_HOLD} );
		if ( actives.size() == 0 && !WorkType.REINSTATED_DISPOSITION.name().equals( getStipendStatus() ) ) {
			throw new ApplicationWorkFlowException("NO ACTIVATED RECURRING FOUND");
		}
		if ( actives.size() > 1 ) {
			throw new ApplicationWorkFlowException("MULTIPLE ACTIVATED RECURRING FOUND");
		} 
		CalculationInfo calcInfo = null;
//		target = actives.get(0);
		
		if ( WorkType.REINSTATED_DISPOSITION.name().equals( getStipendStatus() ) || WorkType.REINSTATED_DISPOSITION.name().equals( getWorkItem().getType() ) ) {
			_log.info("setting REINSTATED_DISPOSITION now..");
			List<StiPt> stiPtList = StiPtLocalServiceUtil.findByOneTimeStatus( getVendrId(), new String[] {"REVOKED_DISPOSITION", StipendConfig.OBSOLETE_PAYMENT, StipendConfig.PAYMENT_FINANCE} );
			if ( !stiPtList.isEmpty() ) {
				target = stiPtList.get(0);
				Calendar startCal = Calendar.getInstance();
				startCal.setTime( target.getStipendStartDate() );
				startCal.add(Calendar.DATE, target.getEntitledDays()+1);
				setStipendStartDate( startCal.getTime() );
			}
			
			_log.info( stiPtList.size() + " size" );
		} else if ( WorkType.APPROVED_DISPOSITION.name().equals( getStipendStatus() ) ) {
			target = null;
		} else if ( WorkType.REVOKED_DISPOSITION.name().equals( getStipendStatus() ) || WorkType.REVOKED_DISPOSITION.name().equals( getWorkItem().getType() ) ) {
			_log.info( actives.size() + " items" );
			if ( !WorkType.REVOKED_DISPOSITION.name().equals( getStipendStatus() ) && WorkType.REVOKED_DISPOSITION.name().equals( getWorkItem().getType() ) ) {
				target = StiPtLocalServiceUtil.findByOneTimeBefore( getVcgId(), new String[]{PAYMENT_FINANCE, ON_HOLD}, getStipendApprovedDate(), getWorkItem().getCompletionDate() );
			} else {
				target = actives.get(0);
			}
			Date startDate = new Date();
			for ( StiPt lastStiPt : StiPtLocalServiceUtil.findByWorkId( target.getWorImId() ) ) {
				StipendConfig temp = new StipendConfig(lastStiPt);
				if ( temp.getStipendStartDate().before(startDate)) {
					startDate = temp.getStipendStartDate(); 
				}
//				if ( temp.getStipendStartDate().before( getStipendStartDate() ) ) {
//					_log.info("OLD DATE:" + temp.getStipendStartDate() + " Proposed NEW DATE:" + getStipendStartDate() );
////					temp.setTempStipendStartDate( getStipendStartDate() ); 
//				}
				lastRecurring.add( temp );
			}
			setTier( target.getTier() );
			setBlsRateHourly( target.getBlsRateHourly() );
			partialMerge( target );
			setPayment( target.getPayment() );
			if ( save ) {
				calcInfo = new FinalPayment(workItem, this, getPayday( Calendar.getInstance() ) );
			}
		} else if ( WorkType.ADDRESS_CHANGE.name().equals( getStipendStatus() ) || StipendConfig.FINANCE_STAGED.equals( getStipendStatus() ) || WorkType.ADDRESS_CHANGE.name().equals( getWorkItem().getType() )) {
			target = actives.get(0);
			setTier( actives.get(0).getTier() );
			partialMerge( actives.get(0) );
			if ( save ) {
				calcInfo = new AddressChange(workItem, this, getPayday( Calendar.getInstance() ) );
			}
		} else if ( WorkType.TIER_UPDATE.name().equals( getStipendStatus() ) || WorkType.TIER_UPDATE.name().equals( getWorkItem().getType() ) ) {
			if ( !WorkType.TIER_UPDATE.name().equals( getStipendStatus() ) && WorkType.TIER_UPDATE.name().equals( getWorkItem().getType() ) ) {
				target = StiPtLocalServiceUtil.findByOneTimeBefore( getVcgId(), new String[]{PAYMENT_FINANCE, ON_HOLD}, getStipendApprovedDate(), getWorkItem().getCompletionDate() );
			} else {
				target = actives.get(0);
			}
			setBlsRateHourly( target.getBlsRateHourly() );
			Date startDate = new Date();
			for ( StiPt lastStiPt : StiPtLocalServiceUtil.findByWorkId( target.getWorImId() ) ) {
				StipendConfig temp = new StipendConfig(lastStiPt);
				if ( temp.getStipendStartDate().before(startDate)) {
					startDate = temp.getStipendStartDate(); 
				}
//				if ( temp.getStipendStartDate().before( getStipendStartDate() ) ) {
//					_log.info("OLD DATE:" + temp.getStipendStartDate() + " Proposed NEW DATE:" + getStipendStartDate() );
////					temp.setTempStipendStartDate( getStipendStartDate() ); 
//				}
				lastRecurring.add( temp );
			}
			if ( startDate.after( getStipendStartDate() ) ) {
				for ( StiPt lastStiPt : StiPtLocalServiceUtil.findByRecurringBefore(target.getVcgId(), new String[] {"TODO"}, startDate) ){
					if ( lastStiPt.getStipendStartDate().before(startDate) ) {
						StipendConfig config = new StipendConfig(lastStiPt);
						config.setStipendEndDate( startDate );
						startDate = getStipendStartDate();
						lastRecurring.add( config );
					}
					if ( lastStiPt.getStipendStartDate().before( getStipendStartDate() ) ) {
						lastStiPt.setStipendStartDate( getStipendStartDate() );
					}
					if ( getStipendStartDate().after( startDate ) ) {
						break;
					}
				}
			}
			
			if ( save ) {
				calcInfo = new TierChange(workItem, this, getPayday( Calendar.getInstance() ) );
			}
		} else if ( StipendConfig.RECURRING.equals( getStipendType() ) ) {
			target = actives.get(0);
		}
		if ( calcInfo != null ) { //save
			setPayment( "" + calcInfo.getMonthlyRate() );
			setOneTimePayment( "" + calcInfo.getFinalAmount() );
			target = actives.get(0);
			actives.get(0).setStipendStatus( OBSOLETE_PAYMENT );
			CaretLocalServiceUtil.save( actives.get(0) );
			CaretLocalServiceUtil.save( this );
		}
		return target;
	}
	
	public BigDecimal getHoldAmount ( BgLae bgLae, Date payday ) {
		
		if ( isRecurring() ) {
			int paymentMonth = (int)(bgLae.getOwnerId() % 12) - 1;
			Calendar lastpayment = Calendar.getInstance();
			lastpayment.set( Calendar.MONTH, paymentMonth );
			lastpayment.set( Calendar.YEAR, (int)bgLae.getOwnerId() / 12 );
			lastpayment.set( Calendar.DAY_OF_MONTH, 1);
			lastpayment.set( Calendar.HOUR_OF_DAY, 0);
			lastpayment.set( Calendar.MINUTE, 0);
			lastpayment.set( Calendar.MILLISECOND, 1);
			_log.info( "Start Date:" + Toolbox.formatDateCprs( lastpayment.getTime() ) ) ;

			int totalMonths = -1;//to account for full month.
			Calendar rollingFirstDay = Calendar.getInstance();
			rollingFirstDay.setTime( lastpayment.getTime() );
			int i = 0;
			for (  ; rollingFirstDay.getTime().before( payday ); totalMonths++ ) {
				if ( i > 120 ) {
					System.err.println("Invalid Stipend-Start-Date..");
					break;
				}
				if ( rollingFirstDay.get(Calendar.MONTH ) == Calendar.DECEMBER ){
					rollingFirstDay.roll( Calendar.YEAR, true );
					rollingFirstDay.roll( Calendar.MONTH, true );
				} else {
					rollingFirstDay.roll( Calendar.MONTH, true );
				}
				i++;
			}
			return new BigDecimal( getPayment() ).multiply(BigDecimal.valueOf( totalMonths ));
		} else if ( getPayslipDate() == null ){
			return new BigDecimal( getOneTimePayment() );
		}
		return BigDecimal.ZERO;
	}
	
	public void partialMerge (StiPt from) {
//		setStipendStatus(from.getStipendStatus());
		setStipendType(from.getStipendType());
		setTierHours( String.valueOf( getTierLevelMonthlyHours( getTier() )  ) );
	}
	
	@Override
    public void persist() throws com.liferay.portal.kernel.exception.SystemException {
			
		if ( RECURRING.equals( getStipendType() ) && PAYMENT_FINANCE.equals( getStipendStatus() ) ){
			try {
				List<StiPt> stiPts = StiPtLocalServiceUtil.findByVcgRecurring( getVcgId() );
				for ( StiPt stiPt: stiPts ) {
					if ( stiPt.getStiPtId() != getStiPtId() && PAYMENT_FINANCE.equals( stiPt.getStipendStatus() ) ) {
						throw new SystemException("CANNOT HAVE MULTIPLE RECURRING ");
					}
				}
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
        super.persist();
        if ( workItemStep != null ){
        	workItemStep.persist();
		}
    }
	
	//Used only during save...
	public void setFields( Date effectiveDate, VcgSupport vcg, WorkItemSupport workItem, ServiceContext sc, String oldVal, String newVal ) throws ApplicationWorkFlowException {
		
		setWorImId( workItem.getWorImId() );
		setStipendStatus( workItem.getType() );
		setICN( vcg.getPrimary().getICN() );
		setVcgId( vcg.getVcgId() );
//		if ( !"PAYMENT_OBSOLETE".equals( getStipendStatus() ) ) {
//			setStipendStatus( workItem.getType() );
//		}
		if ( WorkType.ADDRESS_CHANGE.name().equals( workItem.getType() ) ) {
			BlsRe newRate = BlsReLocalServiceUtil.findLatestBlsByZip( vcg.getVeteran().getZip() );
			setBlsRateHourly( String.valueOf( newRate.getH75() ) );
			setStipendStartDate( StipendConfig.getPayday( Calendar.getInstance() ).getTime() );
		} else {
			if ( WorkType.TIER_UPDATE.name().equals( workItem.getType() ) ) {
				setTier( String.valueOf( vcg.getTierLevel() ) );
				setTierHours( String.valueOf( getTierLevelMonthlyHours( getTier() )  ) );
			}
			setStipendStartDate( effectiveDate );
			if ( WorkType.APPROVED_DISPOSITION.name().equals( workItem.getType() ) || WorkType.REINSTATED_DISPOSITION.name().equals( workItem.getType() ) ) {
				setBlsRateHourly( vcg.getBlsRateHourly() );
				setTier( String.valueOf( vcg.getTierLevel() ) );
				setTierHours( String.valueOf( getTierLevelMonthlyHours( getTier() )  ) );
				setPayment( getMonthlyRate( Double.valueOf( getBlsRateHourly() ), vcg.getTierLevel() ).toString() );
			}
		}
//		CalculationInfo calculationInfo;
		if ( WorkType.REVOKED_DISPOSITION.name().equals( workItem.getType() ) ) {
			setStipendType( ONE_TIME );
			setBlsRateHourly( vcg.getBlsRateHourly() );
			setTier( String.valueOf( vcg.getTierLevel() ) );
			setTierHours( String.valueOf( getTierLevelMonthlyHours( getTier() )  ) );
//			calculationInfo = workItem.getCalcInfo( this );
//			setOneTimePayment( calculationInfo.getFinalAmount().toString() );
		} else {
			setStipendType( RECURRING );
//			setPayment( getMonthlyRate( Double.valueOf( getBlsRateHourly() ), vcg.getTierLevel() ).toString() );
//			calculationInfo = workItem.getCalcInfo( this );
		}
		
//		_log.info( calculationInfo );
//		setICN( vcg.getPrimary().getICN() );
//		setVcgId( vcg.getVcgId() );
		
		workItemStep = new WorSeImpl();
		workItemStep.setWorImId( workItem.getWorImId() );
		workItemStep.setCreationDate( sc.getCreateDate() );
		workItemStep.setUserId( sc.getUserId() );
		int count = WorSeLocalServiceUtil.getCount ( workItem.getWorImId() );
		workItemStep.setStepNumber(count+1);
		workItemStep.setOldStep( oldVal );
		workItemStep.setStep( newVal );
	

	}
	
	public static BigDecimal getMonthlyRate(Double localRate, int tierLevel ) {
		if ( tierLevel == 0 ) {
			return BigDecimal.ZERO;
		}
		BigDecimal monthlyRate= new BigDecimal( localRate ).multiply( getTierLevelMonthlyHours( tierLevel  ) ).setScale( 2, RoundingMode.HALF_UP );
		return monthlyRate;
	}


	public static BigDecimal getTierLevelMonthlyHours( String level ){
		if ( Toolbox.isEmpty(level) ){
			return BigDecimal.ZERO;
		}
		return getTierLevelMonthlyHours( Integer.valueOf(level) );
	}
	
	public static BigDecimal getTierLevelMonthlyHours( int level ){
		switch( Integer.valueOf( level ) ){
		case 1: return StipendConfig.TIER_1_MONTH_HOURS;
		case 2: return StipendConfig.TIER_2_MONTH_HOURS;
		case 3: return StipendConfig.TIER_3_MONTH_HOURS;
		default: return BigDecimal.ZERO; 
		}
	}
	
	//TODO: to accommodate if 27th day of month is passed
	public static Calendar getPayday ( Calendar payday ) {
		Calendar copy = Calendar.getInstance();
		copy.setTime( payday.getTime() );
		copy.set(Calendar.DAY_OF_MONTH, 1);
		if ( Calendar.DECEMBER == copy.get( Calendar.MONTH ) ){
			copy.roll( Calendar.YEAR, true);
		}
		copy.roll(Calendar.MONTH, true);
		_log.debug("setting time to " + Toolbox.formatDateCprs( copy.getTime() ) );
		return copy;
	}
	
	public static Calendar getPayday ( Date nextPayDay ) {
		Calendar copy = Calendar.getInstance();
		copy.setTime( nextPayDay );
		copy.set(Calendar.DAY_OF_MONTH, 1);
		if ( Calendar.DECEMBER == copy.get( Calendar.MONTH ) ){
			copy.roll( Calendar.YEAR, true);
		}
		copy.roll(Calendar.MONTH, true);
		_log.info("setting time to " + Toolbox.formatDateCprs( copy.getTime() ) );
		return copy;
	}
	
	public String getVendorName() throws SystemException {
		if ( getVendor() != null ) {
			return vendor.getLastName() + StringPool.COMMA_AND_SPACE + vendor.getFirstName();
		}
		return StringPool.BLANK;
	}
	
	public String getVerifierName() throws SystemException {
		if ( getWorkItem() != null ) {
			User verifier = UserLocalServiceUtil.fetchUser(workItem.getCompletionBy());
			if ( verifier != null ) {
				return verifier.getLastName() + StringPool.COMMA_AND_SPACE + verifier.getFirstName();
			}
		}
		return StringPool.BLANK;
	}
	
	public Vendr getVendor() throws SystemException {
		if ( vendor == null ) {
			vendor = VendrLocalServiceUtil.fetchVendr(getVendrId());
		}
		return vendor;
	}

	public WorIm getWorkItem() throws SystemException {
		if ( workItem == null ) {
			workItem = WorImLocalServiceUtil.fetchWorIm(getWorImId());
		}
		return workItem;
	}
	
	public String getVeteranName() throws SystemException {
		if ( veteranName == null ) {
			Persn veteran = PersnLocalServiceUtil.fetchPersn( getWorkItem().getPersnId() );
			if ( veteran != null ) {
				veteranName = veteran.getLastName() + StringPool.COMMA_AND_SPACE + veteran.getFirstName();
			}
		}
		return veteranName;
	}
	
	public String getReason() throws SystemException  {
		if ( getWorkItem() != null ) {
			return workItem.getType();
		}
		return StringPool.BLANK;
	}
	
	public long getVcgAnId() throws SystemException {
		if ( getWorkItem() != null ) {
			return getWorkItem().getClassPk();
		}
		return 0;
	}
	
	public String getStipendStartDateStr(){
		return Toolbox.formatDate(getStipendStartDate());
	}
	
	public String getStipendEndDateStr(){
		return Toolbox.formatDate(getStipendEndDate());
	}
	
	public Date getStipendEndDate() {
		if ( stipendEndDate == null ) {
			stipendEndDate = getPayday(new Date()).getTime();
		}
		return stipendEndDate;
	}
	
	public void setStipendEndDate( Date stipendEndDate ) {
		this.stipendEndDate = stipendEndDate;
	}

	public String getStipendApprovedDateStr(){
		return Toolbox.formatDate(getStipendApprovedDate());
	}
	
	public String getPayslipDateStr(){
		return Toolbox.formatDate(getPayslipDate());
	}
	
	public void setPayslipDate(Date payslipDate) {
		if ( getPayslipDate() == null ) {
			super.setPayslipDate(payslipDate);
		}
	}
	
    public void setStipendStatus(java.lang.String stipendStatus) {
    	if ( StipendConfig.RECURRING.equals( getStipendType() ) && StipendConfig.OBSOLETE_PAYMENT.equals( super.getStipendStatus() ) ) {
   			_log.error("Invalid state...");
   			return;
    	}
    	super.setStipendStatus(stipendStatus);
    }
    
    public String getPaymentTypeStr() throws SystemException {
    	if ( RECURRING.equals( getStipendType() ) ) {
    		if ( getPayslipDate() == null ) {
    			return LanguageUtil.get( LocaleUtil.getDefault(), getReason() ) + " One-Time" ;
    		} else {
    			return LanguageUtil.get( LocaleUtil.getDefault(), getReason() ) + " Recurring" ;
    		}
    	} else {
    		return LanguageUtil.get( LocaleUtil.getDefault(), getReason() ) + " " + (Toolbox.isEmpty( getPayment() )? ", One-Time" : ", Recurring") ;
    	}
    }
	
	public String getPaymentStatusStr() throws SystemException{
		return LanguageUtil.get( LocaleUtil.getDefault(), getStipendStatus() ) ;
	}
	
	public String getPaymentStatusStage() throws SystemException {
		return isStaged()?
			(getPaymentStatusStr() + " Staged"):
				getPaymentStatusStr() ;
	}

	public boolean isRecurring() {
		return StipendConfig.RECURRING.equals( getStipendType() );
//		return ( StipendConfig.RECURRING.equals( getStipendType() ) || getPayslipDate() != null ) && StipendConfig.PAYMENT_FINANCE.equals( getStipendStatus() );
	}
	
	public boolean isStaged() {
		if ( PAYMENT_FINANCE.equals( getStipendStatus() ) ) {
			if ( getCycleId() > 0 ) {
				try {
					BgLae bl = BgLaeLocalServiceUtil.fetchBgLae( getCycleId() );
					return bl != null && bl.getLargeText().startsWith(STAGED);
				} catch (SystemException e) {
					e.printStackTrace();
				}
			}
		}
		return false;
	}
	
	public Date getPaymentSubmit() {
		if ( getCycleId() > 0 ) {
			try {
				BgLae bl = BgLaeLocalServiceUtil.fetchBgLae( getCycleId() );
				return bl != null? toCalendar(bl.getOwnerId()).getTime(): null;
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	public static Calendar toCalendar(long cycle) {
		Calendar calendar = Calendar.getInstance();
		calendar.set( Calendar.MONTH, (int)(cycle % 12) - 1 );
		calendar.set( Calendar.YEAR, (int)cycle / 12 );
		calendar.set( Calendar.DAY_OF_MONTH, 1);
		return calendar;
	}

	public BigDecimal getDailyRate() {
		
		if ( dailyRate == null ){
			dailyRate = new BigDecimal ( getTierHours() ).multiply( new BigDecimal( getBlsRateHourly() ) ).multiply( TWELVE ).divide(THREESIXTYFIVE, 2, RoundingMode.HALF_UP );
		}
		return dailyRate;
	}
	
	public BigDecimal getDailyRateDiff() {
		return dailyRateDiff;
	}

	public void setDailyRateDiff(BigDecimal dailyRateDiff) {
		this.dailyRateDiff = dailyRateDiff;
	}

	public int getYear() {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( getStipendStartDate() );
		return calendar.get( Calendar.YEAR );
	}
	
//	public void setEffectiveDate(Date effectiveDate) {
//		setStipendStartDate( effectiveDate );
//	}
	
	public BigDecimal getMonthlyBackPayAmount() {
		return monthlyBackPayAmount;
	}
	
	public BigDecimal setMonthlyBackPayAmount(BigDecimal monthlyBackPayAmount) {
		return this.monthlyBackPayAmount = monthlyBackPayAmount;
	}
	
	public int getRetroactiveMonths() {
		return retroactiveMonths;
	}
	
	public BigDecimal getMonthlyRateDiff() {
		return monthlyRateDiff;
	}

	public void setMonthlyRateDiff(BigDecimal monthlyRateDiff) {
		this.monthlyRateDiff = monthlyRateDiff;
	}

	public void setRetroactiveMonths( int retroactiveMonths ) {
		this.retroactiveMonths = retroactiveMonths;
	}

	public int compareTo(StiPt o) {
		return this.getStipendApprovedDate().compareTo( o.getStipendApprovedDate() );
	}
	

//	public LumCg doClosure( ) throws ApplicationWorkFlowException {
//		
//		List<StiPt> toArchive = StiPtLocalServiceUtil.findByVcgRecurringStatus( getVcgId(), new String[] {StipendConfig.PAYMENT_FINANCE});
//		if ( !toArchive.isEmpty() ) {
//			toArchive.get(0).setStipendStatus( StipendConfig.OBSOLETE_PAYMENT );
//			CaretLocalServiceUtil.save(toArchive.get(0));
//		}
//		List<LumCg> closingPayments = null;
//		
//		closingPayments = new ArrayList<LumCg>();
////		closingPayments.add()
//		
//		
////		if ( ) {
////			
////		}
////		closingPayments.add( revocation );
//		toArchive = StiPtLocalServiceUtil.findByVcgRecurringStatus( getVcgId(), new String[] {StipendConfig.ON_HOLD});
//		if ( !toArchive.isEmpty() ) {
//			toArchive.get(0).setStipendStatus( StipendConfig.OBSOLETE_PAYMENT );
//			CaretLocalServiceUtil.save( toArchive.get(0) );
//			LumCg lumCg = new LumCgImpl();
//			lumCg.setVendrId( getVcgId() );
//			lumCg.setStiPtId( toArchive.get(0).getStiPtId() );
//			closingPayments.add( lumCg );
//		}
//		List<StiPt> toArchiveHold = StiPtLocalServiceUtil.findByVcgRecurringStatus( getVcgId(), new String[] {StipendConfig.ON_HOLD});
//		for( StiPt onHoldManual: toArchiveHold ) {
//			closingPayments.add( new StipendConfig( onHoldManual ).doClosure(  ) );
//		}
//		return null;
//	}

	public void setTempStipendStartDate(Date stipendStartDate) {
		this.tempStipendStartDate = stipendStartDate;
	}

}
