package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.List;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.util.Toolbox;


public class Reinstatement extends InitialPayment {

	
	
	private BigDecimal dailyRate = null;			//( ( [Tier Level Monthly Hours] * [Local Hourly Wage] ) * 12) / 365
	private BigDecimal totalStipend;  				//[Monthly Amount] + [Prorated Amount] + [Back Pay] OCC Super must review if > 35k
//	private BigDecimal monthlyAmount = null;		//1296.30 [Tier Level Monthly Hours] * [Local Hourly Wage]
	private BigDecimal backPay = null;				//[Number of Retro Months] * [Monthly Amount]

	public Reinstatement(WorIm workItem, List<StipendConfig> config, Calendar paymentMonthDate ) {
		super(workItem, config, paymentMonthDate);
		this.lastRecurringConfigs = config;
	}
	
	public Reinstatement(WorIm workItem, StiPt config, Calendar paymentMonthDate ) {
		super(workItem, config, paymentMonthDate);
		//			this.lastRecurring = new StipendConfig( this.config.resolveFinanceStaged(false) );
		if ( paymentDate.getTime().before( config.getStipendStartDate() ) ) {
			paymentDate = StipendConfig.getPayday( paymentDate ); 
			_log.info("Adjusted payment date of Reinstatement to " + paymentDate.getTime());
		}
	}
	
	public BigDecimal getBackPayAmount(){
		if ( isBackPayDetected() ) {
			if ( backPay == null ){
				backPay = getMonthlyBackPayAmount().add( getProratedAmount() );
			}
		} else {
			backPay = defaultValue;
		}
		return backPay;
	}
	
	public BigDecimal getTotalStipend(){
		if ( totalStipend == null ){
			totalStipend = defaultValue;
			if ( isBackPayDetected() ) {
				totalStipend = totalStipend.add( getMonthlyBackPayAmount() ).add( getProratedAmount() );
			} 
			if ( config.getPayslipDate() == null ) {
				if ( StipendConfig.getPayday( config.getEffectiveDate() ).getTime().before( getPaymentDate() ) ) {
					totalStipend = totalStipend.add( getMonthlyRate() );
				}
			} else {
				return getMonthlyRate();
			}
		}
		return totalStipend;
	}
	
	public BigDecimal getMonthlyRate (  ) {
		return new BigDecimal( config.getPayment() );
	}
	
	public String getProratedDate(){
		return Toolbox.formatDate( config.getStipendStartDate() );
	}
	
	public int getTotalDays(  ) {
		if (  isRecurring() ) {
			return 0;
		}
		if ( config.getPayslipDate() == null || config.getPayslipDate().after( getPaymentDate() ) ) {
			Calendar calendar = Calendar.getInstance();
			calendar.setTime( config.getStipendStartDate() );
			int applicationDay = calendar.get( Calendar.DAY_OF_MONTH );
			if ( applicationDay == 1) {
				return 0;				//full month will be accounted
			}
			calendar.set( Calendar.DAY_OF_MONTH, 1 );
			calendar.roll(Calendar.DAY_OF_MONTH, false );
			int endDateCurrentPaymentMonth = calendar.get( Calendar.DAY_OF_MONTH );
			return endDateCurrentPaymentMonth - applicationDay + 1;//to make the approval date inclusive
		}
		return 0;
	}
	
	public BigDecimal getProratedAmount(){
		return new BigDecimal( getTotalDays() ).multiply( getDailyRate() ).setScale(2, RoundingMode.HALF_UP);
	}
	
	public BigDecimal getDailyRate(){
		if ( dailyRate == null ){
			dailyRate = config.getDailyRate();
		}
		return dailyRate;
	}
//
//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig config = new StipendConfig( 3, 18.11, format.parse("01/14/2017") );
//		_log.info( new Reinstatement( config, Calendar.FEBRUARY, 2017 ) );
//	}

	public String toString () {
		return  "Stipend Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n     Reinstatement Date: " + formatDate( config.getStipendStartDate() ) +
				"\n          Tier Level of: " + config.getTier() + 
				"\n Total Monthly Hours of: " + config.getTierHours() + //StipendConfig.getTierLevelMonthlyHours( config.getTier() ) + 
				"\n   Local hourly Rate of: " + config.getBlsRateHourly() +
				"\n          Daily Rate of: " + getDailyRate() +
				"\n        Retro Months of: " + getRetroactiveMonths(  ) +
				"\n      Monthly Amount of: " + getMonthlyRate(  ) +
				"\n          Total Days of: " + getTotalDays(  ) +
				"\n           Payment owed: " + getTotalStipend(  ) +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}

	public boolean isBackPayDetected() {
		return isMonthlyBackPayDetected() || getTotalDays(  ) > 0;
	}
	
	public boolean isMonthlyBackPayDetected() {
		return config.getPayslipDate() == null && config.getStipendStartDate().after( StipendConfig.getPayday( StipendConfig.getPayday(Calendar.getInstance() ) ).getTime() );
	}

	public String getBackPayView() {
		return "BackPayView not ready";
	}
	
	private static Log _log = LogFactoryUtil.getLog( Reinstatement.class );

	@Override
	public BigDecimal getMonthlyBackPayAmount() {
		if ( isBackPayDetected() ) {
			if ( lastRecurringConfigs.get(0).getMonthlyBackPayAmount() == null ) {
				lastRecurringConfigs.get(0).setMonthlyBackPayAmount( new BigDecimal( getRetroactiveMonths() ).multiply( getLastRecurringMonthlyRate( 0 ) ).setScale( 2, RoundingMode.HALF_UP ) );
			}
			return lastRecurringConfigs.get(0).getMonthlyBackPayAmount(); 
//			return new BigDecimal ( getRetroactiveMonths() ).multiply( getMonthlyRate() ).setScale(2, RoundingMode.HALF_UP );
		}
		return defaultValue;
	}

	@Override
	public BigDecimal getMonthlyRateDiff( int x ){
		return getMonthlyRate(); 
	}
	
	
	public BigDecimal getFinalAmount() {
		return getTotalStipend();
	}
}

