package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BgNum;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.WorSe;
import gov.va.caret.model.impl.BgNumImpl;
import gov.va.caret.model.impl.WorSeImpl;
import gov.va.caret.model.support.Vendor;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BgNumLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.workflow.OwnerQueue;

public class RecoupmentView extends MultiFacetedConfig implements Recoupment {

	String cached[];
	BgLae payCycle = null;
	BigDecimal amount = BigDecimal.ZERO;
	boolean recoupmentDetected = true;
	WorkType workType = null;
	String startDate;
	Calendar endDate;
	
	
	private static Log _log = LogFactoryUtil.getLog(RecoupmentView.class);
	
	public RecoupmentView( WorIm workItem, WorSe workItemState, Calendar paymentMonthDate ){
		super( workItem, StipendConfig.NULLCONFIG, paymentMonthDate);
		cached = workItemState.getStep().split(StringPool.COLON);
		try {
			if ( cached != null && cached.length > 1 ) {
				this.config = new StipendConfig( StiPtLocalServiceUtil.fetchStiPt( Long.valueOf( cached[1] ) ) );
			} else {
				this.config = StipendConfig.NULLCONFIG;
			}
		
			java.util.List<BgNum> recoupments = BgNumLocalServiceUtil.findByOwnerId( workItem.getGroupId() );
			if ( !recoupments.isEmpty() ) {
				BgNum bgNum = recoupments.get(0);
				amount = new BigDecimal ( bgNum.getValue() );
				payCycle = BgLaeLocalServiceUtil.fetchBgLae( bgNum.getBoxGpId() );
				int ownerId = (int) payCycle.getOwnerId();
				endDate = Calendar.getInstance();
				endDate.set(Calendar.DAY_OF_MONTH, 1);
				endDate.set(Calendar.MONTH, ownerId % 12);
				endDate.set(Calendar.YEAR, ownerId / 12);
				startDate = workItemState.getOldStep();
			} else {
				_log.error("Couldnt find recoupment totals");
			}
			if ( cached != null && cached.length > 0 ) {
				_log.info("configs:" + cached[0]);
			}
			this.lastRecurringConfigs = new ArrayList<StipendConfig>();
			int ndx = 0;
			for ( int j = 2; j < cached.length; j++ ) {
				StipendConfig rec = new StipendConfig( StiPtLocalServiceUtil.fetchStiPt( Long.valueOf( cached[j++] ) ) );
				rec.setRetroactiveMonths( Integer.valueOf( cached[j++] ) );
				this.lastRecurringConfigs.add(rec);

				String days = cached[j];
				_log.info("days:" + days);
				_log.info("Daily Rate Diff:" + getDailyRateDiff( ndx ) );
				_log.info("Monthly Rate Diff:" + getMonthlyRateDiff( ndx ) );
			}
			
			
		} catch (NumberFormatException | SystemException e) {
			_log.error( "wis.step:" + workItemState.getStep() );
			e.printStackTrace();
			recoupmentDetected = false;
		}
	}

	public BigDecimal getRecoupmentAmount() {
		return amount;
	}
	
	public int getRetroactiveMonths( int ndx ){
		if ( cached != null && cached.length > 3 ) {
			return Integer.valueOf( cached[3]);
		}
		return 0;
	}
	public int getTotalDays() {
		if ( cached != null && cached.length > 4 ) {
			return Integer.valueOf( cached[4] );
		}
		return 0;
	}
	
	@Override
	public boolean isRecoupmentDetected() {
		if ( workType == null ) {
			return false;
		}
		switch( workType ) {
			case TIER_UPDATE:
			case REVOKED_DISPOSITION:
			case ADDRESS_CHANGE:
				return recoupmentDetected;
			
			default: return false;
		}
	}

	@Override
	public BigDecimal getMonthlyRate() {
		return new BigDecimal(config.getPayment());
	}

	public Date getPaymentDate() {
		return StipendConfig.getPayday(endDate).getTime();
	}
	
	public String getStipendStartDate() {
		return startDate;
	}
	
	public String getStipendEndDate() {
		return Toolbox.formatDate(endDate.getTime());
	}
	
	public static WorIm create (  ServiceContext sc, CalculationInfo calcInfo, WorkItemSupport from ) throws ApplicationWorkFlowException, SystemException {
		WorIm worIm = CaretUtil.createWorkItem( sc, 0, from.getVcgSupport().getPrimaryVcgAn(), WorkType.RECOUPMENT, from.getPersnId(), from.getCaregiverId() ) ;
		worIm.setQueueId( OwnerQueue.CONSIDERATION_Q.queueId );
		worIm.setVcgId( from.getVcgSupport().getVcgId() );
		worIm.setStatus( "RECOUPMENT_PENDING" );
		worIm.setGroupId( from.getWorImId() );
		if ( from.getUserId() > 0 && CAction.canDoCaret(sc.getLiferayPortletRequest(), CaretCan.CBOPC_CONSIDERATION_Q ) ) {
			worIm.setUserId( from.getUserId() );
		}
		CaretLocalServiceUtil.save(worIm);
		WorSe worSe = new WorSeImpl();
		worSe.setWorImId( worIm.getWorImId() );
		worSe.setCreationDate( sc.getCreateDate() );
		worSe.setUserId( sc.getUserId() );
		//TODO: use step Number for multiple Recoupments in the pay-period 
		//		worSe.setStepNumber( (int) Vendor.initMonth( Calendar.getInstance() ).getBgLaeId() );
		if ( calcInfo instanceof MultiFacetedConfig ) {
			int size = (( MultiFacetedConfig) calcInfo).getLastRecurringConfigs().size();
			String step = size + StringPool.COLON + String.valueOf( calcInfo.getStipendPaymentConfig().getStiPtId() );
			for ( int ndx = 0; ndx < size; ndx++ ){
				StipendConfig config = (( MultiFacetedConfig) calcInfo).getLastRecurringConfigs().get(ndx);
				step = step + StringPool.COLON + config.getStiPtId() 			//2
				+ StringPool.COLON + config.getRetroactiveMonths()					//3
				+ StringPool.COLON + (ndx == 0? calcInfo.getTotalDays() : 0);
			}
			worSe.setStep( step );
		} else {
			worSe.setStep( "1:" + String.valueOf( calcInfo.getStipendPaymentConfig().getStiPtId() ) //1
					+ ":0:" + calcInfo.getRetroactiveMonths()					//3
					+ StringPool.COLON + calcInfo.getTotalDays() );							//4
		}
		
		worSe.setOldStep( Toolbox.formatDate( calcInfo.getStipendPaymentConfig().getStipendStartDate() ) );
		CaretLocalServiceUtil.save( worSe );
		
		BgNum bgNum = new BgNumImpl();
		bgNum.setBoxGpId( Vendor.initMonth( Calendar.getInstance() ).getBgLaeId() );
		bgNum.setOwnerId( from.getWorImId() );
		bgNum.setValue( calcInfo.getRecoupmentAmount().doubleValue() );
		CaretLocalServiceUtil.save(bgNum);
		
		return worIm;
	}
	
	public String[] getCached() {
		return cached;
	}
}
