package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.List;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.util.Toolbox;

public class MultiFacetedConfig extends CalculationWrapper  {
	
	protected Boolean recurring = null;
	protected List<StipendConfig> lastRecurringConfigs;
	private static Log _log = LogFactoryUtil.getLog( MultiFacetedConfig.class );
	
	public MultiFacetedConfig(WorIm workItem, StiPt config, Calendar paymentMonthDate) {
		super(workItem, config, paymentMonthDate);
	}
	
	public boolean isRecurring () {
		if ( recurring == null ) {
			recurring  = new Boolean( StipendConfig.RECURRING.equals(getStipendPaymentConfig().getStipendType() ) );
//					&& getStipendPaymentConfig().getPayslipDate() != null && (getStipendPaymentConfig().getPayslipDate().compareTo( this.getPaymentMonthDate() ) < 0) );
		}
		return recurring;
	}

	public BigDecimal getDailyRate(){
		if ( lastRecurringConfigs == null || lastRecurringConfigs.size() <= 1) {
			return config.getDailyRate();
		}
		return getLastRecurringDailyRate ( lastRecurringConfigs.size()-1 );  //returns the oldest daily rate
	}
	
	public BigDecimal getLastRecurringMonthlyRate ( int ndx ) {
		StipendConfig pc = lastRecurringConfigs.get( ndx );
		if ( Toolbox.isEmpty( pc.getPayment() ) ) {
			BigDecimal monthlyRate = StipendConfig.getMonthlyRate( Double.valueOf( pc.getBlsRateHourly() ), Integer.valueOf( pc.getTier() ) );
			monthlyRate.setScale( 2, RoundingMode.HALF_UP );
			pc.setPayment( monthlyRate.toPlainString() );
			return monthlyRate;
		}
		return new BigDecimal(pc.getPayment());
	}
	
	public BigDecimal getLastRecurringDailyRate ( int ndx ) {
		StipendConfig pc = lastRecurringConfigs.get( ndx );
		if ( dailyRate == null ){
			dailyRate = new BigDecimal ( pc.getTierHours() ).multiply( new BigDecimal( pc.getBlsRateHourly() ) ).multiply( StipendConfig.TWELVE ).divide(StipendConfig.THREESIXTYFIVE, 2, RoundingMode.HALF_UP );
		}
		return dailyRate;
	}
	
	public List<StipendConfig> getLastRecurringConfigs() {
		return lastRecurringConfigs;
	}
	
	public StipendConfig getLastRecurring ( int index ) {
		return (StipendConfig)lastRecurringConfigs.get(index);
	}
	
	public void setBackpayConfig() {
		for ( int i = 0; i < lastRecurringConfigs.size(); i++) {
			getMonthlyBackPayAmount(i);
			getRetroactiveMonths(i);
		}
	}
	
	public BigDecimal getMonthlyRateDiff( int ndx ){

		if ( lastRecurringConfigs.size() == 1 ) {
			return getMonthlyRate().subtract( getLastRecurringMonthlyRate(lastRecurringConfigs.size()-1) ).abs(); 
		} else {
//			StipendConfig pc = lastRecurringConfigs.get( ndx );
			BigDecimal oldMonthlyRate = getLastRecurringMonthlyRate(ndx);
			BigDecimal montlyRateNew = new BigDecimal( config.getPayment() );
//			monthlyRate = StipendConfig.getMonthlyRate( Double.valueOf( pc.getBlsRateHourly() ), Integer.valueOf( pc.getTier() ) );
			return montlyRateNew.subtract( oldMonthlyRate ).abs();
		}		
	}
	
	public BigDecimal getDailyRateDiff( int ndx ){
		BigDecimal dailyRateDiff = lastRecurringConfigs.get(ndx).getDailyRateDiff();
		if ( dailyRateDiff == null ) {
			dailyRateDiff = lastRecurringConfigs.get(ndx).getDailyRate().subtract( getDailyRate() ).abs();
			lastRecurringConfigs.get(ndx).setDailyRateDiff(dailyRateDiff);
		}
		return dailyRateDiff;
	}
	
	public BigDecimal getMonthlyBackPayAmount( int ndx ){
		if ( lastRecurringConfigs.get(ndx).getMonthlyBackPayAmount() == null ) {
			BigDecimal monthlyBackPayAmount = new BigDecimal( getRetroactiveMonths( ndx ) ) 
					.multiply( getLastRecurringMonthlyRate( ndx ) ).setScale( 2, RoundingMode.HALF_UP );
			
			return monthlyBackPayAmount;
		}
		return lastRecurringConfigs.get(ndx).getMonthlyBackPayAmount();
	}
	
	public int getRetroactiveMonths( int ndx ){
		if ( lastRecurringConfigs.get(ndx).getRetroactiveMonths() == 0 ) {
			int totalMonths = -1;//to account for full month and partial month.
			Calendar rollingFirstDay = Calendar.getInstance();
			rollingFirstDay.setTime( lastRecurringConfigs.get(ndx).getStipendStartDate() );
			int i = 0;
			for (  ; rollingFirstDay.getTime().before( lastRecurringConfigs.get(ndx).getStipendEndDate() ); totalMonths++ ) {
				if ( i > 120 ) {
					System.err.println("Invalid Stipend-Start-Date..");
					break;
				}
				if ( rollingFirstDay.get(Calendar.MONTH ) == Calendar.DECEMBER ){
					rollingFirstDay.roll( Calendar.YEAR, true );
					rollingFirstDay.roll( Calendar.MONTH, true );
				} else {
					rollingFirstDay.roll( Calendar.MONTH, true );
				}
				i++;
			}
			lastRecurringConfigs.get(ndx).setRetroactiveMonths( Math.max( totalMonths > 120? 0: (ndx >0)? totalMonths: totalMonths-1, 0 ) );
		}
//		_log.info("Retro Months: " + lastRecurringConfigs.get(ndx).getRetroactiveMonths() );
		return lastRecurringConfigs.get(ndx).getRetroactiveMonths();
	}

	public String getOneTime(int i) {
		return getMonthlyBackPayAmount(i).add( getBackPayAmount() ).setScale( 2, RoundingMode.HALF_UP ).toPlainString();
	}
	
}
