package gov.va.caret.model.support.occ;


import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.model.BgLae;
import gov.va.caret.model.LumCg;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.support.Vendor;
import gov.va.caret.service.LumCgLocalServiceUtil;
import gov.va.caret.service.PayLgLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;

public class LumpPayment {
	
	private static Log _log = LogFactoryUtil.getLog( LumpPayment.class );
	private static final long serialVersionUID = 1L;
	
	@SuppressWarnings("unchecked")
	Map <DateRange,LumpStructure> payments = new TreeMap<DateRange,LumpStructure>();
	Map <DateRange,StiPt> recoupments;
	
	private Vendr vendor = null;
	
	public LumpPayment(DateRange dateRange, long vendrId) throws PortalException, SystemException {
		
		Date start = dateRange.getStartDate();
		Vendr vendr = gov.va.caret.service.VendrLocalServiceUtil.fetchVendr(vendrId);
		Calendar calendar = Calendar.getInstance();
		for ( calendar.setTime( dateRange.getStartDate() ); calendar.getTime().before( dateRange.getEndDate() ); calendar = StipendConfig.getPayday(calendar) ) { //loop through monthly...
			
			BgLae bgLae = Vendor.initMonth(calendar, false);
			String status = "UNPAID";
			
			PayLg payLg = null;
			_log.info("test" + (vendor == null) + " and " + bgLae == null);
			try {
				payLg = PayLgLocalServiceUtil.findByVendorCycle( vendor.getVendrId(), bgLae.getBgLaeId() );
			} catch (Exception e) {
				return;
			}
			if ( payLg != null ) {
				status = payLg.getReason();
			}
			
			List<LumCg> lumCgs = LumCgLocalServiceUtil.findByVendrCycle( vendrId, bgLae.getBgLaeId() );
			List<StiPt> configs = new ArrayList<StiPt>();
			for ( LumCg lumps : lumCgs ) { //loop through each applicable config (in a month)
				configs.add( StiPtLocalServiceUtil.getStiPt( lumps.getStiPtId() ) );
			}
			Collections.sort(configs, LumpComparator);
			
			Calendar copy = (Calendar)calendar.clone();
			copy.set( Calendar.DAY_OF_MONTH, 1);
			copy.roll( Calendar.DAY_OF_MONTH, false);
			Date end = copy.getTime();
			for ( StiPt config : configs ) {
				start = DateRange.max( config.getStipendStartDate(), start );
				payments.put( new DateRange( start, end ), new LumpStructure(config, status) );
				end = start;
			}
		}
	}
	
	class LumpStructure {
		StiPt config;
		String status;
		
		LumpStructure( StiPt config, String status ){
			this.config = config;
			this.status = status;
		}
		
	}
	
	Comparator LumpComparator = new Comparator<StiPt>() {
		@Override
		public int compare(StiPt o1, StiPt o2) {
			return o2.getStipendStartDate().compareTo(o1.getStipendStartDate());
		}
	};
	
}
