package gov.va.caret.model.support.occ;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.CbopcFmDashboardConfig;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BgNum;
import gov.va.caret.model.FmsIcNew;
import gov.va.caret.model.FmsIcStatus;
import gov.va.caret.model.FmsOg;
import gov.va.caret.model.LumCg;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.LumCgImpl;
import gov.va.caret.model.impl.PayLgImpl;
import gov.va.caret.model.support.BoxNumberSupport;
import gov.va.caret.model.support.Vendor;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.FmsIcNewLocalServiceUtil;
import gov.va.caret.service.FmsIcStatusLocalServiceUtil;
import gov.va.caret.service.FmsOgLocalServiceUtil;
import gov.va.caret.service.LumCgLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.workflow.OwnerQueue;

public class FmsIcMessageListener implements MessageListener {

	private static Log _log = LogFactoryUtil.getLog( FmsIcMessageListener.class );
	
	private static final int MONTH = 0;
	private static final int WEEK = 1;
	private static final int DAY = 2;
	
	@Override
	public void receive(Message arg0) throws MessageListenerException {
		
		Map<Long,Long> incoming = CaretLocalServiceUtil.getFmsState("FMS_INCOMING_LOADED", true);
		
		if ( incoming.isEmpty() ) {
			if ( _log.isDebugEnabled() ) {
				_log.debug("Nothing found from FMS to log");
			}
		} else {
			_log.info("Found Incoming from FMS to log " + incoming.size() );
			
			double dollarRejected = 0;
			double dollarAmount = 0;
			int numberRejected = 0;
			int numberApproved = 0;
			
			int payContext = DAY;
			
			for ( long bgLaeId: incoming.keySet() ) {
				
				BgLae bgLae = null;
				ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
				
				try {
					bgLae =  BgLaeLocalServiceUtil.fetchBgLae(bgLaeId);
					int notFound = 0;
					boolean breakOuter = false;
					BgLae bgLaeNext = Vendor.initMonth( Calendar.getInstance() );
					int count = FmsIcNewLocalServiceUtil.getFmsIcNewsCount();
					int logged = 0;
					for ( ; count > 0 && !breakOuter; count = FmsIcNewLocalServiceUtil.getFmsIcNewsCount() ) {
						List<FmsIcNew> listIcNew = FmsIcNewLocalServiceUtil.getFmsIcNews(0, Math.min(count, 100) );
						for ( FmsIcNew ic: listIcNew ) {
							if ( ic != null && !ic.getPayLogLoaded() ){
								Date icConfirmDate;
								try {
									icConfirmDate = (Date)Toolbox.getDateFormatOrientShort().parseObject( ic.getConfirmDate() );
								} catch ( ParseException pe ) {
									icConfirmDate = new Date();
									pe.printStackTrace();
								}
								
								Long icTransNumber;
								try {
									icTransNumber = Long.valueOf( ic.getTransNumber() );
								} catch ( NumberFormatException nfe ) {
									nfe.printStackTrace();
									continue;
								}
									
								FmsOg fmsOg = FmsOgLocalServiceUtil.fetchFmsOg( icTransNumber );
								
								int countLump = 0;
								for ( StiPt stiPt: StiPtLocalServiceUtil.findByVendorCycle( fmsOg.getVendrId(), bgLaeId ) ) {
									boolean completedAccepted = "C".equals( ic.getFmsActivityCode() );
									if ( completedAccepted ) {
									
										if ( StipendConfig.RECURRING.equals( stiPt.getStipendType() ) ) {
											stiPt.setCycleId( bgLaeNext.getBgLaeId() );
										}
										if ( stiPt.getPayslipDate() == null ) {
											stiPt.setPayslipDate( icConfirmDate );
										}
										CaretLocalServiceUtil.save( stiPt );
										String amount = ( stiPt.getPayslipDate() == null ) ? stiPt.getOneTimePayment() : stiPt.getPayment();
										if ( fmsOg.getLineItems() == 1 && Double.valueOf( amount ) != ic.getDisbursedAmt() ) {
											_log.error("VENDOR PAYMENTS DONT MATCH: config " + amount + "/ disbursement " + ic.getDisbursedAmt() );
										}
										numberApproved++;
										dollarAmount += ic.getDisbursedAmt();

									} else { //"X" for standard cancelled/rejected
										try {
											doRejection( stiPt, ic.getFmsIcId() );
										} catch (PortalException e) {
											e.printStackTrace();
										}
										numberRejected++;
										dollarRejected += ic.getDisbursedAmt();
									}
									
									LumCg lumCg = new LumCgImpl();
									lumCg.setCycleId( fmsOg.getCycleId() );
									lumCg.setStiPtId( stiPt.getStiPtId() );
									lumCg.setVendrId( fmsOg.getVendrId() );
									lumCg.setStatus( ic.getReasonCode() );
									LumCgLocalServiceUtil.addLumCg( lumCg );
									countLump++;

									PayLg payLg = new PayLgImpl();
									payLg.setAmount( ic.getDisbursedAmt()  );
									payLg.setCreationDate( sc.getCreateDate() );
									payLg.setCycleId( fmsOg.getCycleId() );
									payLg.setFmsIcId( ic.getFmsIcId() );
									payLg.setLumped( fmsOg.getLineItems() > 1);
									payLg.setPaymentDate( icConfirmDate );
									payLg.setPaymentNumber( ic.getCheckEftNo() );
									payLg.setReason( completedAccepted? "Successful": "Rejected" );
									payLg.setVendrId( fmsOg.getVendrId() );
									CaretLocalServiceUtil.save(payLg);
								}
								
								if ( countLump != fmsOg.getLineItems() ) {
									_log.error(fmsOg.getFmsOgId() + "- expected:" + fmsOg.getLineItems() + ", actual:" + countLump);
								}
								ic.setPayLogLoaded(true);
								FmsIcNewLocalServiceUtil.updateFmsIcNew( ic );
									
							} else {
								notFound++;
							}
							if ( notFound == count ) {
								breakOuter = true;
								break;
							}
						}
						logged++;
					}
					
					/// Reference second file:
					for ( ; count > 0 && !breakOuter; count = FmsIcStatusLocalServiceUtil.getFmsIcStatusesCount() ) {
						List<FmsIcStatus> listIcStatus = FmsIcStatusLocalServiceUtil.getFmsIcStatuses(0, Math.min(count, 100) );
						for ( FmsIcStatus ic: listIcStatus ) {
							if ( ic != null && !ic.getPayLogLoaded() ){
								Date icConfirmDate = new Date();
								
								Long icTransNumber;
								try {
									icTransNumber = Long.valueOf( ic.getChampDocNum() );
								} catch ( NumberFormatException nfe ) {
									nfe.printStackTrace();
									continue;
								}
									
								FmsOg fmsOg = FmsOgLocalServiceUtil.fetchFmsOg( icTransNumber );
								
								int countLump = 0;
								for ( StiPt stiPt: StiPtLocalServiceUtil.findByVendorCycle( fmsOg.getVendrId(), bgLaeId ) ) {
									
									try {
										doRejection( stiPt, ic.getFmsIsId() );
									} catch (PortalException e) {
										e.printStackTrace();
									}
									numberRejected++;
									Double amount = Double.valueOf( stiPt.getPayslipDate() == null? stiPt.getOneTimePayment(): stiPt.getPayment() );
									try {
										amount = Double.valueOf( ic.getChampAmount() );
										dollarRejected += amount;
									} catch (NumberFormatException nfe) {
										_log.error("Double:" + ic.getChampAmount() );
									}
									
									LumCg lumCg = new LumCgImpl();
									lumCg.setCycleId( fmsOg.getCycleId() );
									lumCg.setStiPtId( stiPt.getStiPtId() );
									lumCg.setVendrId( fmsOg.getVendrId() );
									lumCg.setStatus( ic.getChampErrCode() );
									LumCgLocalServiceUtil.addLumCg( lumCg );
									countLump++;

									PayLg payLg = new PayLgImpl();
									payLg.setAmount( amount );
									payLg.setCreationDate( sc.getCreateDate() );
									payLg.setCycleId( fmsOg.getCycleId() );
									payLg.setFmsIcId( ic.getFmsIsId() );
									payLg.setLumped( fmsOg.getLineItems() > 1);
									payLg.setPaymentDate( icConfirmDate );
									payLg.setReason( "Rejected" );
									payLg.setVendrId( fmsOg.getVendrId() );
									CaretLocalServiceUtil.save(payLg);
								}
								
								if ( countLump != fmsOg.getLineItems() ) {
									_log.error(fmsOg.getFmsOgId() + "- expected:" + fmsOg.getLineItems() + ", actual:" + countLump);
								}
								ic.setPayLogLoaded(true);
								FmsIcStatusLocalServiceUtil.updateFmsIcStatus( ic );
									
							} else {
								notFound++;
							}
							if ( notFound == count ) {
								breakOuter = true;
								break;
							}
						}
						logged++;
					}
					
					
					
					
					if ( notFound > 0 ) {
						_log.error("NOT-Found:" + notFound);
					}
					_log.info("logged:" + logged);
					_log.info("Total Succesful Payments we logged:" + dollarAmount );
					_log.info("Total Rejections we logged:" + dollarRejected );
				
					bgLae.setLargeText( StipendConfig.COMPLETED );
					CaretLocalServiceUtil.save(bgLae);
					
				} catch (ApplicationWorkFlowException e1) {
					e1.printStackTrace();
					return;
				} catch (SystemException e) {
					e.printStackTrace();
					return;
				}
			}
			
			try {
				BoxNumberSupport num = new BoxNumberSupport ( BoxGpLocalServiceUtil.getBoxGroupBgNum( CbopcFmDashboardConfig.AVAILABLE_ID ).get(0) );
				double rejects = "true".equals(PropsUtil.get( "fms.rejects.deduct" ) )? dollarRejected: 0;
				num.setValue( num.getValue() - dollarAmount - rejects );
				CaretLocalServiceUtil.save(num);

				BgNum threshold = BoxGpLocalServiceUtil.getBoxGroupBgNum( CbopcFmDashboardConfig.THRESHOLD_ID ).get(0);
				if ( CaretUtil.isEmailEnabled() ) {
					
					Map<String,Object> otherInfo;
					
					if ( threshold.getValue() > num.getValue() ) {
						
						otherInfo = new HashMap<String,Object>();
						otherInfo.put("to", PropsUtil.get( "occfm.threshold.email.to" ) );
						otherInfo.put("from", PropsUtil.get( "occfm.threshold.email.from" ) );
						otherInfo.put("subject", PortletProps.get( "occfm.threshold.email.subject" ) );
						otherInfo.put("body", PortletProps.get( "occfm.threshold.email.body" ) );
						
						CaretUtil.sendPaymentNotificationMail(otherInfo);
					}
					
					String arg = "fms.daily.loaded.email";
					switch ( payContext ) {
					case MONTH:
						arg = "fms.monthly.loaded.email";
						break;
					case WEEK:
						arg = "fms.weekly.loaded.email";
					} 
					otherInfo = new HashMap<String,Object>();
					otherInfo.put("to", PropsUtil.get( arg + ".to" ) );
					otherInfo.put("from", PropsUtil.get( arg + ".from" ) );
					otherInfo.put("subject", PortletProps.get( arg + ".subject" ) );
					otherInfo.put("body", PortletProps.get( arg + ".body" ) );
					
					CaretUtil.sendPaymentNotificationMail(otherInfo);
				} else {
					
				}
				
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}

		_log.info("FMS Scanner: End");
		
	}

	
	public void doRejection( StiPt config, long fmsIcId ) throws PortalException, SystemException {
		Vendr vendr = VendrLocalServiceUtil.fetchVendr( config.getVendrId() );
		vendr.setStatus( StipendConfig.ON_HOLD );
		CaretLocalServiceUtil.save(vendr);
	
		config.setStipendStatus( StipendConfig.ON_HOLD );
		_log.info("putting on hold..." + config);
		CaretLocalServiceUtil.save( config );
		
		WorIm worIm = WorImLocalServiceUtil.getWorIm( config.getWorImId() );
		WorIm rejectedWorIm = CaretUtil.createWorkItem( ServiceContextThreadLocal.getServiceContext(), worIm.getGroupId(),
				worIm.getClassId(), worIm.getClassPk(), worIm.getPersnId(), WorkType.REJECTED_PAYMENT.name(), worIm.getCaregiverId(),
				WorkType.REJECTED_PAYMENT.getDueDate( ServiceContextThreadLocal.getServiceContext().getCreateDate() ) );
		rejectedWorIm.setQueueId(OwnerQueue.REJ_PAY_Q.getQueueId());
		rejectedWorIm.setVcgId( worIm.getVcgId() );
		rejectedWorIm.setGroupId( fmsIcId );
		rejectedWorIm.setStatus(CaretStrPool.HOLD_PLACED_ON_ACCOUNT);
		_log.info("creating hold work item..." + rejectedWorIm);
		CaretLocalServiceUtil.save(rejectedWorIm);
	}
	
	public static boolean getFmsCode (String key) {
		return Boolean.TRUE.equals( PortletProps.get( key.replaceAll(StringPool.BLANK, StringPool.PERIOD ) + ".fms.code" ) );
	}
	
}
