package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.service.BgLaeLocalServiceUtil;


public class FinalPayment extends MultiFacetedConfig implements Recoupment, BackPay {
	
	private static Log _log = LogFactoryUtil.getLog(FinalPayment.class);
	
	public FinalPayment(WorIm workItem, StiPt config, Calendar payDay ) {
		super(workItem, config, payDay );
		_log.info("FinalPayment..1");
		try {
			this.lastRecurringConfigs = new ArrayList<StipendConfig>();
			this.config.resolveFinanceStaged( false, this.lastRecurringConfigs );
			if ( this.lastRecurringConfigs.get(0).getCycleId() > 0 ) {
				try {
					BgLae cycle = BgLaeLocalServiceUtil.getBgLae( this.lastRecurringConfigs.get(0).getCycleId() );
					this.lastRecurringConfigs.get(0).setStipendEndDate( StipendConfig.toCalendar( cycle.getOwnerId() ).getTime() );
				} catch (PortalException e) {
					e.printStackTrace();
				}
			}
		} catch (ApplicationWorkFlowException | SystemException e) {
			e.printStackTrace();
		}
	}
	
	public FinalPayment(WorIm workItem, Calendar payDay, StiPt config ) {
		super(workItem, config, payDay );
		this.lastRecurringConfigs = new ArrayList<StipendConfig>();
		this.lastRecurringConfigs.add( new StipendConfig( config ) );
		this.lastRecurringConfigs.get(0).setStipendEndDate( config.getStipendStartDate() );
		_log.info("FinalPayment...2");
	}
	
	public boolean isCalculationChange(){
		return true;
	}
	
	public int getTotalDays(  ) {
		int days = 0;
		if ( isRecoupmentDetected() ) {
			
			long diff = lastRecurringConfigs.get(0).getStipendEndDate().getTime() - getBenefitsEndDate().getTime();
			
			days = (int)(diff / (1000*60*60*24));
			days = days%30;
			
		} else if ( isBackPayDetected() ) {
			
			long diff = getBenefitsEndDate().getTime() - lastRecurringConfigs.get(0).getStipendEndDate().getTime();
			
			days = (int)(diff / (1000*60*60*24));
			days = days%30;
			if ( days == 0 ) {
				Calendar calendar = Calendar.getInstance();
				calendar.setTime( getBenefitsEndDate() );
				days = calendar.get( Calendar.DAY_OF_MONTH );
			}
		}
		return days;
	}
	
	public BigDecimal getProratedAmount(){
		return new BigDecimal( getTotalDays() ).multiply( getDailyRate() ).setScale( 2, RoundingMode.HALF_UP );
	}
	
	public BigDecimal getMonthlyBackPayAmount(){
		if ( lastRecurringConfigs.get(0).getMonthlyBackPayAmount() == null ) {
			lastRecurringConfigs.get(0).setMonthlyBackPayAmount( new BigDecimal( getRetroactiveMonths(  ) ).multiply( getLastRecurringMonthlyRate( 0 ) ).setScale( 2, RoundingMode.HALF_UP ) );
		}
		return lastRecurringConfigs.get(0).getMonthlyBackPayAmount(); 
	}
	
	public BigDecimal getDailyRateDiff(){
		return getDailyRate();
	}
	
	@Override
	public int getRetroactiveMonths( ){
		int months = 0;
		if ( isRecoupmentDetected() ) {
			
			long diff = lastRecurringConfigs.get(0).getStipendEndDate().getTime() - getBenefitsEndDate().getTime();
			
			int days = (int)(diff / (1000*60*60*24));
			months = days/30;
			
//			return (int)days;
		} else if ( isBackPayDetected() ) {
			long diff = getBenefitsEndDate().getTime() - lastRecurringConfigs.get(0).getStipendEndDate().getTime();
			
			int days = (int)(diff / (1000*60*60*24));
			months = days/30;
		}
		return months;
	}
	
	public BigDecimal getDailyRate(){
		return config.getDailyRate();
	}
	
	public Date getBenefitsEndDate() {
		Calendar offset = Calendar.getInstance();
		offset.setTime( config.getStipendStartDate() );
		offset.add( Calendar.DAY_OF_YEAR, config.getEntitledDays() );
		return offset.getTime();
	}
	
	public BigDecimal getRecoupmentDaysAmount() {
		return new BigDecimal( getTotalDays() ).multiply( getDailyRate() ).setScale( 2, RoundingMode.HALF_UP );
	}
	
	public double getRecoupmentDays(  ) {
		return getTotalDays();
	}
	
	public BigDecimal getBackPayAmount(){
		if ( isBackPayDetected() ) {
			return getMonthlyRate().multiply( new BigDecimal( getRetroactiveMonths() ) ). add( getProratedAmount() );
		}
		return BigDecimal.ZERO;
	}
	
	public BigDecimal getRecoupmentAmount(){
		if ( isRecoupmentDetected() ) {
			return getMonthlyRate().multiply( new BigDecimal( getRetroactiveMonths() ) ). add( getProratedAmount() );
		}
		return BigDecimal.ZERO;
	}
	
	public boolean isBackPayDetected() {
		return lastRecurringConfigs.get(0).getStipendStartDate().before( this.getBenefitsEndDate() );
//		return lastRecurringConfigs.get(0).getStipendEndDate().before( this.getBenefitsEndDate() );
	}
	
	public boolean isRecoupmentDetected() { 
		return lastRecurringConfigs.get(0).getStipendEndDate().after( this.getBenefitsEndDate() );
	}
	
	public BigDecimal getFinalAmount(){
		if ( isRecoupmentDetected() ) {
			return BigDecimal.ZERO;
		}
		return getBackPayAmount();
	}
	
//	public BigDecimal getEntitlementAmount(){
//		if ( config.getEntitledDays() == 0 ) return BigDecimal.ZERO;
//		return new BigDecimal( config.getEntitledDays()/30 ).multiply( getMonthlyRate() ).setScale( 2, RoundingMode.HALF_UP );
//	}

	//Final Payment (if Termination Date falls within the current Payment Month) = [Entitlement Amount] + Prorated Amount]
	//[Entitlement Amount]  Recoupment Amount]
//	public BigDecimal getFinalAmount(){
//		if ( isRecoupmentDetected() ) {
//			return getMonthlyRate().add( getEntitlementAmount() ); //.subtract( getRecoupmentAmount() );
//		} else {
////			return getMonthlyBackPayAmount().add( getProratedAmount() ).add( getMonthlyRate() ).add( getEntitlementAmount() );
//			return getBackPayAmount().add( getMonthlyRate() ).add( getEntitlementAmount() );
//		}
//	}
	
	
//	public void init ( WorIm workItem, Date revocationDate ) {
		
		/*
		_log.info("init()");
		try {
			lastRecurring = new StipendConfig( this.config.resolveFinanceStaged(false) );
			
			if ( Toolbox.isEmpty( config.getPayment() ) ) {
				config.setPayment( getMonthlyRate().toPlainString() );//LumCgLocalServiceUtil.findByVendrCycle(lastRecurring.getVendrId(), lastRecurring.getCycleId() )
			}
			if ( lastRecurring.getCycleId() > 0 ) {
				BgLae bgLae = BgLaeLocalServiceUtil.fetchBgLae( lastRecurring.getCycleId() );
				if ( bgLae != null ) {
					_log.info("Last Payment attempted on cycle " + bgLae.getLargeText() );
				}
			}
			_log.info("Config state: " + lastRecurring.getStipendStatus() );
			
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		*/
//		Calendar lastPaidMonth = Calendar.getInstance();
//		lastPaidMonth.setTime( paymentDate.getTime() );
//		double paid = 0;
//		List<StiPt> recurringOwed = new ArrayList<StiPt>();
//		try {
//			for ( ; lastPaidMonth.getTime().after(revocationDate ) ; ) {
//				double paidCycle = 0;
//				gov.va.caret.model.BoxGp boxGp = gov.va.caret.model.support.Vendor.getRecurringBoxGp( lastPaidMonth, false );
//				if ( boxGp != null ) {
//					long boxGpId = boxGp.getBoxGpId();
//					int ownerMonth = lastPaidMonth.get( Calendar.MONTH ) + lastPaidMonth.get( Calendar.YEAR )* 12;  // month = 6 for July, year = 24216
//					BgLae bgLae = BgLaeLocalServiceUtil.getBgLaeAssociation( ownerMonth, boxGpId );
//					Calendar start = Calendar.getInstance();
//					if ( bgLae != null ) {
//						PayLg payLg = PayLgLocalServiceUtil.findByVendorCycle( vendor.getVendrId(), bgLae.getBgLaeId() );
//						if ( payLg != null ) {
//							if ( "successful".equals( payLg.getReason() ) ) {
//								List<LumCg> lumps = LumCgLocalServiceUtil.findByVendrCycle( vendor.getVendrId(), bgLae.getBgLaeId() );
//								
//								List<StiPt> recurringCycle = new ArrayList<StiPt>();
//								paidCycle = payLg.getAmount() - resolvePayments( lumps, recurringCycle );
//								recurringOwed.addAll( recurringCycle );
//								if ( paidCycle > 0 && !recurringCycle.isEmpty() ) {
//									for ( StiPt recurring : recurringCycle ) {
//										PaymentLog payLog = new PaymentLog( payLg );
//										if ( paidCycle == Double.valueOf( recurring.getOneTimePayment() ) ) { //initial payment...
//											_log.info("initial one-time recurring payment from " + Toolbox.formatDate( payLog.getBeginDate() ) + " to " + Toolbox.formatDate( payLog.getEndDate() ) );
//											_log.info("recoup payments from " + Toolbox.formatDate(revocationDate ) + " to " + Toolbox.formatDate( payLog.getEndDate() ) );
//											start.setTime( revocationDate );
//											
//											Calendar startCopy = (Calendar) start.clone();
//											
//											Calendar end = Calendar.getInstance();
//											end.setTime( payLog.getEndDate() );
//											
//											for ( ; startCopy.compareTo(end) < 0; recoupMonths++ ) {
//												if ( startCopy.get( Calendar.MONTH ) == Calendar.DECEMBER ) {
//													startCopy.roll(Calendar.YEAR, true);
//													start.roll(Calendar.YEAR, true);
//												}
//												startCopy.roll(Calendar.MONTH, true);
//											}
//											start.roll( Calendar.MONTH, recoupMonths );
//											for ( ; start.compareTo(end) < 0; recoupmentDays++ ) {
//												start.roll(Calendar.DAY_OF_YEAR, true);
//											}
//											_log.info("recoupment days:" + recoupmentDays);
//										} else if ( paidCycle == Double.valueOf( recurring.getPayment() ) ) { // monthly payment
//											_log.info("regular recurring monthly payment " + payLog.getEndDate() );
//											
//											Calendar lastPaidMonthClone = (Calendar) lastPaidMonth.clone();
//											
//											if ( lastPaidMonthClone.get(Calendar.MONTH) == Calendar.JANUARY ) {
//												lastPaidMonthClone.roll(Calendar.YEAR, false);
//											}
//											lastPaidMonthClone.roll(Calendar.MONTH, false);
//											if ( lastPaidMonthClone.getTime().after( revocationDate ) ) {
//												recoupMonths++;
//											} else {
//												lastPaidMonthClone.setTime(revocationDate);
//												for ( ; lastPaidMonthClone.get(Calendar.DATE) != 1; recoupmentDays++ ) {
//													lastPaidMonthClone.roll(Calendar.DATE, true);
//												}
//											}
//											
//										} else {
//											_log.error("could not detect conditions of payment");
//										}
//									}
//								}
//							} else if ( StipendConfig.PAYMENT_REJECTED.equals( payLg.getReason() ) ) {
//								
//							}
//						} else {
//							resolvePayments ( LumCgLocalServiceUtil.findByVendrCycle( vendor.getVendrId(), bgLae.getBgLaeId() ), recurringOwed );
//						}
//					}
//				} else {
//					_log.info("Early Verify - Payments not applied to accounts for current pay-day:" + lastPaidMonth );
//				}
//				if ( lastPaidMonth.get(Calendar.MONTH) == Calendar.JANUARY ) {
//					lastPaidMonth.roll(Calendar.YEAR, false);
//				}
//				lastPaidMonth.roll(Calendar.MONTH, false);
//				paid = paid + paidCycle;
//			}
//		} catch (PortalException e) {
//			e.printStackTrace();
//		} catch (SystemException e) {
//			e.printStackTrace();
//		}
//		_log.info("Recoupment Months:" + recoupmentDays + ", Recoupment Days:" + recoupmentDays);
//	}
	
//	public int getRetroactiveMonths() {
//	int fullMonth = 0;
//	if ( getTotalDays() > 29 ) {
//		fullMonth++;
//	}
//	return fullMonth + getMonthsUnpaidSinceStartDate();
//}
//
//	public double resolvePayments ( List<LumCg> lumps, List<StiPt> recurring ) throws PortalException, SystemException {
//		double manualPayments = 0;
//		for ( LumCg lump : lumps ) {
//			StiPt tempStipt = StiPtLocalServiceUtil.getStiPt( lump.getStiPtId() );
//			if ( StipendConfig.RECURRING.equals(tempStipt.getStipendType() ) ) {
//				recurring.add( tempStipt );
//			} else { // manual amount added to lump sum
//				manualPayments = manualPayments + Double.valueOf( tempStipt.getOneTimePayment() );
//			}
//		}
//		return manualPayments;
//	}
//	
//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig config = new StipendConfig( 3, 18.11, format.parse("10/15/2016"), 90 );
//		_log.info( new FinalPayment( config, Calendar.FEBRUARY, 2017 ) );
//	}
	
	public String toString () {
		return   "            Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n   With Revocation Date: " + formatDate( config.getStipendStartDate() ) +
				"\n       Days Entitled of: " + config.getEntitledDays() +
				"\n         Monthly Amount: " + getMonthlyRate(  ) +
//				"\n  Entitlement Amount of: " + getEntitlementAmount() +

				
				"\n   Local hourly Rate of: " + config.getBlsRateHourly() + //StipendConfig.getTierLevelMonthlyHours( config.getTier() ) +
				"\n          Daily Rate of: " + getDailyRate() +
				"\n          Tier Level of: " + config.getTier() + 
//				"\n         Recoup Days of: " + getRecoupmentDays( ) +
//				"\n  Recoup Days Amount of: " + getRecoupmentDaysAmount( ) +
//				"\nRecoup Months Amount of: " + getMonthlyRate().add( getEntitlementAmount() ) +
				"\n   Benefits End Date of: " + formatDate(  getBenefitsEndDate( ) ) +

				
//				"\n        Recoup Months of: " + getRecoupMonths(  ) +
				
				"\n          Final Payment: " + getFinalAmount() +
//				"\n      Recoupment Amount: " + getRecoupmentAmount() +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}

	
}

