package gov.va.caret.model.support.occ;

import java.util.Date;

public class DateRange extends com.liferay.portal.kernel.util.DateRange implements Comparable<DateRange> {
	
	public DateRange(Date start, Date end){
		super(start, end);
	}
	
	boolean endsAfter(Date date) {
		return getEndDate() == null || getEndDate().after(date);
	}
	
	boolean endsBefore(Date date) {
		return getEndDate()!= null && getEndDate().before(date);
	}
	
	boolean startsAfter(Date date) {
		return getStartDate().after(date);
	}
	
	boolean startsBefore(Date date) {
		return getStartDate().before(date);
	}
	
	boolean isBetween(Date date) {
		return startsBefore(date) && endsAfter(date);
	}
	
	public static Date max( Date one, Date two ) {
		if ( one == null ) return two;
		if ( two == null ) return one;
		return new Date( Math.max(one.getTime(), two.getTime()) );
	}
	
	@Override
	public int compareTo(DateRange o) {
		return getStartDate().compareTo( o.getStartDate() );
	}
	
}
