package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.LumCg;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.support.PaymentLog;
import gov.va.caret.service.LumCgLocalServiceUtil;
import gov.va.caret.service.PayLgLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.Toolbox;

public class CalculationWrapper implements CalculationInfo {

	BigDecimal defaultValue = BigDecimal.ZERO;
	
	protected WorIm workItem;
	protected StipendConfig config;
	protected Calendar paymentDate;
	private int stipendMonth;
	private int stipendYear;
	protected BigDecimal dailyRate = null;			//( ( [Tier Level Monthly Hours] * [Local Hourly Wage] ) * 12) / 365
	protected BigDecimal monthlyRate = null;		//1296.30 [Tier Level Monthly Hours] * [Local Hourly Wage]
//	protected StipendConfig lastRecurring = null;
	private Date lastRecurringPayment = null;
	private int monthsPaid = -1;
//	private int monthsUnpaid = -1;
//	BigDecimal oldDailyRate = null;
//	BigDecimal oldMonthlyRate = null;
	
	public CalculationWrapper(WorIm workItem, StiPt config, Calendar paymentMonthDate ) {
		this.workItem = workItem;
		this.config = new StipendConfig(config);
		this.paymentDate = (Calendar)paymentMonthDate.clone();
		
		int payingMonth = paymentMonthDate.get(Calendar.MONTH);
		int payingYear = paymentMonthDate.get(Calendar.YEAR);
		if ( payingMonth == Calendar.JANUARY ) {
			this.stipendYear = payingYear - 1;
			this.stipendMonth = Calendar.DECEMBER;
		} else {
			this.stipendYear = payingYear;
			this.stipendMonth = payingMonth -1;
		}
	}
	
	public int getPaymentMonth() {
		return stipendMonth;
	}
	
	public String getPaymentMonthStr( ){
		return com.liferay.portal.kernel.util.CalendarUtil.getMonths(Locale.US)[stipendMonth];
	}
	
	public int getPaymentYear() {
		return stipendYear;
	}
	
	public Date getPaymentMonthDate(  ){
		return paymentDate.getTime();
	}
	
	public Date getPaymentDate( ){
		return paymentDate.getTime();
	}
	
	@Override
	public String getProratedDate() {
		return null;
	}
	
	//Junit tested
	@Override
	public int getRetroactiveMonths( ){
		int totalMonths = -2;//to account for full month and partial month.
		Calendar rollingFirstDay = Calendar.getInstance();
		rollingFirstDay.setTime( config.getStipendStartDate() );
		int i = 0;
		for (  ; rollingFirstDay.getTime().before( getPaymentMonthDate(  ) ); totalMonths++ ) {
			if ( i > 120 ) {
				System.err.println("Invalid Stipend-Start-Date..");
				break;
			}
			if ( rollingFirstDay.get(Calendar.MONTH ) == Calendar.DECEMBER ){
				rollingFirstDay.roll( Calendar.YEAR, true );
				rollingFirstDay.roll( Calendar.MONTH, true );
			} else {
				rollingFirstDay.roll( Calendar.MONTH, true );
			}
			i++;
		}
		return Math.max( totalMonths > 120? 0: totalMonths, 0 ) ;
	}

	@Override
	public BigDecimal getMonthlyRecurringAmount() {
		return getMonthlyRate();
	}
	
	public StipendConfig getStipendPaymentConfig (){
		return config;
	}

	public BigDecimal getMonthlyRate (  ) {
		if ( monthlyRate == null && config != null ) {
			if ( !Toolbox.isEmpty( config.getPayment() ) ) {
				monthlyRate = new BigDecimal( config.getPayment() );
			}
		}
		if ( monthlyRate == null ) {
			if ( StipendConfig.RECURRING.equals( config.getStipendType() ) || this instanceof FinalPayment ) {
				if ( Toolbox.isEmpty( config.getTierHours() ) ) {
					monthlyRate = BigDecimal.ZERO;
				} else {
					monthlyRate = new BigDecimal( config.getTierHours() ).multiply( new BigDecimal( config.getBlsRateHourly() ) ).setScale( 2, RoundingMode.HALF_UP );
				}
			} else {
				monthlyRate = BigDecimal.ZERO;
			}
		}
		return monthlyRate;
	}
//	
//	public BigDecimal getOldMonthlyRate ( ) {
//		if ( oldMonthlyRate == null && isMonthlyDiff() && lastRecurring != null ) {
//			if ( !Toolbox.isEmpty( lastRecurring.getPayment() ) ) {
//				oldMonthlyRate = new BigDecimal( lastRecurring.getPayment() );
//			} else {
//				oldMonthlyRate = new BigDecimal( lastRecurring.getTierHours() ).multiply( new BigDecimal( lastRecurring.getBlsRateHourly() ) ).setScale( 2, RoundingMode.HALF_UP );
//			}
//		}
//		return oldMonthlyRate;
//	}
	
	@Override
	public BigDecimal getBackPayAmount() {
		return defaultValue;
	}

	@Override
	public BigDecimal getFinalAmount() {
		return defaultValue;
	}

	@Override
	public BigDecimal getRecoupmentAmount() {
		return defaultValue;
	}

	@Override
	public BigDecimal getProratedAmount() {
		return defaultValue;
	}
	
	@Override
	public BigDecimal getHourlyRate() {
		return Toolbox.isEmpty( config.getBlsRateHourly() )?  BigDecimal.ZERO: new BigDecimal( config.getBlsRateHourly() );
	}

	@Override
	public BigDecimal getDailyRate(){
		if ( dailyRate == null ){
			dailyRate = config.getDailyRate();
		}
		return dailyRate;
	}
	
	public BigDecimal getDailyRateDiff(){
		return getDailyRate();
	}
	
//	public BigDecimal getOldDailyRate( ) {
//		if ( oldDailyRate == null && isDailyDiff() && lastRecurring != null && !Toolbox.isEmpty( lastRecurring.getPayment() ) ){
//			oldDailyRate = lastRecurring.getDailyRate();
//		}
//		if ( oldDailyRate == null ) {
//			return defaultValue;
//		}
//		return oldDailyRate;
//	}
	
	
	
	private boolean isDailyDiff() {
		return this.isProrateFormula();
	}

	public boolean isCalculationWork(){
		return true;
	}
	
	public boolean isCalculationChange(){
		return false;
	}
	
	public boolean isBackPayImpl(){
		return this instanceof BackPay;
	}
	
	public boolean isRecoupmentImpl(){
		return this instanceof Recoupment;
	}
	
	public boolean isRecoupable(){
		return isRecoupmentImpl(); // && ((Recoupment)this).isRecoupmentDetected();
	}
	
	public boolean isBackPayable(){
		return isBackPayImpl(); // && ((BackPay)this).isBackPayDetected();
	}
	
	public String formatDate( Date date ){
		return Toolbox.formatDate(date);
	}

	//Application Date - End Date of Current Payment Month = Total Days
	public int getTotalDays( ) {
		return 0;
	}

	@Override
	public BigDecimal getOneTimePayment() {
		return defaultValue;
	}

	@Override
	public boolean isBackPayDetected() {
		return false;
	}

	@Override
	public boolean isProrateFormula() {
		return true;
	}
	
	@Override
	public boolean isMonthlyDiff() {
		return false;
	}
	
	public int getMonthsPaidSinceStartDate () {
		if ( monthsPaid != -1 ) {
			return monthsPaid;
		}

//		getLastRecurringPayment();
		if ( monthsPaid == 0 ) {
			return 0;
		}
		monthsPaid = 0;
		if ( lastRecurringPayment != null ) {
			Calendar lastPayCal = Calendar.getInstance();
			lastPayCal.setTime( lastRecurringPayment );
			//loop until the start date is after last payment
			for ( ; config.getStipendStartDate().after( lastPayCal.getTime() ) ;) {
				if ( Calendar.DECEMBER == lastPayCal.get( Calendar.MONTH ) ){
					lastPayCal.roll( Calendar.YEAR, true);
				}
				lastPayCal.roll(Calendar.MONTH, true);
				monthsPaid++;
			}
		}
		return monthsPaid;
	}

//	@Override
//	public StiPt getLastRecurring() {
//		// TODO Auto-generated method stub
//		return null;
//	}
//	
//	public int getMonthsHeld() {
//		if ( this.lastRecurring != null ) {
//			Date lastRecurringSubmit = this.lastRecurring.getPaymentSubmit();
//			if ( lastRecurringSubmit != null ) {
//				Calendar lastPay = Calendar.getInstance();
//				lastPay.setTime( lastRecurringSubmit );
//				if ( lastPay.after( paymentDate ) ) {
//					return 0;
//				}
//				int held = -2;
//				while ( lastPay.before( this.paymentDate ) ) {
//					held++;
//					lastPay.add(Calendar.MONTH, 1);
//				}
//				return held;
//			}
//		}
//		
//		return 0;
//	}
	
//	public BigDecimal getHeldAmount() {
//		int monthsHeld = getMonthsHeld();
//		if ( monthsHeld > 0 ) {
//			return new BigDecimal(lastRecurring.getPayment()).multiply(new BigDecimal(monthsHeld) ).setScale(2, RoundingMode.HALF_UP );
//		}
//		return defaultValue;
//	}
	
//	public int getMonthsUnpaidSinceStartDate () {
//		if ( monthsUnpaid != -1 ) {
//			return monthsUnpaid;
//		}
//		getLastRecurringPayment(); //to be called before setting monthsPaid 
//		monthsUnpaid = 0;
//		if ( lastRecurringPayment != null && lastRecurringPayment.before( config.getStipendStartDate() ) ) {
//			Calendar lastPayCal = Calendar.getInstance();
//			lastPayCal.setTime( lastRecurringPayment );
//			//loop until the start date is after last payment
//			for ( ; config.getStipendStartDate().after( lastPayCal.getTime() ) ;) {
//				if ( Calendar.DECEMBER == lastPayCal.get( Calendar.MONTH ) ){
//					lastPayCal.roll( Calendar.YEAR, true);
//				}
//				lastPayCal.roll(Calendar.MONTH, true);
//				monthsUnpaid++;
//			}
//		} else if ( lastRecurringPayment == null ) { //no successful payments made as of yet
//			Calendar daysCal = Calendar.getInstance();
//			try {
//				daysCal.setTime( VcgAnLocalServiceUtil.getVcgAn( workItem.getClassPk() ).getReceivedDate() );
//				daysCal =  StipendConfig.getPayday( StipendConfig.getPayday(daysCal) ); //first cycle is not a full month
//				for ( ; config.getStipendStartDate().after( daysCal.getTime() ); monthsUnpaid++ ) { //if ( lastRecurring.getEndDate().after() )//
//					if ( daysCal.get(Calendar.MONTH ) == Calendar.DECEMBER ){
//						daysCal.roll( Calendar.YEAR, true );
//						daysCal.roll( Calendar.MONTH, true );
//					} else {
//						daysCal.roll( Calendar.MONTH, true );
//					}
//				}
//			} catch (PortalException | SystemException e) {
//				e.printStackTrace();
//			}
//		}
//		
//		return monthsUnpaid;
//	}
	/*
	public Date getLastRecurringPayment() {
		if ( lastRecurringPayment == null && monthsPaid != 0 && lastRecurring != null ) {
			List<PayLg> payments;
			try {
				payments = PayLgLocalServiceUtil.findBySuccessReason( lastRecurring.getVendrId() );
				if ( payments.isEmpty() ) {
					monthsPaid = 0;
					return null;
				}
				for ( PayLg payment: payments ) {
					List<LumCg> lumCgs = LumCgLocalServiceUtil.findByVendrCycle( lastRecurring.getVendrId(), payment.getCycleId() );
					for ( LumCg lumps : lumCgs ) {
						StiPt sti = StiPtLocalServiceUtil.getStiPt( lumps.getStiPtId() );
						if ( sti.getVcgId() != config.getVcgId() ) continue;  //paid for other Veteran...
						if ( StipendConfig.RECURRING.equals( sti.getStipendType() ) ) {
							lastRecurringPayment = new PaymentLog(payment).getEndDate();// would be the end of cycle ... example 7/31
							break;
						}
					}
					if ( lastRecurringPayment != null ) break;
				}
			} catch (SystemException e) {
				e.printStackTrace();
			} catch (PortalException e) {
				e.printStackTrace();
			}
		}
		return lastRecurringPayment;
	}

	public StipendConfig getLastRecurring() {
		return lastRecurring;
	}
	*/
}

