package gov.va.caret.model.support.occ;

import java.util.Calendar;
import java.util.List;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.BlsRe;
import gov.va.caret.model.Persn;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.impl.StiPtImpl;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.util.Toolbox;

public class AnnualRateIncrease {
	
	private static Log _log = LogFactoryUtil.getLog( AnnualRateIncrease.class);
	
	int targetYear;
	
	public AnnualRateIncrease( int targetYear ) {
		this.targetYear = targetYear;
	}

	public void performAnnualRateIncrease(ServiceContext sc) throws PortalException, SystemException {
		_log.info( "performAnnualRateIncrease" + sc.getCreateDate() );

		int year = Calendar.getInstance().get(Calendar.YEAR);
		
		String paymentMethod = targetYear + "_ANNUAL_INCREASE_REVIEWED";
		
		String[] stipendStatus = new String[] { StipendConfig.PAYMENT_FINANCE, StipendConfig.ON_HOLD }; 
		
		for ( int count = 100; count > 0; count = VendrLocalServiceUtil.countByNotPaymentMethod( paymentMethod ) ) {
			for ( Vendr vendr: VendrLocalServiceUtil.findByNotPaymentMethod( paymentMethod, 0, Math.min(count, 100) ) ) {
			
				List<StiPt> stiPts = StiPtLocalServiceUtil.findByRecurrentVendor(vendr.getVendrId(), stipendStatus);
				if ( stiPts.size() == 0 ) {
					continue;
				} else if ( stiPts.size() > 1 ) {
					_log.error("multiple Recurring configs found for Vendor " + vendr.getVendrId() );
					_log.error("will upgrade first config " + stiPts.get(0).getStiPtId() );
				}
				
				Vcg vcg = VcgLocalServiceUtil.getVcg( stiPts.get(0).getVcgId() );
				Persn persn = PersnLocalServiceUtil.getPersn( vcg.getVeteranId() );
				BlsRe newBlsRate = BlsReLocalServiceUtil.findByMoreYear( persn.getZip(), targetYear-1 );
				
				boolean rateIncreaseNeeded = false;

				if ( newBlsRate== null ) {
					_log.info("no new rate found for zip " + persn.getZip() );
				} else if ( newBlsRate.getH75() > Double.valueOf( stiPts.get(0).getBlsRateHourly() ) ) {
					rateIncreaseNeeded = true;
				}
				
				if ( rateIncreaseNeeded ) {
					StiPt stiPt = stiPts.get(0);
					
					String nextStatus;
					if ( year < targetYear ) {
						nextStatus = StipendConfig.FINANCE_STAGED;
					} else {
						nextStatus = stiPt.getStipendStatus();
						if ( stiPt.getPayslipDate() == null && StipendConfig.ON_HOLD.equals( vendr.getStatus() ) ) {
							//re-calculate final payment if was on hold
//							stiPt.setOneTimePayment( recalculatedValue );
						}
						stiPt.setStipendType( StipendConfig.ONE_TIME );
					}
					
					CaretLocalServiceUtil.save( stiPt );

					StiPt stiPtNew = new StiPtImpl();
					stiPtNew.setBlsRateHourly( Double.toString( newBlsRate.getH75() ) );

					stiPtNew.setStipendType( StipendConfig.RECURRING );
					stiPtNew.setStipendStartDate( Toolbox.parseDate( "01/01/" + targetYear ) );
					stiPtNew.setStipendStatus( nextStatus );
					
					stiPtNew.setCycleId( stiPt.getCycleId() );
					stiPtNew.setICN( stiPt.getICN() );
					String monthly = String.valueOf(  StipendConfig.getMonthlyRate( newBlsRate.getH75(), Integer.valueOf( stiPt.getTier() ) ) );
					stiPtNew.setOneTimePayment( monthly );
					stiPtNew.setPayment( monthly );
					stiPtNew.setStipendApprovedDate( stiPt.getStipendApprovedDate() );
					stiPtNew.setTier( stiPt.getTier() );
					stiPtNew.setTierHours( stiPt.getTierHours() );
					stiPtNew.setVcgId( stiPt.getVcgId() );
					stiPtNew.setVendrId( stiPt.getVendrId() );
					stiPtNew.setWorImId( stiPt.getWorImId() );
					
					CaretLocalServiceUtil.save( stiPtNew );
				}
				vendr.setPaymentMethod( paymentMethod );
				CaretLocalServiceUtil.save( vendr );
				
			}
		}
	}
	
}
