package gov.va.caret.model.support.occ;

import java.util.Calendar;
import java.util.Map;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vendr;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;


public class AddressChangeMessageListener implements MessageListener {

	private static Log _log = LogFactoryUtil.getLog( AddressChangeMessageListener.class );


	@Override
	public void receive(Message message) throws MessageListenerException {
		
		_log.info("Start Activating the Address-change payment schedules...");
		
		boolean runAnnualRateIncrease = false;
		ServiceContext sc = new ServiceContext();
		Calendar calendar = Calendar.getInstance();
		
		try {
			sc.setUserId( UserLocalServiceUtil.getDefaultUserId( PortalUtil.getDefaultCompanyId() ) );
			sc.setCompanyId( PortalUtil.getDefaultCompanyId() );
			sc.setAddGuestPermissions(false);
			
			runAnnualRateIncrease = calendar.get( Calendar.MONTH ) == Calendar.JANUARY;
			calendar.set(Calendar.DAY_OF_MONTH, 2);
			for ( StiPt addressChange : StiPtLocalServiceUtil.findAllByRecurringBefore(new String[] {StipendConfig.FINANCE_STAGED}, calendar.getTime()) ) {
				
				Vendr vendr = VendrLocalServiceUtil.fetchVendr( addressChange.getVendrId() );
				
				for (StiPt obsolete : StiPtLocalServiceUtil.findByRecurrentVendor( vendr.getVendrId(), new String[] {StipendConfig.PAYMENT_FINANCE, StipendConfig.ON_HOLD} ) ) {
					obsolete.setStipendType( StipendConfig.ONE_TIME );
					CaretLocalServiceUtil.save( obsolete );
				}
				
				if ( StipendConfig.ON_HOLD.equals( vendr.getStatus() ) ) {
					addressChange.setStipendStatus( StipendConfig.ON_HOLD );
				} else {
					addressChange.setStipendStatus( StipendConfig.PAYMENT_FINANCE );
				}
				CaretLocalServiceUtil.save(addressChange);
				
			}
			
		} catch (ApplicationWorkFlowException e) {
			_log.error("Exception Thrown:", e);
			throw new MessageListenerException(e);
		} catch (SystemException e) {
			_log.error("Exception Thrown:", e);
			throw new MessageListenerException(e);
		} catch (PortalException e) {
			_log.error("Exception Thrown:", e);
			throw new MessageListenerException(e);
		}
		_log.info("Finished Activate the Address payment schedules...");

		if ( runAnnualRateIncrease ) {
			try {
				new AnnualRateIncrease( calendar.get( Calendar.YEAR ) ). performAnnualRateIncrease(sc);
			} catch (PortalException | SystemException e) {
				e.printStackTrace();
			}
		}
		
		Map<String, Object> values = message.getValues();
		if ( values != null && !values.isEmpty() ) {
			for ( String value: values.keySet() ) {
				_log.info("value:"+ value + ":" + values.get(value) );
			}
		}
		
	}
	
	
}

