package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.support.AuditLogSupport;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.Toolbox;


public class AddressChange extends MultiFacetedConfig implements CalculationChange, PersonChange, BackPay, Recoupment {

//	private StipendConfig oldConfig;
//	private BigDecimal oldDailyRate = null;			//( ( [Tier Level Monthly Hours] * [Local Hourly Wage] ) * 12) / 365
	private BigDecimal totalStipend;  				//[Monthly Amount] + [Prorated Amount] + [Back Pay] OCC Super must review if > 35k
	private List<AuditLogSupport> retList;
	private String who;
	private String when;
	
	public AddressChange(WorIm workItem, StiPt config, StiPt lastRecurring, Calendar paymentMonthDate ) throws ApplicationWorkFlowException {
		super(workItem, config, paymentMonthDate);
//		this.lastRecurring = new StipendConfig( lastRecurring );
		if ( Toolbox.isEmpty( config.getPayment() ) ) {
			config.setPayment( getMonthlyRate().toPlainString() );
		}
	}
	
	public AddressChange(WorIm workItem, StiPt config, Calendar paymentMonthDate ) throws ApplicationWorkFlowException {
		super(workItem, config, paymentMonthDate);
//		this.lastRecurring = new StipendConfig( this.config.resolveFinanceStaged(false) );
		if ( Toolbox.isEmpty( config.getPayment() ) ) {
			config.setPayment( getMonthlyRate().toPlainString() );
		}
	}
	
	public BigDecimal getTotalStipend(){
//		if ( totalStipend == null ){
//			totalStipend = getMonthlyRate().subtract( getOldMonthlyRate() );
//		}
		return totalStipend;
	}
	
	
	public BigDecimal getRecoupmentAmount(){
		if ( isRecoupmentDetected() ) {
			return getBackPayAmount();
		}
		return defaultValue;
	}
	
	public int getRetroactiveMonths( ){
//		getMonthsPaidSinceStartDate ();
//		return getMonthsHeld();
		return 0;
	}
	
	public BigDecimal getBackPayAmount(){
		return new BigDecimal( getRetroactiveMonths() ).multiply( getMonthlyRate() ).setScale( 2, RoundingMode.HALF_UP );
	}
	
	public int getTotalDays(  ) {
		return 0;
//		Calendar calendar = Calendar.getInstance();
//		calendar.setTime( config.getStipendStartDate() );
//		return calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH) + 1;
	}
//	
//	public BigDecimal getOldMonthlyRate (  ) {
//		return new BigDecimal( lastRecurring.getPayment() );
//	}
//	
////	@Override
//	public BigDecimal getOldHourlyRate() {
//		return new BigDecimal( lastRecurring.getBlsRateHourly() );
//	}
//	
	@Override
	public boolean isMonthlyDiff() {
		return false;
	}
	
	public BigDecimal getMonthlyRateDiff(){
		return getMonthlyRate(); 
	}
	
	@Override
	public boolean isProrateFormula() {
		return false;
	}
	
	public boolean isCalculationChange(){
		return true;
	}

//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig oldConfig = new StipendConfig( 2, 11.92, format.parse("10/15/2016") );
//		StipendConfig config = new StipendConfig( 2, 18.11, format.parse("02/05/2017") );		
//		_log.info( new AddressChange( config, oldConfig, Calendar.MARCH, 2017 ) );
//	}
	
	public String toString () {
		return   "    Stipend Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n   Address Change Start: " + formatDate( config.getStipendStartDate() ) +
//				"\n Current Monthly Amount: " + getOldMonthlyRate() +
//				"\n Current Monthly Amount: " + getOldMonthlyRate() +
				"\n     New Monthly Amount: " + getMonthlyRate(  ) +

//				"\n  Current Daily Rate of: " + getOldDailyRate() +
//				"\n  Current Daily Rate of: " + getLastRecurring() +
				"\n      New Daily Rate of: " + getDailyRate() +
//				"\n             Pay Change: " + getMonthlyRate().subtract(getOldMonthlyRate()) + 
				"\n      Recoupment Amount: " + getRecoupmentAmount()  +
				"\n      Total Payment Due: " + getTotalStipend(  )  +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate(); 
//				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}

	@Override
	public List<AuditLogSupport> getChanges() {
		if ( retList == null ){
			try {
				this.retList = new ArrayList<AuditLogSupport>();
				for ( AudLg lg: CaretLocalServiceUtil.getChange( workItem.getCreationDate(), new long[]{ workItem.getPersnId() }, new String[] {"address", "zip", "city", "state", "country"} ) ){
					retList.add(new AuditLogSupport(lg));
				}
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		return retList;
	}

	public String getWho() {
		if ( who == null ){
			if ( retList == null ){
				getChanges();
			}
			if ( retList.isEmpty() ){
				who = StringPool.BLANK;
			} else {
				who = retList.get(0).getModifiedBy();
			}
		}
		return who;
	}

	public String getWhen() {
		if ( when == null ){
			if ( retList == null ){
				getChanges();
			}
			if ( retList.isEmpty() ){
				when = StringPool.BLANK;
			} else {
				when = retList.get(0).getModificationDate();
			}
		}
		return when;
	}

	@Override
	public boolean isRecoupmentDetected() {
//		if ( getMonthsHeld() > 0 && this.paymentDate.getTime().after( config.getStipendStartDate() ) && Double.valueOf( config.getBlsRateHourly() ) < Double.valueOf( lastRecurring.getBlsRateHourly() ) ){
//			return true;
//		}
		return false;
	}
	
	public BigDecimal getHeldAmount() {
//		int monthsHeld = getMonthsHeld();
//		if ( monthsHeld > 0 ) {
//			return getMonthlyRate().multiply( new BigDecimal(monthsHeld) ).setScale(2, RoundingMode.HALF_UP );
//		}
		return defaultValue;
	}

	@Override
	public BigDecimal getFinalAmount() {
		if ( isBackPayDetected() ) {
			return getMonthlyRate ().add( getBackPayAmount() ).add( getHeldAmount() );
		} else {
			return getMonthlyRate ( ).add( getHeldAmount() );
		}
	}
	

	@Override
	public boolean isBackPayDetected() {
//		if ( lastRecurring == null || lastRecurring.getWrappedModel() == null ) {
//			_log.error("Validation Error recurring status required for Address Change");
//			_log.error("VALIDATE:" + lastRecurring);
//		}
//		if ( this.paymentDate.getTime().after( config.getStipendStartDate() ) && Double.valueOf( config.getBlsRateHourly() ) > Double.valueOf( lastRecurring.getBlsRateHourly() ) ){
//			return true;
//		}
		return false;
	}

//	@Override
//	public String getBackPayView() {
//		return "getBackPayView";
//	}
	
	private static Log _log = LogFactoryUtil.getLog( AddressChange.class );

//	@Override
//	public BigDecimal getMonthlyBackPayAmount() {
//		return new BigDecimal ( getRetroactiveMonths() ).multiply( getMonthlyRate() ).setScale(2, RoundingMode.HALF_UP );
//	}

	@Override
	public BigDecimal getProratedAmount(int ndx) {
		return BigDecimal.ZERO;
	}

	@Override
	public BigDecimal getMonthlyRateDiff(int ndx) {
		return getMonthlyRateDiff();
	}

	@Override
	public BigDecimal getOneTimePayment(int ndx) {
		return getFinalAmount();
	}

}

