package gov.va.caret.model.support;

import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.VcgImpl;
import gov.va.caret.service.BgAsnLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;

public class Veteran extends Person {
	private static final long serialVersionUID = 1L;

	public static final int VCG_SLOT = 0;
	public static final int VETERAN_SLOT = 1;
	public static final int PRIMARY_SLOT = 2;
	public static final int SECONDARY_SLOT = 3;
	public static final int SECONDARY_TWO_SLOT = 4;
	
	public final static String VA_HEALTH_ENROLLED_ATTRIBUTE = "vaHealthEnrolled";
	public final static String ENROLLED_VA_HEALTH = "enrolled-in-va-health";
	private boolean enrolledInVa = false;
	private BgAsn enrollmentInVa = null;
	
	private static Log _log = LogFactoryUtil.getLog( Veteran.class );
	public static final String APPLICATION_VIEW = "/jsp/online/vetApplyNow.jsp";
	
	private String[] slotStatus = new String[]{"0", String.valueOf( getPersnId() ), "0","0","0"};
	
	Primary primary = null;
	Secondary secondary = null;
	SecondaryTwo secondaryTwo = null;
	
	VcgSupport vcgSupport = null;
	
	public Veteran(Persn person) {
		super( person instanceof Person? ((Person)person).getWrappedModel() : person );
		loadEnrollment();
	}
	
	public Role getRole(){
		return Person.Role.VETERAN;
	}
	
	private BgAsn loadEnrollment() {
		try {
			if ( getPersnId() > 0 ){
				if ( enrollmentInVa == null ){
					List<BoxGp> enrollmentList = CaretUtil.loadBoxGroup(Veteran.class.getName(), ENROLLED_VA_HEALTH);
					for ( BoxGp boxGp: enrollmentList ){
						if ( CaretStrPool.YES.equals( boxGp.getLabel() ) ){
							enrollmentInVa = BoxGpLocalServiceUtil.getBoxGroupAssociation( getPersnId(), boxGp.getBoxGpId() );
							if ( enrollmentInVa == null ){
								enrollmentInVa = new BgAsnImpl();
								enrollmentInVa.setBoxGpId( boxGp.getBoxGpId() );
								enrollmentInVa.setOwnerId( getPersnId() );
							}break;
						}
					}
				}
				if ( enrollmentInVa != null ){
					enrolledInVa = enrollmentInVa.getSelected();
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return enrollmentInVa;
	}

	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		modelAttributes.put( VA_HEALTH_ENROLLED_ATTRIBUTE, loadEnrollment() != null? enrollmentInVa.getSelected() : enrolledInVa );
		return modelAttributes;
	}
	
	public Map<String, Object> getPdfAttributes(Map<String, Object> extra) {
		Map<String, Object> modelAttributes = super.getPdfAttributes(extra);
		modelAttributes.put( "enrolledYes", loadEnrollment() != null? enrollmentInVa.getSelected() : enrolledInVa );
		modelAttributes.put( "enrolledNo", loadEnrollment() != null? !enrollmentInVa.getSelected() : !enrolledInVa );
		return modelAttributes;
	}
	
	public void setModelAttributes( Map<String, Object> modelAttributes ) {
		super.setModelAttributes(modelAttributes);

		Object vaHealthEnrolled = modelAttributes.get( VA_HEALTH_ENROLLED_ATTRIBUTE );
		if ( vaHealthEnrolled != null && vaHealthEnrolled instanceof Boolean ){
			setVaHealthEnrolled( (Boolean) vaHealthEnrolled );
		} else {
			_log.warn("Could not set VA Health Enrollment");
		}
	}
	
	public String getIcn(){
		if ( !Toolbox.isEmpty( getICN() ) ){
			return getICN();
		}
		return super.getIcn();
	}
	
	public void persist () throws SystemException{
		super.persist();
		boolean temp = enrolledInVa;
		if ( loadEnrollment() != null ){
			enrollmentInVa.setSelected(temp);
			BgAsnLocalServiceUtil.updateBgAsn(enrollmentInVa);
		}
	}
	
	public String getVaHealthEnrolledStr (){
		return Boolean.TRUE == getVaHealthEnrolled ()? CaretStrPool.YES : CaretStrPool.NO;
	}
	
	public void setVaHealthEnrolled(boolean vaHealthEnrolled) {
		if ( loadEnrollment() != null ){
			enrollmentInVa.setSelected(vaHealthEnrolled);
		}
		enrolledInVa = vaHealthEnrolled;
	}
	
	public boolean isVaHealthEnrolled(){
		return getVaHealthEnrolled();
	}
	public boolean getVaHealthEnrolled(){
		if ( loadEnrollment() != null ){
			return enrollmentInVa.isSelected();
		}
		return enrolledInVa;
	}
	
	private VcgSupport getVcgSupport() {
		if (  vcgSupport == null  ){
			vcgSupport = VcgSupport.getVeteranVcg( getPersnId() );
		}
		return vcgSupport;
	}
	
	public boolean isPrimaryAvailable(){
		if ( primary != null && primary.getPersnId() > 0 ){
			return false;
		}
			
		if ( CaretStrPool.ACTIVE_VCG.equals( getStatus() ) ){
			slotStatus[VCG_SLOT] = String.valueOf( getVcgSupport().getVcgId() );
			if ( getVcgSupport().getPrimaryDispReason() != null && VcgSupport.isActive( getVcgSupport().getPrimaryDispReason() ) ){
				_log.info("****VCG with primary active****");
				if ( primary == null ) try {
					primary = new Primary( PersnLocalServiceUtil.getPersn( getVcgSupport().getPrimaryId() ) );
					slotStatus[PRIMARY_SLOT] = String.valueOf( getVcgSupport().getPrimaryId() );
					return false;
				} catch (PortalException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		try {
			for ( Persn v: getPersnSet() ){
				if ( v.getPersnId() == 0 ) continue;
				for ( VcgAn vcgAn : VcgAnLocalServiceUtil.getByPersn( v.getPersnId() ) ) {
					VcgApplication app = new VcgApplication( vcgAn );
					if ( app.getPrimaryId() > 0 ){
						if ( ApplicationStatus.NEED_SIGNATURE.name().equals( app.getStatus() ) || ApplicationStatus.SUBMITTED.name().equals( app.getStatus() ) ){
							_log.info("****Online app with primary Selected****");
							if ( primary == null ) try {
								primary = new Primary( PersnLocalServiceUtil.getPersn( app.getPrimaryId() ) );
								slotStatus[PRIMARY_SLOT] = "0" + app.getPrimaryId();
								return false;
							} catch (PortalException e) {
								ApplicationWorkFlowException.handleException(e);
							} catch (SystemException e) {
								ApplicationWorkFlowException.handleException(e);
							}
						}
					}
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		slotStatus[PRIMARY_SLOT] = "0";
		return true;
	}

	public boolean isSecondaryAvailable(){
		if ( secondary != null && secondary.getPersnId() > 0 ){
			return false;
		}
		if ( CaretStrPool.ACTIVE_VCG.equals( getStatus() ) ){
			slotStatus[VCG_SLOT] = String.valueOf( getVcgSupport().getVcgId() );
			if ( getVcgSupport().getSecondaryDispReason() != null && VcgSupport.isActive( getVcgSupport().getSecondaryDispReason() ) ){
				_log.info("****VCG with Secondary active****");
				if ( secondary == null ) try {
					secondary = new Secondary( PersnLocalServiceUtil.getPersn( getVcgSupport().getSecondaryId() ) );
					slotStatus[SECONDARY_SLOT] = String.valueOf( getVcgSupport().getSecondaryId() );
					return false;
				} catch (PortalException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		try {
			for ( Persn v: getPersnSet() ){
				if ( v.getPersnId() == 0 ) continue;
			for ( VcgAn vcgAn : VcgAnLocalServiceUtil.getByPersn(  v.getPersnId() ) ) {
				VcgApplication app = new VcgApplication( vcgAn );
				if ( app.getSecondaryId() > 0  ){
					if ( ApplicationStatus.NEED_SIGNATURE.name().equals( app.getStatus() ) || ApplicationStatus.SUBMITTED.name().equals( app.getStatus() ) ){
						_log.info("****Online app with Secondary Selected****");
						if ( secondary == null ) try {
							secondary = new Secondary( PersnLocalServiceUtil.getPersn( app.getSecondaryId() ) );
							slotStatus[SECONDARY_SLOT] = "0" + app.getSecondaryId();
							return false;
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					}
				}
			}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		slotStatus[SECONDARY_SLOT] = "0";
		return true;
	}
	
	public boolean isSecondaryTwoAvailable(){
		if ( secondaryTwo != null && secondaryTwo.getPersnId() > 0 ){
			return false;
		}
		if ( CaretStrPool.ACTIVE_VCG.equals( getStatus() ) ){
			slotStatus[VCG_SLOT] = String.valueOf( getVcgSupport().getVcgId() );
			if ( getVcgSupport().getSecondaryTwoDispReason() != null && VcgSupport.isActive( getVcgSupport().getSecondaryTwoDispReason() ) ){
				_log.info("****VCG with SecondaryTwo active****");
				if ( secondaryTwo == null ) try {
					secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( getVcgSupport().getSecondaryTwoId() ) );
					slotStatus[SECONDARY_TWO_SLOT] = String.valueOf( getVcgSupport().getSecondaryTwoId() );
					return false;
				} catch (PortalException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		try {
			for ( Persn v: getPersnSet() ){
				if ( v.getPersnId() == 0 ) continue;
			for ( VcgAn vcgAn : VcgAnLocalServiceUtil.getByPersn( v.getPersnId() ) ) {
				VcgApplication app = new VcgApplication( vcgAn );
				if ( app.getSecondaryTwoId() > 0  ){
					if ( ApplicationStatus.NEED_SIGNATURE.name().equals( app.getStatus() ) || ApplicationStatus.SUBMITTED.name().equals( app.getStatus() ) ){
						_log.info("****Online app with SecondaryTwo Selected****");
						if ( secondaryTwo == null ) try {
							secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( app.getSecondaryTwoId() ) );
							slotStatus[SECONDARY_TWO_SLOT] = "0" + app.getSecondaryTwoId();
							return false;
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					}
				}
			}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		slotStatus[SECONDARY_TWO_SLOT] = "0";
		return true;
	}
	
	public long getPrimaryId(){
		if ( primary == null ){
			isPrimaryAvailable();
		}
		if ( primary != null  ){
			return primary.getPersnId();
		}
		return 0;
	}
	
	public long getSecondaryId(){
		if ( secondary == null ){
			isSecondaryAvailable();
		}
		if ( secondary != null ){
			return secondary.getPersnId();
		}
		return 0;
	}
	
	public long getSecondaryTwoId(){
		if ( secondaryTwo == null ){
			isSecondaryTwoAvailable();
		}
		if ( secondaryTwo != null ){
			return secondaryTwo.getPersnId();
		}
		return 0;
	}
	
	public Primary getPrimary(){
		return primary;
	}
	
	public Secondary getSecondary(){
		return secondary;
	}
	
	public SecondaryTwo getSecondaryTwo(){
		return secondaryTwo;
	}
	
	public boolean isFamily(){
		return false;
	}

	public String[] getActives() {
		isPrimaryAvailable();
		isSecondaryAvailable();
		isSecondaryTwoAvailable();
		return slotStatus;
	}

	public Long[] getVcgActives() {
		VcgSupport vcg = getVcgSupport();
		if ( vcg == null ) vcg = new VcgSupport ( new VcgImpl() );
		return ArrayUtil.toArray( vcg.getActiveVcgIdsArray( getPersnId() ) );
	}
	
	public String getOnlineView(){ return APPLICATION_VIEW; }
}
