package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Crypto;
import gov.va.caret.model.Persn;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.VendrWrapper;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.CryptoImpl;
import gov.va.caret.model.impl.VendrImpl;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CryptoLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;


public class Vendor extends VendrWrapper implements AddressPerson {
	
	private static final long serialVersionUID = -8375561258486068131L;
	public static final Vendor DEFAULT_PERSON = new Vendor( new VendrImpl() );
	public static final String TAXID = "TAXID";
	public static final String WEEK = "week-";
	public static final String MONTH = "month-";
	public static final String DAY = "day-";
	
	
	private Crypto _crypto = null;
	private String _taxId = StringPool.BLANK;
	private Primary caregiver = null;
	Boolean validUspsAddress = null;
	Boolean changed = false;
	private Map<Long,StiPt> recurringMap;
	
	public Vendor(Vendr vendr) {
		super(vendr);
	}

	public Vendor( Vendr vendr, Persn caregiver ) {
		super(vendr);
		this.caregiver = new Primary (caregiver);
		super.setPersnId( caregiver.getPersnId() );
	}

	private Crypto loadCrypto() {
		try {
			if ( getVendrId() > 0 ){
				if ( _crypto == null ){
					_crypto = CryptoLocalServiceUtil.getCrypto( getVendrId(), TAXID );
				}
				if ( _crypto == null ){
					_crypto = new CryptoImpl();
					_crypto.setType( TAXID );
					_crypto.setOwnerId( getVendrId() );
				} else {
					_taxId = _crypto.getCryptoValue();
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return _crypto;
	}
	
	public void setTaxId ( String metadata ){
		if ( Person.SSN_FORMAT.equals(metadata) ){
			metadata = StringPool.BLANK;
		}
		if ( loadCrypto() != null ){
//			encrypt:
//			c.setCryptoValue( com.liferay.portal.kernel.util.Base64.fromURLSafe( metadata ) );
			if ( !metadata.equals( _crypto.getCryptoValue() ) ){
				changed = true;
				_crypto.setCryptoValue(metadata);
			}
		}
		_taxId = metadata;
	}
	
	public String getTaxId(){
		if ( loadCrypto() != null ){
//			decript:
//			return com.liferay.portal.kernel.util.Base64.toURLSafe( c.getCryptoValue() );
			return _crypto.getCryptoValue();
		}
		if ( Toolbox.isEmpty(_taxId) && caregiver != null ){
			setTaxId( caregiver.getSsn() );
		}
		return _taxId;
	}
	
	public java.lang.String getICN() {
		
		if ( Toolbox.isEmpty( super.getICN() ) && caregiver != null ){
			super.setICN( caregiver.getICN() );
		}
		return super.getICN();
        
	}
	
    public void setLastName( String string ) {
    	if ( !string.equals( super.getLastName() ) ){
    		changed = true;
			super.setLastName( string );
		}
    }
    
    public void setFirstName( String string ) {
    	if ( !string.equals( super.getFirstName() ) ){
			changed = true;
			super.setFirstName( string );
		}
    }
    
    public void setAddress( String string ) {
    	if ( !string.equals( super.getAddress() ) ){
			changed = true;
			super.setAddress( string );
		}
    }
    
    public void setCity( String string ) {
    	if ( !string.equals( super.getCity() ) ){
			changed = true;
			super.setCity( string );
		}
    }
    
    public void setState( String string ) {
    	if ( !string.equals( super.getState() ) ){
			changed = true;
			super.setState( string );
		}
    }
    
    public void setCountry( String string ) {
    	if ( !string.equals( super.getCountry() ) ){
			changed = true;
			super.setCountry( string );
		}
    }
    
    public void setZip( String string ) {
    	if ( !string.equals( super.getZip() ) ){
			changed = true;
			super.setZip( string );
		}
    }
	
	public void setICN( String string ) {
		if ( !string.equals( super.getICN() ) ){
			changed = true;
			super.setICN( string );
		}
	}
	
    public java.lang.String getLastName() {
    	if ( Toolbox.isEmpty( super.getLastName() ) && caregiver != null ){
			setLastName( caregiver.getLastName() );
		}
        return super.getLastName();
    }
    
    public java.lang.String getFirstName() {
    	if ( Toolbox.isEmpty( super.getFirstName() ) && caregiver != null ){
			setFirstName( caregiver.getFirstName() );
		}
        return super.getFirstName();
    }
    
    public java.lang.String getVendorName() {
    	if ( Toolbox.isEmpty( super.getFirstName() ) && caregiver != null ){
			setFirstName( caregiver.getFirstName() );
		}
        return getLastName() + StringPool.COMMA_AND_SPACE + getFirstName();
    }
    
    public java.lang.String getAddress() {
    	if ( Toolbox.isEmpty( super.getAddress() ) && caregiver != null ){
			setAddress( caregiver.getAddress() );
		}
        return super.getAddress();
    }
    
    public java.lang.String getCity() {
    	if ( Toolbox.isEmpty( super.getCity() ) && caregiver != null ){
			setCity( caregiver.getCity() );
		}
        return super.getCity();
    }
    
    public java.lang.String getState() {
    	if ( Toolbox.isEmpty( super.getState() ) && caregiver != null ){
			setState( caregiver.getState() );
		}
        return super.getState();
    }
    
    public java.lang.String getCountry() {
    	if ( Toolbox.isEmpty( super.getCountry() ) && caregiver != null ){
			setCountry( caregiver.getCountry() );
		}
        return super.getCountry();
    }
    
    public java.lang.String getZip() {
    	if ( Toolbox.isEmpty( super.getZip() ) && caregiver != null ){
			setZip( caregiver.getZip() );
		}
        return super.getZip();
    }
	
	
	public boolean isValidUspsAddress(){
		if ( validUspsAddress == null ){
			if ( !Toolbox.isEmpty(getAddress()) && !Toolbox.isEmpty(getCity()) && !Toolbox.isEmpty(getState()) && !Toolbox.isEmpty(getZip()) && !"0".equals(getZip() )  ){
				_log.info("making USPS call with " + getAddress() + " " +  getCity() + " " +  getState() + " " + getZip() );
				validUspsAddress = CaretUtil.isValidateUspsAddress( getAddress(), getCity(), getState(), getZip(), getAddress2() );
			}
		}
		if ( validUspsAddress == null ){
			validUspsAddress = false;
		}
		return validUspsAddress;
	}
	
	public boolean isFinancing() throws ApplicationWorkFlowException {
		return StiPtLocalServiceUtil.findByRecurring( getVendrId(), new String[] { StipendConfig.PAYMENT_FINANCE } ).isEmpty() ;
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		modelAttributes.put( TAXID, loadCrypto() != null? _crypto.getCryptoValue() : _taxId );
		return modelAttributes;
	}
	
	public void setModelAttributes( Map<String, Object> map ) {
		if ( map.containsKey( TAXID ) ){
			setTaxId( Toolbox.formatSsn( map.get(TAXID).toString() ) );
		}
		super.setModelAttributes(map);
	}
	
	public void persist () throws SystemException{
		super.persist();
		if ( loadCrypto() != null ){
			_crypto.setCryptoValue( _taxId );
			if ( ! Toolbox.isEmpty( _crypto.getCryptoValue() ) ){
				CryptoLocalServiceUtil.updateCrypto(_crypto);
			}
		}
		if ( Toolbox.isEmpty( _crypto.getCryptoValue() ) ){
			throw new com.liferay.portal.kernel.exception.SystemException("TAX ID cannot be empty");
		}
		if ( Toolbox.isEmpty( getFirstName() ) ){
			throw new com.liferay.portal.kernel.exception.SystemException("First name cannot be empty");
		}
		if ( Toolbox.isEmpty( getLastName() ) ){
			throw new com.liferay.portal.kernel.exception.SystemException("Last name cannot be empty");
		}
	}

	public WorkType getWorkType() {
//		if ( Toolbox.isEmpty( getDirectDepositInfo() ) || Toolbox.isEmpty( getPaymentMethod() ) ){
//			if ( getVendrId() == 0 ){
//				return WorkType.VENDOR_CREATE_HOLD;
//			}
//			return WorkType.VENDOR_UPDATE_HOLD;
//		}
		if ( getVendrId() == 0 ){
			return WorkType.VENDOR_CREATE;
		}
		if ( changed ){
			return WorkType.VENDOR_UPDATE;
		}
		return null;
	}

	public static BoxGp getRecurringBoxGp( Calendar calendar, boolean create ) throws ApplicationWorkFlowException, SystemException {
		return getPaymentBg( StipendConfig.RECURRING, MONTH + calendar.get( Calendar.MONTH ), calendar.get( Calendar.YEAR ), create );
	}
	
	public static BoxGp getRecurringBoxGp( Calendar calendar ) throws ApplicationWorkFlowException, SystemException {
		return getPaymentBg( StipendConfig.RECURRING, MONTH + calendar.get( Calendar.MONTH ), calendar.get( Calendar.YEAR ) );
	}
	
	public static BoxGp getOneTimeBg( Calendar calendar, boolean create ) throws ApplicationWorkFlowException, SystemException {
		return getPaymentBg( StipendConfig.ONE_TIME, WEEK + calendar.get(Calendar.WEEK_OF_YEAR), calendar.get(Calendar.YEAR), create );
	}
	
	public static BoxGp getOneTimeBg( Calendar calendar ) throws ApplicationWorkFlowException, SystemException {
		return getPaymentBg( StipendConfig.ONE_TIME, WEEK + calendar.get(Calendar.WEEK_OF_YEAR), calendar.get(Calendar.YEAR) );
	}
	
	public static BoxGp getOneTimeDailyBg( Calendar calendar ) throws ApplicationWorkFlowException, SystemException {
		return getPaymentBg( StipendConfig.ONE_TIME, DAY + calendar.get(Calendar.DAY_OF_YEAR), calendar.get(Calendar.YEAR) );
	}
	
	public static Calendar getMaxWeekBgIds( Calendar calendar, String[] reply ) {
		try {
			for ( int i = 0 ; i < 3; i++) {
				int ownerWeek = calendar.get( Calendar.WEEK_OF_YEAR ) + calendar.get( Calendar.YEAR )* 52;
				BoxGp boxGp = getOneTimeBg( calendar );
				BgLae bgLae = BgLaeLocalServiceUtil.getBgLaeAssociation( ownerWeek, boxGp.getBoxGpId() );
				if ( bgLae == null ) {
					calendar.roll(Calendar.WEEK_OF_YEAR, false);
					reply[0] = "0";
					continue;
				}
				reply[0] = String.valueOf( bgLae.getBgLaeId() );
			}
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
			reply[0] = "0";
		} catch (SystemException e) {
			e.printStackTrace();
			reply[0] = "0";
		}
		return calendar;
	}
	
	public static BgLae getMaxMonthBoxGpId( Calendar calendar, String[] reply )  {
		
		BgLae bgLae = null;
		try {
			for ( int i = 0 ; i < 3; i++) {
				int ownerMonth = calendar.get(Calendar.MONTH) + calendar.get( Calendar.YEAR )* 12;
				BoxGp boxGp = Vendor.getRecurringBoxGp(calendar);
				bgLae = BgLaeLocalServiceUtil.getBgLaeAssociation( ownerMonth , boxGp.getBoxGpId() );
				if ( bgLae == null ) {
					calendar.roll(Calendar.MONTH, false);
					if ( calendar.get(Calendar.MONTH) == Calendar.DECEMBER ) {
						calendar.roll(Calendar.YEAR, false);
					}
					reply[0] = "0";
					continue;
				}
				reply[0] = String.valueOf( bgLae.getBgLaeId() );
				break;
			}
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
			reply[0] = "0";
		} catch (SystemException e) {
			e.printStackTrace();
			reply[0] = "0";
		}
		return bgLae;
	}
	
	public static List<BoxGp> getWeekBoxGroups ( Calendar calendar) throws ApplicationWorkFlowException {
		return BoxGpLocalServiceUtil.getBoxGroups( StipendConfig.ONE_TIME, WEEK + calendar.get( Calendar.WEEK_OF_YEAR ) + "/" + calendar.get(Calendar.YEAR));
	}
	
	public static BoxGp getPaymentBg ( String type, String schedule, int year ) throws ApplicationWorkFlowException, SystemException {
		return getPaymentBg ( type, schedule, year, true );
	}
	public static BoxGp getPaymentBg ( String type, String schedule, int year, boolean create ) throws ApplicationWorkFlowException, SystemException {
		String subGroup = schedule+ "/" + year;
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups( type, subGroup );
		if ( !groups.isEmpty() ) {
			return groups.get(0);
		}
		if ( !create ) 
			return null;
		groups = new ArrayList<BoxGp>();
		BoxGp grp = new BoxGpImpl();
		grp.setBoxGroup( type );
		grp.setBoxSubGroup( subGroup );
		grp.setLabel( type );
		grp.setViewSequence( year );
		return BoxGpLocalServiceUtil.addBoxGp(grp);
	}


	private static Log _log = LogFactoryUtil.getLog( Vendor.class );

	public static BgLae getPaymentStep( com.liferay.portal.service.ServiceContext sc ) throws ApplicationWorkFlowException, SystemException {
		Calendar cal = Calendar.getInstance();
		
		int day = cal.get(Calendar.DAY_OF_MONTH);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.DAY_OF_MONTH, false);
		
		int end = cal.get(Calendar.DAY_OF_MONTH);
		
		for ( int d = day; d< end; d++) {
			cal.set( Calendar.DAY_OF_MONTH, d );
			if ( cal.get (Calendar.DAY_OF_WEEK ) == Calendar.THURSDAY ) {
				return initWeek( cal, sc);
			}
		}
		
		return initMonth( cal );
	}
	
	public static BgLae initWeek ( Calendar cal, ServiceContext sc) throws ApplicationWorkFlowException, SystemException {
		int ownerWeek = cal.get( Calendar.WEEK_OF_YEAR ) + cal.get( Calendar.YEAR )* 52;
		BoxGp boxGp = getOneTimeBg( cal, true );
		BgLae bgLae = BgLaeLocalServiceUtil.getBgLaeAssociation( ownerWeek, boxGp.getBoxGpId() );
		if ( bgLae == null ) {
			bgLae = new BgLaeImpl();
			bgLae.setOwnerId( ownerWeek );
			bgLae.setBoxGpId( boxGp.getBoxGpId() );
			bgLae.setLargeText( "PENDING-REQUESTED-" + Toolbox.formatDate( sc.getCreateDate() ) );
			BgLaeLocalServiceUtil.addBgLae( bgLae);
			_log.info("created :" + bgLae );
		}
		return bgLae;
	}

	public static BgLae initMonth( Calendar cal ) throws ApplicationWorkFlowException, SystemException {
		return initMonth(cal, true);
	}
	
	public static BgLae initMonth( Calendar cal, boolean roll ) throws ApplicationWorkFlowException, SystemException {
		if ( roll ) {
			if ( Calendar.DECEMBER == cal.get(Calendar.MONTH ) ) {
				cal.set(Calendar.MONTH, Calendar.JANUARY);
				cal.roll(Calendar.YEAR, true);
			} else {
				cal.roll(Calendar.MONTH, true);
			}
		}
		BoxGp boxGp = getRecurringBoxGp( cal );
		int ownerMonth = cal.get( Calendar.MONTH ) + cal.get( Calendar.YEAR )* 12;
		BgLae bgLae = BgLaeLocalServiceUtil.getBgLaeAssociation( ownerMonth, boxGp.getBoxGpId() );
		if ( bgLae == null ) {
			try {
				bgLae = new BgLaeImpl();
				bgLae.setOwnerId( ownerMonth );
				bgLae.setBoxGpId( boxGp.getBoxGpId() );
				cal.set(Calendar.DAY_OF_MONTH, 1);
				bgLae.setLargeText( "PENDING-AUTOMATIC-" + Toolbox.formatDate( cal.getTime() ) );
				BgLaeLocalServiceUtil.addBgLae( bgLae);
				_log.info("created :" + bgLae );
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		return bgLae;
	}

}
