package gov.va.caret.model.support;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.controller.dashboard.config.FacilityDashboardConfig;
import gov.va.caret.model.Apeal;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Note;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.Persn;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.VcgWrapper;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.Waivr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.VcgImpl;
import gov.va.caret.model.support.Person.Role;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.pdf.FileType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.ApealLocalServiceUtil;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.BgAsnLocalServiceUtil;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.PayLgLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.WaivrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;

import java.util.LinkedHashMap;

public class VcgSupport extends VcgWrapper {
	
	public enum WaiverCode {
		NOT_APPLICABLE, NOT_NEEDED, CSC_NEEDED, VISN_NEEDED, VISN_REVIEW_NEEDED, VISN_REVIEW_EXPIRED, DENIED, APPROVED
	}
	
	Veteran veteran = null;
	Person primary = null;
	Person secondary = null;
	Person secondaryTwo = null;
	Person general = null;
	Person context = Person.DEFAULT_PERSON;
	String veteranName = null;
	String primaryName = null;
	String secondaryName = null;
	String secondaryTwoName = null;
	String generalName = null;
	VcgApplication[] vcgApplication = new VcgApplication[3];
	private Map<String,BgLae> customAttributes = new HashMap<String,BgLae>();
	private Map<Person.Role,List<String>> dispChoices = new CaretMap<Person.Role,List<String>>(Collections.EMPTY_LIST);

	private WaiverCode[] waiverState = new WaiverCode[3];
	
	private static Log _log = LogFactoryUtil.getLog( VcgSupport.class );
	private Map<String,Note> notes = new HashMap<String,Note>();
	
	public List<DocumentSupport> vcgDocsCurrent = new ArrayList<DocumentSupport>();
	//public List<DocumentSupport> cgDocsCurrent = new ArrayList<DocumentSupport>();
	//public List<DocumentSupport> poaDocsCurrent = new ArrayList<DocumentSupport>();
	public List<DocumentSupport> vcgDocsAll = new ArrayList<DocumentSupport>();
	//public List<DocumentSupport> cgDocsAll = new ArrayList<DocumentSupport>();
	//public List<DocumentSupport> poaDocsAll = new ArrayList<DocumentSupport>();

	private BigDecimal DEFAULT_RATE = new gov.va.caret.util.CBigDecimal("1.00");
	private BlsRe blsRe = null;
	
	final static String APPEALED_IN_TIER = "appeal-in-tier";
	public final static String TIER_APPEAL_ATTRIBUTE = "tierAppealed";
	private boolean appealedInTr = false;
	private BgAsn appealmentInTr = null;
	Boolean isTierAppealed = null;
	boolean apealmentInTrChanged = false;
	String apealmentState = StringPool.BLANK;
	boolean viewMember = true;
	private String facilityNumber = null;
	
	public List<DocumentSupport> getVcgDocsCurrent() {
		return vcgDocsCurrent;
	}

	public void setVcgDocsCurrent(List<DocumentSupport> vcgDocsCurrent) {
		this.vcgDocsCurrent = vcgDocsCurrent;
	}

	public List<DocumentSupport> getVcgDocsAll() {
		return vcgDocsAll;
	}

	public void setVcgDocsAll(List<DocumentSupport> vcgDocsAll) {
		this.vcgDocsAll = vcgDocsAll;
	}

	private static final long serialVersionUID = 1L;
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public static VcgSupport getVeteranVcg ( long veteranId ) {
		VcgSupport support = null;
		try {
			Vcg v = VcgLocalServiceUtil.getVeteranVcg( veteranId );
			if ( v == null ){
				support = new VcgSupport( new VcgImpl() );
				support.setVeteranId( veteranId );
			} else {
				return new VcgSupport(v);
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return support;
	}
	
	public static VcgSupport getVcgSupport ( long vcgId ) {
		if ( vcgId == 0 ) return null;
		VcgSupport support = null;
		try {
			Vcg v = VcgLocalServiceUtil.getVcg( vcgId );
			if ( v == null ){
				support = new VcgSupport( new VcgImpl() );
			} else {
				return new VcgSupport(v);
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return support;
	}

	public VcgSupport(gov.va.caret.model.Vcg vcg) {
		super(vcg);
		loadTrAppealment();
	}

	public VcgSupport getThis(){
		return this;
	}
	
	public String getVeteranName() {
		if ( veteranName == null ){
			this.veteranName = getFullName( getVeteranId() );
		}
		return veteranName;
	}

	public String getPrimaryName() {
		if ( primaryName == null ){
			this.primaryName = getFullName( getPrimaryId() );
		}
		return primaryName;
	}

	public String getSecondaryName() {
		if ( secondaryName == null ){
			this.secondaryName = getFullName( getSecondaryId() );
		}
		return secondaryName;
	}

	public String getSecondaryTwoName() {
		if ( secondaryTwoName == null ){
			this.secondaryTwoName = getFullName( getSecondaryTwoId() );
		}
		return secondaryTwoName;
	}
	
	public String getGeneralName() {
		if ( generalName == null ){
			this.generalName = getFullName( getGeneralId() );
		}
		return generalName;
	}
	
	public String getFullName ( long persnId ){
		if ( persnId > 0 ){
			return CaretUtil.getPersnFullName ( persnId );
		}
		return StringPool.BLANK;
	}
	
	public String getTierEffectiveDateStr() {
		return Toolbox.formatDateCprs( getTierEffectiveDate() );
	}
	
	public void setTierEffectiveDateStr( String dateStr ) {
		try {
			setTierEffectiveDate( (Date) Toolbox.getDateFormatCprs().parseObject(dateStr) );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	private Persn getPerson ( long persnId ){
		try {
			return PersnLocalServiceUtil.getPersn( persnId );
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public Veteran getVeteran(){
		if ( getVeteranId() > 0 ){
			if ( veteran == null ){
				veteran = new Veteran( getPerson( getVeteranId() ) );
			} 
		}
		return veteran;
	}
	
	public Person getPrimary(){
		if ( getPrimaryId() > 0 ){
			if ( primary == null ){
				primary = new Primary( getPerson( getPrimaryId() ) );
			} 
		}
		return primary;
	}
	
	public Person getSecondary(){
		if ( getSecondaryId() > 0 ){
			if ( secondary == null ){
				secondary = new Secondary( getPerson ( getSecondaryId() ) );
			}
		}
		return secondary;
	}
	
	public Person getSecondaryTwo(){
		if ( getSecondaryTwoId() > 0 ){
			if ( secondaryTwo == null ){
				secondaryTwo = new SecondaryTwo( getPerson(getSecondaryTwoId()) );
			}
		}
		return secondaryTwo;
	}
	
	public Person getGeneral(){
		if ( getGeneralId() > 0 ){
			if ( general == null ){
				general = new General ( getPerson( getGeneralId() ) );
			}
		}
		return general;
	}
	
	public boolean isGeneralAssignable (){
		if ( getGeneral() == null ){
			return true;
		}
		if ( this.isGeneralApproved() || isInProcess( getGeneralDispReason() )  ){
			return false;
		}
		return true;
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		if ( getPrimaryDispositionDate() != null ) {
			modelAttributes.put("primaryDispositionDate", Toolbox.getDateFormatCprs().format( getPrimaryDispositionDate() ) );
		}
		if ( getSecondaryDispositionDate() != null ) {
			modelAttributes.put("secondaryDispositionDate", Toolbox.getDateFormatCprs().format( getSecondaryDispositionDate() ) );
		}
		if ( getSecondaryTwoDispositionDate() != null ) {
			modelAttributes.put("secondaryTwoDispositionDate", Toolbox.getDateFormatCprs().format( getSecondaryTwoDispositionDate() ) );
		}
		if ( getGeneralDispositionDate() != null ) {
			modelAttributes.put("generalDispositionDate", Toolbox.getDateFormatCprs().format( getGeneralDispositionDate() ) );
		}
		
		if ( getPrimaryInitDispDate() != null ) {
			modelAttributes.put("primaryInitDispDate", Toolbox.getDateFormatCprs().format( getPrimaryInitDispDate() ) );
		}
		if ( getSecondaryInitDispDate() != null ) {
			modelAttributes.put("secondaryInitDispDate", Toolbox.getDateFormatCprs().format( getSecondaryInitDispDate() ) );
		}
		if ( getSecondaryTwoInitDispDate() != null ) {
			modelAttributes.put("secondaryTwoInitDispDate", Toolbox.getDateFormatCprs().format( getSecondaryTwoInitDispDate() ) );
		}
		if ( getGeneralInitDispDate() != null ) {
			modelAttributes.put("generalInitDispDate", Toolbox.getDateFormatCprs().format( getGeneralInitDispDate() ) );
		}
		
		if ( getTierEffectiveDate() != null ) {
			modelAttributes.put("tierEffectiveDate", Toolbox.getDateFormatCprs().format( getTierEffectiveDate() ) );
		}
		if ( getPrimaryRevocationDate() != null ) {
			modelAttributes.put("primaryRevocationDate", Toolbox.getDateFormatCprs().format( getPrimaryRevocationDate() ) );
		}
		if ( getSecondaryRevocationDate() != null ) {
			modelAttributes.put("secondaryRevocationDate", Toolbox.getDateFormatCprs().format( getSecondaryRevocationDate() ) );
		}
		if ( getSecondaryTwoRevocationDate() != null ) {
			modelAttributes.put("secondaryTwoRevocationDate", Toolbox.getDateFormatCprs().format( getSecondaryTwoRevocationDate() ) );
		}
		if ( getGeneralRevocationDate() != null ) {
			modelAttributes.put("generalRevocationDate", Toolbox.getDateFormatCprs().format( getGeneralRevocationDate() ) );
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			if ( note == null ) continue;
			String text = note.getValue();
			modelAttributes.put( attribute, text.substring(0, Math.min(text.length(), 75)) );
		}
		if ( loadTrAppealment() != null ){
			if ( apealmentInTrChanged ){
				modelAttributes.put( TIER_APPEAL_ATTRIBUTE, apealmentState );
			} else {
				try {
					List<AudLg> list = CaretLocalServiceUtil.findByClassPk( getVcgId(), TIER_APPEAL_ATTRIBUTE);
					if ( !list.isEmpty() ){
						modelAttributes.put( TIER_APPEAL_ATTRIBUTE, list.get(0).getNewValue() );
					}
				} catch (ApplicationWorkFlowException e) {
					e.printStackTrace();
				}
			}
		}
		
		return modelAttributes;
	}
	
	
	private VcgApplication getVcgAn ( long vcgAnId ){
		if ( vcgAnId > 0 )
		try {
			return new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( vcgAnId ) );
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public VcgApplication getPersonVcgAn(Person.Role caregiverRole) {
		if ( Person.Role.PRIMARY == caregiverRole ){
			return getPrimaryVcgAn();
		} else if ( caregiverRole == Person.Role.SECONDARY ) {
			return getSecondaryVcgAn();
		} else if ( caregiverRole == Person.Role.SECONDARYTWO ) {
			return getSecondaryTwoVcgAn();
		}
		return null;
	}
	
	public VcgApplication getPersonVcgAn(long persnId) {
		if ( persnId == getPrimaryId() ){
			return getPrimaryVcgAn();
		}
		if ( persnId == getSecondaryId() ){
			return getSecondaryVcgAn();
		}
		if ( persnId == getSecondaryTwoId() ){
			return getSecondaryTwoVcgAn();
		}
		return null;
	}
	
	public Person getPersonRole(long persnId) {
		if ( persnId == getVeteranId() ){
			return getVeteran();
		}
		if ( persnId == getPrimaryId() ){
			return getPrimary();
		}
		if ( persnId == getSecondaryId() ){
			return getSecondary();
		}
		if ( persnId == getSecondaryTwoId() ){
			return getSecondaryTwo();
		}
		if ( persnId == getGeneralId() ){
			return getGeneral();
		}
		return null;
	}
	
	public String caregiverDispReason( Person.Role role ){
		if ( role == Person.Role.PRIMARY ){
			return getPrimaryDispReason();
		}
		if ( role == Person.Role.SECONDARY ){
			return getSecondaryDispReason();
		}
		if ( role == Person.Role.SECONDARYTWO ){
			return getSecondaryTwoDispReason();
		}
		if ( role == Person.Role.GENERAL ){
			return getGeneralDispReason();
		}
		return StringPool.BLANK;
	}
	
	public boolean caregiverAssessmentComplete( Person.Role role ){
		if ( role == Person.Role.PRIMARY ){
			return primaryAssmtComplete(getVcgId(), getPrimaryId() );
		}
		if ( role == Person.Role.SECONDARY ){
			return secondaryAssmtComplete(getVcgId(), getSecondaryId());
		}
		if ( role == Person.Role.SECONDARYTWO ){
			return secondaryTwoAssmtComplete(getVcgId(), getSecondaryTwoId() );
		}
		return false;
	}
	
	public VcgApplication getPrimaryVcgAn(){
		if ( vcgApplication[0] == null ){
			vcgApplication[0] = getVcgAn( getPrimaryVcgAnId() );
		}
		return vcgApplication[0];
	}
	
	public VcgApplication getSecondaryVcgAn(){
		if ( vcgApplication[1] == null ){
			vcgApplication[1] = getVcgAn( getSecondaryVcgAnId() );
		}
		return vcgApplication[1];
	}
	
	public VcgApplication getSecondaryTwoVcgAn(){
		if ( vcgApplication[2] == null ){
			vcgApplication[2] = getVcgAn( getSecondaryTwoVcgAnId() );
		}
		return vcgApplication[2];
	}
	
	public boolean isWaiverPrimary(){
		if ( getPrimaryVcgAn() != null ){
			return WorkType.CSC_WAIVER.getDueDate( vcgApplication[0].getApplicationDate() ).compareTo( new Date() ) < 0;
		}
		return false;
	}
	
	public boolean isWaiverSecondary(){
		if ( getSecondaryVcgAn() != null ){
			return WorkType.CSC_WAIVER.getDueDate( vcgApplication[1].getApplicationDate() ).compareTo( new Date() ) < 0;
		}
		return false;
	}
	
	public boolean isWaiverSecondaryTwo(){
		if ( getSecondaryTwoVcgAn() != null ){
			return WorkType.CSC_WAIVER.getDueDate( vcgApplication[2].getApplicationDate() ).compareTo( new Date() ) < 0;
		}
		return false;
	}
	
	public String getPrimaryWaiverCode() throws ApplicationWorkFlowException{
		if ( getPrimaryInitDispDate() != null ){
			waiverState[0] = WaiverCode.NOT_APPLICABLE; 
		}
		return getWaiverCode(0).name();
	}
	
	public String getSecondaryWaiverCode() throws ApplicationWorkFlowException{
		if ( getSecondaryInitDispDate() != null ){
			waiverState[1] = WaiverCode.NOT_APPLICABLE; 
		}
		return getWaiverCode(1).name();
	}
	
	public String getSecondaryTwoWaiverCode() throws ApplicationWorkFlowException{
		if ( getSecondaryTwoInitDispDate() != null ){
			waiverState[2] = WaiverCode.NOT_APPLICABLE;
		}
		return getWaiverCode(2).name();
	}
	
	public boolean getVisnNeeded() throws ApplicationWorkFlowException{
		WaiverCode waiverCode = getWaiverCode(context.getRole().getId()-2);
		return WaiverCode.VISN_NEEDED == waiverCode || WaiverCode.VISN_REVIEW_EXPIRED == waiverCode;
	}
	
	public boolean getCscNeeded() throws ApplicationWorkFlowException{
		WaiverCode waiverCode = getWaiverCode(context.getRole().getId()-2);
		return WaiverCode.CSC_NEEDED == waiverCode;
	}
	
	
	public WaiverCode getWaiverCode(int ndx) throws ApplicationWorkFlowException{
		if ( waiverState[ndx] != null ){
			return waiverState[ndx];
		}
		_log.info("loading waiver state " + ndx);
		if ( vcgApplication[ndx] == null ){
			vcgApplication[ndx] = getVcgAnNdx( ndx );
		}
		if ( vcgApplication[ndx] == null ){
			return waiverState[ndx] = WaiverCode.NOT_APPLICABLE; 
		}
		Date now = new Date();
		if ( WorkType.APP_DELAY.getDueDate( vcgApplication[ndx].getApplicationDate() ).compareTo( now ) < 0 ){

			Waivr waivr = WaivrLocalServiceUtil.getByOwner( vcgApplication[ndx].getVcgAnId(), getPersonId( Person.Role.getRole(ndx+2) ) );
			
			if ( waivr != null ){
				if ( waivr.getCompletionDate() == null ){
					return waiverState[ndx] = WaiverCode.VISN_REVIEW_NEEDED;
				} else if ( WorkType.DELAY_REVIEWED.getDueDate( waivr.getCompletionDate() ).compareTo( now ) < 0 ){
					return waiverState[ndx] = WaiverCode.VISN_REVIEW_EXPIRED; //same UI as WaiverCode.VISN_NEEDED
				} else {
					if ( CaretStrPool.DENIED.equals( waivr.getAdjudication() ) ){
						return waiverState[ndx] = WaiverCode.DENIED;
					} 
					if ( CaretStrPool.COMPLETE.equals( waivr.getAdjudication() ) ){
						return waiverState[ndx] = WaiverCode.APPROVED;
					}
					return waiverState[ndx] = WaiverCode.NOT_NEEDED; 
				}
			}  else {
				return waiverState[ndx] = WaiverCode.VISN_NEEDED;
			}
			
			
//			if ( appDelayWork[ndx] == null && WorImLocalServiceUtil.countByCgWork(getVcgId(), getCaregiverId(ndx), WorkType.APP_DELAY.name()) > 0 ){
//				appDelayWork[ndx] = WorImLocalServiceUtil.findByCgWorkLast(getVcgId(), getCaregiverId(ndx), WorkType.APP_DELAY.name());
//			}
//			if ( appDelayWork[ndx] == null ){
//				return waiverState[ndx] = WaiverCode.VISN_NEEDED;
//			} else {
//				if ( WorImLocalServiceUtil.countByCgWork(getVcgId(), getCaregiverId(ndx), WorkType.DELAY_REVIEWED.name()) > 0 ){
//					delayReviewedWork[ndx] = WorImLocalServiceUtil.findByCgWorkLast(getVcgId(), getCaregiverId(ndx), WorkType.DELAY_REVIEWED.name());
//				}
//				if ( delayReviewedWork[ndx] == null || appDelayWork[ndx].getDueDate().after(now) ){
//					return waiverState[ndx] = WaiverCode.VISN_REVIEW_NEEDED;
//				} else {
//					if ( delayReviewedWork[ndx].getDueDate().before(now) ) {
//						return waiverState[ndx] = WaiverCode.VISN_REVIEW_EXPIRED;
//					} 
//					Waivr waivr = WaivrLocalServiceUtil.getByWorkId(appDelayWork[ndx].getWorImId());
//					if ( waivr != null ){
//						if ( CaretStrPool.DENIED.equals( waivr.getAdjudication() ) ){
//							return waiverState[ndx] = WaiverCode.DENIED;
//						} 
//						if ( CaretStrPool.COMPLETE.equals( waivr.getAdjudication() ) ){
//							return waiverState[ndx] = WaiverCode.APPROVED;
//						}
//					} 
//					return waiverState[ndx] = WaiverCode.NOT_NEEDED;
//				}
//			}
		} else if ( WorkType.CSC_WAIVER.getDueDate( vcgApplication[ndx].getApplicationDate() ).compareTo( now ) < 0 ) {
			return waiverState[ndx] = WaiverCode.CSC_NEEDED;
		} else {
			return waiverState[ndx] = WaiverCode.NOT_NEEDED;
		}
	}
	
	private VcgApplication getVcgAnNdx(int ndx) {
		switch (ndx){
		case 0: return getVcgAn(getPrimaryVcgAnId());
		case 1: return getVcgAn(getSecondaryVcgAnId());
		case 2: return getVcgAn(getSecondaryTwoVcgAnId());
		}
		return null;
	}

	private long getCaregiverId( int ndx ){
		switch (ndx){
		case 0: return getPrimaryId();
		case 1: return getSecondaryId();
		case 2: return getSecondaryTwoId();
		case 3: return getGeneralId();
		}
		return 0;
	}

	public WorIm getWaiverPrimaryWork () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getPrimaryId(), WorkType.APP_DELAY.name() );
		if ( worIm != null ){
			return worIm;
		}
		 
		return null;
	}
	
	public String getWaiverPrimaryWorkExpires () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getPrimaryId(), WorkType.DELAY_REVIEWED.name() );
		if ( worIm != null ){
			return Toolbox.formatDateCprs( worIm.getDueDate() );
		}
		 
		return null;
	}
	public WorIm getWaiverSecondaryWork () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getSecondaryId(), WorkType.APP_DELAY.name() );
		if ( worIm != null && worIm.getDueDate().after( Toolbox.adjustDate( 1.0, new Date(), false ) ) ){
			return worIm;
		}
		 
		return null;
	}
	
	public String getWaiverSecondaryWorkExpires () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getSecondaryId(), WorkType.DELAY_REVIEWED.name() );
		if ( worIm != null ){
			return Toolbox.formatDateCprs( worIm.getDueDate() );
		}
		 
		return null;
	}
	public WorIm getWaiverSecondaryTwoWork () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getSecondaryTwoId(), WorkType.APP_DELAY.name() );
		if ( worIm != null && worIm.getDueDate().after( Toolbox.adjustDate( 1.0, new Date(), false ) ) ){
			return worIm;
		}
		 
		return null;
	}
	
	public String getWaiverSecondaryTwoWorkExpires () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getSecondaryTwoId(), WorkType.DELAY_REVIEWED.name() );
		if ( worIm != null ){
			return Toolbox.formatDateCprs( worIm.getDueDate() );
		}
		
		return null;
	}
	
	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		if ( getVeteranId() == 0 ){
			throw new com.liferay.portal.kernel.exception.SystemException("Veteran ID cannot be 0");
		}
		Vcg vcgX = null;
		try {//Additional validation to block VCG duplicates for Veteran.
			if ( Toolbox.isEmpty( getVeteran().getICN() ) ) {
				_log.error("ICN is blank... likely a non-IAM env.");
			} 
			if ( this.getVcgId() == 0 ) {
				if ( (vcgX = VcgLocalServiceUtil.getVeteranVcg( getVeteranId() )) != null ) {
					_log.error("Cannot create VCG for Veteran with existing VCG:" + vcgX.getVcgId());
					return;
				}
//				if ( !Toolbox.isEmpty( getVeteran().getICN() ) ) {
//					for ( Persn persn : PersnLocalServiceUtil.getByIcns( getVeteran().getICN() ) ) {
//						if ( (vcgX = VcgLocalServiceUtil.getVeteranVcg( persn.getPersnId() )) != null ) {
//							_log.error("Cannot create VCG for Veteran with existing VCG:" + vcgX.getVcgId());
//							return;
//						}
//					}
//				}
			}
			
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		super.persist();
		if ( saveCustomAttributes() ) {
			setLastUpdatedDate( ServiceContextThreadLocal.getServiceContext().getCreateDate() );
			setLastUpdatedUserId( ServiceContextThreadLocal.getServiceContext().getUserId() );
			super.persist();
		}
		
	}
	
	private BoxGp initCustomAttribute( String attribute ) throws ApplicationWorkFlowException{
		BoxGp custom = new BoxGpImpl();
		custom.setBoxGroup( VcgSupport.class.getName() );
		custom.setBoxSubGroup( String.valueOf( getVcgId() ) );
		custom.setLabel( attribute );  //attribute
//		custom.setViewSequence( sequence );
		try {
			return BoxGpLocalServiceUtil.addBoxGp( custom );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException ( e );
		}
	}
	private BoxGp getCustomAttribute ( String attribute, long applicationId ) throws ApplicationWorkFlowException {
		List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( VcgApplication.class.getName(), String.valueOf( getVcgId() )  );
		BoxGp custom = null;
		if ( attributes.isEmpty() ){
			custom = initCustomAttribute ( attribute );
		} else {
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){ //TODO:
					custom = bgAtt;
				}
			}
		}
		if ( custom == null ){
			custom = initCustomAttribute ( attribute );
		}
		return custom;
	}
	
	private boolean saveCustomAttributes() {
		int count = 0;
		if ( !customAttributes.isEmpty() ){
			for ( String attribute: customAttributes.keySet() ){
				BgLae value = customAttributes.get( attribute );
				try {
					CaretLocalServiceUtil.save(value);
					count = count + CaretLocalServiceUtil.getChangeCount( ServiceContextThreadLocal.getServiceContext().getCreateDate(), new long[] { value.getPrimaryKey() }, new String[] {attribute} );
				} catch (ApplicationWorkFlowException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			if ( note == null ) continue;
			if ( note.getNoteId() == 0 ) try {
				note.setChainId( getVcgId() );
				note.setVcgId( getVcgId() );
				notes.put(attribute, CaretLocalServiceUtil.addNote(note));
				count++;
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		
		if ( appealmentInTr != null ){
//			appealmentInTr.setSelected(appealedInTr);
			try {
				BgAsnLocalServiceUtil.updateBgAsn(appealmentInTr);
				_log.info("update for appealmentInTr " + appealmentInTr );
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		if ( count == 0 ) {
			String[] attributes = new String[] {"address", "zip", "city", "state", "country",
					"otherHealthInsurance","mediEnrolled","vaHealthEnrolled","otherHealthInsuranceYesNo","mediEnrolledYesNo","vaHealthEnrolledYesNo",
					"lastName", "firstName", "middleName", "gender", "birthDate", "ssn", "phone"};
			
			List<Long> ids = new ArrayList<Long>();
			ids.add(getVeteranId());
			if ( getPrimaryId() > 0 ) {
				ids.add(getPrimaryId());
			}
			if ( getSecondaryId() > 0 ) {
				ids.add(getSecondaryId());
			}
			if ( getSecondaryTwoId() > 0 ) {
				ids.add(getSecondaryTwoId());
			}
			if ( getGeneralId() > 0 ) {
				ids.add(getGeneralId());
			}
			try {
				count = CaretLocalServiceUtil.getChangeCount( 
						ServiceContextThreadLocal.getServiceContext().getCreateDate(), 
						ArrayUtil.toArray( ids.toArray( new Long[ ids.size() ]) ), attributes );
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		return count > 0;
	}
	
	public void setNote ( String attribute, String comment, long userId, Date createDate, long groupId ){
		 notes.put( attribute, CaretUtil.createNote( createDate, getVcgId(), groupId, userId, comment ) );
	}

	public void useNote( String attribute, Note note ) {
		notes.put( attribute, note );
	}
	
	public Note getNote ( String attribute ){
		if ( notes.containsKey(attribute) ){
			return notes.get(attribute); 
		}
		return null;
	}
	

	private BgLae getLeaAttr ( String attribute, long applicationId ) throws ApplicationWorkFlowException {
		BoxGp custom = getCustomAttribute ( attribute, applicationId );
		BgLae value = BgLaeLocalServiceUtil.getBgLaeAssociation( getVcgId(), custom.getBoxGpId() );
		if ( value == null ){
			value = new BgLaeImpl();
			value.setBoxGpId( custom.getBoxGpId() );
		}
		return value;
	}
	
	public void setCustomAppAttribute ( long applicationId, String largeText, String attr ) {
		try {
			BgLae customAttr = null;
			for ( String key : customAttributes.keySet() ){
				if ( key.equals(attr) ){
					customAttr = customAttributes.get(key);
				}
			}
			if ( customAttr == null ){
				customAttr = getLeaAttr ( attr, applicationId );
				customAttributes.put( attr, customAttr );
			}
			customAttr.setLargeText( largeText );
			customAttr.setOwnerId( applicationId );
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	public void setInvalidApplication ( long applicationId, String largeText ) {
		try {
			BgLae invalid = null;
			String attr = CaretStrPool.INVALID_APPLICATION + applicationId;
			for ( String key : customAttributes.keySet() ){
				if ( key.equals(attr) ){
					invalid = customAttributes.get(key);
				}
			}
			if ( invalid == null ){
				invalid = getLeaAttr ( attr, applicationId );
				customAttributes.put( attr, invalid );
			}
			invalid.setLargeText( largeText );
			invalid.setOwnerId( applicationId );
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	public void setDuplicateApplication(long applicationId, String largeText) {
		try {
			BgLae duplicate = null;
			String attr = CaretStrPool.DUPLICATE_APPLICATION + applicationId;
			for ( String key : customAttributes.keySet() ){
				if ( key.equals(attr) ){
					duplicate = customAttributes.get(key);
				}
			}
			if ( duplicate == null ){
				duplicate = getLeaAttr ( attr, applicationId );
				customAttributes.put( attr, duplicate );
			}
			duplicate.setLargeText( largeText );
			duplicate.setOwnerId( applicationId );
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	public void setTicketNumber(long applicationId, String ticketNumber) {
		setCustomAppAttribute( applicationId, ticketNumber, CaretStrPool.TICKET_NUMBER + applicationId );
	}
	
	public void setViewable ( PortletRequest request ) {
		DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
		if ( dashConfig instanceof FacilityDashboardConfig ){
			viewMember = ((FacilityDashboardConfig)dashConfig).getGroupId().contains( getGroupId() );
		} 
	}
	
	public String getFacilityNumber() {
		if ( this.facilityNumber  == null ) {
			try {
				facilityNumber = FacilLocalServiceUtil.getByOrgId(getGroupId()).getFacilityNumber();
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		return this.facilityNumber;
	}
	
	public boolean isViewMember() {
		return viewMember;
	}

	public void loadPermissionState(PortletRequest request) throws ApplicationWorkFlowException {
		if ( getPrimary() != null ){
			getPrimaryDispChoices( request );
		}
		if ( getSecondary() != null ){
			getSecondaryDispChoices( request );
		}
		if ( getSecondaryTwo() != null ){
			getSecondaryTwoDispChoices( request );
		}
		if ( getGeneral() != null ){
			getGeneralDispChoices( request );
		}
	}
	
	public List<String> getGeneralDispChoices( PortletRequest request ) throws ApplicationWorkFlowException {
		List<String> l = getNextDispStates( getGeneralDispReason(), getGeneral(), false, request );
		dispChoices.put(Role.GENERAL, l);
		return l;
	}
	
	public List<String> getPrimaryDispChoices( PortletRequest request ) throws ApplicationWorkFlowException {
		List<String> l = getNextDispStates( getPrimaryDispReason(), getPrimary(), isPrimaryAssmtComplete(), request );
		dispChoices.put(Role.PRIMARY, l);
		return l;
	}
	
	public List<String> getSecondaryDispChoices( PortletRequest request ) throws ApplicationWorkFlowException {
		List<String> l = getNextDispStates( getSecondaryDispReason(), getSecondary(), isSecondaryAssmtComplete(), request  );
		dispChoices.put(Role.SECONDARY, l);
		return l;
	}
	
	public List<String> getSecondaryTwoDispChoices( PortletRequest request ) throws ApplicationWorkFlowException {
		List<String> l = getNextDispStates( getSecondaryTwoDispReason(), getSecondaryTwo(), isSecondaryTwoAssmtComplete(), request );
		dispChoices.put(Role.SECONDARYTWO, l);
		return l;
	}
	
	public Boolean hasPrimaryDispChoices(  ) {
		return !dispChoices.get(Person.Role.PRIMARY).isEmpty();
	}
	public Boolean hasSecondaryDispChoices(  ) {
		return !dispChoices.get(Person.Role.SECONDARY).isEmpty();
	}
	public Boolean hasSecondaryTwoDispChoices(  ) {
		return !dispChoices.get(Person.Role.SECONDARYTWO).isEmpty();
	}
	public Boolean hasGeneralDispChoices(  ) {
		return !dispChoices.get(Person.Role.GENERAL).isEmpty();
	}
	
	public static String getDisposition ( String state ){
		if ( Toolbox.isEmpty( state ) ){
			return StringPool.BLANK;
		}
		if ( !CaretStrPool.IN_PROCESS.equals( state ) ){
			int end = Math.max( state.indexOf('-'), state.length() ) ;
			return state.substring(0,end-1);
		}
		return state;
	}
	
	public boolean isTierEditEnabled ( ){
		if ( getPrimary() != null ){
			String reason = getPrimaryDispReason();
			return isApproved( reason ) || isReinstated( reason ) || CaretStrPool.APPEALED_REVOCATION_PRO_VETERAN.equals( reason );
		}
		return false;
	}
	
	public boolean isApproved( String reason ){
		return reason != null && reason.equals(CaretStrPool.APPROVED);
	}
	
	public boolean isInProcess( String reason ){
		return reason != null && reason.equals(CaretStrPool.IN_PROCESS);
	}
	
	public boolean isDisapproved( String reason ){
		return reason != null && reason.startsWith(CaretStrPool.DISAPPROVED);
	}
	
	public boolean isRevoked( String reason ){
		return reason != null && reason.startsWith(CaretStrPool.REVOKED);
	}
	
	private Boolean canAppeal = null;
	public boolean canAppeal( Person person, PortletRequest request ) throws ApplicationWorkFlowException{
		if ( canAppeal != null ) return canAppeal;
		String reason = caregiverDispReason( person.getRole() );
		if ( !getNextDispStates(reason, person, caregiverAssessmentComplete( person.getRole() ), request).isEmpty() ){
			if ( isDisapproved(reason) && getAppealCount(person, new String[] {"appealed-disapproved-"}) < 2 ) {
				return true;
			}
			if ( isRevoked(reason) && getAppealCount(person, new String[] {"appealed-revoked-"}) < 2 ) {
				return true;
			}
		}
		return canAppeal = false;
	}
	
	public boolean isAppealed( Role role ){
		return isAppealed( caregiverDispReason( role ) );
	}
	
	public boolean isAppealedRevocation( Role role ){
		return isAppealedRevocation( caregiverDispReason( role ) );
	}
	
	public boolean isAppealedTier( ){
		if ( isTierAppealed != null ){
			return isTierAppealed;
		}
		Apeal appeal = ApealLocalServiceUtil.getByOwner( getVcgId(), getPrimaryId(), CaretStrPool.APPEALED_TIER );
		if ( appeal != null && !Toolbox.isEmpty( appeal.getAdjudication() ) ){
			return isTierAppealed = true;
		}
		return isTierAppealed = false;
	}
	
	public boolean isAppealedDisapproval( Role role ){
		return isAppealedDisapproval( caregiverDispReason( role ) );
	}
	
	public boolean isAppealed( String reason ){
		return reason != null && reason.startsWith(CaretStrPool.APPEALED );
	}
	
	public boolean isAppealedRevocation( String reason ){
		return reason != null && reason.startsWith(CaretStrPool.APPEALED_REVOCATION );
	}
	
	public boolean isAppealedDisapproval( String reason ){
		return reason != null && reason.startsWith(CaretStrPool.APPEALED_DISAPPROVAL );
	}
	
	public boolean isReinstated( String reason ){
		return reason != null && reason.equals(CaretStrPool.REINSTATED);
	}
	
	public boolean isNew (){
		return getVcgId() == 0;
	}
	
	public long[] getActiveVcgIdsArray ( long persnId ) {
		long[] array = new long[5];
		if ( getVcgId() > 0 ){
			array[0] = getVcgId();
			array[1] = getVeteranId();
			if ( getPrimaryId() > 0 && VcgSupport.isActive( getPrimaryDispReason() ) ){
				array[2] = getPrimaryId();
			}
			if ( getSecondaryId() > 0 && VcgSupport.isActive( getSecondaryDispReason() ) ){
				array[3] = getSecondaryId();
			}
			if ( getSecondaryTwoId() > 0 && VcgSupport.isActive( getSecondaryTwoDispReason() ) ){
				array[4] = getSecondaryTwoId();
			}
			return array;
		}
		return new long[]{ 0, persnId, 0,0,0 };
	}
	
	public static boolean isActive ( String reason ){
		return reason != null && 
			( reason.equals(CaretStrPool.REINSTATED) ||
				reason.startsWith(CaretStrPool.APPEALED) ||
				reason.equals(CaretStrPool.IN_PROCESS) ||
				reason.equals(CaretStrPool.APPROVED) );
	}

	public List<String> getNextDispStates( String state, Person person, boolean assessmentComplete, PortletRequest request ) throws ApplicationWorkFlowException {
		List<String> dispStates = new ArrayList<String>();
		if ( isInProcess( state ) ){
			if ( Person.Role.GENERAL == person.getRole() ){
				if ( isApproved( getPrimaryDispReason() ) || isReinstated( getPrimaryDispReason() ) || isAppealed( getPrimaryDispReason() ) || 
						isApproved( getSecondaryDispReason() ) || isReinstated( getSecondaryDispReason() ) || isAppealed( getSecondaryDispReason() ) ||
						isApproved( getSecondaryTwoDispReason() ) || isReinstated( getSecondaryTwoDispReason() ) || isAppealed( getSecondaryTwoDispReason() ) ){
					return Arrays.asList(new String[]{CaretStrPool.DISAPPROVED});
				} else {
					return Arrays.asList(new String[]{CaretStrPool.APPROVED, CaretStrPool.DISAPPROVED});
				}
			} else if ( Person.Role.PRIMARY == person.getRole() ){
				WaiverCode waiverState = getWaiverCode(0);
				if ( waiverState.name().startsWith("VISN") ) {
					return Collections.emptyList();
				} else if ( waiverState == WaiverCode.DENIED  
						|| !assessmentComplete || Toolbox.isEmpty( person.getSsn() ) || !hasBls() ||
						!person.isValidUspsAddress() || isGeneralApproved() || !((Primary)person).isInsuranceAnswered() ){
					return Arrays.asList(new String[]{CaretStrPool.DISAPPROVED});
				}  else {
					return Arrays.asList(new String[]{CaretStrPool.APPROVED, CaretStrPool.DISAPPROVED});
				}
			} else if ( person.getRole() == Person.Role.SECONDARY || person.getRole() == Person.Role.SECONDARYTWO ) {
				WaiverCode waiverState = getWaiverCode(person.getRole().getId()-2);
				if ( waiverState.name().startsWith("VISN") ) {
					return Collections.emptyList();
				} else if ( waiverState == WaiverCode.DENIED || !assessmentComplete || Toolbox.isEmpty( person.getSsn() ) || !person.isValidUspsAddress() 
						|| isGeneralApproved() ){
					return Arrays.asList(new String[]{CaretStrPool.DISAPPROVED});
				}  else {
					return Arrays.asList(new String[]{CaretStrPool.APPROVED, CaretStrPool.DISAPPROVED});
				}
			}
		} else if ( isApproved( state ) || isReinstated( state ) ){
			return Arrays.asList(new String[]{CaretStrPool.REVOKED});
		} else if ( isRevoked( state ) ){
			if ( Person.Role.GENERAL == person.getRole() ){
				if ( isApproved( getPrimaryDispReason() ) || isReinstated( getPrimaryDispReason() ) || isAppealed( getPrimaryDispReason() ) ){
					return Collections.emptyList();
				} else {
					if ( getAppealCount(person, new String[] {"appealed-revoked-"}) < 2 ) {
						return Arrays.asList(new String[]{CaretStrPool.REINSTATED,CaretStrPool.APPEALED_REVOCATION});
					} else {
						return Arrays.asList(new String[]{CaretStrPool.REINSTATED});
					}
				}
			} else {
				if ( assessmentComplete && person.isValidUspsAddress() && !Toolbox.isEmpty( person.getSsn() ) ){
					if ( Person.Role.PRIMARY == person.getRole() ) {
						if ( isApproved( getGeneralDispReason() ) || isReinstated ( getGeneralDispReason() ) ){
							return Collections.emptyList();
						} else if ( CAction.canDoCaret(request, CaretCan.TECH_DISPOSITION ) || getPrimaryDispReason().indexOf("revocation-veteran-request") > 0 ){
							if ( getAppealCount(person, new String[] {"appealed-revoked-"}) < 2 ) {
								return Arrays.asList(new String[]{CaretStrPool.REINSTATED,CaretStrPool.APPEALED_REVOCATION});
							} else {
								return Arrays.asList(new String[]{CaretStrPool.REINSTATED});
							}
						}
					} else if ( CAction.canDoCaret(request, CaretCan.TECH_DISPOSITION ) || getPrimaryDispReason().indexOf("revocation-veteran-request") > 0 ){
						if ( getAppealCount(person, new String[] {"appealed-revoked-"}) < 2 ) {
							return Arrays.asList(new String[]{CaretStrPool.REINSTATED,CaretStrPool.APPEALED_REVOCATION});
						} else {
							return Arrays.asList(new String[]{CaretStrPool.REINSTATED});
						}
					}
				}
				if ( getAppealCount(person, new String[] {"appealed-revoked-"}) < 2 ) {
					return Arrays.asList(new String[]{CaretStrPool.APPEALED_REVOCATION});
				}
			}
		} else if ( isAppealedRevocation( state ) ){
			if ( assessmentComplete && person.isValidUspsAddress() && !Toolbox.isEmpty( person.getSsn() ) ){
				return Arrays.asList(new String[]{CaretStrPool.APPEALED_REVOCATION_PRO_VA,CaretStrPool.APPEALED_REVOCATION_PRO_VETERAN} );
			} else {
				return Arrays.asList(new String[]{CaretStrPool.APPEALED_REVOCATION_PRO_VA});
			}
		} else if ( isAppealedDisapproval( state ) ){
			if ( person.isValidUspsAddress() && !Toolbox.isEmpty( person.getSsn() ) ){
				return Arrays.asList(new String[]{CaretStrPool.APPEALED_DISAPPROVAL_PRO_VA,CaretStrPool.APPEALED_DISAPPROVAL_PRO_VETERAN});
			} else {
				return Arrays.asList(new String[]{CaretStrPool.APPEALED_DISAPPROVAL_PRO_VA});
			}
		} else if ( isDisapproved( state ) ){
			if ( Person.Role.PRIMARY == person.getRole() ) {
				if ( isApproved( getGeneralDispReason() ) || isReinstated ( getGeneralDispReason() ) ){
					return Collections.emptyList();
				} else if (CAction.canDoCaret(request, CaretCan.TECH_DISPOSITION ) || 
						Toolbox.adjustBusinessDate( Double.valueOf( PortletProps.get("csc.undo.disapprove.days") ), getPrimaryInitDispDate(), true ).after( new Date() ) ){
					if ( getAppealCount(person, new String[] {"appealed-disapproved-"}) < 2 ) {
						return Arrays.asList(new String[]{CaretStrPool.IN_PROCESS,CaretStrPool.APPEALED_DISAPPROVAL});
					} else {
						return Arrays.asList(new String[]{CaretStrPool.IN_PROCESS});
					}
				}
			} else if ( Person.Role.SECONDARY == person.getRole() ){ 
				if ( CAction.canDoCaret(request, CaretCan.TECH_DISPOSITION ) || 
						Toolbox.adjustBusinessDate( Double.valueOf( PortletProps.get("csc.undo.disapprove.days") ), getSecondaryInitDispDate(), true ).after( new Date() ) ){
					if ( getAppealCount(person, new String[] {"appealed-disapproved-"}) < 2 ) {
						return Arrays.asList(new String[]{CaretStrPool.IN_PROCESS,CaretStrPool.APPEALED_DISAPPROVAL});
					} else {
						return Arrays.asList(new String[]{CaretStrPool.IN_PROCESS});
					}
				}
			} else if ( Person.Role.SECONDARYTWO == person.getRole() ){
				if ( CAction.canDoCaret(request, CaretCan.TECH_DISPOSITION ) ||
						Toolbox.adjustBusinessDate( Double.valueOf( PortletProps.get("csc.undo.disapprove.days") ), getSecondaryTwoInitDispDate(), true ).after( new Date() ) ){
					if ( getAppealCount(person, new String[] {"appealed-disapproved-"}) < 2 ) {
						return Arrays.asList(new String[]{CaretStrPool.IN_PROCESS,CaretStrPool.APPEALED_DISAPPROVAL});
					} else {
						return Arrays.asList(new String[]{CaretStrPool.IN_PROCESS});
					}
				} 
			} else {
				return Collections.singletonList(CaretStrPool.IN_PROCESS);
			}
			if ( getAppealCount(person, new String[] {"appealed-disapproved-"}) < 2 ) {
				return Collections.singletonList(CaretStrPool.APPEALED_DISAPPROVAL);
			}
		}
		return dispStates;
	}
	
	public int getAppealCount(Person person, String[] type) {
		if ( person.isGeneralRole() ) return 0;
		String[] reasons = new String[] {"tier", "appealed-disapproved-", "appealed-revoked-"};
		return ApealLocalServiceUtil.countByOwner2(getPersonVcgAn( person.getPersnId() ).getVcgAnId(), person.getPersnId(), type);
	}

	public boolean isPrimaryApproved(){
		return isApproved( getPrimaryDispReason() ) || isReinstated( getPrimaryDispReason() ) || CaretStrPool.APPEALED_REVOCATION_PRO_VETERAN.equals( getPrimaryDispReason() );
	}
	
	public boolean isPrimaryRevoked() {
		return isRevoked( getPrimaryDispReason() );
	}
	
	public boolean isSecondaryApproved(){
		return isApproved( getSecondaryDispReason() ) || isReinstated( getSecondaryDispReason() );
	}
	
	public boolean isSecondaryTwoApproved(){
		return isApproved( getSecondaryTwoDispReason() ) || isReinstated( getSecondaryTwoDispReason() );
	}
	
	public boolean isGeneralApproved(){
		return isApproved( getGeneralDispReason() ) || isReinstated( getGeneralDispReason() );
	}
	
	public String getIcon( String disposition ){
		String icon;
		if ( isRevoked(disposition) ){
			icon = PortletProps.get(CaretStrPool.REVOKED + "icon");
		} else if ( isDisapproved(disposition) ){
			icon = PortletProps.get(CaretStrPool.DISAPPROVED + "icon");
		} else {
			icon = PortletProps.get(disposition + "-icon");
		}
		if ( Toolbox.isEmpty(icon) ){
			icon = CaretStrPool.DEFAULT_DISPOSITION_ICON;
		}
		return icon;
	}
	
	public String getTierIcon(){
		String icon = PortletProps.get ( "tier-" + getTierLevel() + "-icon");
		if ( Toolbox.isEmpty(icon) ){
			icon = CaretStrPool.DEFAULT_TIER_ICON;
		}
		return icon;
	}
	
	public void setTierLevel ( int tierLevel ){
		if ( getTierLevel() > 0 && getTierLevel() != tierLevel ){
			setTierLevelPreviously( getTierLevel() );
		}
		super.setTierLevel(tierLevel);
	}
	
	public int getHours ( int level ){
		switch( level ){
		case (1): return Integer.getInteger( PortletProps.get( "tier1.hours"), 10 );
		case (2): return Integer.getInteger( PortletProps.get( "tier2.hours"), 25 );
		case (3): return Integer.getInteger( PortletProps.get( "tier3.hours"), 40 );
		}
		return 0;
	}
	
	public int getTierHours(){
		if ( getTierLevel() > 0 ){
			return getHours( getTierLevel() );
		}
		return 0;
	}

	public int getTierHoursPreviously(){
		if ( getTierLevel() > 0 ){
			return getHours( getTierLevelPreviously() );
		}
		return 0;
	}
	
	public int getTierLevelPreviously(){
		return super.getTierLevelPreviously();
	}
	
	
	public String getPrimaryDispIcon(){
		return getIcon ( getPrimaryDispReason() );
	}
	
	public String getSecondaryDispIcon(){
		return getIcon ( getSecondaryDispReason() );
	}
	
	public String getSecondaryTwoDispIcon(){
		return getIcon ( getSecondaryTwoDispReason() );
	}
	
	public String getGeneralDispIcon(){
		return getIcon ( getGeneralDispReason() );
	}

	public boolean isPrimaryAssmtComplete(){
		return primaryAssmtComplete(getVcgId(), getPrimaryId());
	}
	
	public boolean isSecondaryAssmtComplete(){
		return secondaryAssmtComplete(getVcgId(), getSecondaryId());
	}
	
	public boolean isSecondaryTwoAssmtComplete(){
		return secondaryTwoAssmtComplete(getVcgId(), getSecondaryTwoId());
	}
	
	public boolean primaryAssmtComplete(long vcgId, long primaryId)
	{	
		boolean result = false;
		boolean primClinical = false;
		boolean primAssessment = false;
		boolean primTraining= false;
		boolean primInHome = false;

		try {
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

			for(Assmt assessment:completedAssessmentList)
			{
				if(assessment.isActive())
				{
					if(assessment.getType().equals(CaretStrPool.PRIMARY_CLINICAL) && assessment.getCaregiverId()==primaryId){
						primClinical = true;					
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_ASSESSMENT) && assessment.getCaregiverId()==primaryId){
						primAssessment = true;
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_TRAINING) && assessment.getCaregiverId()==primaryId){
						primTraining = true;
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_IN_HOME) && assessment.getCaregiverId()==primaryId){
						primInHome = true;
					}
				}
			}
			
			if(primClinical && primAssessment && primTraining && primInHome){
				//_log.info("Primary Assessment complete");
				result = true;
			}else{
				//_log.info("primary assessment not complete");
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	
		return result;
	}
	
	public boolean secondaryAssmtComplete(long vcgId, long secondaryId)
	{
		boolean result = false;
		boolean secClinical = false;
		boolean secAssessment = false;
		boolean secTraining= false;

		try {
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

			for(Assmt assessment:completedAssessmentList)
			{
				if(assessment.isActive())
				{
					if(assessment.getType().equals(CaretStrPool.SECONDARY_CLINICAL) && assessment.getCaregiverId()==secondaryId){
						secClinical = true;
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_ASSESSMENT) && assessment.getCaregiverId()==secondaryId){
						secAssessment = true;
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TRAINING) && assessment.getCaregiverId()==secondaryId){
						secTraining = true;
					}
				}
			}
			
			if(secClinical && secAssessment && secTraining){
				//_log.info("Secondary Assessment complete");
				result = true;
			}else{
				//_log.info("Secondary assessment not complete");
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		return result;
	}
	
	public boolean secondaryTwoAssmtComplete(long vcgId, long secondaryTwoId)
	{
		boolean result = false;
		boolean secTwoClinical = false;
		boolean secTwoAssessment = false;
		boolean secTwoTraining= false;
		try {
			List<Assmt> completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

			for(Assmt assessment:completedAssessmentList)
			{
				if(assessment.isActive())
				{
					if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_CLINICAL) && assessment.getCaregiverId()==secondaryTwoId){
						secTwoClinical = true;
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_ASSESSMENT) && assessment.getCaregiverId()==secondaryTwoId){
						secTwoAssessment = true;
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_TRAINING) && assessment.getCaregiverId()==secondaryTwoId){
						secTwoTraining = true;
					}
				}
			}
	
			if(secTwoClinical && secTwoAssessment && secTwoTraining){
				//_log.info("Secondary Two Assessment complete");
				result = true;
			}else{
				//_log.info("Secondary Two Assessment not complete");
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		return result;
	}
	
	
	public void getSupportingDocData()
	{		
		List<DocumentSupport> allDocSuport = new ArrayList<DocumentSupport>(); 

		try 
		{
			List<VcgAn> allApps = VcgAnLocalServiceUtil.getByVcg(getVcgId());
			List<Long> allAppIds = new ArrayList<Long>();

			for(VcgAn oneApp:allApps){
				allAppIds.add(oneApp.getVcgAnId());
			}
			List<Apeal> appeals = ApealLocalServiceUtil.getByVcgAn(ArrayUtil.toArray( allAppIds.toArray( new Long[allAppIds.size()] ) ) );
			
			Long[] longIds = allAppIds.toArray(new Long[allAppIds.size()]);
			long[] newLongIds = new long[longIds.length+appeals.size()];			
			int i = 0;
			
			for(Long oneLong:longIds) {
				newLongIds[i++]=oneLong;
			}
			for(Apeal apeal:appeals) {
				newLongIds[i++]=apeal.getApealId();
			}
			
			
			List<Docum> allDocs;
			if ( newLongIds.length > 0 ){
				allDocs = DocumLocalServiceUtil.findByVcgAnId(newLongIds);
			} else {
				allDocs = Collections.emptyList();
			}
			
			String vcgId = Long.toString(getVcgId());		 
			Map<String, String> vcgIdMap = new HashMap<String, String>();
			vcgIdMap.put("vcgId", vcgId);
			
			List<Map<String, Object>> additionalData = CaretLocalServiceUtil.getReport( "vcgSupportingDocuments", vcgIdMap);

			
			for(Docum oneDoc:allDocs){
				DocumentSupport oneDocSupport = new DocumentSupport(oneDoc);
				allDocSuport.add(oneDocSupport);
				
				long vcgAnId = oneDoc.getClassPk();

				if(getPrimaryId()!= 0 && (getPrimaryVcgAnId() == vcgAnId)){
	            	oneDocSupport.primary = true;
	            }
				if(getSecondaryId()!=0 && (getSecondaryVcgAnId() == vcgAnId)){
					oneDocSupport.secondary = true;
		        }
				if(getSecondaryTwoId()!=0 && (getSecondaryTwoVcgAnId() == vcgAnId)){
					oneDocSupport.secondaryTwo = true;
	            }
								
				String fileName = oneDoc.getName();
				String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
				oneDocSupport.docType = fileType;
							
				if (oneDoc.getDocument() != null && oneDoc.getDocument().length() >0) {
					oneDocSupport.docSize = (oneDoc.getDocument().length())/1000;
				} else {
					oneDocSupport.docSize = 0;
				}
				
				for (Map<String, Object> map : additionalData) {
					
					String docId = "";
				    for (Map.Entry<String, Object> entry : map.entrySet()) {
				        String key = entry.getKey();
				        String value = entry.getValue().toString();
				        
				        //For reference
				        //ndx0 - doc.documId	//ndx1 - vcgAn.vcgAnId	//ndx2 - aud.attribute	//ndx3 - doc.name	//ndx4 - doc.type_	
				        //ndx5 - aud.modifieddate //ndx6 - firstname //ndx7 - lastname

				        //_log.info("key/value is : "+key+"/"+value);
				        
				        if(key.equals("ndx0") && value.equals(String.valueOf(oneDoc.getDocumId()))){	
				        	docId = value;
				        }
				    }
				    
				    for (Map.Entry<String, Object> entryTemp : map.entrySet()) {
				        String keyTemp = entryTemp.getKey();
				        String valueTemp = entryTemp.getValue().toString();

				        if(docId.equals(String.valueOf(oneDocSupport.getDocumId()))){
				        	//update docsupport
				        	if(keyTemp.equals("ndx5")){
					        	oneDocSupport.setCreationDate(valueTemp);					        	
					        }else if(keyTemp.equals("ndx6")){
					        	oneDocSupport.setCreatedByFirstName(valueTemp);
					        }else if(keyTemp.equals("ndx7")){
					        	oneDocSupport.setCreatedByLastName(valueTemp);					        	
					        }else if(keyTemp.equals("ndx8")){
					        	oneDocSupport.setNote(valueTemp);
					        }
				        }
					}
				}
			}
				
		
			for(DocumentSupport oneDocument:allDocSuport){
				oneDocument.setCreatedByFullName(oneDocument.getCreatedByLastName() +", "+oneDocument.getCreatedByFirstName());
				if(oneDocument.getType().equals(FileType.TEN_TEN_CG.name()) || oneDocument.getType().equals(FileType.CSC_1010.name())){
					oneDocument.setUiDocType(CaretStrPool.DOC_1010CG);
					this.vcgDocsAll.add(oneDocument);
					if(isCurrent(oneDocument.getClassPk(), oneDocument.getDeleted())){
						this.vcgDocsCurrent.add(oneDocument);
					}
				}else if(oneDocument.getType().equals(FileType.POA.name()) || oneDocument.getType().equals(FileType.CSC_POA.name())){
					oneDocument.setUiDocType(CaretStrPool.DOC_POA);
					this.vcgDocsAll.add(oneDocument);
					if(isCurrent(oneDocument.getClassPk(), oneDocument.getDeleted())){
						this.vcgDocsCurrent.add(oneDocument);
					}
				} else {
					oneDocument.setUiDocType(oneDocument.getType());
					this.vcgDocsAll.add(oneDocument);
					if(isCurrent(oneDocument.getClassPk(), oneDocument.getDeleted())){
						this.vcgDocsCurrent.add(oneDocument);
					}
				}
			}				
		}catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SQLException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}
	
	
	public boolean isCurrent(long vcgAnId, boolean deleted){
		boolean result = false;
		
		if(isPrimaryCurrent(vcgAnId, deleted) 
				|| isSecondaryCurrent(vcgAnId, deleted)
				|| isSecondaryTwoCurrent(vcgAnId, deleted)){
			result = true;
		}
		
		return result;
	}
	
	public boolean isPrimaryCurrent(long vcgAnId, boolean deleted){
		boolean result = false;

		if(getPrimaryId()!= 0 
				&& (getPrimaryVcgAnId() == vcgAnId)
				//&& getPrimaryDispReason()!=null 
				//&& (getPrimaryDispReason().equals(CaretStrPool.IN_PROCESS) || getPrimaryDispReason().equals(CaretStrPool.APPROVED))
				&& (isInProcess(getPrimaryDispReason()) || isApproved(getPrimaryDispReason()) || isReinstated(getPrimaryDispReason()))
				&& !deleted){
        	result = true;
        }
		
		return result;
	}
	
	public boolean isSecondaryCurrent(long vcgAnId, boolean deleted){
		boolean result = false;

		if(getSecondaryId()!=0 
				&& (getSecondaryVcgAnId() == vcgAnId)
				//&& getSecondaryDispReason()!=null 
				//&& (getSecondaryDispReason().equals(CaretStrPool.IN_PROCESS) || getSecondaryDispReason().equals(CaretStrPool.APPROVED))
				&& (isInProcess(getSecondaryDispReason()) || isApproved(getSecondaryDispReason()) || isReinstated(getSecondaryDispReason()))
				&& !deleted){
			result = true;
        }

		return result;
	}

	public boolean isSecondaryTwoCurrent(long vcgAnId, boolean deleted){
		boolean result = false;

		if(getSecondaryTwoId()!=0 
				&& (getSecondaryTwoVcgAnId() == vcgAnId) 
				//&& getSecondaryTwoDispReason()!=null 
				//&& (getSecondaryTwoDispReason().equals(CaretStrPool.IN_PROCESS) || getSecondaryTwoDispReason().equals(CaretStrPool.APPROVED))
				&& (isInProcess(getSecondaryTwoDispReason()) || isApproved(getSecondaryTwoDispReason()) || isReinstated(getSecondaryTwoDispReason()))
				&& !deleted){
			result = true;
        }
		
		return result;
	}

	
	public Map<String,Object> getPrimaryDispReasons() {
		Map<String,Object> map = new LinkedHashMap<String,Object>();
		if ( isInProcess( getPrimaryDispReason() ) ){
			for ( String reason : PortletProps.getArray("primary-reasons") ){
				map.put(reason, reason); 
			}
		} else if ( isRevoked( getPrimaryDispReason() ) || isDisapproved( getPrimaryDispReason() ) ){
			String reason = "appealed-" + getPrimaryDispReason().substring(0, getPrimaryDispReason().indexOf('-')) + "-";
			return Collections.singletonMap(reason, (Object)reason);
		} else if ( isApproved( getPrimaryDispReason() ) || isReinstated( getPrimaryDispReason() ) ){
			for ( String reasonSection: getPrimaryRevocationReasons() ){
				if ( Toolbox.isEmpty( PortletProps.get(reasonSection) ) ){
					map.put(reasonSection, reasonSection);
				} else {
					map.put(reasonSection, true);
					for ( String reason : PortletProps.getArray(reasonSection) ){
						map.put(reason, reason);
					}
				}
			}
		}
		return map;
	}

	private String[] getPrimaryRevocationReasons() {
		return PortletProps.getArray("primary-revocation-reasons");
	}

	public Object getSecondaryDispReasons() {
		Map<String,Object> map = new LinkedHashMap<String,Object>();
		if ( isInProcess( getSecondaryDispReason() )  || isRevoked( getSecondaryDispReason() ) ){
			for ( String reason : PortletProps.getArray("secondary-reasons") ){
				map.put(reason, reason); 
			}
		} else if ( isApproved( getSecondaryDispReason() ) || isReinstated( getSecondaryDispReason() ) ){
			for ( String reasonSection: PortletProps.getArray("revocation-reasons") ){
				if ( Toolbox.isEmpty( PortletProps.get(reasonSection) ) ){
					map.put(reasonSection, reasonSection);
				} else {
					map.put(reasonSection, true);
					for ( String reason : PortletProps.getArray(reasonSection) ){
						map.put(reason, reason);
					}
				}
			}
		}
		return map;
	}

	public Object getSecondaryTwoDispReasons() {
		Map<String,Object> map = new LinkedHashMap<String,Object>();
		if ( isInProcess( getSecondaryTwoDispReason() )  || isRevoked( getSecondaryTwoDispReason() ) ){
			for ( String reason : PortletProps.getArray("secondaryTwo-reasons") ){
				map.put(reason, reason); 
			}
		} else if ( isApproved( getSecondaryTwoDispReason() ) || isReinstated( getSecondaryTwoDispReason() ) ){
			for ( String reasonSection: PortletProps.getArray("revocation-reasons") ){
				if ( Toolbox.isEmpty( PortletProps.get(reasonSection) ) ){
					map.put(reasonSection, reasonSection);
				} else {
					map.put(reasonSection, true);
					for ( String reason : PortletProps.getArray(reasonSection) ){
						map.put(reason, reason);
					}
				}
			}
		}
		return map;
	}
	
	public Object getGeneralDispReasons() {
		Map<String,Object> map = new LinkedHashMap<String,Object>();
		if ( isInProcess( getGeneralDispReason() ) || isRevoked( getGeneralDispReason() ) ){
			for ( String reason : PortletProps.getArray("general-reasons") ){
				map.put(reason, reason); 
			}
		} else if ( isApproved( getGeneralDispReason() ) || isReinstated( getGeneralDispReason() )  ){
			for ( String reasonSection: PortletProps.getArray("general-revocation-reasons") ){
				if ( Toolbox.isEmpty( PortletProps.get(reasonSection) ) ){
					map.put(reasonSection, reasonSection);
				} else {
					map.put(reasonSection, true);
					for ( String reason : PortletProps.getArray(reasonSection) ){
						map.put(reason, reason);
					}
				}
			}
		}
		return map;
	}

	public void setNewPrimary(long primaryId, String primaryRelationship, long vcgAnId, Date recievedDate ) {
		long oldCaregiverId = getPrimaryId();
		setPrimaryVcgAnId(vcgAnId);
		setPrimaryType(primaryRelationship);
		setPrimaryId(primaryId);
		setPrimaryDispReason(CaretStrPool.IN_PROCESS);
		setPrimaryInitDispDate(null);
		setPrimaryDispositionDate(null);
		setTierEffectiveDate( recievedDate );
		setTierLevel(0);
		setTierLevelPreviously(0);
		clearNonTrainingAssessments(Person.Role.PRIMARY, oldCaregiverId);
	}

	public void setNewSecondary(long secondaryId, String secondaryRelationship, long vcgAnId) {
		long oldCaregiverId = getSecondaryId();
		setSecondaryVcgAnId(vcgAnId);
		setSecondaryType(secondaryRelationship);
		setSecondaryId(secondaryId);
		setSecondaryDispReason(CaretStrPool.IN_PROCESS);
		setSecondaryInitDispDate(null);
		setSecondaryDispositionDate(null);
		setSecondaryRevocationDate(null);
		clearNonTrainingAssessments(Person.Role.SECONDARY, oldCaregiverId);
	}

	public void setNewSecondaryTwo(long secondaryTwoId, String secondaryTwoRelationship, long vcgAnId) {
		long oldCaregiverId = getSecondaryTwoId();
		setSecondaryTwoVcgAnId(vcgAnId);
		setSecondaryTwoType(secondaryTwoRelationship);
		setSecondaryTwoId(secondaryTwoId);
		setSecondaryTwoDispReason(CaretStrPool.IN_PROCESS);
		setSecondaryTwoInitDispDate(null);
		setSecondaryTwoDispositionDate(null);
		setSecondaryTwoRevocationDate(null);
		clearNonTrainingAssessments(Person.Role.SECONDARYTWO, oldCaregiverId);
	}
	
	public void setNewGeneral(long generalId, String generalRelationship) {
		setGeneralType(generalRelationship);
		setGeneralId(generalId);
		setGeneralDispReason(CaretStrPool.IN_PROCESS);
		setGeneralInitDispDate(null);
		setGeneralDispositionDate(null);
		setGeneralRevocationDate(null);
	}
	
	public WorkType getDispositionWork ( String dispReason ){
		if ( isApproved( dispReason ) ){
			return WorkType.APPROVED_DISPOSITION;
		}
		if ( isRevoked(dispReason) ){
			return WorkType.REVOKED_DISPOSITION;
		}
		if ( isReinstated(dispReason) ){
			return WorkType.REINSTATED_DISPOSITION;
		}
		return null;
	}
	
	public WorkType getPrimaryDispositionState ( ){
		return getDispositionWork( getPrimaryDispReason() );
	}
	
	public void setPrimaryDispositionDate( Date date, Date initDispDate ){
		super.setPrimaryDispositionDate( date );
		if ( getPrimaryInitDispDate() == null ){
			setPrimaryInitDispDate( initDispDate );
		}
	}
	
	public void setSecondaryDispositionDate( Date date, Date initDispDate ){
		super.setSecondaryDispositionDate( date );
		if ( getSecondaryInitDispDate() == null ){
			setSecondaryInitDispDate( initDispDate );
		}
	}
	
	public void setSecondaryTwoDispositionDate( Date date, Date initDispDate ){
		super.setSecondaryTwoDispositionDate( date );
		if ( getSecondaryTwoInitDispDate() == null ){
			setSecondaryTwoInitDispDate( initDispDate );
		}
	}

	public void setPrimaryDispReason ( String primaryDispReason ) {
		//TODO: apply validation...
		super.setPrimaryDispReason( primaryDispReason );
		if ( isApproved( getPrimaryDispReason() ) ) {
			setPrimaryRevocationDate(null);
		}
	}
	
	public long getPersonId(Role caregiverRole) {
		if ( Person.Role.PRIMARY == caregiverRole ){
			return getPrimaryId();
		} else if ( caregiverRole == Person.Role.SECONDARY ) {
			return getSecondaryId();
		} else if ( caregiverRole == Person.Role.SECONDARYTWO ) {
			return getSecondaryTwoId();
		}
		return 0;
	}
	
	public Person getPerson(Role caregiverRole) {
		if ( Person.Role.PRIMARY == caregiverRole ){
			return getPrimary();
		} else if ( caregiverRole == Person.Role.SECONDARY ) {
			return getSecondary();
		} else if ( caregiverRole == Person.Role.SECONDARYTWO ) {
			return getSecondaryTwo();
		}
		return null;
	}

	public Date geVeteranAssessmentCompletionDate() {
		// TODO Auto-generated method stub
		
		return new Date();
	}

	public Date getCaregiverAssessmentCompletionDate(Role role) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "Assessment" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		return new Date();
	}

	public Date getCaregiverTrainingCompletionDate(Role role) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "Training" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		return new Date();
	}
	
	public Date getCaregiverAssessmentCompletionDate(Role role, boolean newDate) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "Assessment" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		if ( newDate ) {
			return new Date();
		}
		return null;
	}

	public Date getInHomeCompletionDate(Role role, boolean newDate) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "InHome" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		if ( newDate ) {
			return new Date();
		}
		return null;
	}
	
	public Date getClinicalCompletionDate(Role role, boolean newDate) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "Clinical" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		if ( newDate ) {
			return new Date();
		}
		return null;
	}
	
	public Date getInHomeCompletionDate(Role role) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "InHome" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		return new Date();
	}
	
	public Date getClinicalCompletionDate(Role role) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "Clinical" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		return new Date();
	}
	
	public Object clearNonTrainingAssessments ( Person.Role caregiverRole, long oldCaregiverId ) {
		String[] initialTypes = {CaretStrPool.PRIMARY_ASSESSMENT, CaretStrPool.PRIMARY_CLINICAL, CaretStrPool.PRIMARY_TRAINING, CaretStrPool.PRIMARY_IN_HOME, CaretStrPool.SECONDARY_ASSESSMENT, CaretStrPool.SECONDARY_CLINICAL, CaretStrPool.SECONDARY_TRAINING, CaretStrPool.SECONDARY_TWO_ASSESSMENT, CaretStrPool.SECONDARY_TWO_CLINICAL, CaretStrPool.SECONDARY_TWO_TRAINING};

		long caregiverId;
		String[] types;
		switch(caregiverRole) {
			case PRIMARY:
				caregiverId = getPrimaryId();
				types = new String[] { CaretStrPool.PRIMARY_ASSESSMENT, CaretStrPool.PRIMARY_CLINICAL, CaretStrPool.PRIMARY_IN_HOME }; //CaretStrPool.PRIMARY_TRAINING 
				break;
			case SECONDARY:
				caregiverId = getSecondaryId();
				types = new String[] { CaretStrPool.SECONDARY_ASSESSMENT, CaretStrPool.SECONDARY_CLINICAL }; //CaretStrPool.SECONDARY_TRAINING
				break;
			case SECONDARYTWO:
				caregiverId = getSecondaryTwoId();
				types = new String[] { CaretStrPool.SECONDARY_TWO_ASSESSMENT, CaretStrPool.SECONDARY_TWO_CLINICAL }; //, CaretStrPool.SECONDARY_TWO_TRAINING
				break;
			default: return null;
		}
		
		
		_log.info("OldCgId:" + oldCaregiverId + ", newCgId: " + caregiverId );
		try {
			List<Assmt> assessments = AssmtLocalServiceUtil.findByVcgTypes(getVcgId(), caregiverId, types );
			if ( !assessments.isEmpty() ) {
				_log.info(caregiverRole.label + "clearNonTrainingAssessments " + assessments.size() );
				for ( Assmt assmt: assessments ) {
					assmt.setComment("");
					assmt.setCompletionDate(null);
					CaretLocalServiceUtil.save(assmt);
				}
			}
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	
	public void setTierAppealed(boolean enrolled, String apealmentState) {
		if ( loadTrAppealment() != null ){
			apealmentInTrChanged = appealmentInTr.getSelected() != enrolled;
			appealmentInTr.setSelected(enrolled);
			if ( apealmentInTrChanged ){
				this.apealmentState = apealmentState;
			}
		}
		appealedInTr = enrolled;
	}
	
	public boolean isTierAppealed(){
		return getTierAppealed();
	}
	public boolean getTierAppealed(){
		if ( loadTrAppealment() != null ){
			return appealmentInTr.isSelected();
		}
		return appealedInTr;
	}
	
	private BgAsn loadTrAppealment() {
		try {
			if ( getPrimaryId() > 0 ){
				if ( appealmentInTr == null ){
					List<BoxGp> enrollmentList = CaretUtil.loadBoxGroup(Person.class.getName(), APPEALED_IN_TIER);
					for ( BoxGp boxGp: enrollmentList ){
						if ( CaretStrPool.YES.equals( boxGp.getLabel() ) ){
							appealmentInTr = BoxGpLocalServiceUtil.getBoxGroupAssociation( getPrimaryVcgAnId(), boxGp.getBoxGpId() );
							if ( appealmentInTr == null ){
								appealmentInTr = new BgAsnImpl();
								appealmentInTr.setBoxGpId( boxGp.getBoxGpId() );
								appealmentInTr.setOwnerId( getPrimaryVcgAnId() );
							}
							appealedInTr = appealmentInTr.getSelected();
							return appealmentInTr;
						}
					}
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return appealmentInTr;
	}
	
	public BigDecimal getMonthlyAmount(){
		return StipendConfig.getMonthlyRate( getH75().doubleValue(), getTierLevel() );
	}
	
	public PaymentLog getLastPayment() throws ApplicationWorkFlowException{
		Vendr vendr = VendrLocalServiceUtil.findByPersnId( getPrimaryId() );
		if ( vendr == null ) {
			return null;
		}
		PayLg payLg = PayLgLocalServiceUtil.fetchLastPayment( vendr.getVendrId() );
		if ( payLg == null ) {
			return null;
		}
		return new PaymentLog( payLg );
	}
	
	public boolean hasBls(){
		if ( Toolbox.isEmpty( getVeteran().getZip() ) ){
			return false;
		}
		try {
			Object o = BlsReLocalServiceUtil.findLatestBlsByZip( getVeteran().getZip() );
			if ( o == null ){
				o = BlsReLocalServiceUtil.findLatestBlsByZip( Integer.valueOf( getVeteran().getZip()).toString() );
			}
			return o != null;
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		return false;
	}
	
	
	public BigDecimal getH75(){
		if (  Toolbox.isEmpty( getBlsRateHourly() ) && this.blsRe == null ){
			loadBls();
		}
		if ( this.blsRe != null ){
			return new BigDecimal( this.blsRe.getH75().toString() );
		} else {
			return Toolbox.isEmpty( getBlsRateHourly() )? BigDecimal.ZERO : new BigDecimal( getBlsRateHourly() );
		}
	}
	
	private void loadBls(){
		if ( Toolbox.isEmpty( getBlsRateHourly() ) && getPrimary() != null && blsRe == null && getVeteran()!= null && !Toolbox.isEmpty( getVeteran().getZip() ) ){
			try {
				List<BlsRe> list = BlsReLocalServiceUtil.findBlsByZip( getVeteran().getZip() );
				int maxYr = 0;
				int currentYear = Calendar.getInstance().get(Calendar.YEAR);
				for ( BlsRe bls: list ){
					if ( bls.getYear() > maxYr && bls.getYear() < currentYear ){
						this.blsRe = bls;
						maxYr = bls.getYear();
					}
				}
				if ( this.blsRe != null ){
					setBlsRateHourly( this.blsRe.getH75().toString() );
				}
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
	}

	public VcgSupport setContext(Person person) {
		this.context = person;
		return this;
	}

	public long getWorkCaregiverId() {
		if ( getPrimaryId() > 0 ) {
			return getPrimaryId();
		}
		if ( getSecondaryId() > 0 ) {
			return getSecondaryId();
		}
		if ( getSecondaryTwoId() > 0 ) {
			return getSecondaryTwoId();
		}
		return getGeneralId();
	}
	
	public boolean canTransfer( PortletRequest request, Object permissionChecker, Object scopeId ){
		
		return CAction.canDoCaret(permissionChecker, scopeId, CaretCan.UPDATE_ACTIVE_VCG_FACILITY );
//		DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );

//		if ( dashConfig instanceof FacilityDashboardConfig ){
//				!((FacilityDashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG)).getGroupId().contains(getGroupId()) &&
//		}
//		return false;
	}
	
}
