package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.VcgAnWrapper;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.Toolbox;


public class VcgAnSupport extends VcgAnWrapper {
	
	private static final long serialVersionUID = -8375561258346068131L;
	
	String formattedcompletionDate = "";
	String formattedScheduleDate = "";

		
	public VcgAnSupport(VcgAn vcgAn) {
		super(vcgAn);
	}	
	public Map<Long,String> getEarliestApplicationReceiveDateByCaregiver(Set<Long> caregivers, Map<Long,List<Persn>> cgMap) {
		//(LogFactoryUtil.getLog(AssmtSupport.class)).info("MCCP.S________________________________________________");
		Map<Long,String> earliestApplicationReceiveDateByCaregiver = new HashMap<Long,String>();
		String dateStr = null;
		//
		try {
			for(Long caregiverId : caregivers) {
				//(LogFactoryUtil.getLog(VcgAnSupport.class)).info("MCCP.S.meth1: iter thru caregivers: " + caregiverId);
				List<VcgAn> existingApplicationsForCG = getExistingApplicationsForCaregiver(caregiverId, cgMap);
				//(LogFactoryUtil.getLog(VcgAnSupport.class)).info("MCCP.S.meth1: existingApplicationsForCG size: " + existingApplicationsForCG.size());
				
				if (CollectionUtils.isNotEmpty(existingApplicationsForCG)) {
					if (existingApplicationsForCG.size() > 1) {
						Collections.sort(existingApplicationsForCG, new Comparator<VcgAn>(){
							@Override
							public int compare(VcgAn a, VcgAn b) {
								return a.getReceivedDate().before(b.getReceivedDate()) ? 1 : a.getReceivedDate() == b.getReceivedDate() ? 0 : -1;
							}					
						});
					}
					dateStr = Toolbox.formatDateCprs(existingApplicationsForCG.get(0).getReceivedDate());
					earliestApplicationReceiveDateByCaregiver.put(caregiverId, dateStr);
				}
				else {
					earliestApplicationReceiveDateByCaregiver.put(caregiverId, "");
				}
			}
		}
		catch(Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}	
		return earliestApplicationReceiveDateByCaregiver;
	}	
	
	private List<VcgAn> getExistingApplicationsForCaregiver(Long caregiverId, Map<Long,List<Persn>> cgMap) {
		List<VcgAn> all = new ArrayList<VcgAn>();
		//
		Set<VcgAn> compositeCaregiverSearch = new HashSet<VcgAn>();
		List<VcgAn> existingApplicationsById = getExistingApplicationsForCaregiverById(caregiverId);
		if (CollectionUtils.isNotEmpty(existingApplicationsById)) {compositeCaregiverSearch.addAll(existingApplicationsById);}
		List<VcgAn> existingApplicationsByOtherCriteria = getExistingApplicationsForCaregiverByOtherCriteria(caregiverId, cgMap);
		if (CollectionUtils.isNotEmpty(existingApplicationsByOtherCriteria)) {compositeCaregiverSearch.addAll(existingApplicationsByOtherCriteria);}
		//
		all.addAll(compositeCaregiverSearch);
		return all;
	}	
	private List<VcgAn> getExistingApplicationsForCaregiverById(Long caregiverId) {
		List<VcgAn> existingApplications = new ArrayList<VcgAn>();
		try {
			List<VcgAn> primaries = VcgAnLocalServiceUtil.findByPrimaryId(caregiverId);
			existingApplications.addAll(primaries);
			List<VcgAn> secondaries = VcgAnLocalServiceUtil.findBySecondaryId(caregiverId);
			existingApplications.addAll(secondaries);	
			List<VcgAn> secondariesTwo = VcgAnLocalServiceUtil.findBySecondaryTwoId(caregiverId);
			existingApplications.addAll(secondariesTwo);				
			return existingApplications;
		}
		catch(Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return new ArrayList<VcgAn>();
	}
	private List<VcgAn> getExistingApplicationsForCaregiverByOtherCriteria(Long caregiverId, Map<Long,List<Persn>> cgMap) {
		List<VcgAn> softSearch = new ArrayList<VcgAn>();
		List<Persn> persnSearch1 = cgMap.get(caregiverId);
		for(Persn p : persnSearch1) {
			//(LogFactoryUtil.getLog(VcgAnSupport.class)).info("MCCP.S.meth4:persn1: " + p.getPersnId());
			List<VcgAn> existingTrainingById = getExistingApplicationsForCaregiverById(caregiverId);
			if (CollectionUtils.isNotEmpty(existingTrainingById)) {softSearch.addAll(existingTrainingById);}
		}
		return softSearch;
	}	
}
