package gov.va.caret.model.support;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.expando.model.ExpandoBridge;

import gov.va.caret.model.Persn;
import gov.va.caret.model.PersnSoap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

public class PersnJUnit extends PersnSoap implements Persn {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String nns;
	public int compareTo(Persn persn) {return 0;}
	public Class<?> getModelClass() {return getClass().getClass();}
	public String getModelClassName() {return getClass().getClass().getName();}
	public Object clone() { return null; }
	
	public Persn toEscapedModel() {return null;}
	public Persn toUnescapedModel() {return null;}
	public CacheModel<Persn> toCacheModel() {return null;}
	public boolean isNew() {return false;}
	public void setNew(boolean n) {}
	public boolean isCachedModel() {return false;}
	public void setCachedModel(boolean cachedModel) {}
	public boolean isEscapedModel() { return false;}
	public Serializable getPrimaryKeyObj() {return null;}
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {}
	public ExpandoBridge getExpandoBridge() {return null;}
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel) {}
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge) {}
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {}
	public String toXmlString() {return null;}
	public void resetOriginalValues() {}
	public void setModelAttributes(Map<String, Object> attributes) {}
	public void persist() throws SystemException {}
	public String getPersnUserUuid() throws SystemException { return null;}
	public void setPersnUserUuid(String persnUserUuid) {}
	public String getUserUuid() throws SystemException { return null;}
	public void setUserUuid(String userUuid) {}
	public String toString() {
		return getPersnId() + "," + getLastName() + "," + getFirstName() + "," + getAddress() + "," + getCity() + "," + getZip() + "," + getState() + "," + getICN()  ;
	}
	
	public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("persnId", getPersnId());
        attributes.put("persnUserId", getPersnUserId());
        attributes.put("lastName", getLastName());
        attributes.put("firstName", getFirstName());
        attributes.put("middleName", Toolbox.nullSafe(getMiddleName()));
        attributes.put("prefix", getPrefix());
        attributes.put("suffix", Toolbox.nullSafe((getSuffix())));
        attributes.put("birthDate", getBirthDate());
        attributes.put("deceasedDate", getDeceasedDate());
        attributes.put("phone", Toolbox.nullSafe(getPhone()));
        attributes.put("phone2", Toolbox.nullSafe(getPhone2() ));
        attributes.put(CaretStrPool.ADDRESS, Toolbox.nullSafe(getAddress()));
        attributes.put(CaretStrPool.ADDRESS2, Toolbox.nullSafe(getAddress2()));
        attributes.put(CaretStrPool.CITY, Toolbox.nullSafe(getCity()));
        attributes.put(CaretStrPool.ZIP, Toolbox.nullSafe(getZip()));
        attributes.put(CaretStrPool.STATE, Toolbox.nullSafe(getState()));
        attributes.put("country", getCountryCode());
        attributes.put(CaretStrPool.GENDER, Toolbox.nullSafe(getGender()));
        attributes.put("email", getEmail());
        attributes.put("email2", getEmail2());
        attributes.put("status", getStatus());
        attributes.put("source", getSource());
        attributes.put("validAddress", getValidAddress());
        attributes.put("externalId", getExternalId());
        attributes.put("otherHealthInsurance", getOtherHealthInsurance());
        attributes.put("userId", getUserId());
        attributes.put("groupId", getGroupId());
        attributes.put("vistaId", getVistaId());
        attributes.put("eeId", getEeId());
        attributes.put("ICN", getICN());
        
        
        if ( getBirthDate() != null ) {
        	attributes.put(CaretStrPool.BIRTHDATE, Toolbox.getDateFormatCprs().format( getBirthDate() ) );
		}
//        attributes.put( CaretStrPool.SSN, nns );
        
        return attributes;
    }
	
	public PersnJUnit camelCase ( ) { 
		setFirstName( Toolbox.decode ( getFirstName(), true ) );
		setLastName( Toolbox.decode ( getLastName(), true ) );
		setMiddleName( Toolbox.decode ( getMiddleName(), true ) );
		setAddress( Toolbox.decode ( getAddress(), true ) );
		setAddress2( Toolbox.decode ( getAddress2(), true ) );
		setCity( Toolbox.decode ( getCity(), true ) );
		return this;
	}
	
	public String getCountryCode() {
		return !( StringPool.FALSE.equals( getCountry() ) || StringPool.TRUE.equals( getCountry() ) || StringPool.BLANK.equals( getCountry() ) )? getCountry(): StringPool.BLANK;
	}
	
	public String getNns() {
		return nns;
	}
	public void setNns(String nns) {
		this.nns = nns;
	}
}
