package gov.va.caret.model.support;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;

import gov.va.caret.model.BgLae;
import gov.va.caret.model.LumCg;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.PayLgWrapper;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.LumCgLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.Toolbox;


public class PaymentLog extends PayLgWrapper {
	
	private static final long serialVersionUID = 1L;
	
	public static NumberFormat dollarFormat = NumberFormat.getCurrencyInstance(Locale.getDefault());
	
	private Date beginDate = null;
	private Date endDate = null;
	private String verifiedBy;
	private long vcgAnId;
	private String vendorName;
	private List<StiPt> stiPts;
	private WorIm worIm;
	private BgLae cycle;
	private Vendor vendr;
	Boolean recurring = null;
	int paymentMonth = 0;

	private StiPt stiPt = null;
	private static Log _log = LogFactoryUtil.getLog( PaymentLog.class );
	
	public PaymentLog(PayLg PayLg) {
		super(PayLg);
	}
	
	public BgLae getCycle() {
		if ( cycle == null ) {
			try {
				loadDates();
			} catch (PortalException | SystemException e) {
				e.printStackTrace();
			}
		}
		return cycle;
	}
	
	public List<StiPt> getStipendConfigs() throws PortalException, SystemException {
		if ( stiPts == null ) {
			getStipendConfig();
		}
		return stiPts;
	}
	
	public Vendor getVendor() throws PortalException, SystemException {
		if ( vendr == null ) {
			vendr = new Vendor ( VendrLocalServiceUtil.getVendr( this.getVendrId() ) );
		}
		return vendr;
	}
	
	public boolean isRecurring() throws PortalException, SystemException {
		if ( recurring == null ) {
			recurring = StipendConfig.RECURRING.equals( getStipendConfig().getStipendType() );
		}
		return recurring;
	}
	
	public StiPt getStipendConfig() throws SystemException {
		if ( stiPt == null ) {
			stiPts = new ArrayList<StiPt>(); 
			for (LumCg lumpConfig : LumCgLocalServiceUtil.findByVendrCycle( getVendrId(), getCycleId() ) ) {
				StiPt temp = StiPtLocalServiceUtil.fetchStiPt( lumpConfig.getStiPtId() );
				stiPts.add( temp );
				if ( "recurring".equals( temp.getStipendType() ) ) {
					if ( stiPt != null ) {
						_log.warn("Multiple recurring in single month, possible begin/end date mid-month for each-" + stiPt.getStiPtId() + "/" + temp.getStiPtId() );
					}
					stiPt = temp;
				}
			}
			if ( stiPt == null ) {
				stiPt = stiPts.get(0);
			}
		}
		return stiPt;
	}

	public String getTaxId() throws PortalException, SystemException {
		return getVendor().getTaxId();
	}

	public String getVerifiedBy() throws PortalException, SystemException {
		if ( verifiedBy == null ) {
			if ( getWorIm() != null ) {
				User user = UserLocalServiceUtil.fetchUser( worIm.getCompletionBy() );
				if ( user != null ) {
					verifiedBy = user.getFullName();
				}
			} else {
				verifiedBy = StringPool.BLANK;
			}
		}
		return verifiedBy;
	}

	public String getVerifiedOn() throws PortalException, SystemException {
		return Toolbox.formatDate( getStipendConfig().getStipendApprovedDate() );
	}

	public long getVcgAnId() throws PortalException, SystemException {
		if ( vcgAnId == 0 ) {
			if ( getWorIm() != null ) {
				vcgAnId = worIm.getClassPk();
			} else {
				vcgAnId = -1;
			}
		}
		return vcgAnId;
	}

	public String getVendorName() throws PortalException, SystemException {
		if ( vendorName == null ) {
			vendorName = getVendor().getLastName() + StringPool.COMMA_AND_SPACE + getVendor().getFirstName();
		}
		return vendorName;
	}
	
	public Date getEndDate() throws PortalException, SystemException{
		if ( endDate == null ) {
			loadDates();
		}
		return endDate;
	}

	public Date getBeginDate() throws PortalException, SystemException{
		if ( beginDate == null ) {
			loadDates();
		}
		return beginDate;
	}
	
	public String getEndDateStr() throws PortalException, SystemException{
		if ( endDate == null ) {
			loadDates();
		}
		return Toolbox.formatDateCprs(endDate);
	}

	public String getBeginDateStr() throws PortalException, SystemException{
		if ( beginDate == null ) {
			loadDates();
		}
		return Toolbox.formatDateCprs(beginDate);
	}
	
	private void loadDates() throws PortalException, SystemException {
		if ( isRecurring() ) {
			if ( cycle == null ) {
				cycle = BgLaeLocalServiceUtil.getBgLae( getCycleId() );
			}
			paymentMonth = (int)(cycle.getOwnerId() % 12) - 1;
			Calendar calendar = Calendar.getInstance();
			calendar.set( Calendar.MONTH, paymentMonth );
			calendar.set( Calendar.YEAR, (int)cycle.getOwnerId() / 12 );
			calendar.set( Calendar.DAY_OF_MONTH, 1);
			calendar.set( Calendar.HOUR_OF_DAY, 0);
			calendar.set( Calendar.MINUTE, 0);
			calendar.set( Calendar.MILLISECOND, 1);
			
			if ( stiPt .getStipendStartDate().after( calendar.getTime() ) ) { 
				beginDate = stiPt.getStipendStartDate();
			} else {
				beginDate = calendar.getTime();
			}
			
			calendar.roll( Calendar.DAY_OF_MONTH, false );
			endDate = calendar.getTime();
			if ( stiPt.getPayslipDate() != null && stiPt.getPayslipDate().after( endDate ) ) {
				endDate = stiPt.getPayslipDate();
				beginDate = stiPt.getStipendStartDate();
			}
		}
	}
	
	public String getPaymentMonth() {
		return Toolbox.MONTHS[paymentMonth];
	}
	
	public String getPayment(){
		return dollarFormat.format( getAmount( ) );
	}
	
	public WorIm getWorIm() throws PortalException, SystemException {
		if ( worIm == null ) {
			worIm = WorImLocalServiceUtil.getWorIm( getStipendConfig().getWorImId() );
		}
		return worIm;
	}

	public Date getCycleDate() throws PortalException, SystemException {
		if ( isRecurring() ) {
			return StipendConfig.toCalendar( getCycle().getOwnerId() ).getTime();
		} else { //use stipend begin date for Man Payments...
			return null;
		}
	}
	
	public boolean isDuplicateEnabled() throws PortalException, SystemException {
		if ( StipendConfig.PAYMENT_REJECTED.equals( getReason() ) ){
			return false;
		}
		return isRecurring();
	}

}

