package gov.va.caret.model.support;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.FacilWrapper;
import gov.va.caret.util.Toolbox;

public class FacilSupport extends FacilWrapper {
		
	private String facilName;
	private String facilDisplayName;
	
	private static final long serialVersionUID = 1L;
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public FacilSupport(gov.va.caret.model.Facil Facil) {
		super(Facil);
		//
		Organization org = null;
		try {org = OrganizationLocalServiceUtil.getOrganization(this.getGroupId());}
		catch(Exception e) {ApplicationWorkFlowException.handleException(e);}
		if (org != null) {this.setFacilName(org.getName());}
		this.setFacilDisplayName(getFacilDisplayName(facilName, this.getLocation()));
	}
	
	public String getFacilName() {
		return facilName;
	}

	public void setFacilName(String facilName) {
		this.facilName = facilName;
	}	
	
	public String getFacilDisplayName() {
		return facilDisplayName;
	}

	public void setFacilDisplayName(String facilDisplayName) {
		this.facilDisplayName = facilDisplayName;
	}
			
	public static String getFacilDisplayName(String facilityName, String location) {
		return !Toolbox.isEmpty(facilityName) ? facilityName + " - " + location : location;
	}
	
	private static Log _log = LogFactoryUtil.getLog( FacilSupport.class );

}
