package gov.va.caret.model.support;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.ActionRequest;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.CalEt;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.CallWrapper;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;

public class CallSupport extends CallWrapper {

	public static final boolean USE_CREATIONDATE_FOR_START_DATE = true;
	public static final int LARGE_FIELD_LENGTH = 2000;
	public static final int DEFAULT_FIELD_LENGTH = 75;
	//public static int MZZ_LOG = 0;	
	
	String personName = null;
	String personLastName = null;
	String caregiverName = null;
	private Map<String,BgLae> customAttributes = new HashMap<String,BgLae>();
	private Map<Long,BoxGp> customAttributeFields = new HashMap<Long,BoxGp>();	
	private Boolean docLoaded = null;
//	private WorkType workType = null;
	private boolean isCallReferral = false;
	private String workItemType;
	CalEt callEvent = null;
	private Map<String,Note> notes = new HashMap<String,Note>();
	private String[] transferRemarks_ = null;
	private String[] summary_ = null;	
	private String[] message_ = null;
	
	private static final long serialVersionUID = 1L;
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public CallSupport(gov.va.caret.model.Call Call) {
		super(Call);
		if ( !"Referral".equals(getCallType() ) ){
			isCallReferral = getWorkPrimaryKey() > 0;
		}
		try {
			if (getWorkPrimaryKey() > 0) {		
				WorkItemSupport worImS = new WorkItemSupport(WorImLocalServiceUtil.getWorIm(getWorkPrimaryKey()));
				this.setWorkItemType(
					worImS.getType().equals("CALL_REFERRAL") ? "" : worImS.getType());
			}
			else {
				this.setWorkItemType("");
			}
			//
			customAttributes.put("transferRemarks", getLeaAttr("transferRemarks","call-extended-fields", 0));
			customAttributes.put("summary", getLeaAttr("summary","call-extended-fields", 0));
			customAttributes.put("message", getLeaAttr("message","call-extended-fields", 0));
		}
		catch(Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		this.transferRemarks_ = new String[2];
		this.summary_ = new String[2];	
		this.message_ = new String[2];
	}

	public String getPersonName() {
		if ( personName == null ){
			this.personName = getFullName( getVeteranPersnId() );
		}
		return personName;
	}
	
	public String getVeteranLastName() {
		if ( personLastName == null ){
			this.personLastName = getLastName( getVeteranPersnId() );
		}
		return personLastName;
	}

	public String getCaregiverName() {
		if ( caregiverName == null ){
			this.caregiverName = getFullName( getCallerPersnId() );
		}
		return caregiverName;
	}
	
	public String getUserName() {
		return CaretUtil.getUserFullName( this.getUserId() );
	}	
	
	public List<Docum> getDocuments(){
		try{
			if ( isDocLoaded() ){
				return DocumLocalServiceUtil.getByPrimaryKey( getCallId() );
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public WorkType getWorkType(){
		if ( "Referral".equals(getCallType() ) ){
			return WorkType.REFERRAL;
		} else {
			return WorkType.CALL_REFERRAL;
		}
	}
	
	public String getCreateEntry(){
		if ( isCallReferral ){
			return CaretStrPool.CREATE_CALLS;
		} else {
			return CaretStrPool.CREATE_REFERRAL;
		}
	}
	
	public boolean isDocLoaded(){
		if ( docLoaded == null ){
			try {
				docLoaded = DocumLocalServiceUtil.getByPrimaryKeyCount( getCallId() ) > 0;
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return docLoaded;
	}
	
	public boolean isTransferable(){
		switch (getWorkType()){
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public boolean isAssignable(){
		switch (getWorkType()){
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public String getDueDateStr ( ){
		String dueDate = StringPool.BLANK;
		if ( getWorkPrimaryKey() > 0 ){
			try {
				Date due = WorImLocalServiceUtil.getWorIm(getWorkPrimaryKey()).getDueDate();
				return Toolbox.formatDateCprs(due);
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return dueDate;
	}
	
	public String getCreateDateStr ( ){
		if ( getCreationDate() != null ){
			return Toolbox.formatDateCprs( getCreationDate() );
		}
		return StringPool.BLANK;
	}
	
	public String getModificationDateStr ( ){
		if ( getModificationDate() != null ){
			return Toolbox.formatDateCprs( getModificationDate() );
		}
//		if ( getCreationDate() != null ){
//			return Toolbox.formatDateCprs( getCreationDate() );
//		}
		return StringPool.BLANK;
	}
	
	public String getLastName ( long persnId ){
		if ( persnId > 0 ){
			try {
				return PersnLocalServiceUtil.getPersn( persnId ).getLastName();
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return StringPool.BLANK;
	}
	
	public String getFullName ( long persnId ){
		if ( persnId > 0 ){
			try {
				Persn persn = PersnLocalServiceUtil.getPersn( persnId );
				return CaretStrPool.UNKNOWN_IDENTITY.equals( persn.getStatus() ) ? "Unknown" : persn.getLastName() + StringPool.COMMA_AND_SPACE + persn.getFirstName();
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			return CaretUtil.getPersnFullName ( persnId );
		}
		return StringPool.BLANK;
	}
	
	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		if ( getVeteranPersnId() == 0 ){
			throw new com.liferay.portal.kernel.exception.SystemException("Person ID cannot be 0");
		}
		super.persist();
		saveCustomAttributes();
	}
	
	private BoxGp initCustomAttribute( String attribute ) throws ApplicationWorkFlowException{
		BoxGp custom = new BoxGpImpl();
		custom.setBoxGroup( CallSupport.class.getName() );
		custom.setBoxSubGroup( String.valueOf( getCallId() ) );
		custom.setLabel( attribute );  //attribute
//		custom.setViewSequence( sequence );
		try {
			return BoxGpLocalServiceUtil.addBoxGp( custom );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException ( e );
		}
	}
	private BoxGp initCustomAttribute( String attribute, String boxGroupSubGroup ) throws ApplicationWorkFlowException{
		//_log.info("MZZ[" + CallSupport.MZZ_LOG++ + "]" + "::: callSupport.initCustomAttribute....1");
		BoxGp custom = new BoxGpImpl();
		custom.setBoxGroup( CallSupport.class.getName() );
		custom.setBoxSubGroup( boxGroupSubGroup );
		custom.setLabel( attribute );  //attribute
//		custom.setViewSequence( sequence );
		try {
			return BoxGpLocalServiceUtil.addBoxGp( custom );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException ( e );
		}
	}	
	private BoxGp getCustomAttribute ( String attribute, long applicationId ) throws ApplicationWorkFlowException {
		List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( CallSupport.class.getName(), String.valueOf( getCallId() )  );
		BoxGp custom = null;
		if ( attributes.isEmpty() ){
			custom = initCustomAttribute ( attribute );
		} else {
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					custom = bgAtt;
				}
			}
		}
		if ( custom == null ){
			custom = initCustomAttribute ( attribute );
		}
		return custom;
	}
	private BoxGp getCustomAttribute ( String attribute, String boxGroupSubGroup, long applicationId ) throws ApplicationWorkFlowException {
		//_log.info("MZZ[" + CallSupport.MZZ_LOG++ + "]" + "::: callSupport.getCustomAttribute....1");
		List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( CallSupport.class.getName(), boxGroupSubGroup  );
		BoxGp custom = null;
		if ( attributes.isEmpty() ){
			custom = initCustomAttribute ( attribute, boxGroupSubGroup );
		} else {
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					custom = bgAtt;
				}
			}
		}
		if ( custom == null ){
			custom = initCustomAttribute ( attribute, boxGroupSubGroup );
		}
		customAttributeFields.put(custom.getBoxGpId(), custom);
		return custom;
	}	
	
	private void saveCustomAttributes() {
//		if ( !customAttributes.isEmpty() ){
//			for ( BgLae value : customAttributes.values() ){
//				try {
//					CaretLocalServiceUtil.save(value);
//				} catch (ApplicationWorkFlowException e) {
//					ApplicationWorkFlowException.handleException(e);
//				}
//			}
//		}
		if ( !customAttributes.isEmpty() ) {
			for ( String key : customAttributes.keySet() ){
				if (key.equalsIgnoreCase("transferRemarks") || key.equalsIgnoreCase("summary") || key.equalsIgnoreCase("message")) {
					updateExtendedField(key, customAttributes.get(key));
				}
				else {
					BgLae value = customAttributes.get(key);
					try {
						CaretLocalServiceUtil.save(value);
					} catch (ApplicationWorkFlowException e) {
						ApplicationWorkFlowException.handleException(e);
					}					
				}
			}
		}		
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			if ( note.getNoteId() == 0 ) try {
				note.setChainId( getCallId() );
				notes.put(attribute, CaretLocalServiceUtil.addNote(note));
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}
	
	public void updateExtendedField(String key, BgLae ca) {
		String s = ca.getLargeText();
		if (!Toolbox.isEmpty(s)) {
			//_log.info("MZZ[" + CallSupport.MZZ_LOG++ + "]" + "::: callSupport.saveCustomAttribute(" + key + "): "+ s);
			if (ca.getOwnerId() == 0) {
				ca.setOwnerId(this.getCallId());
			}
			try {
				BgLaeLocalServiceUtil.updateBgLae(ca);
			}
			catch(Exception e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		else {
			//_log.info("MZZ[" + CallSupport.MZZ_LOG++ + "]" + "::: callSupport.DONT_SAVECustomAttribute(" + key + "): "+ s);
			if (ca.getBgLaeId() > 0) {
				try {
					BgLaeLocalServiceUtil.deleteBgLae(ca);
				}
				catch(Exception e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}		
	}	
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			String text = note.getValue();
			modelAttributes.put( attribute, text.substring(0, Math.min(text.length(), 75)) );
		}
		if ( !customAttributes.isEmpty() ) {
			for ( String key : customAttributes.keySet() ){
				BgLae ca = customAttributes.get(key);
				modelAttributes.put(key, "");
				if (key.equalsIgnoreCase("transferRemarks")) {
					this.setTransferRemarks(this.getTransferRemarks_()[0]);
					ca.setLargeText(this.getTransferRemarks_()[1]);
				}
				else if (key.equalsIgnoreCase("summary")) {
					this.setSummary(this.getSummary_()[0]);
					ca.setLargeText(this.getSummary_()[1]);					
				}
				else if (key.equalsIgnoreCase("message")) {
					this.setMessage(this.getMessage_()[0]);
					ca.setLargeText(this.getMessage_()[1]);					
				}				
			}
		}		
		return modelAttributes;
	}

	private BgLae getLeaAttr ( String attribute, long applicationId ) throws ApplicationWorkFlowException {
		BoxGp custom = getCustomAttribute ( attribute, applicationId );
		BgLae value = BgLaeLocalServiceUtil.getBgLaeAssociation( getCallId(), custom.getBoxGpId() );
		if ( value == null ){
			value = new BgLaeImpl();
			value.setBoxGpId( custom.getBoxGpId() );
		}
		return value;
	}
	private BgLae getLeaAttr ( String attribute, String boxGroupSubGroup, long applicationId ) throws ApplicationWorkFlowException {
		//_log.info("MZZ[" + CallSupport.MZZ_LOG++ + "]" + "::: callSupport.getLeaAttr....1");
		BoxGp custom = getCustomAttribute ( attribute, boxGroupSubGroup, applicationId );
		//_log.info("MZZ[" + CallSupport.MZZ_LOG++ + "]" + "[CallSupport.const].getLeaAttr:boxgp: " + custom.getBoxGroup() + "." + custom.getBoxSubGroup() + "." + custom.getLabel());
		BgLae value = BgLaeLocalServiceUtil.getBgLaeAssociation( getCallId(), custom.getBoxGpId() );
		if ( value == null ){
			value = new BgLaeImpl();
			value.setBoxGpId( custom.getBoxGpId() );
			value.setOwnerId( getCallId() );
		}
		return value;
	}	

	public void setNote ( String attribute, String comment, long userId, Date createDate, long groupId ){
		 notes.put( attribute, CaretUtil.createNote( createDate, getCallId(), groupId, userId, comment ) );
	}

	public void useNote( String attribute, Note note ) {
		notes.put( attribute, note );
	}
	
	public Note getNote ( String attribute ){
		if ( notes.containsKey(attribute) ){
			return notes.get(attribute); 
		}
		return null;
	}
	public String[] getTransferRemarks_() {
		return transferRemarks_;
	}
	
	public String getTransferRemarks_asString() {
		if (this.getCallId() > 0) {
			this.setTransferRemarks_();
			return Toolbox.toString(this.getTransferRemarks_());	
		}
		else {
			return "";
		}
	}
	
	public void setTransferRemarks_(String[] transferRemarks_) {
		this.transferRemarks_ = transferRemarks_;
	}
	
	public void setTransferRemarks_(String s) {
		this.transferRemarks_ = getCompoundValueArray(s);
	}
	
	public void setTransferRemarks_() {
		this.transferRemarks_[0] = this.getTransferRemarks();
		if ( !customAttributes.isEmpty() ) {
			if (customAttributes.containsKey("transferRemarks")) {
				transferRemarks_[1] = (customAttributes.get("transferRemarks")).getLargeText();
			}
		}
	}	

	public String[] getSummary_() {
		return summary_;
	}

	public void setSummary_(String[] summary_) {
		this.summary_ = summary_;
	}
	
	public String getSummary_asString() {
		if (this.getCallId() > 0) {
			this.setSummary_();
			return Toolbox.toString(this.getSummary_());		
		}
		else {
			return "";
		}
	}	
	
	public void setSummary_(String s) {
		this.summary_ = getCompoundValueArray(s);
	}	
	
	public void setSummary_() {
		this.summary_[0] = this.getSummary();
		if ( !customAttributes.isEmpty() ) {
			if (customAttributes.containsKey("summary")) {
				summary_[1] = (customAttributes.get("summary")).getLargeText();
			}
		}
	}
	
	public String[] getMessage_() {
		return message_;
	}
	
	public String getMessage_asString() {
		if (this.getCallId() > 0) {
			this.setMessage_();
			return Toolbox.toString(this.getMessage_());	
		}
		else {
			return "";
		}
	}
	
	public void setMessage_(String[] message_) {
		this.message_ = message_;
	}
	
	public void setMessage_(String s) {
		this.message_ = getCompoundValueArray(s);
	}
	
	public void setMessage_() {
		this.message_[0] = this.getMessage();
		if ( !customAttributes.isEmpty() ) {
			if (customAttributes.containsKey("message")) {
				message_[1] = (customAttributes.get("message")).getLargeText();
			}
		}
	}			
		
	public void setCompoundValue(ActionRequest request, String name, String prefix) {
		//
		Object o = request.getAttribute("call_");
		String value = ParamUtil.get(request, prefix == null? name : prefix + name, StringPool.BLANK );
		//_log.info("MZZ[" + CallSupport.MZZ_LOG++ + "]" + "[CallSupport.inst]setCompoundValue(" + name + ") value len = " + value.length());
		if (name.equalsIgnoreCase("transferRemarks")) {this.setTransferRemarks_(value);}
		else if (name.equalsIgnoreCase("summary")) {this.setSummary_(value);}
		else if (name.equalsIgnoreCase("message")) {this.setMessage_(value);}

	}	
	public void setCompoundValue(ActionRequest request, String name, String prefix, String value) {
		//
		//_log.info("MZZ[" + CallSupport.MZZ_LOG++ + "]" + "[CallSupport.inst]setCompoundValue(" + name + ") value len = " + value.length());
		//_log.info("MZZ[" + CallSupport.MZZ_LOG++ + "]" + "value" + value);
		if (name.equalsIgnoreCase("transferRemarks")) {this.setTransferRemarks_(value);}
		else if (name.equalsIgnoreCase("summary")) {this.setSummary_(value);}
		else if (name.equalsIgnoreCase("message")) {this.setMessage_(value);}

	}
	public String getWorkItemType() {
		return workItemType;
	}
	public void setWorkItemType(String workItemType) {
		this.workItemType = workItemType;
	}	
	public static String[] getCompoundValueArray(String s) {
		String[] tempArray = new String[]{"",""};
		if (!Toolbox.isEmpty(s)) {
			String tempString = s.substring(0, 
				(s.length() > (LARGE_FIELD_LENGTH + DEFAULT_FIELD_LENGTH) ? 
				(LARGE_FIELD_LENGTH + DEFAULT_FIELD_LENGTH) : 
				s.length()));			
			if (s.length() > DEFAULT_FIELD_LENGTH) {
				tempArray[0] = tempString.substring(0, DEFAULT_FIELD_LENGTH);
				tempArray[1] = tempString.substring(DEFAULT_FIELD_LENGTH);
			}
			else {
				tempArray[0] = tempString;
				tempArray[1] = "";
			}
		}
		return tempArray;
	}
	public static int getExtendedFieldLength() {
		return CallSupport.LARGE_FIELD_LENGTH + CallSupport.DEFAULT_FIELD_LENGTH;
	}
	
	private static Log _log = LogFactoryUtil.getLog( CallSupport.class );
	
}
