package gov.va.caret.model.support;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.model.BgNum;
import gov.va.caret.model.BgNumWrapper;

public class BoxNumberSupport extends BgNumWrapper {
	
	private static final long serialVersionUID = 1L;
	private static Log _log = LogFactoryUtil.getLog( BoxNumberSupport.class );
	
	public BoxNumberSupport(BgNum bgNum) {
		super(bgNum);
	}
	
	public String getValueStr() {
		BigDecimal value = new BigDecimal(getValue()).setScale( 2, RoundingMode.HALF_UP );
		return value.toPlainString();
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();
		
		modelAttributes.put("value", new BigDecimal(getValue()).setScale( 2, RoundingMode.HALF_UP ).toPlainString() );
		
		return modelAttributes;
	}
	
	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		if ( getOwnerId() == 0 ){
			_log.error("Owner ID missing... will not persist now.");
			return;
		}
		super.persist();
	}
}