package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.AssmtWrapper;
import gov.va.caret.model.Persn;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CachedReport;

public class AssmtSupport extends AssmtWrapper {
	
	public String[] trainingTypes = {CaretStrPool.PRIMARY_TRAINING, CaretStrPool.SECONDARY_TRAINING, CaretStrPool.SECONDARY_TWO_TRAINING};
	private static final long serialVersionUID = -8375561258346068131L;
	
	String formattedcompletionDate = "";
	String formattedScheduleDate = "";

		
	public AssmtSupport(Assmt assmt) {
		super(assmt);
	}


	public String getFormattedcompletionDate() {
		return formattedcompletionDate;
	}

	public void setFormattedcompletionDate(String formattedcompletionDate) {
		this.formattedcompletionDate = formattedcompletionDate;
	}

	public String getFormattedScheduleDate() {
		return formattedScheduleDate;
	}

	public void setFormattedScheduleDate(String formattedScheduleDate) {
		this.formattedScheduleDate = formattedScheduleDate;
	}
	
	public Map<Long,String> getEarliestTrainingCompletionDateByCaregiver(Set<Long> caregivers, Map<Long,List<Persn>> cgMap) {
		//(LogFactoryUtil.getLog(AssmtSupport.class)).info("MCCP.Q________________________________________________");
		Map<Long,String> earliestTrainingCompletionDateByCaregiver = new HashMap<Long,String>();
		String dateStr = null;
		//
		try {
			for(Long caregiverId : caregivers) {
				//(LogFactoryUtil.getLog(AssmtSupport.class)).info("MCCP.Q.meth1: iter thru caregivers: " + caregiverId);
				List<Assmt> existingTrainingForCG = getExistingTrainingForCaregiver(caregiverId, cgMap);
				//(LogFactoryUtil.getLog(AssmtSupport.class)).info("MCCP.Q.meth1: existingTrainingForCG size: " + existingTrainingForCG.size());
				
				if (CollectionUtils.isNotEmpty(existingTrainingForCG)) {
					if (existingTrainingForCG.size() > 1) {
						Collections.sort(existingTrainingForCG, new Comparator<Assmt>(){
							@Override
							public int compare(Assmt a, Assmt b) {
								return a.getCompletionDate().before(b.getCompletionDate()) ? 1 : a.getCompletionDate() == b.getCompletionDate() ? 0 : -1;
							}					
						});
					}
					dateStr = Toolbox.formatDateCprs(existingTrainingForCG.get(0).getCompletionDate());
					earliestTrainingCompletionDateByCaregiver.put(caregiverId, dateStr);
				}
				else {
					earliestTrainingCompletionDateByCaregiver.put(caregiverId, "");
				}
			}
		}
		catch(Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}	
		return earliestTrainingCompletionDateByCaregiver;
	}
	private List<Assmt> getExistingTrainingForCaregiver(Long caregiverId, Map<Long,List<Persn>> cgMap) {
		List<Assmt> all = new ArrayList<Assmt>();
		//
		Set<Assmt> compositeCaregiverSearch = new HashSet<Assmt>();
		List<Assmt> existingTrainingById = getExistingTrainingForCaregiverById(caregiverId);
		if (CollectionUtils.isNotEmpty(existingTrainingById)) {compositeCaregiverSearch.addAll(existingTrainingById);}
		List<Assmt> existingTrainingByOtherCriteria = getExistingTrainingForCaregiverByOtherCriteria(caregiverId, cgMap);
		if (CollectionUtils.isNotEmpty(existingTrainingByOtherCriteria)) {compositeCaregiverSearch.addAll(existingTrainingByOtherCriteria);}
		//
		all.addAll(compositeCaregiverSearch);
		return all;
	}
	private List<Assmt> getExistingTrainingForCaregiverById(Long caregiverId) {
		try {
			return AssmtLocalServiceUtil.findByCaregiverTypes(caregiverId,  trainingTypes );
		}
		catch(Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return new ArrayList<Assmt>();
	}
	private List<Assmt> getExistingTrainingForCaregiverByOtherCriteria(Long caregiverId, Map<Long,List<Persn>> cgMap) {
		List<Assmt> softSearch = new ArrayList<Assmt>();
		List<Persn> persnSearch1 = cgMap.get(caregiverId);
		for(Persn p : persnSearch1) {
			//(LogFactoryUtil.getLog(AssmtSupport.class)).info("MCCP.Q.meth4:persn1: " + p.getPersnId());
			List<Assmt> existingTrainingById = getExistingTrainingForCaregiverById(caregiverId);
			if (CollectionUtils.isNotEmpty(existingTrainingById)) {softSearch.addAll(existingTrainingById);}
		}
		return softSearch;
	}
	
}
