package gov.va.caret.model.support;

import java.util.Map;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Apeal;
import gov.va.caret.model.ApealWrapper;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;


public class AppealSupport extends ApealWrapper  {
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    
    
	Person person = null;


	private VcgAnSupport vcgAn;


	private VcgSupport vcg;
	
	
	public AppealSupport(Apeal apeal) {
		super(apeal);
	}


	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		return modelAttributes;
	}
	
	public void persist () throws SystemException{
		super.persist();
	}
	
	public VcgAnSupport getApplication() {
		if ( vcgAn == null ) {
			try {
				vcgAn = new VcgAnSupport( VcgAnLocalServiceUtil.fetchVcgAn( getClassPk() ) );
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		return vcgAn;
	}
	
	public VcgSupport getVcg() throws SystemException {
		if ( vcg == null ) {
			vcg = new VcgSupport ( VcgLocalServiceUtil.fetchVcg(  getApplication().getVcgId() ) );
		}
		return vcg;
	}

	public Person getCaregiver() {
		if ( person == null ) {
			try {
				person = new Person ( PersnLocalServiceUtil.fetchPersn(getOwnerId()) );
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		return person;
	}
	
}
