package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.WorIm;
import gov.va.caret.model.WorImModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the WorIm service. Represents a row in the &quot;CARET_WORK_ITEM&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.WorImModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WorImImpl}.
 * </p>
 *
 * @author caret
 * @see WorImImpl
 * @see gov.va.caret.model.WorIm
 * @see gov.va.caret.model.WorImModel
 * @generated
 */
public class WorImModelImpl extends BaseModelImpl<WorIm> implements WorImModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a wor im model instance should use the {@link gov.va.caret.model.WorIm} interface instead.
     */
    public static final String TABLE_NAME = "CARET_WORK_ITEM";
    public static final Object[][] TABLE_COLUMNS = {
            { "worImId", Types.BIGINT },
            { "type_", Types.VARCHAR },
            { "classId", Types.BIGINT },
            { "classPk", Types.BIGINT },
            { "status", Types.VARCHAR },
            { "creationDate", Types.TIMESTAMP },
            { "dueDate", Types.TIMESTAMP },
            { "completionDate", Types.TIMESTAMP },
            { "completionBy", Types.BIGINT },
            { "groupId", Types.BIGINT },
            { "userId", Types.BIGINT },
            { "caregiverId", Types.BIGINT },
            { "persnId", Types.BIGINT },
            { "queId", Types.BIGINT },
            { "vcgId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_WORK_ITEM (worImId LONG not null primary key,type_ VARCHAR(75) null,classId LONG,classPk LONG,status VARCHAR(75) null,creationDate DATE null,dueDate DATE null,completionDate DATE null,completionBy LONG,groupId LONG,userId LONG,caregiverId LONG,persnId LONG,queId LONG,vcgId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_WORK_ITEM";
    public static final String ORDER_BY_JPQL = " ORDER BY worIm.worImId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_WORK_ITEM.worImId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.WorIm"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.WorIm"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.WorIm"),
            true);
    public static long CAREGIVERID_COLUMN_BITMASK = 1L;
    public static long CLASSID_COLUMN_BITMASK = 2L;
    public static long CLASSPK_COLUMN_BITMASK = 4L;
    public static long GROUPID_COLUMN_BITMASK = 8L;
    public static long STATUS_COLUMN_BITMASK = 16L;
    public static long TYPE_COLUMN_BITMASK = 32L;
    public static long USERID_COLUMN_BITMASK = 64L;
    public static long VCGID_COLUMN_BITMASK = 128L;
    public static long WORIMID_COLUMN_BITMASK = 256L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.WorIm"));
    private static ClassLoader _classLoader = WorIm.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { WorIm.class };
    private long _worImId;
    private String _type;
    private String _originalType;
    private long _classId;
    private long _originalClassId;
    private boolean _setOriginalClassId;
    private long _classPk;
    private long _originalClassPk;
    private boolean _setOriginalClassPk;
    private String _status;
    private String _originalStatus;
    private Date _creationDate;
    private Date _dueDate;
    private Date _completionDate;
    private long _completionBy;
    private long _groupId;
    private long _originalGroupId;
    private boolean _setOriginalGroupId;
    private long _userId;
    private String _userUuid;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private long _caregiverId;
    private long _originalCaregiverId;
    private boolean _setOriginalCaregiverId;
    private long _persnId;
    private long _queId;
    private long _vcgId;
    private long _originalVcgId;
    private boolean _setOriginalVcgId;
    private long _columnBitmask;
    private WorIm _escapedModel;

    public WorImModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _worImId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setWorImId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _worImId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return WorIm.class;
    }

    @Override
    public String getModelClassName() {
        return WorIm.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("worImId", getWorImId());
        attributes.put("type", getType());
        attributes.put("classId", getClassId());
        attributes.put("classPk", getClassPk());
        attributes.put("status", getStatus());
        attributes.put("creationDate", getCreationDate());
        attributes.put("dueDate", getDueDate());
        attributes.put("completionDate", getCompletionDate());
        attributes.put("completionBy", getCompletionBy());
        attributes.put("groupId", getGroupId());
        attributes.put("userId", getUserId());
        attributes.put("caregiverId", getCaregiverId());
        attributes.put("persnId", getPersnId());
        attributes.put("queId", getQueId());
        attributes.put("vcgId", getVcgId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long worImId = (Long) attributes.get("worImId");

        if (worImId != null) {
            setWorImId(worImId);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Long classId = (Long) attributes.get("classId");

        if (classId != null) {
            setClassId(classId);
        }

        Long classPk = (Long) attributes.get("classPk");

        if (classPk != null) {
            setClassPk(classPk);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Date dueDate = (Date) attributes.get("dueDate");

        if (dueDate != null) {
            setDueDate(dueDate);
        }

        Date completionDate = (Date) attributes.get("completionDate");

        if (completionDate != null) {
            setCompletionDate(completionDate);
        }

        Long completionBy = (Long) attributes.get("completionBy");

        if (completionBy != null) {
            setCompletionBy(completionBy);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Long caregiverId = (Long) attributes.get("caregiverId");

        if (caregiverId != null) {
            setCaregiverId(caregiverId);
        }

        Long persnId = (Long) attributes.get("persnId");

        if (persnId != null) {
            setPersnId(persnId);
        }

        Long queId = (Long) attributes.get("queId");

        if (queId != null) {
            setQueId(queId);
        }

        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }
    }

    @Override
    public long getWorImId() {
        return _worImId;
    }

    @Override
    public void setWorImId(long worImId) {
        _worImId = worImId;
    }

    @Override
    public String getType() {
        if (_type == null) {
            return StringPool.BLANK;
        } else {
            return _type;
        }
    }

    @Override
    public void setType(String type) {
        _columnBitmask |= TYPE_COLUMN_BITMASK;

        if (_originalType == null) {
            _originalType = _type;
        }

        _type = type;
    }

    public String getOriginalType() {
        return GetterUtil.getString(_originalType);
    }

    @Override
    public long getClassId() {
        return _classId;
    }

    @Override
    public void setClassId(long classId) {
        _columnBitmask |= CLASSID_COLUMN_BITMASK;

        if (!_setOriginalClassId) {
            _setOriginalClassId = true;

            _originalClassId = _classId;
        }

        _classId = classId;
    }

    public long getOriginalClassId() {
        return _originalClassId;
    }

    @Override
    public long getClassPk() {
        return _classPk;
    }

    @Override
    public void setClassPk(long classPk) {
        _columnBitmask |= CLASSPK_COLUMN_BITMASK;

        if (!_setOriginalClassPk) {
            _setOriginalClassPk = true;

            _originalClassPk = _classPk;
        }

        _classPk = classPk;
    }

    public long getOriginalClassPk() {
        return _originalClassPk;
    }

    @Override
    public String getStatus() {
        if (_status == null) {
            return StringPool.BLANK;
        } else {
            return _status;
        }
    }

    @Override
    public void setStatus(String status) {
        _columnBitmask |= STATUS_COLUMN_BITMASK;

        if (_originalStatus == null) {
            _originalStatus = _status;
        }

        _status = status;
    }

    public String getOriginalStatus() {
        return GetterUtil.getString(_originalStatus);
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    @Override
    public Date getDueDate() {
        return _dueDate;
    }

    @Override
    public void setDueDate(Date dueDate) {
        _dueDate = dueDate;
    }

    @Override
    public Date getCompletionDate() {
        return _completionDate;
    }

    @Override
    public void setCompletionDate(Date completionDate) {
        _completionDate = completionDate;
    }

    @Override
    public long getCompletionBy() {
        return _completionBy;
    }

    @Override
    public void setCompletionBy(long completionBy) {
        _completionBy = completionBy;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _columnBitmask |= GROUPID_COLUMN_BITMASK;

        if (!_setOriginalGroupId) {
            _setOriginalGroupId = true;

            _originalGroupId = _groupId;
        }

        _groupId = groupId;
    }

    public long getOriginalGroupId() {
        return _originalGroupId;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _columnBitmask |= USERID_COLUMN_BITMASK;

        if (!_setOriginalUserId) {
            _setOriginalUserId = true;

            _originalUserId = _userId;
        }

        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    public long getOriginalUserId() {
        return _originalUserId;
    }

    @Override
    public long getCaregiverId() {
        return _caregiverId;
    }

    @Override
    public void setCaregiverId(long caregiverId) {
        _columnBitmask |= CAREGIVERID_COLUMN_BITMASK;

        if (!_setOriginalCaregiverId) {
            _setOriginalCaregiverId = true;

            _originalCaregiverId = _caregiverId;
        }

        _caregiverId = caregiverId;
    }

    public long getOriginalCaregiverId() {
        return _originalCaregiverId;
    }

    @Override
    public long getPersnId() {
        return _persnId;
    }

    @Override
    public void setPersnId(long persnId) {
        _persnId = persnId;
    }

    @Override
    public long getQueId() {
        return _queId;
    }

    @Override
    public void setQueId(long queId) {
        _queId = queId;
    }

    @Override
    public long getVcgId() {
        return _vcgId;
    }

    @Override
    public void setVcgId(long vcgId) {
        _columnBitmask |= VCGID_COLUMN_BITMASK;

        if (!_setOriginalVcgId) {
            _setOriginalVcgId = true;

            _originalVcgId = _vcgId;
        }

        _vcgId = vcgId;
    }

    public long getOriginalVcgId() {
        return _originalVcgId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            WorIm.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public WorIm toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (WorIm) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        WorImImpl worImImpl = new WorImImpl();

        worImImpl.setWorImId(getWorImId());
        worImImpl.setType(getType());
        worImImpl.setClassId(getClassId());
        worImImpl.setClassPk(getClassPk());
        worImImpl.setStatus(getStatus());
        worImImpl.setCreationDate(getCreationDate());
        worImImpl.setDueDate(getDueDate());
        worImImpl.setCompletionDate(getCompletionDate());
        worImImpl.setCompletionBy(getCompletionBy());
        worImImpl.setGroupId(getGroupId());
        worImImpl.setUserId(getUserId());
        worImImpl.setCaregiverId(getCaregiverId());
        worImImpl.setPersnId(getPersnId());
        worImImpl.setQueId(getQueId());
        worImImpl.setVcgId(getVcgId());

        worImImpl.resetOriginalValues();

        return worImImpl;
    }

    @Override
    public int compareTo(WorIm worIm) {
        long primaryKey = worIm.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof WorIm)) {
            return false;
        }

        WorIm worIm = (WorIm) obj;

        long primaryKey = worIm.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        WorImModelImpl worImModelImpl = this;

        worImModelImpl._originalType = worImModelImpl._type;

        worImModelImpl._originalClassId = worImModelImpl._classId;

        worImModelImpl._setOriginalClassId = false;

        worImModelImpl._originalClassPk = worImModelImpl._classPk;

        worImModelImpl._setOriginalClassPk = false;

        worImModelImpl._originalStatus = worImModelImpl._status;

        worImModelImpl._originalGroupId = worImModelImpl._groupId;

        worImModelImpl._setOriginalGroupId = false;

        worImModelImpl._originalUserId = worImModelImpl._userId;

        worImModelImpl._setOriginalUserId = false;

        worImModelImpl._originalCaregiverId = worImModelImpl._caregiverId;

        worImModelImpl._setOriginalCaregiverId = false;

        worImModelImpl._originalVcgId = worImModelImpl._vcgId;

        worImModelImpl._setOriginalVcgId = false;

        worImModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<WorIm> toCacheModel() {
        WorImCacheModel worImCacheModel = new WorImCacheModel();

        worImCacheModel.worImId = getWorImId();

        worImCacheModel.type = getType();

        String type = worImCacheModel.type;

        if ((type != null) && (type.length() == 0)) {
            worImCacheModel.type = null;
        }

        worImCacheModel.classId = getClassId();

        worImCacheModel.classPk = getClassPk();

        worImCacheModel.status = getStatus();

        String status = worImCacheModel.status;

        if ((status != null) && (status.length() == 0)) {
            worImCacheModel.status = null;
        }

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            worImCacheModel.creationDate = creationDate.getTime();
        } else {
            worImCacheModel.creationDate = Long.MIN_VALUE;
        }

        Date dueDate = getDueDate();

        if (dueDate != null) {
            worImCacheModel.dueDate = dueDate.getTime();
        } else {
            worImCacheModel.dueDate = Long.MIN_VALUE;
        }

        Date completionDate = getCompletionDate();

        if (completionDate != null) {
            worImCacheModel.completionDate = completionDate.getTime();
        } else {
            worImCacheModel.completionDate = Long.MIN_VALUE;
        }

        worImCacheModel.completionBy = getCompletionBy();

        worImCacheModel.groupId = getGroupId();

        worImCacheModel.userId = getUserId();

        worImCacheModel.caregiverId = getCaregiverId();

        worImCacheModel.persnId = getPersnId();

        worImCacheModel.queId = getQueId();

        worImCacheModel.vcgId = getVcgId();

        return worImCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(31);

        sb.append("{worImId=");
        sb.append(getWorImId());
        sb.append(", type=");
        sb.append(getType());
        sb.append(", classId=");
        sb.append(getClassId());
        sb.append(", classPk=");
        sb.append(getClassPk());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", dueDate=");
        sb.append(getDueDate());
        sb.append(", completionDate=");
        sb.append(getCompletionDate());
        sb.append(", completionBy=");
        sb.append(getCompletionBy());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", caregiverId=");
        sb.append(getCaregiverId());
        sb.append(", persnId=");
        sb.append(getPersnId());
        sb.append(", queId=");
        sb.append(getQueId());
        sb.append(", vcgId=");
        sb.append(getVcgId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(49);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.WorIm");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>worImId</column-name><column-value><![CDATA[");
        sb.append(getWorImId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classId</column-name><column-value><![CDATA[");
        sb.append(getClassId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classPk</column-name><column-value><![CDATA[");
        sb.append(getClassPk());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>dueDate</column-name><column-value><![CDATA[");
        sb.append(getDueDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>completionDate</column-name><column-value><![CDATA[");
        sb.append(getCompletionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>completionBy</column-name><column-value><![CDATA[");
        sb.append(getCompletionBy());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>caregiverId</column-name><column-value><![CDATA[");
        sb.append(getCaregiverId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>persnId</column-name><column-value><![CDATA[");
        sb.append(getPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>queId</column-name><column-value><![CDATA[");
        sb.append(getQueId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vcgId</column-name><column-value><![CDATA[");
        sb.append(getVcgId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
