package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Vcg;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing Vcg in entity cache.
 *
 * @author caret
 * @see Vcg
 * @generated
 */
public class VcgCacheModel implements CacheModel<Vcg>, Externalizable {
    public long vcgId;
    public long veteranId;
    public String status;
    public long assessCompletionDate;
    public long primaryTrainedDate;
    public long visitationDate;
    public long primaryId;
    public long secondaryId;
    public long secondaryTwoId;
    public boolean generalCaregiver;
    public String primaryType;
    public String secondaryType;
    public String secondaryTwoType;
    public long primaryDispositionDate;
    public long secondaryDispositionDate;
    public long secondaryTwoDispositionDate;
    public int tierLevel;
    public long tierEffectiveDate;
    public String veteranDispReason;
    public String primaryDispReason;
    public String secondaryDispReason;
    public String secondaryTwoDispReason;
    public long primaryRevocationDate;
    public long secondaryRevocationDate;
    public long secondaryTwoRevocationDate;
    public long groupId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(53);

        sb.append("{vcgId=");
        sb.append(vcgId);
        sb.append(", veteranId=");
        sb.append(veteranId);
        sb.append(", status=");
        sb.append(status);
        sb.append(", assessCompletionDate=");
        sb.append(assessCompletionDate);
        sb.append(", primaryTrainedDate=");
        sb.append(primaryTrainedDate);
        sb.append(", visitationDate=");
        sb.append(visitationDate);
        sb.append(", primaryId=");
        sb.append(primaryId);
        sb.append(", secondaryId=");
        sb.append(secondaryId);
        sb.append(", secondaryTwoId=");
        sb.append(secondaryTwoId);
        sb.append(", generalCaregiver=");
        sb.append(generalCaregiver);
        sb.append(", primaryType=");
        sb.append(primaryType);
        sb.append(", secondaryType=");
        sb.append(secondaryType);
        sb.append(", secondaryTwoType=");
        sb.append(secondaryTwoType);
        sb.append(", primaryDispositionDate=");
        sb.append(primaryDispositionDate);
        sb.append(", secondaryDispositionDate=");
        sb.append(secondaryDispositionDate);
        sb.append(", secondaryTwoDispositionDate=");
        sb.append(secondaryTwoDispositionDate);
        sb.append(", tierLevel=");
        sb.append(tierLevel);
        sb.append(", tierEffectiveDate=");
        sb.append(tierEffectiveDate);
        sb.append(", veteranDispReason=");
        sb.append(veteranDispReason);
        sb.append(", primaryDispReason=");
        sb.append(primaryDispReason);
        sb.append(", secondaryDispReason=");
        sb.append(secondaryDispReason);
        sb.append(", secondaryTwoDispReason=");
        sb.append(secondaryTwoDispReason);
        sb.append(", primaryRevocationDate=");
        sb.append(primaryRevocationDate);
        sb.append(", secondaryRevocationDate=");
        sb.append(secondaryRevocationDate);
        sb.append(", secondaryTwoRevocationDate=");
        sb.append(secondaryTwoRevocationDate);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Vcg toEntityModel() {
        VcgImpl vcgImpl = new VcgImpl();

        vcgImpl.setVcgId(vcgId);
        vcgImpl.setVeteranId(veteranId);

        if (status == null) {
            vcgImpl.setStatus(StringPool.BLANK);
        } else {
            vcgImpl.setStatus(status);
        }

        if (assessCompletionDate == Long.MIN_VALUE) {
            vcgImpl.setAssessCompletionDate(null);
        } else {
            vcgImpl.setAssessCompletionDate(new Date(assessCompletionDate));
        }

        if (primaryTrainedDate == Long.MIN_VALUE) {
            vcgImpl.setPrimaryTrainedDate(null);
        } else {
            vcgImpl.setPrimaryTrainedDate(new Date(primaryTrainedDate));
        }

        if (visitationDate == Long.MIN_VALUE) {
            vcgImpl.setVisitationDate(null);
        } else {
            vcgImpl.setVisitationDate(new Date(visitationDate));
        }

        vcgImpl.setPrimaryId(primaryId);
        vcgImpl.setSecondaryId(secondaryId);
        vcgImpl.setSecondaryTwoId(secondaryTwoId);
        vcgImpl.setGeneralCaregiver(generalCaregiver);

        if (primaryType == null) {
            vcgImpl.setPrimaryType(StringPool.BLANK);
        } else {
            vcgImpl.setPrimaryType(primaryType);
        }

        if (secondaryType == null) {
            vcgImpl.setSecondaryType(StringPool.BLANK);
        } else {
            vcgImpl.setSecondaryType(secondaryType);
        }

        if (secondaryTwoType == null) {
            vcgImpl.setSecondaryTwoType(StringPool.BLANK);
        } else {
            vcgImpl.setSecondaryTwoType(secondaryTwoType);
        }

        if (primaryDispositionDate == Long.MIN_VALUE) {
            vcgImpl.setPrimaryDispositionDate(null);
        } else {
            vcgImpl.setPrimaryDispositionDate(new Date(primaryDispositionDate));
        }

        if (secondaryDispositionDate == Long.MIN_VALUE) {
            vcgImpl.setSecondaryDispositionDate(null);
        } else {
            vcgImpl.setSecondaryDispositionDate(new Date(
                    secondaryDispositionDate));
        }

        if (secondaryTwoDispositionDate == Long.MIN_VALUE) {
            vcgImpl.setSecondaryTwoDispositionDate(null);
        } else {
            vcgImpl.setSecondaryTwoDispositionDate(new Date(
                    secondaryTwoDispositionDate));
        }

        vcgImpl.setTierLevel(tierLevel);

        if (tierEffectiveDate == Long.MIN_VALUE) {
            vcgImpl.setTierEffectiveDate(null);
        } else {
            vcgImpl.setTierEffectiveDate(new Date(tierEffectiveDate));
        }

        if (veteranDispReason == null) {
            vcgImpl.setVeteranDispReason(StringPool.BLANK);
        } else {
            vcgImpl.setVeteranDispReason(veteranDispReason);
        }

        if (primaryDispReason == null) {
            vcgImpl.setPrimaryDispReason(StringPool.BLANK);
        } else {
            vcgImpl.setPrimaryDispReason(primaryDispReason);
        }

        if (secondaryDispReason == null) {
            vcgImpl.setSecondaryDispReason(StringPool.BLANK);
        } else {
            vcgImpl.setSecondaryDispReason(secondaryDispReason);
        }

        if (secondaryTwoDispReason == null) {
            vcgImpl.setSecondaryTwoDispReason(StringPool.BLANK);
        } else {
            vcgImpl.setSecondaryTwoDispReason(secondaryTwoDispReason);
        }

        if (primaryRevocationDate == Long.MIN_VALUE) {
            vcgImpl.setPrimaryRevocationDate(null);
        } else {
            vcgImpl.setPrimaryRevocationDate(new Date(primaryRevocationDate));
        }

        if (secondaryRevocationDate == Long.MIN_VALUE) {
            vcgImpl.setSecondaryRevocationDate(null);
        } else {
            vcgImpl.setSecondaryRevocationDate(new Date(secondaryRevocationDate));
        }

        if (secondaryTwoRevocationDate == Long.MIN_VALUE) {
            vcgImpl.setSecondaryTwoRevocationDate(null);
        } else {
            vcgImpl.setSecondaryTwoRevocationDate(new Date(
                    secondaryTwoRevocationDate));
        }

        vcgImpl.setGroupId(groupId);

        vcgImpl.resetOriginalValues();

        return vcgImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        vcgId = objectInput.readLong();
        veteranId = objectInput.readLong();
        status = objectInput.readUTF();
        assessCompletionDate = objectInput.readLong();
        primaryTrainedDate = objectInput.readLong();
        visitationDate = objectInput.readLong();
        primaryId = objectInput.readLong();
        secondaryId = objectInput.readLong();
        secondaryTwoId = objectInput.readLong();
        generalCaregiver = objectInput.readBoolean();
        primaryType = objectInput.readUTF();
        secondaryType = objectInput.readUTF();
        secondaryTwoType = objectInput.readUTF();
        primaryDispositionDate = objectInput.readLong();
        secondaryDispositionDate = objectInput.readLong();
        secondaryTwoDispositionDate = objectInput.readLong();
        tierLevel = objectInput.readInt();
        tierEffectiveDate = objectInput.readLong();
        veteranDispReason = objectInput.readUTF();
        primaryDispReason = objectInput.readUTF();
        secondaryDispReason = objectInput.readUTF();
        secondaryTwoDispReason = objectInput.readUTF();
        primaryRevocationDate = objectInput.readLong();
        secondaryRevocationDate = objectInput.readLong();
        secondaryTwoRevocationDate = objectInput.readLong();
        groupId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(vcgId);
        objectOutput.writeLong(veteranId);

        if (status == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(status);
        }

        objectOutput.writeLong(assessCompletionDate);
        objectOutput.writeLong(primaryTrainedDate);
        objectOutput.writeLong(visitationDate);
        objectOutput.writeLong(primaryId);
        objectOutput.writeLong(secondaryId);
        objectOutput.writeLong(secondaryTwoId);
        objectOutput.writeBoolean(generalCaregiver);

        if (primaryType == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(primaryType);
        }

        if (secondaryType == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(secondaryType);
        }

        if (secondaryTwoType == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(secondaryTwoType);
        }

        objectOutput.writeLong(primaryDispositionDate);
        objectOutput.writeLong(secondaryDispositionDate);
        objectOutput.writeLong(secondaryTwoDispositionDate);
        objectOutput.writeInt(tierLevel);
        objectOutput.writeLong(tierEffectiveDate);

        if (veteranDispReason == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(veteranDispReason);
        }

        if (primaryDispReason == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(primaryDispReason);
        }

        if (secondaryDispReason == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(secondaryDispReason);
        }

        if (secondaryTwoDispReason == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(secondaryTwoDispReason);
        }

        objectOutput.writeLong(primaryRevocationDate);
        objectOutput.writeLong(secondaryRevocationDate);
        objectOutput.writeLong(secondaryTwoRevocationDate);
        objectOutput.writeLong(groupId);
    }
}
