package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.PMMessage;
import gov.va.caret.model.PMMessageModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the PMMessage service. Represents a row in the &quot;private_message&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.PMMessageModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PMMessageImpl}.
 * </p>
 *
 * @author caret
 * @see PMMessageImpl
 * @see gov.va.caret.model.PMMessage
 * @see gov.va.caret.model.PMMessageModel
 * @generated
 */
public class PMMessageModelImpl extends BaseModelImpl<PMMessage>
    implements PMMessageModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a p m message model instance should use the {@link gov.va.caret.model.PMMessage} interface instead.
     */
    public static final String TABLE_NAME = "private_message";
    public static final Object[][] TABLE_COLUMNS = {
            { "messageId", Types.BIGINT },
            { "subject", Types.VARCHAR },
            { "body", Types.VARCHAR },
            { "url", Types.VARCHAR },
            { "parentMessageId", Types.BIGINT },
            { "ownerId", Types.BIGINT },
            { "ownerName", Types.VARCHAR },
            { "postedDate", Types.TIMESTAMP },
            { "recepients", Types.VARCHAR },
            { "readRecepients", Types.VARCHAR },
            { "isRead", Types.BOOLEAN }
        };
    public static final String TABLE_SQL_CREATE = "create table private_message (messageId LONG not null primary key,subject VARCHAR(75) null,body VARCHAR(75) null,url VARCHAR(75) null,parentMessageId LONG,ownerId LONG,ownerName VARCHAR(75) null,postedDate DATE null,recepients VARCHAR(75) null,readRecepients VARCHAR(75) null,isRead BOOLEAN)";
    public static final String TABLE_SQL_DROP = "drop table private_message";
    public static final String ORDER_BY_JPQL = " ORDER BY pmMessage.postedDate DESC";
    public static final String ORDER_BY_SQL = " ORDER BY private_message.postedDate DESC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.PMMessage"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.PMMessage"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.PMMessage"),
            true);
    public static long OWNERID_COLUMN_BITMASK = 1L;
    public static long PARENTMESSAGEID_COLUMN_BITMASK = 2L;
    public static long POSTEDDATE_COLUMN_BITMASK = 4L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.PMMessage"));
    private static ClassLoader _classLoader = PMMessage.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] {
            PMMessage.class
        };
    private long _messageId;
    private String _subject;
    private String _body;
    private String _url;
    private long _parentMessageId;
    private long _originalParentMessageId;
    private boolean _setOriginalParentMessageId;
    private long _ownerId;
    private long _originalOwnerId;
    private boolean _setOriginalOwnerId;
    private String _ownerName;
    private Date _postedDate;
    private String _recepients;
    private String _readRecepients;
    private boolean _isRead;
    private long _columnBitmask;
    private PMMessage _escapedModel;

    public PMMessageModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _messageId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setMessageId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _messageId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return PMMessage.class;
    }

    @Override
    public String getModelClassName() {
        return PMMessage.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("messageId", getMessageId());
        attributes.put("subject", getSubject());
        attributes.put("body", getBody());
        attributes.put("url", getUrl());
        attributes.put("parentMessageId", getParentMessageId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("ownerName", getOwnerName());
        attributes.put("postedDate", getPostedDate());
        attributes.put("recepients", getRecepients());
        attributes.put("readRecepients", getReadRecepients());
        attributes.put("isRead", getIsRead());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long messageId = (Long) attributes.get("messageId");

        if (messageId != null) {
            setMessageId(messageId);
        }

        String subject = (String) attributes.get("subject");

        if (subject != null) {
            setSubject(subject);
        }

        String body = (String) attributes.get("body");

        if (body != null) {
            setBody(body);
        }

        String url = (String) attributes.get("url");

        if (url != null) {
            setUrl(url);
        }

        Long parentMessageId = (Long) attributes.get("parentMessageId");

        if (parentMessageId != null) {
            setParentMessageId(parentMessageId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        String ownerName = (String) attributes.get("ownerName");

        if (ownerName != null) {
            setOwnerName(ownerName);
        }

        Date postedDate = (Date) attributes.get("postedDate");

        if (postedDate != null) {
            setPostedDate(postedDate);
        }

        String recepients = (String) attributes.get("recepients");

        if (recepients != null) {
            setRecepients(recepients);
        }

        String readRecepients = (String) attributes.get("readRecepients");

        if (readRecepients != null) {
            setReadRecepients(readRecepients);
        }

        Boolean isRead = (Boolean) attributes.get("isRead");

        if (isRead != null) {
            setIsRead(isRead);
        }
    }

    @Override
    public long getMessageId() {
        return _messageId;
    }

    @Override
    public void setMessageId(long messageId) {
        _messageId = messageId;
    }

    @Override
    public String getSubject() {
        if (_subject == null) {
            return StringPool.BLANK;
        } else {
            return _subject;
        }
    }

    @Override
    public void setSubject(String subject) {
        _subject = subject;
    }

    @Override
    public String getBody() {
        if (_body == null) {
            return StringPool.BLANK;
        } else {
            return _body;
        }
    }

    @Override
    public void setBody(String body) {
        _body = body;
    }

    @Override
    public String getUrl() {
        if (_url == null) {
            return StringPool.BLANK;
        } else {
            return _url;
        }
    }

    @Override
    public void setUrl(String url) {
        _url = url;
    }

    @Override
    public long getParentMessageId() {
        return _parentMessageId;
    }

    @Override
    public void setParentMessageId(long parentMessageId) {
        _columnBitmask |= PARENTMESSAGEID_COLUMN_BITMASK;

        if (!_setOriginalParentMessageId) {
            _setOriginalParentMessageId = true;

            _originalParentMessageId = _parentMessageId;
        }

        _parentMessageId = parentMessageId;
    }

    public long getOriginalParentMessageId() {
        return _originalParentMessageId;
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _columnBitmask |= OWNERID_COLUMN_BITMASK;

        if (!_setOriginalOwnerId) {
            _setOriginalOwnerId = true;

            _originalOwnerId = _ownerId;
        }

        _ownerId = ownerId;
    }

    public long getOriginalOwnerId() {
        return _originalOwnerId;
    }

    @Override
    public String getOwnerName() {
        if (_ownerName == null) {
            return StringPool.BLANK;
        } else {
            return _ownerName;
        }
    }

    @Override
    public void setOwnerName(String ownerName) {
        _ownerName = ownerName;
    }

    @Override
    public Date getPostedDate() {
        return _postedDate;
    }

    @Override
    public void setPostedDate(Date postedDate) {
        _columnBitmask = -1L;

        _postedDate = postedDate;
    }

    @Override
    public String getRecepients() {
        if (_recepients == null) {
            return StringPool.BLANK;
        } else {
            return _recepients;
        }
    }

    @Override
    public void setRecepients(String recepients) {
        _recepients = recepients;
    }

    @Override
    public String getReadRecepients() {
        if (_readRecepients == null) {
            return StringPool.BLANK;
        } else {
            return _readRecepients;
        }
    }

    @Override
    public void setReadRecepients(String readRecepients) {
        _readRecepients = readRecepients;
    }

    @Override
    public boolean getIsRead() {
        return _isRead;
    }

    @Override
    public boolean isIsRead() {
        return _isRead;
    }

    @Override
    public void setIsRead(boolean isRead) {
        _isRead = isRead;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            PMMessage.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public PMMessage toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (PMMessage) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        PMMessageImpl pmMessageImpl = new PMMessageImpl();

        pmMessageImpl.setMessageId(getMessageId());
        pmMessageImpl.setSubject(getSubject());
        pmMessageImpl.setBody(getBody());
        pmMessageImpl.setUrl(getUrl());
        pmMessageImpl.setParentMessageId(getParentMessageId());
        pmMessageImpl.setOwnerId(getOwnerId());
        pmMessageImpl.setOwnerName(getOwnerName());
        pmMessageImpl.setPostedDate(getPostedDate());
        pmMessageImpl.setRecepients(getRecepients());
        pmMessageImpl.setReadRecepients(getReadRecepients());
        pmMessageImpl.setIsRead(getIsRead());

        pmMessageImpl.resetOriginalValues();

        return pmMessageImpl;
    }

    @Override
    public int compareTo(PMMessage pmMessage) {
        int value = 0;

        value = DateUtil.compareTo(getPostedDate(), pmMessage.getPostedDate());

        value = value * -1;

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof PMMessage)) {
            return false;
        }

        PMMessage pmMessage = (PMMessage) obj;

        long primaryKey = pmMessage.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        PMMessageModelImpl pmMessageModelImpl = this;

        pmMessageModelImpl._originalParentMessageId = pmMessageModelImpl._parentMessageId;

        pmMessageModelImpl._setOriginalParentMessageId = false;

        pmMessageModelImpl._originalOwnerId = pmMessageModelImpl._ownerId;

        pmMessageModelImpl._setOriginalOwnerId = false;

        pmMessageModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<PMMessage> toCacheModel() {
        PMMessageCacheModel pmMessageCacheModel = new PMMessageCacheModel();

        pmMessageCacheModel.messageId = getMessageId();

        pmMessageCacheModel.subject = getSubject();

        String subject = pmMessageCacheModel.subject;

        if ((subject != null) && (subject.length() == 0)) {
            pmMessageCacheModel.subject = null;
        }

        pmMessageCacheModel.body = getBody();

        String body = pmMessageCacheModel.body;

        if ((body != null) && (body.length() == 0)) {
            pmMessageCacheModel.body = null;
        }

        pmMessageCacheModel.url = getUrl();

        String url = pmMessageCacheModel.url;

        if ((url != null) && (url.length() == 0)) {
            pmMessageCacheModel.url = null;
        }

        pmMessageCacheModel.parentMessageId = getParentMessageId();

        pmMessageCacheModel.ownerId = getOwnerId();

        pmMessageCacheModel.ownerName = getOwnerName();

        String ownerName = pmMessageCacheModel.ownerName;

        if ((ownerName != null) && (ownerName.length() == 0)) {
            pmMessageCacheModel.ownerName = null;
        }

        Date postedDate = getPostedDate();

        if (postedDate != null) {
            pmMessageCacheModel.postedDate = postedDate.getTime();
        } else {
            pmMessageCacheModel.postedDate = Long.MIN_VALUE;
        }

        pmMessageCacheModel.recepients = getRecepients();

        String recepients = pmMessageCacheModel.recepients;

        if ((recepients != null) && (recepients.length() == 0)) {
            pmMessageCacheModel.recepients = null;
        }

        pmMessageCacheModel.readRecepients = getReadRecepients();

        String readRecepients = pmMessageCacheModel.readRecepients;

        if ((readRecepients != null) && (readRecepients.length() == 0)) {
            pmMessageCacheModel.readRecepients = null;
        }

        pmMessageCacheModel.isRead = getIsRead();

        return pmMessageCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(23);

        sb.append("{messageId=");
        sb.append(getMessageId());
        sb.append(", subject=");
        sb.append(getSubject());
        sb.append(", body=");
        sb.append(getBody());
        sb.append(", url=");
        sb.append(getUrl());
        sb.append(", parentMessageId=");
        sb.append(getParentMessageId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", ownerName=");
        sb.append(getOwnerName());
        sb.append(", postedDate=");
        sb.append(getPostedDate());
        sb.append(", recepients=");
        sb.append(getRecepients());
        sb.append(", readRecepients=");
        sb.append(getReadRecepients());
        sb.append(", isRead=");
        sb.append(getIsRead());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(37);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.PMMessage");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>messageId</column-name><column-value><![CDATA[");
        sb.append(getMessageId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>subject</column-name><column-value><![CDATA[");
        sb.append(getSubject());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>body</column-name><column-value><![CDATA[");
        sb.append(getBody());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>url</column-name><column-value><![CDATA[");
        sb.append(getUrl());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>parentMessageId</column-name><column-value><![CDATA[");
        sb.append(getParentMessageId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerName</column-name><column-value><![CDATA[");
        sb.append(getOwnerName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>postedDate</column-name><column-value><![CDATA[");
        sb.append(getPostedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>recepients</column-name><column-value><![CDATA[");
        sb.append(getRecepients());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>readRecepients</column-name><column-value><![CDATA[");
        sb.append(getReadRecepients());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>isRead</column-name><column-value><![CDATA[");
        sb.append(getIsRead());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
