package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.PMDeletedMessage;
import gov.va.caret.model.PMDeletedMessageModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the PMDeletedMessage service. Represents a row in the &quot;deleted_message&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.PMDeletedMessageModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PMDeletedMessageImpl}.
 * </p>
 *
 * @author caret
 * @see PMDeletedMessageImpl
 * @see gov.va.caret.model.PMDeletedMessage
 * @see gov.va.caret.model.PMDeletedMessageModel
 * @generated
 */
public class PMDeletedMessageModelImpl extends BaseModelImpl<PMDeletedMessage>
    implements PMDeletedMessageModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a p m deleted message model instance should use the {@link gov.va.caret.model.PMDeletedMessage} interface instead.
     */
    public static final String TABLE_NAME = "deleted_message";
    public static final Object[][] TABLE_COLUMNS = {
            { "deletedMessageId", Types.BIGINT },
            { "messageId", Types.BIGINT },
            { "ownerId", Types.BIGINT },
            { "deletedDate", Types.TIMESTAMP }
        };
    public static final String TABLE_SQL_CREATE = "create table deleted_message (deletedMessageId LONG not null primary key,messageId LONG,ownerId LONG,deletedDate DATE null)";
    public static final String TABLE_SQL_DROP = "drop table deleted_message";
    public static final String ORDER_BY_JPQL = " ORDER BY pmDeletedMessage.deletedDate DESC";
    public static final String ORDER_BY_SQL = " ORDER BY deleted_message.deletedDate DESC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.PMDeletedMessage"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.PMDeletedMessage"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.PMDeletedMessage"),
            true);
    public static long MESSAGEID_COLUMN_BITMASK = 1L;
    public static long OWNERID_COLUMN_BITMASK = 2L;
    public static long DELETEDDATE_COLUMN_BITMASK = 4L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.PMDeletedMessage"));
    private static ClassLoader _classLoader = PMDeletedMessage.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] {
            PMDeletedMessage.class
        };
    private long _deletedMessageId;
    private long _messageId;
    private long _originalMessageId;
    private boolean _setOriginalMessageId;
    private long _ownerId;
    private long _originalOwnerId;
    private boolean _setOriginalOwnerId;
    private Date _deletedDate;
    private long _columnBitmask;
    private PMDeletedMessage _escapedModel;

    public PMDeletedMessageModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _deletedMessageId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setDeletedMessageId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _deletedMessageId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return PMDeletedMessage.class;
    }

    @Override
    public String getModelClassName() {
        return PMDeletedMessage.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("deletedMessageId", getDeletedMessageId());
        attributes.put("messageId", getMessageId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("deletedDate", getDeletedDate());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long deletedMessageId = (Long) attributes.get("deletedMessageId");

        if (deletedMessageId != null) {
            setDeletedMessageId(deletedMessageId);
        }

        Long messageId = (Long) attributes.get("messageId");

        if (messageId != null) {
            setMessageId(messageId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        Date deletedDate = (Date) attributes.get("deletedDate");

        if (deletedDate != null) {
            setDeletedDate(deletedDate);
        }
    }

    @Override
    public long getDeletedMessageId() {
        return _deletedMessageId;
    }

    @Override
    public void setDeletedMessageId(long deletedMessageId) {
        _deletedMessageId = deletedMessageId;
    }

    @Override
    public long getMessageId() {
        return _messageId;
    }

    @Override
    public void setMessageId(long messageId) {
        _columnBitmask |= MESSAGEID_COLUMN_BITMASK;

        if (!_setOriginalMessageId) {
            _setOriginalMessageId = true;

            _originalMessageId = _messageId;
        }

        _messageId = messageId;
    }

    public long getOriginalMessageId() {
        return _originalMessageId;
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _columnBitmask |= OWNERID_COLUMN_BITMASK;

        if (!_setOriginalOwnerId) {
            _setOriginalOwnerId = true;

            _originalOwnerId = _ownerId;
        }

        _ownerId = ownerId;
    }

    public long getOriginalOwnerId() {
        return _originalOwnerId;
    }

    @Override
    public Date getDeletedDate() {
        return _deletedDate;
    }

    @Override
    public void setDeletedDate(Date deletedDate) {
        _columnBitmask = -1L;

        _deletedDate = deletedDate;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            PMDeletedMessage.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public PMDeletedMessage toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (PMDeletedMessage) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        PMDeletedMessageImpl pmDeletedMessageImpl = new PMDeletedMessageImpl();

        pmDeletedMessageImpl.setDeletedMessageId(getDeletedMessageId());
        pmDeletedMessageImpl.setMessageId(getMessageId());
        pmDeletedMessageImpl.setOwnerId(getOwnerId());
        pmDeletedMessageImpl.setDeletedDate(getDeletedDate());

        pmDeletedMessageImpl.resetOriginalValues();

        return pmDeletedMessageImpl;
    }

    @Override
    public int compareTo(PMDeletedMessage pmDeletedMessage) {
        int value = 0;

        value = DateUtil.compareTo(getDeletedDate(),
                pmDeletedMessage.getDeletedDate());

        value = value * -1;

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof PMDeletedMessage)) {
            return false;
        }

        PMDeletedMessage pmDeletedMessage = (PMDeletedMessage) obj;

        long primaryKey = pmDeletedMessage.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        PMDeletedMessageModelImpl pmDeletedMessageModelImpl = this;

        pmDeletedMessageModelImpl._originalMessageId = pmDeletedMessageModelImpl._messageId;

        pmDeletedMessageModelImpl._setOriginalMessageId = false;

        pmDeletedMessageModelImpl._originalOwnerId = pmDeletedMessageModelImpl._ownerId;

        pmDeletedMessageModelImpl._setOriginalOwnerId = false;

        pmDeletedMessageModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<PMDeletedMessage> toCacheModel() {
        PMDeletedMessageCacheModel pmDeletedMessageCacheModel = new PMDeletedMessageCacheModel();

        pmDeletedMessageCacheModel.deletedMessageId = getDeletedMessageId();

        pmDeletedMessageCacheModel.messageId = getMessageId();

        pmDeletedMessageCacheModel.ownerId = getOwnerId();

        Date deletedDate = getDeletedDate();

        if (deletedDate != null) {
            pmDeletedMessageCacheModel.deletedDate = deletedDate.getTime();
        } else {
            pmDeletedMessageCacheModel.deletedDate = Long.MIN_VALUE;
        }

        return pmDeletedMessageCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{deletedMessageId=");
        sb.append(getDeletedMessageId());
        sb.append(", messageId=");
        sb.append(getMessageId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", deletedDate=");
        sb.append(getDeletedDate());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.PMDeletedMessage");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>deletedMessageId</column-name><column-value><![CDATA[");
        sb.append(getDeletedMessageId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>messageId</column-name><column-value><![CDATA[");
        sb.append(getMessageId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>deletedDate</column-name><column-value><![CDATA[");
        sb.append(getDeletedDate());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
