package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.PMDeletedMessage;
import gov.va.caret.service.PMDeletedMessageLocalServiceUtil;

/**
 * The extended model base implementation for the PMDeletedMessage service. Represents a row in the &quot;deleted_message&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PMDeletedMessageImpl}.
 * </p>
 *
 * @author caret
 * @see PMDeletedMessageImpl
 * @see gov.va.caret.model.PMDeletedMessage
 * @generated
 */
public abstract class PMDeletedMessageBaseImpl extends PMDeletedMessageModelImpl
    implements PMDeletedMessage {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a p m deleted message model instance should use the {@link PMDeletedMessage} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            PMDeletedMessageLocalServiceUtil.addPMDeletedMessage(this);
        } else {
            PMDeletedMessageLocalServiceUtil.updatePMDeletedMessage(this);
        }
    }
}
