package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Note;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing Note in entity cache.
 *
 * @author caret
 * @see Note
 * @generated
 */
public class NoteCacheModel implements CacheModel<Note>, Externalizable {
    public String uuid;
    public long noteId;
    public String value;
    public long userId;
    public long creationDate;
    public long groupId;
    public long chainId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(15);

        sb.append("{uuid=");
        sb.append(uuid);
        sb.append(", noteId=");
        sb.append(noteId);
        sb.append(", value=");
        sb.append(value);
        sb.append(", userId=");
        sb.append(userId);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append(", chainId=");
        sb.append(chainId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Note toEntityModel() {
        NoteImpl noteImpl = new NoteImpl();

        if (uuid == null) {
            noteImpl.setUuid(StringPool.BLANK);
        } else {
            noteImpl.setUuid(uuid);
        }

        noteImpl.setNoteId(noteId);

        if (value == null) {
            noteImpl.setValue(StringPool.BLANK);
        } else {
            noteImpl.setValue(value);
        }

        noteImpl.setUserId(userId);

        if (creationDate == Long.MIN_VALUE) {
            noteImpl.setCreationDate(null);
        } else {
            noteImpl.setCreationDate(new Date(creationDate));
        }

        noteImpl.setGroupId(groupId);
        noteImpl.setChainId(chainId);

        noteImpl.resetOriginalValues();

        return noteImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        uuid = objectInput.readUTF();
        noteId = objectInput.readLong();
        value = objectInput.readUTF();
        userId = objectInput.readLong();
        creationDate = objectInput.readLong();
        groupId = objectInput.readLong();
        chainId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        if (uuid == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(uuid);
        }

        objectOutput.writeLong(noteId);

        if (value == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(value);
        }

        objectOutput.writeLong(userId);
        objectOutput.writeLong(creationDate);
        objectOutput.writeLong(groupId);
        objectOutput.writeLong(chainId);
    }
}
