package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Note;
import gov.va.caret.service.NoteLocalServiceUtil;

/**
 * The extended model base implementation for the Note service. Represents a row in the &quot;CARET_NOTE&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NoteImpl}.
 * </p>
 *
 * @author caret
 * @see NoteImpl
 * @see gov.va.caret.model.Note
 * @generated
 */
public abstract class NoteBaseImpl extends NoteModelImpl implements Note {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a note model instance should use the {@link Note} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            NoteLocalServiceUtil.addNote(this);
        } else {
            NoteLocalServiceUtil.updateNote(this);
        }
    }
}
