package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Facil;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing Facil in entity cache.
 *
 * @author caret
 * @see Facil
 * @generated
 */
public class FacilCacheModel implements CacheModel<Facil>, Externalizable {
    public long facilId;
    public String facilityNumber;
    public String location;
    public long groupId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{facilId=");
        sb.append(facilId);
        sb.append(", facilityNumber=");
        sb.append(facilityNumber);
        sb.append(", location=");
        sb.append(location);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Facil toEntityModel() {
        FacilImpl facilImpl = new FacilImpl();

        facilImpl.setFacilId(facilId);

        if (facilityNumber == null) {
            facilImpl.setFacilityNumber(StringPool.BLANK);
        } else {
            facilImpl.setFacilityNumber(facilityNumber);
        }

        if (location == null) {
            facilImpl.setLocation(StringPool.BLANK);
        } else {
            facilImpl.setLocation(location);
        }

        facilImpl.setGroupId(groupId);

        facilImpl.resetOriginalValues();

        return facilImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        facilId = objectInput.readLong();
        facilityNumber = objectInput.readUTF();
        location = objectInput.readUTF();
        groupId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(facilId);

        if (facilityNumber == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(facilityNumber);
        }

        if (location == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(location);
        }

        objectOutput.writeLong(groupId);
    }
}
