package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Crypto;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing Crypto in entity cache.
 *
 * @author caret
 * @see Crypto
 * @generated
 */
public class CryptoCacheModel implements CacheModel<Crypto>, Externalizable {
    public long cryptoId;
    public long ownerId;
    public String type;
    public String value;
    public int hcode;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{cryptoId=");
        sb.append(cryptoId);
        sb.append(", ownerId=");
        sb.append(ownerId);
        sb.append(", type=");
        sb.append(type);
        sb.append(", value=");
        sb.append(value);
        sb.append(", hcode=");
        sb.append(hcode);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Crypto toEntityModel() {
        CryptoImpl cryptoImpl = new CryptoImpl();

        cryptoImpl.setCryptoId(cryptoId);
        cryptoImpl.setOwnerId(ownerId);

        if (type == null) {
            cryptoImpl.setType(StringPool.BLANK);
        } else {
            cryptoImpl.setType(type);
        }

        if (value == null) {
            cryptoImpl.setValue(StringPool.BLANK);
        } else {
            cryptoImpl.setValue(value);
        }

        cryptoImpl.setHcode(hcode);

        cryptoImpl.resetOriginalValues();

        return cryptoImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        cryptoId = objectInput.readLong();
        ownerId = objectInput.readLong();
        type = objectInput.readUTF();
        value = objectInput.readUTF();
        hcode = objectInput.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(cryptoId);
        objectOutput.writeLong(ownerId);

        if (type == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(type);
        }

        if (value == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(value);
        }

        objectOutput.writeInt(hcode);
    }
}
