package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Cesp;
import gov.va.caret.service.CespLocalServiceUtil;

/**
 * The extended model base implementation for the Cesp service. Represents a row in the &quot;CARET_CESP&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CespImpl}.
 * </p>
 *
 * @author caret
 * @see CespImpl
 * @see gov.va.caret.model.Cesp
 * @generated
 */
public abstract class CespBaseImpl extends CespModelImpl implements Cesp {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a cesp model instance should use the {@link Cesp} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            CespLocalServiceUtil.addCesp(this);
        } else {
            CespLocalServiceUtil.updateCesp(this);
        }
    }
}
