package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.CalEt;
import gov.va.caret.service.CalEtLocalServiceUtil;

/**
 * The extended model base implementation for the CalEt service. Represents a row in the &quot;CARET_CALL_EVENT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CalEtImpl}.
 * </p>
 *
 * @author caret
 * @see CalEtImpl
 * @see gov.va.caret.model.CalEt
 * @generated
 */
public abstract class CalEtBaseImpl extends CalEtModelImpl implements CalEt {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a cal et model instance should use the {@link CalEt} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            CalEtLocalServiceUtil.addCalEt(this);
        } else {
            CalEtLocalServiceUtil.updateCalEt(this);
        }
    }
}
