package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.BlsAe;
import gov.va.caret.model.BlsAeModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the BlsAe service. Represents a row in the &quot;CARET_BLS_AREA&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.BlsAeModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BlsAeImpl}.
 * </p>
 *
 * @author caret
 * @see BlsAeImpl
 * @see gov.va.caret.model.BlsAe
 * @see gov.va.caret.model.BlsAeModel
 * @generated
 */
public class BlsAeModelImpl extends BaseModelImpl<BlsAe> implements BlsAeModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a bls ae model instance should use the {@link gov.va.caret.model.BlsAe} interface instead.
     */
    public static final String TABLE_NAME = "CARET_BLS_AREA";
    public static final Object[][] TABLE_COLUMNS = {
            { "blsAeId", Types.BIGINT },
            { "areaName", Types.VARCHAR },
            { "areaNumber", Types.INTEGER }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_BLS_AREA (blsAeId LONG not null primary key,areaName VARCHAR(75) null,areaNumber INTEGER)";
    public static final String TABLE_SQL_DROP = "drop table CARET_BLS_AREA";
    public static final String ORDER_BY_JPQL = " ORDER BY blsAe.areaNumber ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_BLS_AREA.areaNumber ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.BlsAe"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.BlsAe"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.BlsAe"),
            true);
    public static long AREANUMBER_COLUMN_BITMASK = 1L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.BlsAe"));
    private static ClassLoader _classLoader = BlsAe.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { BlsAe.class };
    private long _blsAeId;
    private String _areaName;
    private int _areaNumber;
    private int _originalAreaNumber;
    private boolean _setOriginalAreaNumber;
    private long _columnBitmask;
    private BlsAe _escapedModel;

    public BlsAeModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _blsAeId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBlsAeId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _blsAeId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return BlsAe.class;
    }

    @Override
    public String getModelClassName() {
        return BlsAe.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("blsAeId", getBlsAeId());
        attributes.put("areaName", getAreaName());
        attributes.put("areaNumber", getAreaNumber());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long blsAeId = (Long) attributes.get("blsAeId");

        if (blsAeId != null) {
            setBlsAeId(blsAeId);
        }

        String areaName = (String) attributes.get("areaName");

        if (areaName != null) {
            setAreaName(areaName);
        }

        Integer areaNumber = (Integer) attributes.get("areaNumber");

        if (areaNumber != null) {
            setAreaNumber(areaNumber);
        }
    }

    @Override
    public long getBlsAeId() {
        return _blsAeId;
    }

    @Override
    public void setBlsAeId(long blsAeId) {
        _blsAeId = blsAeId;
    }

    @Override
    public String getAreaName() {
        if (_areaName == null) {
            return StringPool.BLANK;
        } else {
            return _areaName;
        }
    }

    @Override
    public void setAreaName(String areaName) {
        _areaName = areaName;
    }

    @Override
    public int getAreaNumber() {
        return _areaNumber;
    }

    @Override
    public void setAreaNumber(int areaNumber) {
        _columnBitmask = -1L;

        if (!_setOriginalAreaNumber) {
            _setOriginalAreaNumber = true;

            _originalAreaNumber = _areaNumber;
        }

        _areaNumber = areaNumber;
    }

    public int getOriginalAreaNumber() {
        return _originalAreaNumber;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            BlsAe.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public BlsAe toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (BlsAe) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        BlsAeImpl blsAeImpl = new BlsAeImpl();

        blsAeImpl.setBlsAeId(getBlsAeId());
        blsAeImpl.setAreaName(getAreaName());
        blsAeImpl.setAreaNumber(getAreaNumber());

        blsAeImpl.resetOriginalValues();

        return blsAeImpl;
    }

    @Override
    public int compareTo(BlsAe blsAe) {
        int value = 0;

        if (getAreaNumber() < blsAe.getAreaNumber()) {
            value = -1;
        } else if (getAreaNumber() > blsAe.getAreaNumber()) {
            value = 1;
        } else {
            value = 0;
        }

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BlsAe)) {
            return false;
        }

        BlsAe blsAe = (BlsAe) obj;

        long primaryKey = blsAe.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        BlsAeModelImpl blsAeModelImpl = this;

        blsAeModelImpl._originalAreaNumber = blsAeModelImpl._areaNumber;

        blsAeModelImpl._setOriginalAreaNumber = false;

        blsAeModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<BlsAe> toCacheModel() {
        BlsAeCacheModel blsAeCacheModel = new BlsAeCacheModel();

        blsAeCacheModel.blsAeId = getBlsAeId();

        blsAeCacheModel.areaName = getAreaName();

        String areaName = blsAeCacheModel.areaName;

        if ((areaName != null) && (areaName.length() == 0)) {
            blsAeCacheModel.areaName = null;
        }

        blsAeCacheModel.areaNumber = getAreaNumber();

        return blsAeCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(7);

        sb.append("{blsAeId=");
        sb.append(getBlsAeId());
        sb.append(", areaName=");
        sb.append(getAreaName());
        sb.append(", areaNumber=");
        sb.append(getAreaNumber());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(13);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BlsAe");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>blsAeId</column-name><column-value><![CDATA[");
        sb.append(getBlsAeId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>areaName</column-name><column-value><![CDATA[");
        sb.append(getAreaName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>areaNumber</column-name><column-value><![CDATA[");
        sb.append(getAreaNumber());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
